## Send Event

This step sends a message to a Workflow Instance. The event will typically fire a transition, 
potentially moving the workflow from one state to another.

### Structure
1 ⇒ 1

### Input
The incoming record should have a `wfiState` holding a `workflowId` and a `_id` for the workflow instance.

```
{
  "wfiState": {
    "_id": <workflowInstanceId>
    "workflowId": <workflowId>
  }
}
```
Both are required, because the location of the workflow instance depends on the definition of the workflow.

You may need to restructure your record to get this format.

### Parameters
* `Event` - the name of the event to send - ie. corresponding to a transition of the workflow
* `Parameters Field` - the name of a field (a nested document) to be passed as parameters with the event

### Output
If the event is not processed (eg. the workflow is in the wrong state to accept it), the output is a 
record with a `result` field indicating the error. 
Otherwise, the updated workflow instance record, after processing the event, is returned.

### Notes

* The Parameters will be passed to the workflow, which will typically pass them on to an ETL Chain as the
elxEvent contents. Therefore the parameters should be a nested document,  
as elxEvent is always expected to be a document.

#### See Also
* Workflow Module
