## Xlsx Merge

This step takes incoming records each holding the bytes of an XLSX file (workbook) and merges them into a single
XLSX file combining the sheets from each incoming workbook. 

If the same sheet name occurs in multiple workbooks, they will be renamed by appending _1, _2 etc. to ensure
all sheet names are unique.

The result is a single record holding the bytes for the combined XLSX file

### Structure
N => 1

### Input
Each incoming record should contain a `bytes` array, holding the XLSX bytes. If these are loaded from a 
password protected file, then they should be unprotected before this step.
The sheets extracted from the bytes received will be copied into a new XLSX workbook.

### Parameters
There are no parameters for this step

### Output
A single record containing:

* `bytes` - The byte array holding the XLSX spreadsheet

* `mimeType` - The mime-type. Always "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"

* `mergeCount` - the number of workbooks that were received

In the case of failure, there will be a `mergeError` string field instead.

#### Notes
* Any incoming records which do not contain `bytes` will be skipped

* As an ETL record in MongoDB can hold no more than approx 16MB of data, you should avoid inspecting the output
  of this step, if the data is large. Instead, use a FileWriter to write it to disk and inspect the file that way.
 
* An error in viewing the output of this step is most likely a limitation in MongoDB record storage, ETL itself can
  handle records of any size, eg. to transmit to S3, write to disk etc. The key thing is to not retain huge bytes 
  within the results or output which are saved into MongoDB at the end of a `Run` or `Run to Step` command. 

#### See Also
