## Xlsx Updater

This step takes incoming bytes representing an XLSX spreadsheet file and 
performs updates on cells, writing the results back into outgoing bytes.

Updates require several fields wrapped as a record:

```
{"sheet": "Sheet1", "row": 1, "col": 1, "value": "Hello World"}
```

Note that indexes are 1-based, just like in Excel itself. You can also use a String for col:

```
{"sheet": "Sheet1", "row": 1, "col": "A", "value": "Hello World"}
```

The value may be a string, integer, double, boolean or timestamp. The cell will not be formatted.

### Structure
1 => 1

### Input
The input record should contain a binary field called bytes which represents a valid XLSX spreadsheet.

The input may contain a string field called password, which will be used to decrypt and later re-encrypt the
spreadsheet, if the password is not empty.

### Parameters

`Updates Field` - The field holding information about the updates to be performed on the spreadsheet. 
  Several options are allowed:
 
* A single update record (as described above)
* An array of update records
* A string representing a chain to run, given this same input record, which will emit multiple update records.

### Output
The input record with:

* `success` - a boolean value indicating success

On success:

* `bytes` - An updated version of the bytes field from the incoming record (re-encrypted if necessary)

On failure:

* `error` - An error message indicating what went wrong - this will typically be missing/invalid bytes or a bad password.

#### Notes
* Password strings are trimmed, so whitespace is removed from the start and end.

* Updates that do not contain valid sheet, row, col and value fields will be ignored 
  - these will not be flagged as an error

* Data will be inserted into cells without changing the format, so just like mail merge, set up the appropriate formats 
first - including dummy data if you like - and these will be overwritten with new data preserving the format (provided the data type is compatible).

#### See Also

* Xlsx Password Protect
