## XLSX Definition

This step constructs the parameters needed by the XLSX Reader.

## Structure

1 => 1

## Inputs

No special inputs required, but any fields for incoming records are preserved (upstream overrides this).

### Parameters

* `URL` - the location of the XLSX file

* `Sheet` - the sheet of the file to be read

* `Header Rows` - a list of header rows in the sheet

* `Start Row` - the row the data starts from

* `Password` - the password to the XLSX file

* `Base JSON` - This object will be used as the base for any documents constructed by the XLSX Reader

### Output

* `url` - the location of the XLSX file

* `sheet` - the sheet defined by the step

* `headerRows` - an array of rows the step defined as headers

* `startRow` - the row the data in the XLSX file starts at

* `password` - the password to the XLSX file

* `base` - the base json defined by this step

#### Notes

* This is a utility step to make it easier to construct the necessary input for XLSX Reader. You don't need
  to use this - you can construct the same definition yourself, eg. by using a Json Record or even by reading
  from MongoDB.

* The separation between definition and use also enables you to add substitution steps in between.

* As whitespace is stripped from input fields, it is hard to specify tab separators. You can use
  the special character `␉` (unicode character 0x2409) "horizontal tabulation" to represent it.

#### See Also

* XLSX Reader