## XML Reader

This step converts incoming XML into records for subsequent processing.

To use this step, you need to define the root for navigation to construct each record. Here's an example:

Input:
```
<?xml version="1.0" encoding="UTF-8"?>
<demo>
  <group name="A">
    <record name="First">Value1</record>
    <record name="Second">Value2</record>
  </group>
  <group name="B">
    <record name="First">Value3</record>
    <record name="Second">Value4</record>
    <record name="Third">Value5</record>
  </group>
</demo>
```

To extract the records, we need to specify the xpath to get to each record value. That is: `/demo/group/record`

This will identify five roots from which records will be built. 

Then we define an extractor for each field we want added to the output record, for example:
```
Name: Name, XPath: @name
Name: Value, XPath: text()
Name: Group, XPath: ../@name
```

The output we get contains the three additional fields:

|Name | Value | Group |
|---|---|---|
|First | Value1 | A |
|Second | Value2 | A |
|First | Value3 | B |
|Second | Value4 | B |
|Third | Value5 | B |


See the specifications for XPath for more details on how you can navigate around the tree to locate useful parts of the XML file.

### Structure
1 => N

### Input
The `bytes` field on each record received will be parsed into XML

### Parameters
* `Roots` - the xpath which is used to identify the roots of the extraction process. Each root identified produces one record out.

(Repeating)

* `Name` - the field name for the extracted value 

* `XPath` - the xpath navigation from the root to obtain the field value.

### Output
A record will be output for each root identified, with the additional fields added as defined by the Extractors

#### Notes

* Read up on XPath syntax for full details - the example above shows accessing an attribute via `@` notation, 
accessing the text within an element, via `text()` and traversing the tree - including upwards with `..`

#### See Also

* XML Tree Reader

* XSLT Processor
