
// all global functions have been moved to the elxfn namespace
// to prevent possible conflicts with other javascript libraries
var elxfn = function() {}

elxfn.isNull = function(a) 
{
    return typeof a == 'object' && !a;
}

elxfn.isNumber = function(a) 
{
    return typeof a == 'number';
}

elxfn.isString = function(a) 
{
    return typeof a == 'string';
}

elxfn.asNumber = function(str)
{
	var len = str.length;
	if (str.charAt(0)=='(' && str.charAt(len-1)==')') 
	{
		str = "-" + str.substring(1,len-1);
	}
	return Number(str);
}

elxfn.asDate = function(str, pattern)
{
  pattern = pattern || "yyyy-MM-dd";
  var sdf = new java.text.SimpleDateFormat(pattern);
	return sdf.parse(str);
}

elxfn.isDateString = function(str,pattern)
{
	pattern = pattern || "yyyy-MM-dd";
	return Packages.com.elixirtech.util.DateUtil.isDate(str,pattern);
}

elxfn.isNumberString = function(str)
{
	return Packages.com.elixirtech.util.NumberUtil.isNumber(str);
}

elxfn.trim = function(str)
{
	if (str.trim) return str.trim();           // Java String
	else return str.replace(/^\s+|\s+$/g, ""); // JavaScript String
}

elxfn.strip = function(str, ch)
{
	var idx = str.indexOf(ch);
	if (idx<0) return str;
	
	var ret = str;
	var len = str.length;
	while (idx>=0)
	{
		ret = ret.substring(0,idx) + ret.substring(idx+1,len);
		idx = ret.indexOf(ch,idx);
	}
	return ret;
}

elxfn.leftTrim = function(str)
{
   var whitespace = new String(" \t\n\r");
   var s = new String(str);
   if (whitespace.indexOf(s.charAt(0)) != -1)
   {
      var j=0, i = s.length;
      while (j < i && whitespace.indexOf(s.charAt(j)) != -1) j++;
      s = s.substring(j, i);
   }
   return s;
}

elxfn.rightTrim = function(str)
{
   var whitespace = new String(" \t\n\r");
   var s = new String(str);
   if (whitespace.indexOf(s.charAt(s.length-1)) != -1)
   {
      var i = s.length - 1;       // Get length of string
      while (i >= 0 && whitespace.indexOf(s.charAt(i)) != -1) i--;
      s = s.substring(0, i+1);
   }
   return s;
}

elxfn.padRight = function(s, len, ch)
{
  ch = ch || " "
  if (s.length>len) return s.substring(0,len)
  while (s.length<len)
    s = s + ch
  return s;
}

elxfn.padLeft = function(s, len, ch)
{
  ch = ch || " "
  if (s.length>len) return s.slice(-len)
  while (s.length<len)
    s = ch + s
  return s;
}

// added 05/05/06 for ease of porting Scheme
elxfn.leftString = function(s, len)
{
	return s.substring(0,len);
}

// added 05/05/06 for ease of porting Scheme
elxfn.rightString = function(s, len)
{
	return s.substring(s.length()-len);
}

// added 05/05/06 for ease of porting Scheme
elxfn.nullZero = function(value)
{
	if (value==null) return 0;
	else return value;
}

elxfn.javaToJS = function(obj,scope)
{
  return Packages.org.mozilla.javascript.Context.javaToJS(obj,scope);
}

//DateFunctions
// DateFunctions created Tue Sep 21 16:50:46 SGT 2004 : 
// A generic set of Date offset functions 
// Format: offsetDate(Years, Months, Days)

elxfn.offsetDays = function(origDate, numDays)
{
  return elxfn.offsetDate(origDate,0,0,numDays);
}

elxfn.offsetMonths = function(origDate, numMonths)
{
  return elxfn.offsetDate(origDate,0,numMonths,0);
}

elxfn.offsetYears = function(origDate, numYears)
{  
  return elxfn.offsetDate(origDate,numYears,0,0);
}

elxfn.offsetDate = function(origDate, numYears, numMonths, numDays)
{
	var cal = java.util.Calendar.getInstance();
	cal.setTime(origDate);
	cal.add(java.util.Calendar.YEAR,numYears);
	cal.add(java.util.Calendar.MONTH,numMonths);
	cal.add(java.util.Calendar.DAY_OF_MONTH,numDays);
	return cal.getTime();
} 

// for porting from scheme
elxfn.dateAdd = function(origDate, increment, interval)
{
	var cal = java.util.Calendar.getInstance();
	cal.setTime(origDate);
	var field = null;
	switch(interval)
	{
		case 'S': field = java.util.Calendar.MILLISECOND; break;
		case 's': field = java.util.Calendar.SECOND; break;
		case 'm': field = java.util.Calendar.MINUTE; break;
		case 'H': field = java.util.Calendar.HOUR; break;
		case 'd': field = java.util.Calendar.DAY; break;
		case 'M': field = java.util.Calendar.MONTH; break;
		case 'y': field = java.util.Calendar.YEAR; break;
		default: valid = false;
	}
	if (field)
	{
		cal.add(field,increment);
	}
	return cal.getTime();
} 

/* dateDiff created Tue Sep 28 11:02:01 SGT 2004 */
// takes in three parameters: the two dates and an interval
// returns days minutes or seconds based on third arguement 

elxfn.dateDiff = function(DateA, DateB, interval)
{
	x = DateB.getTime();
	y = DateA.getTime();
	result = 0;
	if (y>x)
		result = y-x;
	else
		result = x-y;
	switch (interval.charAt(0))
	{
	case 'd':
	case 'D':
		//returns number of days
		result = result /(24*3600000);
		break;
	case 'h':
	case 'H':
		//returns number of Hours
		result = result / 3600000;
		break;
	case 'm':
	case 'M':
		result = result / 60000;
		break;
		//returns minutes
	case 's':
	case 'S':
		result = result / 1000;
		break;
		//returns seconds
	default:
		//default return milliseconds
		break;	
	}
	return result;
}

elxfn.toDate = function(dateString, pattern)
{
	var sdf = java.text.SimpleDateFormat(pattern);
	return sdf.parse(dateString);
}

// Safe support
/*
importClass(Packages.com.elixirtech.arch.safe.SafeUtil);

elxfn.getSafeProperties = function(path,pass)
{
	return SafeUtil.getSafeProperties(path,pass); 
}
*/
elxfn.terminate = function(code,msg)
{
    Packages.com.elixirtech.arch.Elixir.throwTerminate(code,msg);
}

// AOP

elxfn.addBefore = function(obj, fname, before)
{
    var oldFunc = obj[fname];
    obj[fname] = function()
    {
        return oldFunc.apply(this, before(arguments, oldFunc, this));
    };
};

elxfn.addAfter = function(obj, fname, after) 
{
    var oldFunc = obj[fname];
    obj[fname] = function()
    {
        return after(oldFunc.apply(this, arguments), arguments, oldFunc, this);
    };
};

elxfn.addAround = function(obj, fname, around) 
{
    var oldFunc = obj[fname];
    obj[fname] = function()
    {
        return around(arguments, oldFunc, this);
    };
};

// deprecate old globals

elxfn.deprecate = function(scope,name)
{
	elxfn.addBefore(scope,name,elxfn.deprecatedFn(name));
}

elxfn.deprecatedFn = function(name)
{
	return function(args)
	{
		Log.warn("Deprecated function: " + name + ", please use elxfn."+name + " instead.");
		return args;
	}
}

// add globals to simulate old behaviour:
// remove these in case of conflicts
isNull = elxfn.isNull;
isNumber = elxfn.isNumber;
isString = elxfn.isString;
asNumber = elxfn.asNumber;
asDate = elxfn.asDate;
trim = elxfn.trim;
strip = elxfn.strip;
leftTrim = elxfn.leftTrim;
rightTrim = elxfn.rightTrim;

offsetDays = elxfn.offsetDays;
offsetMonths = elxfn.offsetMonths;
offsetYears = elxfn.offsetYears;
offsetDate = elxfn.offsetDate;
dateDiff = elxfn.dateDiff;

// deprecate the global versions
elxfn.deprecate(this,"isNull");
elxfn.deprecate(this,"isNumber");
elxfn.deprecate(this,"isString");
elxfn.deprecate(this,"asNumber");
elxfn.deprecate(this,"asDate");
elxfn.deprecate(this,"trim");
elxfn.deprecate(this,"strip");
elxfn.deprecate(this,"leftTrim");
elxfn.deprecate(this,"rightTrim");

elxfn.deprecate(this,"offsetDays");
elxfn.deprecate(this,"offsetMonths");
elxfn.deprecate(this,"offsetYears");
elxfn.deprecate(this,"offsetDate");
elxfn.deprecate(this,"dateDiff");

// resource bundle migration

elxfn.resourceLookup = function(rb,str,locale)
{
	Packages.com.elixirtech.report2.data.util.Resource.getLocaleBasedText(rb,str,locale);
}

elxfn.resourceLookup = function(rb,str,locale)
{
	if (locale==null)
	{
		return Packages.com.elixirtech.report2.data.util.Resource.getText(rb,str);
	}
	else
	{
		return Packages.com.elixirtech.report2.data.util.Resource.getLocaleBasedText(rb,str,locale);
	}
}

// new GUI functions - experimental, may change at any time

var elxgui = new function() {}

elxgui.setSize = function(width, height)
{
	var f = Packages.com.elixirtech.arch.Elixir.get(Packages.com.elixirtech.arch.ElixirFrame);
	if (f)
	{
		f.getFrame().setSize(new java.awt.Dimension(width,height));
		return true;
	}
	else
	{
		return false;
	}
}

// note this will be intercepted on I18N version
elxgui.setTitle = function(title)
{
	var f = Packages.com.elixirtech.arch.Elixir.get(Packages.com.elixirtech.arch.ElixirFrame);
	if (f)
	{
		f.getFrame().setTitle(title);
		return true;
	}
	else
	{
		return false;
	}
}

elxgui.navigate = function(location)
{
	var f = Packages.com.elixirtech.arch.Elixir.get(Packages.com.elixirtech.arch.ElixirFrame);
	if (f)
	{
		f.postNavigate(new Packages.com.elixirtech.arch.UINavigatorPath(location));
		return true;
	}
	else
	{
		return false;
	}
}

elxgui.snapshot = function(filename)
{
	var f = Packages.com.elixirtech.arch.Elixir.get(Packages.com.elixirtech.arch.ElixirFrame);
	if (f)
	{
		return f.postSnapshot(filename);
	}
	else
	{
		return false;
	}
}

elxgui.input = function(text)
{
	var f = Packages.com.elixirtech.arch.Elixir.get(Packages.com.elixirtech.arch.ElixirFrame);
	if (f)
	{
		return f.postInput(text);
	}
	else
	{
		return false;
	}
}

elxgui.tab = function()
{
	var f = Packages.com.elixirtech.arch.Elixir.get(Packages.com.elixirtech.arch.ElixirFrame);
	if (f)
	{
		return f.postTab();
	}
	else
	{
		return false;
	}
}

elxgui.sleep = function(ms)
{
	java.lang.Thread.sleep(ms);
}

elxgui.waitForArrowCursor = function()
{
	var f = Packages.com.elixirtech.arch.Elixir.get(Packages.com.elixirtech.arch.ElixirFrame);
	if (f)
	{
		f.waitForArrowCursor();
	}
}
