// SQLBuilder.js

function SQLBuilder() // varargs
{
	this.m_Conditions = new java.util.ArrayList();
}

SQLBuilder.prototype.addCondition = function(name,condition,type,value)
{
	this.m_Conditions.add(new Condition(name,condition,type,value));
}

SQLBuilder.prototype.buildWhere = function()
{
	ret = "";
	pos = 0;
	if (this.m_Conditions.size()>0)
	{
		it = this.m_Conditions.iterator();
		while (it.hasNext())
		{
			c = it.next();
			if (c.isValid())
			{
				if (pos==0) ret = ret + "WHERE ";
				else ret = ret + " AND ";
				ret = ret + c.getSQL();
				++pos;
			}
		}
	}
	return ret;
}

SQLBuilder.prototype.buildAnd = function()
{
	var ret = "";
	if (this.m_Conditions.size()>0)
	{
		it = this.m_Conditions.iterator();
		while (it.hasNext())
		{
			c = it.next();
			if (c.isValid())
			{
				ret = ret + " AND ";
				ret = ret + c.getSQL();
			}
		}
	}
	return ret;
}

function Condition(name,condition,type,value)
{
	this.m_Name = name;
	this.m_Condition = condition;
	this.m_Type = type;
	this.m_Value = value;
}

Condition.prototype.isValid = function()
{
	return this.m_Value!=null && !"".equals(this.m_Value);
}

Condition.prototype.getSQL = function()
{
	var ret = this.m_Name + this.m_Condition;
	if ("String".equals(this.m_Type))
	{
		ret = ret + "'"+this.m_Value+"'";
	}
	else if ("Date".equals(this.m_Type))
	{
		ret = ret + "DATE('"+this.m_Value+"')";
	}
	else
	{
		ret = ret + this.m_Value;
	}
	return ret;
}

// Test

sb = new SQLBuilder();
sb.addCondition("first","=","String","Hello");
println(sb.buildWhere());

sb.addCondition("second","=","String","World");
println(sb.buildWhere());

sb.addCondition("third","=","Date","2005-05-19");
println(sb.buildWhere());

sb.addCondition("fourth",">","Integer",5);
println(sb.buildWhere());

sb.addCondition("fifth",">","Integer","");
println(sb.buildWhere());

sb.addCondition("sixth","!=","String","Goodbye");
println(sb.buildWhere());
