/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.native;

import java.io.Reader;
import java.io.Serializable;
import org.json4s.AsJsonInput;
import org.json4s.AsJsonInput$;
import org.json4s.JArray;
import org.json4s.JArray$;
import org.json4s.JBool;
import org.json4s.JBool$;
import org.json4s.JDecimal;
import org.json4s.JDecimal$;
import org.json4s.JDouble;
import org.json4s.JDouble$;
import org.json4s.JInt;
import org.json4s.JInt$;
import org.json4s.JLong;
import org.json4s.JLong$;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JObject$;
import org.json4s.JSet;
import org.json4s.JSet$;
import org.json4s.JString;
import org.json4s.JString$;
import org.json4s.JValue;
import org.json4s.ParserUtil$;
import org.json4s.StreamingJsonWriter$;
import org.json4s.native.Document;
import org.json4s.native.Document$;
import org.json4s.native.JsonParser$;
import org.json4s.native.Printer$;
import org.json4s.prefs.EmptyValueStrategy;
import org.json4s.prefs.EmptyValueStrategy$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.WithFilter;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public interface JsonMethods
extends org.json4s.JsonMethods<Document> {
    public static JValue parse$(JsonMethods $this, Object in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput evidence$1) {
        return $this.parse(in, useBigDecimalForDouble, useBigIntForLong, evidence$1);
    }

    default public <A> JValue parse(A in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput<A> evidence$1) {
        return JsonParser$.MODULE$.parse(in, useBigDecimalForDouble, useBigIntForLong, evidence$1);
    }

    public static boolean parse$default$2$(JsonMethods $this) {
        return $this.parse$default$2();
    }

    default public boolean parse$default$2() {
        return false;
    }

    public static boolean parse$default$3$(JsonMethods $this) {
        return $this.parse$default$3();
    }

    default public boolean parse$default$3() {
        return true;
    }

    public static Option parseOpt$(JsonMethods $this, Object in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput evidence$2) {
        return $this.parseOpt(in, useBigDecimalForDouble, useBigIntForLong, evidence$2);
    }

    default public <A> Option<JValue> parseOpt(A in, boolean useBigDecimalForDouble, boolean useBigIntForLong, AsJsonInput<A> evidence$2) {
        None$ none$;
        try {
            Reader reader = AsJsonInput$.MODULE$.asJsonInput(in, evidence$2).toReader();
            boolean bl = JsonParser$.MODULE$.parse$default$2();
            none$ = JsonParser$.MODULE$.parse(reader, bl, useBigDecimalForDouble, useBigIntForLong).toOption();
        }
        catch (Exception exception) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static boolean parseOpt$default$2$(JsonMethods $this) {
        return $this.parseOpt$default$2();
    }

    default public boolean parseOpt$default$2() {
        return false;
    }

    public static boolean parseOpt$default$3$(JsonMethods $this) {
        return $this.parseOpt$default$3();
    }

    default public boolean parseOpt$default$3() {
        return true;
    }

    public static Document render$(JsonMethods $this, JValue value, boolean alwaysEscapeUnicode, EmptyValueStrategy emptyValueStrategy) {
        return $this.render(value, alwaysEscapeUnicode, emptyValueStrategy);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public Document render(JValue value, boolean alwaysEscapeUnicode, EmptyValueStrategy emptyValueStrategy) {
        List list;
        Document document;
        JValue jValue = emptyValueStrategy.replaceEmpty(value);
        if (jValue == null) {
            document = Document$.MODULE$.text("null");
            return document;
        }
        if (jValue instanceof JBool) {
            JBool jBool = JBool$.MODULE$.unapply((JBool)jValue);
            boolean bl = jBool._1();
            if (bl) {
                document = Document$.MODULE$.text("true");
                return document;
            }
            if (!bl) {
                document = Document$.MODULE$.text("false");
                return document;
            }
        }
        if (jValue instanceof JDouble) {
            double d;
            JDouble jDouble = JDouble$.MODULE$.unapply((JDouble)jValue);
            double n = d = jDouble._1();
            document = Document$.MODULE$.text(StreamingJsonWriter$.MODULE$.handleInfinity(n));
            return document;
        }
        if (jValue instanceof JDecimal) {
            BigDecimal bigDecimal;
            JDecimal jDecimal = JDecimal$.MODULE$.unapply((JDecimal)jValue);
            BigDecimal n = bigDecimal = jDecimal._1();
            document = Document$.MODULE$.text(n.toString());
            return document;
        }
        if (jValue instanceof JLong) {
            long l;
            JLong jLong = JLong$.MODULE$.unapply((JLong)jValue);
            long n = l = jLong._1();
            document = Document$.MODULE$.text(BoxesRunTime.boxToLong((long)n).toString());
            return document;
        }
        if (jValue instanceof JInt) {
            BigInt bigInt;
            JInt jInt = JInt$.MODULE$.unapply((JInt)jValue);
            BigInt n = bigInt = jInt._1();
            document = Document$.MODULE$.text(n.toString());
            return document;
        }
        if (JNull$.MODULE$.equals(jValue)) {
            document = Document$.MODULE$.text("null");
            return document;
        }
        if (JNothing$.MODULE$.equals(jValue)) {
            throw package$.MODULE$.error("can't render 'nothing'");
        }
        if (jValue instanceof JString) {
            JString jString = JString$.MODULE$.unapply((JString)jValue);
            String string = jString._1();
            if (string == null) {
                document = Document$.MODULE$.text("null");
                return document;
            }
            String s = string;
            document = Document$.MODULE$.text(new StringBuilder(2).append("\"").append(ParserUtil$.MODULE$.quote(s, alwaysEscapeUnicode)).append("\"").toString());
            return document;
        }
        if (jValue instanceof JArray) {
            List list2;
            JArray jArray = JArray$.MODULE$.unapply((JArray)jValue);
            List arr = list2 = jArray._1();
            Document document2 = Document$.MODULE$.text("[");
            Document document3 = this.series((Iterable<Document>)((Iterable)this.trimArr((Iterable<JValue>)arr).map((Function1 & Serializable)_$1 -> this.render((JValue)_$1, alwaysEscapeUnicode, emptyValueStrategy))));
            document = Document$.MODULE$.text("]").$colon$colon(document3).$colon$colon(document2);
            return document;
        }
        if (jValue instanceof JSet) {
            Set set;
            JSet jSet = JSet$.MODULE$.unapply((JSet)jValue);
            Set set2 = set = jSet._1();
            Document document4 = Document$.MODULE$.text("[");
            Document document5 = this.series((Iterable<Document>)((Iterable)this.trimArr((Iterable<JValue>)set2).map((Function1 & Serializable)_$2 -> this.render((JValue)_$2, alwaysEscapeUnicode, emptyValueStrategy))));
            document = Document$.MODULE$.text("]").$colon$colon(document5).$colon$colon(document4);
            return document;
        }
        if (!(jValue instanceof JObject)) throw new MatchError((Object)jValue);
        JObject jObject = JObject$.MODULE$.unapply((JObject)jValue);
        List obj = list = jObject._1();
        Document document6 = Document$.MODULE$.break();
        Document nested = this.fields((List<Document>)this.trimObj((List<Tuple2<String, JValue>>)obj).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String n = (String)tuple2._1();
            JValue v = (JValue)tuple2._2();
            Document document = Document$.MODULE$.text(new StringBuilder(3).append("\"").append(ParserUtil$.MODULE$.quote(n, alwaysEscapeUnicode)).append("\":").toString());
            return this.render(v, alwaysEscapeUnicode, emptyValueStrategy).$colon$colon(document);
        })).$colon$colon(document6);
        Document document7 = Document$.MODULE$.text("{");
        Document document8 = Document$.MODULE$.nest(2, nested);
        Document document9 = Document$.MODULE$.break();
        document = Document$.MODULE$.text("}").$colon$colon(document9).$colon$colon(document8).$colon$colon(document7);
        return document;
    }

    public static boolean render$default$2$(JsonMethods $this) {
        return $this.render$default$2();
    }

    default public boolean render$default$2() {
        return false;
    }

    public static EmptyValueStrategy render$default$3$(JsonMethods $this) {
        return $this.render$default$3();
    }

    default public EmptyValueStrategy render$default$3() {
        return EmptyValueStrategy$.MODULE$.default();
    }

    private WithFilter<JValue, Iterable> trimArr(Iterable<JValue> xs) {
        return xs.withFilter((Function1 & Serializable)_$3 -> {
            JValue jValue = _$3;
            JNothing$ jNothing$ = JNothing$.MODULE$;
            return jValue == null ? jNothing$ != null : !jValue.equals(jNothing$);
        });
    }

    private List<Tuple2<String, JValue>> trimObj(List<Tuple2<String, JValue>> xs) {
        return xs.filter((Function1 & Serializable)_$4 -> {
            Object object = _$4._2();
            JNothing$ jNothing$ = JNothing$.MODULE$;
            return object == null ? jNothing$ != null : !object.equals(jNothing$);
        });
    }

    private Document series(Iterable<Document> docs) {
        return this.punctuate(Document$.MODULE$.text(","), docs);
    }

    private Document fields(List<Document> docs) {
        Document document = Document$.MODULE$.text(",");
        return this.punctuate(Document$.MODULE$.break().$colon$colon(document), (Iterable<Document>)docs);
    }

    private Document punctuate(Document p, Iterable<Document> docs) {
        return docs.isEmpty() ? Document$.MODULE$.empty() : (Document)docs.reduceLeft((Function2 & Serializable)(d1, d2) -> d2.$colon$colon(p).$colon$colon((Document)d1));
    }

    public static String compact$(JsonMethods $this, Document d) {
        return $this.compact(d);
    }

    default public String compact(Document d) {
        return Printer$.MODULE$.compact(d);
    }

    public static String pretty$(JsonMethods $this, Document d) {
        return $this.pretty(d);
    }

    default public String pretty(Document d) {
        return Printer$.MODULE$.pretty(d);
    }
}

