/*
 * Decompiled with CFR 0.152.
 */
package ambience.i18n.editor;

import ambience.i18n.common.Language;
import ambience.i18n.common.Language$;
import ambience.i18n.editor.ActionHandler$;
import ambience.i18n.editor.I18NLanguages$;
import ambience.i18n.editor.I18nEditorModule;
import ambience.i18n.editor.ResourceBundleHandler$;
import ambience.i18n.editor.UploadHandler$MasterStructure$;
import ambience.i18n.editor.UploadHandler$MasterUploadStructure$;
import ambience.i18n.editor.UploadHandler$TranslationStructure$;
import ambience.i18n.editor.UploadHandler$TranslationUploadStructure$;
import ambience.i18n.editor.UploadHandler$TranslationsStructure$;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.KeyDecoder$;
import io.circe.KeyEncoder$;
import io.circe.ParsingFailure;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple1$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class UploadHandler
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UploadHandler.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;

    public UploadHandler(I18nEditorModule module) {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Either<String, Json>> handleUpload(UserDB.User user, String format, byte[] bytes, String filename, boolean isMaster) {
        String str = new String(bytes, Gravity$.MODULE$.UTF_8());
        String string = format;
        if (".json".equals(string)) {
            if (isMaster) {
                return this.doJsonMaster(user, str, isMaster);
            }
            return this.doJsonTranslations(user, str, isMaster);
        }
        if (".properties".equals(string)) {
            if (isMaster) {
                return this.doResourceBundleMaster(user, str, filename, isMaster);
            }
            return this.doResourceBundleTranslations(user, str, filename, isMaster);
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"Unsupported format"));
    }

    public Task<Either<String, Json>> doJsonMaster(UserDB.User user, String str, boolean isMaster) {
        Either either = io.circe.parser.package$.MODULE$.parse(str);
        if (either instanceof Right) {
            Json masterJson = (Json)((Right)either).value();
            String string = "name";
            String string2 = "master";
            int size = 2;
            Either either2 = masterJson.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("MasterUploadStructure", UploadHandler::doJsonMaster$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), UploadHandler::doJsonMaster$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(UploadHandler::doJsonMaster$$anonfun$3)))));
            if (either2 instanceof Right) {
                MasterUploadStructure fus = (MasterUploadStructure)((Right)either2).value();
                String uuid = UUID.randomUUID().toString();
                Object[] objectArray = new Tuple2[4];
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tempId");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(uuid));
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString(fus.name()));
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
                objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.fromString(uuid));
                String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"master");
                Iterable iterable = (Iterable)io.circe.syntax.package$.MODULE$.EncoderOps(fus.master().map((Function1 & Serializable)x -> {
                    Object[] objectArray = new Tuple2[2];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"key");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, x._1());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, x._2());
                    return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                }));
                objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)iterable, (Encoder)Encoder$.MODULE$.encodeIterable((Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString()), Predef$.MODULE$.$conforms())));
                Document doc = org.mongodb.scala.package$.MODULE$.Document().apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).noSpaces());
                return this.addImportMaster(user, doc, uuid).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.buildJsonResponse(uuid, isMaster, this.buildJsonResponse$default$3(), this.buildJsonResponse$default$4()).map((Function1 & Serializable)json -> package$.MODULE$.Right().apply(json));
                });
            }
            if (either2 instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either2).value();
                String string7 = "translations";
                boolean size2 = true;
                Either either3 = masterJson.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("TranslationUploadStructure", UploadHandler::doJsonMaster$$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string7), UploadHandler::doJsonMaster$$anonfun$6, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(UploadHandler::doJsonMaster$$anonfun$7)))));
                if (either3 instanceof Right) {
                    TranslationUploadStructure fus = (TranslationUploadStructure)((Right)either3).value();
                    String uuid = UUID.randomUUID().toString();
                    TranslationStructure translation = (TranslationStructure)fus.translations().headOption().getOrElse(UploadHandler::$anonfun$5);
                    Object[] objectArray = new Tuple2[4];
                    String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tempId");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)Json$.MODULE$.fromString(uuid));
                    String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)Json$.MODULE$.fromString(""));
                    String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
                    objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)Json$.MODULE$.fromString(uuid));
                    String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)"master");
                    Iterable iterable = (Iterable)io.circe.syntax.package$.MODULE$.EncoderOps(translation.translation().map((Function1 & Serializable)x -> {
                        Object[] objectArray = new Tuple2[2];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"key");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, x._1());
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, x._2());
                        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }));
                    objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)iterable, (Encoder)Encoder$.MODULE$.encodeIterable((Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString()), Predef$.MODULE$.$conforms())));
                    Document doc = org.mongodb.scala.package$.MODULE$.Document().apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).noSpaces());
                    return this.addImportMaster(user, doc, uuid).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.buildJsonResponse(uuid, isMaster, this.buildJsonResponse$default$3(), this.buildJsonResponse$default$4()).map((Function1 & Serializable)json -> package$.MODULE$.Right().apply(json));
                    });
                }
                if (either3 instanceof Left) {
                    DecodingFailure err2 = (DecodingFailure)((Left)either3).value();
                    this.log().error(() -> UploadHandler.doJsonMaster$$anonfun$9(err2), Line$.MODULE$.apply(111), FullName$.MODULE$.apply("ambience.i18n.editor.UploadHandler.doJsonMaster"));
                    return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"Decode json failed"));
                }
                throw new MatchError((Object)either3);
            }
            throw new MatchError((Object)either2);
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            this.log().error(() -> UploadHandler.doJsonMaster$$anonfun$10(err), Line$.MODULE$.apply(116), FullName$.MODULE$.apply("ambience.i18n.editor.UploadHandler.doJsonMaster"));
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"Decode json failed"));
        }
        throw new MatchError((Object)either);
    }

    public Task<Either<String, Json>> doJsonTranslations(UserDB.User user, String str, boolean isMaster) {
        Either either = io.circe.parser.package$.MODULE$.parse(str);
        if (either instanceof Right) {
            Json translationJson = (Json)((Right)either).value();
            String string = "translations";
            boolean size = true;
            Either either2 = translationJson.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("TranslationUploadStructure", UploadHandler::doJsonTranslations$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), UploadHandler::doJsonTranslations$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(UploadHandler::doJsonTranslations$$anonfun$3)))));
            if (either2 instanceof Right) {
                TranslationUploadStructure fus = (TranslationUploadStructure)((Right)either2).value();
                List languageList = fus.translations().map((Function1 & Serializable)x -> x.languageCode());
                List<Language> validLanguages = this.filterValidLanguageCodes((List<String>)languageList);
                int invalidCodesTotal = languageList.length() - validLanguages.length();
                String uuid = UUID.randomUUID().toString();
                List seqDoc = fus.translations().map((Function1 & Serializable)translations -> {
                    Object[] objectArray = new Tuple2[4];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"tempId");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(uuid));
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"languageCode");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(translations.languageCode()));
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"languageName");
                    objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(translations.languageName()));
                    String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"translation");
                    Iterable iterable = (Iterable)io.circe.syntax.package$.MODULE$.EncoderOps(translations.translation().map((Function1 & Serializable)x -> {
                        Object[] objectArray = new Tuple2[2];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"key");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, x._1());
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, x._2());
                        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    }));
                    objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)iterable, (Encoder)Encoder$.MODULE$.encodeIterable((Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString()), Predef$.MODULE$.$conforms())));
                    return org.mongodb.scala.package$.MODULE$.Document().apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).noSpaces());
                });
                return this.addImportTranslations(user, validLanguages, (List<Document>)seqDoc, uuid).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.buildJsonResponse(uuid, isMaster, invalidCodesTotal, validLanguages).map((Function1 & Serializable)json -> package$.MODULE$.Right().apply(json));
                });
            }
            if (either2 instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either2).value();
                this.log().error(() -> UploadHandler.doJsonTranslations$$anonfun$5(err), Line$.MODULE$.apply(147), FullName$.MODULE$.apply("ambience.i18n.editor.UploadHandler.doJsonTranslations"));
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"Decode upload failed"));
            }
            throw new MatchError((Object)either2);
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            this.log().error(() -> UploadHandler.doJsonTranslations$$anonfun$6(err), Line$.MODULE$.apply(151), FullName$.MODULE$.apply("ambience.i18n.editor.UploadHandler.doJsonTranslations"));
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"Decode json failed"));
        }
        throw new MatchError((Object)either);
    }

    public Task<Either<String, Json>> doResourceBundleMaster(UserDB.User user, String str, String filename, boolean isMaster) {
        String string = "master";
        boolean size = true;
        Either either = ResourceBundleHandler$.MODULE$.tryResourceBundle(str, isMaster).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("MasterStructure", UploadHandler::doResourceBundleMaster$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), UploadHandler::doResourceBundleMaster$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(UploadHandler::doResourceBundleMaster$$anonfun$3)))));
        if (either instanceof Right) {
            MasterStructure fus = (MasterStructure)((Right)either).value();
            String name = this.getMasterNameFromFilename(filename);
            String uuid = UUID.randomUUID().toString();
            Object[] objectArray = new Tuple2[4];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tempId");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(uuid));
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(uuid));
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString(name));
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"master");
            Iterable iterable = (Iterable)io.circe.syntax.package$.MODULE$.EncoderOps(fus.master().map((Function1 & Serializable)x -> {
                Object[] objectArray = new Tuple2[2];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"key");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, x._1());
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, x._2());
                return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }));
            objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)iterable, (Encoder)Encoder$.MODULE$.encodeIterable((Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString()), Predef$.MODULE$.$conforms())));
            Document doc = org.mongodb.scala.package$.MODULE$.Document().apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).noSpaces());
            return this.addImportMaster(user, doc, uuid).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.buildJsonResponse(uuid, isMaster, this.buildJsonResponse$default$3(), this.buildJsonResponse$default$4()).map((Function1 & Serializable)json -> package$.MODULE$.Right().apply(json));
            });
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().error(() -> UploadHandler.doResourceBundleMaster$$anonfun$5(err), Line$.MODULE$.apply(178), FullName$.MODULE$.apply("ambience.i18n.editor.UploadHandler.doResourceBundleMaster"));
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"Decode resource bundle failed"));
        }
        throw new MatchError((Object)either);
    }

    public Task<Either<String, Json>> doResourceBundleTranslations(UserDB.User user, String str, String filename, boolean isMaster) {
        String string = "translation";
        boolean size = true;
        Either either = ResourceBundleHandler$.MODULE$.tryResourceBundle(str, isMaster).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("TranslationsStructure", UploadHandler::doResourceBundleTranslations$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), UploadHandler::doResourceBundleTranslations$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(UploadHandler::doResourceBundleTranslations$$anonfun$3)))));
        if (either instanceof Right) {
            TranslationsStructure fus = (TranslationsStructure)((Right)either).value();
            String languageCode = this.getCodeFromFilename(filename);
            List languages = (List)new .colon.colon((Object)languageCode, (List)Nil$.MODULE$);
            if (languages.nonEmpty()) {
                List<Language> validLanguages = this.filterValidLanguageCodes((List<String>)languages);
                Language language = (Language)validLanguages.headOption().getOrElse(UploadHandler::$anonfun$13);
                int invalidCodesTotal = languages.length() - validLanguages.length();
                String uuid = UUID.randomUUID().toString();
                Object[] objectArray = new Tuple2[4];
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tempId");
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(uuid));
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"languageCode");
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(language.languageCode()));
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"languageName");
                objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString(language.languageName()));
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"translation");
                Iterable iterable = (Iterable)io.circe.syntax.package$.MODULE$.EncoderOps(fus.translation().map((Function1 & Serializable)x -> {
                    Object[] objectArray = new Tuple2[2];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"key");
                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, x._1());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
                    objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, x._2());
                    return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                }));
                objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)iterable, (Encoder)Encoder$.MODULE$.encodeIterable((Encoder)Encoder$.MODULE$.encodeMap(KeyEncoder$.MODULE$.encodeKeyString(), Encoder$.MODULE$.encodeString()), Predef$.MODULE$.$conforms())));
                Document seqDoc = org.mongodb.scala.package$.MODULE$.Document().apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).noSpaces());
                return this.addImportTranslation(user, validLanguages, seqDoc, uuid).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.buildJsonResponse(uuid, isMaster, invalidCodesTotal, validLanguages).map((Function1 & Serializable)json -> package$.MODULE$.Right().apply(json));
                });
            }
            this.log().error(UploadHandler::doResourceBundleTranslations$$anonfun$5, Line$.MODULE$.apply(211), FullName$.MODULE$.apply("ambience.i18n.editor.UploadHandler.doResourceBundleTranslations"));
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"Failed to get language code from filename"));
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().error(() -> UploadHandler.doResourceBundleTranslations$$anonfun$6(err), Line$.MODULE$.apply(216), FullName$.MODULE$.apply("ambience.i18n.editor.UploadHandler.doResourceBundleTranslations"));
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)"Decode resource bundle failed"));
        }
        throw new MatchError((Object)either);
    }

    public Task<BoxedUnit> addImportTranslations(UserDB.User user, List<Language> languageCodes, List<Document> translations, String tempId) {
        List<Document> list = translations;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Document> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Document head = (Document)colon2.head();
            List tail = list3;
            return this.addImportTranslation(user, languageCodes, head, tempId).flatMap((Function1 & Serializable)_$1 -> this.addImportTranslations(user, languageCodes, (List<Document>)tail, tempId));
        }
        throw new MatchError(list);
    }

    public Task<BoxedUnit> addImportTranslation(UserDB.User user, List<Language> languageCodes, Document translation, String tempId) {
        String languageCode = (String)translation.get("languageCode", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).getOrElse(UploadHandler::$anonfun$16);
        String uuid = UUID.randomUUID().toString();
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)uuid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tempId");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)tempId), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        Document doc = (Document)translation.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (languageCodes.contains((Object)languageCode) || languageCodes.nonEmpty()) {
            return ActionHandler$.MODULE$.getTempI18nCollection(tempId).insertOneT(doc).void();
        }
        return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
    }

    public Task<BoxedUnit> addImportMaster(UserDB.User user, Document master, String tempId) {
        String uuid = UUID.randomUUID().toString();
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)uuid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tempId");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)tempId), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        Document doc = (Document)master.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return ActionHandler$.MODULE$.getTempI18nCollection(tempId).insertOneT(doc).void();
    }

    public List<Language> filterValidLanguageCodes(List<String> uploadedLanguages) {
        return ((IterableOnceOps)((IterableOps)I18NLanguages$.MODULE$.localeMap().filter((Function1 & Serializable)x -> uploadedLanguages.contains(x._1()))).map((Function1 & Serializable)x -> Language$.MODULE$.apply((String)x._1(), (String)x._2()))).toList();
    }

    public Task<Json> buildJsonResponse(String tempId, boolean isMaster, int invalidCode, List<Language> validLanguages) {
        return Task$.MODULE$.apply(() -> UploadHandler.buildJsonResponse$$anonfun$1(tempId, invalidCode, validLanguages, isMaster));
    }

    public int buildJsonResponse$default$3() {
        return 0;
    }

    public List<Language> buildJsonResponse$default$4() {
        return package$.MODULE$.Nil();
    }

    public String getCodeFromFilename(String filename) {
        Object object;
        String rawCode = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(filename.substring(filename.indexOf("_") + 1)), 11);
        String[] stringArray = rawCode.split("_");
        if (stringArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray), 2) == 0) {
            String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
            String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
            String language = string;
            String variant = string2;
            return language + "-" + variant;
        }
        return rawCode;
    }

    public String getMasterNameFromFilename(String filename) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])filename.split("_"));
        return (String)ArrayOps$.MODULE$.headOption$extension(object).getOrElse(UploadHandler::getMasterNameFromFilename$$anonfun$1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List doJsonMaster$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeString());
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 doJsonMaster$$anonfun$2() {
        UploadHandler$MasterUploadStructure$ uploadHandler$MasterUploadStructure$ = UploadHandler$MasterUploadStructure$.MODULE$;
        return (Function1 & Serializable)p -> (MasterUploadStructure)uploadHandler$MasterUploadStructure$.fromProduct((Product)p);
    }

    private static final Product doJsonMaster$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)Some$.MODULE$.apply(UploadHandler$MasterUploadStructure$.MODULE$.$lessinit$greater$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var3_2;
        void var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeString());
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$3() {
        UploadHandler$TranslationStructure$ uploadHandler$TranslationStructure$ = UploadHandler$TranslationStructure$.MODULE$;
        return (Function1 & Serializable)p -> (TranslationStructure)uploadHandler$TranslationStructure$.fromProduct((Product)p);
    }

    private static final Product $anonfun$4() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply(UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$5()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List doJsonMaster$$anonfun$5() {
        void var1_6;
        String string = "_id";
        String string2 = "masterId";
        String string3 = "languageCode";
        String string4 = "languageName";
        String string5 = "translation";
        int size = 5;
        Decoder decodeA = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("TranslationStructure", UploadHandler::$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), UploadHandler::$anonfun$3, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(UploadHandler::$anonfun$4)))));
        void var0_7 = var1_6;
        return package$.MODULE$.Nil().$colon$colon((Object)var0_7);
    }

    private static final Function1 doJsonMaster$$anonfun$6() {
        UploadHandler$TranslationUploadStructure$ uploadHandler$TranslationUploadStructure$ = UploadHandler$TranslationUploadStructure$.MODULE$;
        return (Function1 & Serializable)p -> (TranslationUploadStructure)uploadHandler$TranslationUploadStructure$.fromProduct((Product)p);
    }

    private static final Product doJsonMaster$$anonfun$7() {
        return Tuple1$.MODULE$.apply((Object)None$.MODULE$);
    }

    private static final TranslationStructure $anonfun$5() {
        return UploadHandler$TranslationStructure$.MODULE$.apply(UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$1(), UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$2(), UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$3(), UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$4(), UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Object doJsonMaster$$anonfun$9(DecodingFailure err$1) {
        return "Cannot decode uploaded file as json: " + err$1;
    }

    private static final Object doJsonMaster$$anonfun$10(ParsingFailure err$2) {
        return "Cannot decode uploaded file as json: " + err$2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$7() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var3_2;
        void var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeString());
        return package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$8() {
        UploadHandler$TranslationStructure$ uploadHandler$TranslationStructure$ = UploadHandler$TranslationStructure$.MODULE$;
        return (Function1 & Serializable)p -> (TranslationStructure)uploadHandler$TranslationStructure$.fromProduct((Product)p);
    }

    private static final Product $anonfun$9() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply(UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$5()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List doJsonTranslations$$anonfun$1() {
        void var1_6;
        String string = "_id";
        String string2 = "masterId";
        String string3 = "languageCode";
        String string4 = "languageName";
        String string5 = "translation";
        int size = 5;
        Decoder decodeA = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("TranslationStructure", UploadHandler::$anonfun$7, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), UploadHandler::$anonfun$8, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(UploadHandler::$anonfun$9)))));
        void var0_7 = var1_6;
        return package$.MODULE$.Nil().$colon$colon((Object)var0_7);
    }

    private static final Function1 doJsonTranslations$$anonfun$2() {
        UploadHandler$TranslationUploadStructure$ uploadHandler$TranslationUploadStructure$ = UploadHandler$TranslationUploadStructure$.MODULE$;
        return (Function1 & Serializable)p -> (TranslationUploadStructure)uploadHandler$TranslationUploadStructure$.fromProduct((Product)p);
    }

    private static final Product doJsonTranslations$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)None$.MODULE$);
    }

    private static final Object doJsonTranslations$$anonfun$5(DecodingFailure err$3) {
        return "Cannot decode uploaded file as upload: " + err$3;
    }

    private static final Object doJsonTranslations$$anonfun$6(ParsingFailure err$4) {
        return "Cannot decode uploaded file as json: " + err$4;
    }

    /*
     * WARNING - void declaration
     */
    private static final List doResourceBundleMaster$$anonfun$1() {
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeString());
        void var0_1 = var1;
        return package$.MODULE$.Nil().$colon$colon((Object)var0_1);
    }

    private static final Function1 doResourceBundleMaster$$anonfun$2() {
        UploadHandler$MasterStructure$ uploadHandler$MasterStructure$ = UploadHandler$MasterStructure$.MODULE$;
        return (Function1 & Serializable)p -> (MasterStructure)uploadHandler$MasterStructure$.fromProduct((Product)p);
    }

    private static final Product doResourceBundleMaster$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply(UploadHandler$MasterStructure$.MODULE$.$lessinit$greater$default$1()));
    }

    private static final Object doResourceBundleMaster$$anonfun$5(DecodingFailure err$5) {
        return "Cannot decode uploaded file as resource bundle: " + err$5;
    }

    /*
     * WARNING - void declaration
     */
    private static final List doResourceBundleTranslations$$anonfun$1() {
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.decodeString());
        void var0_1 = var1;
        return package$.MODULE$.Nil().$colon$colon((Object)var0_1);
    }

    private static final Function1 doResourceBundleTranslations$$anonfun$2() {
        UploadHandler$TranslationsStructure$ uploadHandler$TranslationsStructure$ = UploadHandler$TranslationsStructure$.MODULE$;
        return (Function1 & Serializable)p -> (TranslationsStructure)uploadHandler$TranslationsStructure$.fromProduct((Product)p);
    }

    private static final Product doResourceBundleTranslations$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply(UploadHandler$TranslationsStructure$.MODULE$.$lessinit$greater$default$1()));
    }

    private static final Language $anonfun$13() {
        return Language$.MODULE$.apply(Language$.MODULE$.$lessinit$greater$default$1(), Language$.MODULE$.$lessinit$greater$default$2());
    }

    private static final Object doResourceBundleTranslations$$anonfun$5() {
        return "Invalid language code";
    }

    private static final Object doResourceBundleTranslations$$anonfun$6(DecodingFailure err$6) {
        return "Cannot decode uploaded file as resource bundle: " + err$6;
    }

    private static final String $anonfun$16() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static final List buildJsonResponse$$anonfun$1$$anonfun$1() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Json buildJsonResponse$$anonfun$1(String tempId$2, int invalidCode$1, List validLanguages$3, boolean isMaster$6) {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"tempId");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(tempId$2));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"invalidTranslationTotal");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromInt(invalidCode$1));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"importedLanguages");
        List list = (List)io.circe.syntax.package$.MODULE$.EncoderOps((Object)validLanguages$3);
        String string4 = "languageCode";
        String string5 = "languageName";
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)package.EncoderOps$.MODULE$.asJson$extension((Object)list, (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(UploadHandler::buildJsonResponse$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4), Configuration$.MODULE$.default()))))));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"isMaster");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Json$.MODULE$.fromBoolean(isMaster$6));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final String getMasterNameFromFilename$$anonfun$1() {
        return "";
    }

    public static final class MasterStructure
    implements Product,
    Serializable {
        private final Map master;

        public static MasterStructure apply(Map<String, String> map) {
            return UploadHandler$MasterStructure$.MODULE$.apply(map);
        }

        public static MasterStructure fromProduct(Product product) {
            return UploadHandler$MasterStructure$.MODULE$.fromProduct(product);
        }

        public static MasterStructure unapply(MasterStructure masterStructure) {
            return UploadHandler$MasterStructure$.MODULE$.unapply(masterStructure);
        }

        public static Map<String, String> $lessinit$greater$default$1() {
            return UploadHandler$MasterStructure$.MODULE$.$lessinit$greater$default$1();
        }

        public MasterStructure(Map<String, String> master) {
            this.master = master;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MasterStructure)) return false;
            MasterStructure masterStructure = (MasterStructure)object;
            Map<String, String> map = this.master();
            Map<String, String> map2 = masterStructure.master();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MasterStructure;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "MasterStructure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "master";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<String, String> master() {
            return this.master;
        }

        public MasterStructure copy(Map<String, String> master) {
            return new MasterStructure(master);
        }

        public Map<String, String> copy$default$1() {
            return this.master();
        }

        public Map<String, String> _1() {
            return this.master();
        }
    }

    public static final class MasterUploadStructure
    implements Product,
    Serializable {
        private final String name;
        private final Map master;

        public static MasterUploadStructure apply(String string, Map<String, String> map) {
            return UploadHandler$MasterUploadStructure$.MODULE$.apply(string, map);
        }

        public static MasterUploadStructure fromProduct(Product product) {
            return UploadHandler$MasterUploadStructure$.MODULE$.fromProduct(product);
        }

        public static MasterUploadStructure unapply(MasterUploadStructure masterUploadStructure) {
            return UploadHandler$MasterUploadStructure$.MODULE$.unapply(masterUploadStructure);
        }

        public static Map<String, String> $lessinit$greater$default$2() {
            return UploadHandler$MasterUploadStructure$.MODULE$.$lessinit$greater$default$2();
        }

        public MasterUploadStructure(String name, Map<String, String> master) {
            this.name = name;
            this.master = master;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MasterUploadStructure)) return false;
            MasterUploadStructure masterUploadStructure = (MasterUploadStructure)object;
            String string = this.name();
            String string2 = masterUploadStructure.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Map<String, String> map = this.master();
            Map<String, String> map2 = masterUploadStructure.master();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MasterUploadStructure;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MasterUploadStructure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "master";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public Map<String, String> master() {
            return this.master;
        }

        public MasterUploadStructure copy(String name, Map<String, String> master) {
            return new MasterUploadStructure(name, master);
        }

        public String copy$default$1() {
            return this.name();
        }

        public Map<String, String> copy$default$2() {
            return this.master();
        }

        public String _1() {
            return this.name();
        }

        public Map<String, String> _2() {
            return this.master();
        }
    }

    public static final class TranslationStructure
    implements Product,
    Serializable {
        private final String _id;
        private final String masterId;
        private final String languageCode;
        private final String languageName;
        private final Map translation;

        public static TranslationStructure apply(String string, String string2, String string3, String string4, Map<String, String> map) {
            return UploadHandler$TranslationStructure$.MODULE$.apply(string, string2, string3, string4, map);
        }

        public static TranslationStructure fromProduct(Product product) {
            return UploadHandler$TranslationStructure$.MODULE$.fromProduct(product);
        }

        public static TranslationStructure unapply(TranslationStructure translationStructure) {
            return UploadHandler$TranslationStructure$.MODULE$.unapply(translationStructure);
        }

        public static String $lessinit$greater$default$1() {
            return UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$1();
        }

        public static String $lessinit$greater$default$2() {
            return UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$2();
        }

        public static String $lessinit$greater$default$3() {
            return UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$3();
        }

        public static String $lessinit$greater$default$4() {
            return UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$4();
        }

        public static Map<String, String> $lessinit$greater$default$5() {
            return UploadHandler$TranslationStructure$.MODULE$.$lessinit$greater$default$5();
        }

        public TranslationStructure(String _id, String masterId, String languageCode, String languageName, Map<String, String> translation) {
            this._id = _id;
            this.masterId = masterId;
            this.languageCode = languageCode;
            this.languageName = languageName;
            this.translation = translation;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TranslationStructure)) return false;
            TranslationStructure translationStructure = (TranslationStructure)object;
            String string = this._id();
            String string2 = translationStructure._id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.masterId();
            String string4 = translationStructure.masterId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.languageCode();
            String string6 = translationStructure.languageCode();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.languageName();
            String string8 = translationStructure.languageName();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            Map<String, String> map = this.translation();
            Map<String, String> map2 = translationStructure.translation();
            if (map == null) {
                if (map2 == null) return true;
                return false;
            } else {
                if (!map.equals(map2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TranslationStructure;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "TranslationStructure";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "_id";
                }
                case 1: {
                    return "masterId";
                }
                case 2: {
                    return "languageCode";
                }
                case 3: {
                    return "languageName";
                }
                case 4: {
                    return "translation";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String _id() {
            return this._id;
        }

        public String masterId() {
            return this.masterId;
        }

        public String languageCode() {
            return this.languageCode;
        }

        public String languageName() {
            return this.languageName;
        }

        public Map<String, String> translation() {
            return this.translation;
        }

        public TranslationStructure copy(String _id, String masterId, String languageCode, String languageName, Map<String, String> translation) {
            return new TranslationStructure(_id, masterId, languageCode, languageName, translation);
        }

        public String copy$default$1() {
            return this._id();
        }

        public String copy$default$2() {
            return this.masterId();
        }

        public String copy$default$3() {
            return this.languageCode();
        }

        public String copy$default$4() {
            return this.languageName();
        }

        public Map<String, String> copy$default$5() {
            return this.translation();
        }

        public String _1() {
            return this._id();
        }

        public String _2() {
            return this.masterId();
        }

        public String _3() {
            return this.languageCode();
        }

        public String _4() {
            return this.languageName();
        }

        public Map<String, String> _5() {
            return this.translation();
        }
    }

    public static final class TranslationUploadStructure
    implements Product,
    Serializable {
        private final List translations;

        public static TranslationUploadStructure apply(List<TranslationStructure> list) {
            return UploadHandler$TranslationUploadStructure$.MODULE$.apply(list);
        }

        public static TranslationUploadStructure fromProduct(Product product) {
            return UploadHandler$TranslationUploadStructure$.MODULE$.fromProduct(product);
        }

        public static TranslationUploadStructure unapply(TranslationUploadStructure translationUploadStructure) {
            return UploadHandler$TranslationUploadStructure$.MODULE$.unapply(translationUploadStructure);
        }

        public TranslationUploadStructure(List<TranslationStructure> translations) {
            this.translations = translations;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TranslationUploadStructure)) return false;
            TranslationUploadStructure translationUploadStructure = (TranslationUploadStructure)object;
            List<TranslationStructure> list = this.translations();
            List<TranslationStructure> list2 = translationUploadStructure.translations();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TranslationUploadStructure;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TranslationUploadStructure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "translations";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<TranslationStructure> translations() {
            return this.translations;
        }

        public TranslationUploadStructure copy(List<TranslationStructure> translations) {
            return new TranslationUploadStructure(translations);
        }

        public List<TranslationStructure> copy$default$1() {
            return this.translations();
        }

        public List<TranslationStructure> _1() {
            return this.translations();
        }
    }

    public static final class TranslationsStructure
    implements Product,
    Serializable {
        private final Map translation;

        public static TranslationsStructure apply(Map<String, String> map) {
            return UploadHandler$TranslationsStructure$.MODULE$.apply(map);
        }

        public static TranslationsStructure fromProduct(Product product) {
            return UploadHandler$TranslationsStructure$.MODULE$.fromProduct(product);
        }

        public static TranslationsStructure unapply(TranslationsStructure translationsStructure) {
            return UploadHandler$TranslationsStructure$.MODULE$.unapply(translationsStructure);
        }

        public static Map<String, String> $lessinit$greater$default$1() {
            return UploadHandler$TranslationsStructure$.MODULE$.$lessinit$greater$default$1();
        }

        public TranslationsStructure(Map<String, String> translation) {
            this.translation = translation;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TranslationsStructure)) return false;
            TranslationsStructure translationsStructure = (TranslationsStructure)object;
            Map<String, String> map = this.translation();
            Map<String, String> map2 = translationsStructure.translation();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TranslationsStructure;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TranslationsStructure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "translation";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<String, String> translation() {
            return this.translation;
        }

        public TranslationsStructure copy(Map<String, String> translation) {
            return new TranslationsStructure(translation);
        }

        public Map<String, String> copy$default$1() {
            return this.translation();
        }

        public Map<String, String> _1() {
            return this.translation();
        }
    }
}

