/*
 * Decompiled with CFR 0.152.
 */
package ambience.i18n.management;

import ambience.codex.BulkDownload;
import ambience.i18n.management.BulkDownload$;
import better.files.File;
import better.files.File$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.FileDataBytes$;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexFilter;
import io.circe.Json;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class BulkDownload {
    public static Task<BulkDownload.Result> apply(Task<CodexCollection> task, String string, CodexFilter codexFilter, String string2, Set<BsonValue> set, String string3) {
        return BulkDownload$.MODULE$.apply(task, string, codexFilter, string2, set, string3);
    }

    public static String buildJson(Document document) {
        return BulkDownload$.MODULE$.buildJson(document);
    }

    public static BulkDownload.Intermediate buildZip(List<Document> list, String string, String string2) {
        return BulkDownload$.MODULE$.buildZip(list, string, string2);
    }

    public static String buildZipFilename(String string) {
        return BulkDownload$.MODULE$.buildZipFilename(string);
    }

    public static Option<String> getId(String string, Document document) {
        return BulkDownload$.MODULE$.getId(string, document);
    }

    public static Option<String> getName(String string, Document document) {
        return BulkDownload$.MODULE$.getName(string, document);
    }

    public static Task<Option<List<Json>>> getTranslations(String string) {
        return BulkDownload$.MODULE$.getTranslations(string);
    }

    public static LoggingInterface log() {
        return BulkDownload$.MODULE$.log();
    }

    public static class Builder {
        private final String nameField;
        private final String extension;
        private final File tmpDir;
        private final File zipFile;
        private final File outFolder;

        public Builder(String nameField, String extension) {
            this.nameField = nameField;
            this.extension = extension;
            String string = File$.MODULE$.newTemporaryDirectory$default$1();
            Option option = File$.MODULE$.newTemporaryDirectory$default$2();
            this.tmpDir = File$.MODULE$.newTemporaryDirectory(string, option, File$.MODULE$.newTemporaryDirectory$default$3(string, option));
            boolean bl = this.tmpDir().createChild$default$3();
            this.zipFile = this.tmpDir().createChild("bulk.zip", false, bl, this.tmpDir().createChild$default$4("bulk.zip", false, bl), this.tmpDir().createChild$default$5("bulk.zip", false, bl));
            boolean bl2 = this.tmpDir().createChild$default$3();
            this.outFolder = this.tmpDir().createChild("root", true, bl2, this.tmpDir().createChild$default$4("root", true, bl2), this.tmpDir().createChild$default$5("root", true, bl2));
        }

        public File tmpDir() {
            return this.tmpDir;
        }

        public File zipFile() {
            return this.zipFile;
        }

        public File outFolder() {
            return this.outFolder;
        }

        public BulkDownload.Intermediate run(List<Document> documents) {
            List fullNames = documents.flatMap((Function1 & Serializable)doc -> this.exportDoc((Document)doc));
            int n = this.outFolder().zipTo$default$2();
            this.outFolder().zipTo(this.zipFile(), n, this.outFolder().zipTo$default$3(this.zipFile(), n));
            return BulkDownload.Intermediate$.MODULE$.apply(fullNames, (DataBytes)FileDataBytes$.MODULE$.apply(this.zipFile().toJava()));
        }

        public Option<String> exportDoc(Document doc) {
            return BulkDownload$.MODULE$.getName(this.nameField, doc).map((Function1 & Serializable)name -> {
                String fullName = name + "." + this.extension;
                File file = this.outFolder().$div(this.safe(fullName));
                File file2 = file.createFileIfNotExists(true, file.createFileIfNotExists$default$2(true), file.createFileIfNotExists$default$3(true));
                file2.appendText(BulkDownload$.MODULE$.buildJson(doc), StandardCharsets.UTF_8);
                return fullName;
            });
        }

        public String safe(String fullName) {
            return fullName.replace("\\", "_").replace("/", "_").replace(":", "_");
        }

        public void dispose() {
            BulkDownload$.MODULE$.log().info(this::dispose$$anonfun$1, Line$.MODULE$.apply(84), FullName$.MODULE$.apply("ambience.i18n.management.BulkDownload.Builder.dispose"));
            this.tmpDir().delete(this.tmpDir().delete$default$1(), this.tmpDir().delete$default$2());
        }

        private final Object dispose$$anonfun$1() {
            return "Deleting temporary directory " + this.tmpDir().path();
        }
    }
}

