/*
 * Decompiled with CFR 0.152.
 */
package monix.catnap;

import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.implicits$;
import java.io.Serializable;
import monix.catnap.ConcurrentQueue$;
import monix.catnap.ConcurrentQueue$ApplyBuilders$;
import monix.catnap.internal.QueueHelpers;
import monix.execution.BufferCapacity;
import monix.execution.CancelablePromise;
import monix.execution.ChannelType;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicAny$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.atomic.PaddingStrategy$LeftRight128$;
import monix.execution.internal.Constants$;
import monix.execution.internal.collection.LowLevelConcurrentQueue;
import monix.execution.internal.collection.LowLevelConcurrentQueue$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ConcurrentQueue<F, A>
implements Serializable {
    private final Concurrent<F> F;
    private final F tryPollRef;
    private final F pollRef;
    private final F clearRef;
    private final LowLevelConcurrentQueue<A> queue;
    private final QueueHelpers<F> helpers;
    private final AtomicAny<CancelablePromise<BoxedUnit>> consumersAwaiting;
    private final AtomicAny<CancelablePromise<BoxedUnit>> producersAwaiting;
    private final Function0<A> pollQueue;
    private final Function1<A, Object> pollTest;
    private final Function1<A, A> pollMap;
    private final Function1<Object, Object> offerTest;
    private final Function1<Object, BoxedUnit> offerMap;

    public static <F> Concurrent apply(Concurrent<F> concurrent) {
        return ConcurrentQueue$.MODULE$.apply(concurrent);
    }

    public static <F, A> Object bounded(int n, Concurrent<F> concurrent, ContextShift<F> contextShift) {
        return ConcurrentQueue$.MODULE$.bounded(n, concurrent, contextShift);
    }

    public static <F, A> Object unbounded(Option<Object> option, Concurrent<F> concurrent, ContextShift<F> contextShift) {
        return ConcurrentQueue$.MODULE$.unbounded(option, concurrent, contextShift);
    }

    public static <F, A> ConcurrentQueue<F, A> unsafe(BufferCapacity bufferCapacity, ChannelType channelType, Concurrent<F> concurrent, ContextShift<F> contextShift) {
        return ConcurrentQueue$.MODULE$.unsafe(bufferCapacity, channelType, concurrent, contextShift);
    }

    public static <F, A> Object withConfig(BufferCapacity bufferCapacity, ChannelType channelType, Concurrent<F> concurrent, ContextShift<F> contextShift) {
        return ConcurrentQueue$.MODULE$.withConfig(bufferCapacity, channelType, concurrent, contextShift);
    }

    public static <F, A> Option<Object> unbounded$default$1() {
        return ConcurrentQueue$.MODULE$.unbounded$default$1();
    }

    public static <F, A> ChannelType unsafe$default$2() {
        return ConcurrentQueue$.MODULE$.unsafe$default$2();
    }

    public ConcurrentQueue(BufferCapacity capacity, ChannelType channelType, Concurrent<F> F, ContextShift<F> cs) {
        this.F = F;
        this.tryPollRef = F.delay(this::$init$$$anonfun$1);
        this.pollRef = F.defer(() -> this.$init$$$anonfun$2(F));
        this.clearRef = F.delay((Function0)((JFunction0.mcV.sp & Serializable)this::$init$$$anonfun$3));
        this.queue = LowLevelConcurrentQueue$.MODULE$.apply(capacity, channelType, true);
        this.helpers = new QueueHelpers<F>(F, cs);
        this.consumersAwaiting = AtomicAny$.MODULE$.withPadding(null, (PaddingStrategy)PaddingStrategy$LeftRight128$.MODULE$);
        this.producersAwaiting = capacity.isBounded() ? AtomicAny$.MODULE$.withPadding(null, (PaddingStrategy)PaddingStrategy$LeftRight128$.MODULE$) : null;
        this.pollQueue = (Function0 & Serializable)() -> this.tryPollUnsafe();
        this.pollTest = (Function1 & Serializable)_$5 -> _$5 != null;
        this.pollMap = (Function1 & Serializable)a -> a;
        this.offerTest = (Function1 & Serializable)x -> BoxesRunTime.unboxToBoolean((Object)x);
        this.offerMap = (Function1 & Serializable)v1 -> {
            ConcurrentQueue.$init$$$anonfun$8(BoxesRunTime.unboxToBoolean((Object)v1));
            return BoxedUnit.UNIT;
        };
    }

    public F tryOffer(A a) {
        return (F)this.F.delay(() -> this.tryOffer$$anonfun$1(a));
    }

    public F offer(A a) {
        return (F)this.F.defer(() -> this.offer$$anonfun$1(a));
    }

    public F offerMany(Iterable<A> seq) {
        return (F)this.F.defer(() -> this.offerMany$$anonfun$1(seq));
    }

    public F tryPoll() {
        return this.tryPollRef;
    }

    public F poll() {
        return this.pollRef;
    }

    public F drain(int minLength, int maxLength) {
        return (F)this.F.defer(() -> this.drain$$anonfun$1(minLength, maxLength));
    }

    public F clear() {
        return this.clearRef;
    }

    public F isEmpty() {
        return (F)this.F.delay(this::isEmpty$$anonfun$1);
    }

    private boolean tryOfferUnsafe(A a) {
        boolean bl;
        if (this.queue.offer(a) == 0) {
            this.notifyConsumers();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private A tryPollUnsafe() {
        void var1_1;
        Object a = this.queue.poll();
        this.notifyProducers();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int tryDrainUnsafe(ArrayBuffer<A> buffer, int maxLength) {
        void var3_3;
        int length = this.queue.drainToBuffer(buffer, maxLength);
        if (length > 0) {
            this.notifyProducers();
        }
        return (int)var3_3;
    }

    private void notifyConsumers() {
        ConcurrentQueue concurrentQueue = this;
        while (true) {
            concurrentQueue.queue.fenceOffer();
            CancelablePromise ref = (CancelablePromise)concurrentQueue.consumersAwaiting.get();
            if (ref == null) break;
            if (!concurrentQueue.consumersAwaiting.compareAndSet((Object)ref, null)) continue;
            ref.complete(Constants$.MODULE$.successOfUnit());
            break;
        }
    }

    private void notifyProducers() {
        ConcurrentQueue concurrentQueue = this;
        while (concurrentQueue.producersAwaiting != null) {
            concurrentQueue.queue.fencePoll();
            CancelablePromise ref = (CancelablePromise)concurrentQueue.producersAwaiting.get();
            if (ref == null) break;
            if (!concurrentQueue.producersAwaiting.compareAndSet((Object)ref, null)) continue;
            ref.complete(Constants$.MODULE$.successOfUnit());
            break;
        }
    }

    private F offerWait(A a) {
        return (F)this.F.asyncF((Function1 & Serializable)cb -> this.helpers.sleepThenRepeat(this.producersAwaiting, (Function0 & Serializable)() -> this.tryOfferUnsafe(a), this.offerTest, this.offerMap, cb, this.F));
    }

    private Seq<A> toSeq(ArrayBuffer<A> buffer) {
        Object object = Predef$.MODULE$.genericArrayOps(buffer.toArray(ClassTag$.MODULE$.Any()));
        return ArrayOps$.MODULE$.toSeq$extension(object);
    }

    private final Option $init$$$anonfun$1() {
        return Option$.MODULE$.apply(this.tryPollUnsafe());
    }

    private final Object $init$$$anonfun$2(Concurrent F$1) {
        A happy = this.tryPollUnsafe();
        return happy != null ? F$1.pure(happy) : F$1.asyncF((Function1 & Serializable)cb -> this.helpers.sleepThenRepeat(this.consumersAwaiting, this.pollQueue, this.pollTest, this.pollMap, cb, (Concurrent<F>)F$1));
    }

    private final void $init$$$anonfun$3() {
        this.queue.clear();
        this.notifyProducers();
    }

    private static final /* synthetic */ void $init$$$anonfun$8(boolean _$6) {
    }

    private final boolean tryOffer$$anonfun$1(Object a$1) {
        return this.tryOfferUnsafe(a$1);
    }

    private final Object offer$$anonfun$1(Object a$2) {
        return this.tryOfferUnsafe(a$2) ? this.F.unit() : this.offerWait(a$2);
    }

    private final Object loop$1(Iterator cursor) {
        Object elem = null;
        boolean hasCapacity = true;
        while (hasCapacity && cursor.hasNext()) {
            elem = cursor.next();
            hasCapacity = this.queue.offer(elem) == 0;
        }
        this.notifyConsumers();
        return !hasCapacity ? implicits$.MODULE$.toFlatMapOps(this.offerWait(elem), this.F).flatMap((Function1 & Serializable)_$2 -> this.loop$1(cursor)) : this.F.unit();
    }

    private final Object offerMany$$anonfun$1(Iterable seq$1) {
        Iterator cursor = seq$1.iterator();
        return this.loop$1(cursor);
    }

    private final /* synthetic */ Seq drain$$anonfun$1$$anonfun$1$$anonfun$3(ArrayBuffer buffer$4, int _$4) {
        return this.toSeq(buffer$4);
    }

    private final Object drain$$anonfun$1(int minLength$1, int maxLength$1) {
        if (minLength$1 > maxLength$1) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(27).append("minLength (").append(minLength$1).append(") <= maxLength (").append(maxLength$1).toString());
        }
        ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
        int length = this.tryDrainUnsafe(buffer, maxLength$1);
        return length >= minLength$1 ? this.F.pure(this.toSeq(buffer)) : this.F.asyncF((Function1 & Serializable)cb -> this.helpers.sleepThenRepeat(this.consumersAwaiting, (Function0 & Serializable)() -> this.tryDrainUnsafe(buffer, maxLength$1 - buffer.length()), (JFunction1.mcZI.sp & Serializable)_$3 -> buffer.length() >= minLength$1, (Function1 & Serializable)_$4 -> this.drain$$anonfun$1$$anonfun$1$$anonfun$3(buffer, BoxesRunTime.unboxToInt((Object)_$4)), cb, this.F));
    }

    private final boolean isEmpty$$anonfun$1() {
        return this.queue.isEmpty();
    }

    public static final class ApplyBuilders<F> {
        private final Concurrent F;

        public static <A, F> Object bounded$extension(Concurrent concurrent, int n, ContextShift<F> contextShift) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.bounded$extension(concurrent, n, contextShift);
        }

        public static <F> boolean equals$extension(Concurrent concurrent, Object object) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.equals$extension(concurrent, object);
        }

        public static <F> int hashCode$extension(Concurrent concurrent) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.hashCode$extension(concurrent);
        }

        public static <A, F> Object unbounded$extension(Concurrent concurrent, Option<Object> option, ContextShift<F> contextShift) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.unbounded$extension(concurrent, option, contextShift);
        }

        public static <A, F> ConcurrentQueue<F, A> unsafe$extension(Concurrent concurrent, BufferCapacity bufferCapacity, ChannelType channelType, ContextShift<F> contextShift) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.unsafe$extension(concurrent, bufferCapacity, channelType, contextShift);
        }

        public static <A, F> Object withConfig$extension(Concurrent concurrent, BufferCapacity bufferCapacity, ChannelType channelType, ContextShift<F> contextShift) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.withConfig$extension(concurrent, bufferCapacity, channelType, contextShift);
        }

        public static <A, F> ChannelType unsafe$default$2$extension(Concurrent concurrent) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.unsafe$default$2$extension(concurrent);
        }

        public static <A, F> ChannelType withConfig$default$2$extension(Concurrent concurrent) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.withConfig$default$2$extension(concurrent);
        }

        public ApplyBuilders(Concurrent<F> F) {
            this.F = F;
        }

        public int hashCode() {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.hashCode$extension(this.F());
        }

        public boolean equals(Object x$0) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.equals$extension(this.F(), x$0);
        }

        public Concurrent<F> F() {
            return this.F;
        }

        public <A> F bounded(int capacity, ContextShift<F> cs) {
            return (F)ConcurrentQueue$ApplyBuilders$.MODULE$.bounded$extension(this.F(), capacity, cs);
        }

        public <A> F unbounded(Option<Object> chunkSizeHint, ContextShift<F> cs) {
            return (F)ConcurrentQueue$ApplyBuilders$.MODULE$.unbounded$extension(this.F(), chunkSizeHint, cs);
        }

        public <A> F withConfig(BufferCapacity capacity, ChannelType channelType, ContextShift<F> cs) {
            return (F)ConcurrentQueue$ApplyBuilders$.MODULE$.withConfig$extension(this.F(), capacity, channelType, cs);
        }

        public <A> ChannelType withConfig$default$2() {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.withConfig$default$2$extension(this.F());
        }

        public <A> ConcurrentQueue<F, A> unsafe(BufferCapacity capacity, ChannelType channelType, ContextShift<F> cs) {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.unsafe$extension(this.F(), capacity, channelType, cs);
        }

        public <A> ChannelType unsafe$default$2() {
            return ConcurrentQueue$ApplyBuilders$.MODULE$.unsafe$default$2$extension(this.F());
        }
    }
}

