/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.concurrent;

import cats.Eval;
import cats.Functor;
import cats.Invariant;
import cats.Invariant$;
import cats.Monad;
import cats.arrow.FunctionK;
import cats.data.IndexedStateT;
import cats.effect.Sync;
import cats.effect.concurrent.Ref$;
import cats.effect.concurrent.Ref$ApplyBuilders$;
import cats.effect.concurrent.Ref$RefOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public abstract class Ref<F, A> {
    public static <F, A> Ref RefOps(Ref<F, A> ref) {
        return Ref$.MODULE$.RefOps(ref);
    }

    public static <F> Sync apply(Sync<F> sync) {
        return Ref$.MODULE$.apply(sync);
    }

    public static <F> Invariant<Ref> catsInvariantForRef(Functor<F> functor) {
        return Ref$.MODULE$.catsInvariantForRef(functor);
    }

    public static <F, G, A> Object in(A a, Sync<F> sync, Sync<G> sync2) {
        return Ref$.MODULE$.in(a, sync, sync2);
    }

    public static <F, A, B> Ref<F, B> lens(Ref<F, A> ref, Function1<A, B> function1, Function1<A, Function1<B, A>> function12, Sync<F> sync) {
        return Ref$.MODULE$.lens(ref, function1, function12, sync);
    }

    public static <F, A> Object of(A a, Sync<F> sync) {
        return Ref$.MODULE$.of(a, sync);
    }

    public static <F, A> Ref<F, A> unsafe(A a, Sync<F> sync) {
        return Ref$.MODULE$.unsafe(a, sync);
    }

    public abstract F get();

    public abstract F set(A var1);

    public F getAndUpdate(Function1<A, A> f) {
        return this.modify((Function1 & Serializable)a -> Tuple2$.MODULE$.apply(f.apply(a), a));
    }

    public F getAndSet(A a) {
        return this.getAndUpdate((Function1 & Serializable)_$2 -> a);
    }

    public F updateAndGet(Function1<A, A> f) {
        return this.modify((Function1 & Serializable)a -> {
            Object newA = f.apply(a);
            return Tuple2$.MODULE$.apply(newA, newA);
        });
    }

    public abstract F access();

    public abstract F tryUpdate(Function1<A, A> var1);

    public abstract <B> F tryModify(Function1<A, Tuple2<A, B>> var1);

    public abstract F update(Function1<A, A> var1);

    public abstract <B> F modify(Function1<A, Tuple2<A, B>> var1);

    public abstract <B> F tryModifyState(IndexedStateT<Eval, A, A, B> var1);

    public abstract <B> F modifyState(IndexedStateT<Eval, A, A, B> var1);

    public <G> Ref<G, A> mapK(FunctionK<F, G> f, Functor<F> F) {
        return new TransformedRef(this, f, F);
    }

    public static final class ApplyBuilders<F> {
        private final Sync F;

        public static <F> boolean equals$extension(Sync sync, Object object) {
            return Ref$ApplyBuilders$.MODULE$.equals$extension(sync, object);
        }

        public static <F> int hashCode$extension(Sync sync) {
            return Ref$ApplyBuilders$.MODULE$.hashCode$extension(sync);
        }

        public static <A, F> Object of$extension(Sync sync, A a) {
            return Ref$ApplyBuilders$.MODULE$.of$extension(sync, a);
        }

        public ApplyBuilders(Sync<F> F) {
            this.F = F;
        }

        public int hashCode() {
            return Ref$ApplyBuilders$.MODULE$.hashCode$extension(this.F());
        }

        public boolean equals(Object x$0) {
            return Ref$ApplyBuilders$.MODULE$.equals$extension(this.F(), x$0);
        }

        public Sync<F> F() {
            return this.F;
        }

        public <A> F of(A a) {
            return (F)Ref$ApplyBuilders$.MODULE$.of$extension(this.F(), a);
        }
    }

    public static final class LensRef<F, A, B>
    extends Ref<F, B> {
        private final Ref<F, A> underlying;
        private final Function1<A, B> lensGet;
        private final Function1<A, Function1<B, A>> lensSet;
        private final Sync<F> F;
        private final Object access;

        public LensRef(Ref<F, A> underlying, Function1<A, B> lensGet, Function1<A, Function1<B, A>> lensSet, Sync<F> F) {
            this.underlying = underlying;
            this.lensGet = lensGet;
            this.lensSet = lensSet;
            this.F = F;
            this.access = F.flatMap(underlying.get(), (Function1 & Serializable)snapshotA -> {
                Object snapshotB = lensGet.apply(snapshotA);
                Object setter = F.delay(() -> this.$anonfun$8(underlying, lensGet, lensSet, F, snapshotB));
                return package.functor$.MODULE$.toFunctorOps(setter, (Functor)F).tupleLeft(snapshotB);
            });
        }

        @Override
        public F get() {
            return (F)this.F.map(this.underlying.get(), (Function1 & Serializable)a -> this.lensGet.apply(a));
        }

        @Override
        public F set(B b) {
            return this.underlying.update((Function1 & Serializable)a -> this.lensModify(a, (Function1 & Serializable)_$23 -> b));
        }

        @Override
        public F getAndSet(B b) {
            return this.underlying.modify((Function1 & Serializable)a -> Tuple2$.MODULE$.apply(this.lensModify(a, (Function1 & Serializable)_$24 -> b), this.lensGet.apply(a)));
        }

        @Override
        public F update(Function1<B, B> f) {
            return this.underlying.update((Function1 & Serializable)a -> this.lensModify(a, f));
        }

        @Override
        public <C> F modify(Function1<B, Tuple2<B, C>> f) {
            return this.underlying.modify((Function1 & Serializable)a -> {
                Object oldB = this.lensGet.apply(a);
                Tuple2 tuple2 = (Tuple2)f.apply(oldB);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object b = tuple2._1();
                Object c = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(b, c);
                Object b2 = tuple22._1();
                Object c2 = tuple22._2();
                return Tuple2$.MODULE$.apply(((Function1)this.lensSet.apply(a)).apply(b2), c2);
            });
        }

        @Override
        public F tryUpdate(Function1<B, B> f) {
            return (F)this.F.map(this.tryModify((Function1<B, Tuple2<B, C>>)(Function1 & Serializable)a -> Tuple2$.MODULE$.apply(f.apply(a), (Object)BoxedUnit.UNIT)), (Function1 & Serializable)_$25 -> _$25.isDefined());
        }

        @Override
        public <C> F tryModify(Function1<B, Tuple2<B, C>> f) {
            return this.underlying.tryModify((Function1 & Serializable)a -> {
                Object oldB = this.lensGet.apply(a);
                Tuple2 tuple2 = (Tuple2)f.apply(oldB);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object b = tuple2._1();
                Object result = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(b, result);
                Object b2 = tuple22._1();
                Object result2 = tuple22._2();
                return Tuple2$.MODULE$.apply(((Function1)this.lensSet.apply(a)).apply(b2), result2);
            });
        }

        @Override
        public <C> F tryModifyState(IndexedStateT<Eval, B, B, C> state) {
            Function1 f = (Function1)((Eval)state.runF()).value();
            return this.tryModify((Function1<B, Tuple2<B, C>>)(Function1 & Serializable)a -> (Tuple2)((Eval)f.apply(a)).value());
        }

        @Override
        public <C> F modifyState(IndexedStateT<Eval, B, B, C> state) {
            Function1 f = (Function1)((Eval)state.runF()).value();
            return this.modify((Function1<B, Tuple2<B, C>>)(Function1 & Serializable)a -> (Tuple2)((Eval)f.apply(a)).value());
        }

        @Override
        public F access() {
            return (F)this.access;
        }

        private A lensModify(A s, Function1<B, B> f) {
            return (A)((Function1)this.lensSet.apply(s)).apply(f.apply(this.lensGet.apply(s)));
        }

        private final boolean $anonfun$1$$anonfun$1$$anonfun$1(AtomicBoolean hasBeenCalled$5) {
            return hasBeenCalled$5.compareAndSet(false, true);
        }

        private final boolean $anonfun$3$$anonfun$3$$anonfun$3$$anonfun$2$$anonfun$1() {
            return false;
        }

        private final /* synthetic */ Object $anonfun$5$$anonfun$5$$anonfun$5(Ref underlying$4, Function1 lensGet$4, Function1 lensSet$4, Sync F$8, Object snapshotB$3, Object b$2, boolean hasBeenCalled) {
            return F$8.map(underlying$4.tryModify((Function1 & Serializable)a -> hasBeenCalled && lensGet$4.apply(a) == snapshotB$3 ? Tuple2$.MODULE$.apply(((Function1)lensSet$4.apply(a)).apply(b$2), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : Tuple2$.MODULE$.apply(a, (Object)BoxesRunTime.boxToBoolean((boolean)false))), (Function1 & Serializable)_$26 -> BoxesRunTime.unboxToBoolean((Object)_$26.getOrElse(this::$anonfun$3$$anonfun$3$$anonfun$3$$anonfun$2$$anonfun$1)));
        }

        private final Function1 $anonfun$8(Ref underlying$2, Function1 lensGet$2, Function1 lensSet$2, Sync F$6, Object snapshotB$1) {
            AtomicBoolean hasBeenCalled = new AtomicBoolean(false);
            return (Function1 & Serializable)b -> F$6.flatMap(F$6.delay(() -> this.$anonfun$1$$anonfun$1$$anonfun$1(hasBeenCalled)), (Function1 & Serializable)hasBeenCalled -> this.$anonfun$5$$anonfun$5$$anonfun$5(underlying$2, lensGet$2, lensSet$2, F$6, snapshotB$1, b, BoxesRunTime.unboxToBoolean((Object)hasBeenCalled)));
        }
    }

    public static final class RefOps<F, A> {
        private final Ref ref;

        public static <F, A> boolean equals$extension(Ref ref, Object object) {
            return Ref$RefOps$.MODULE$.equals$extension(ref, object);
        }

        public static <F, A> int hashCode$extension(Ref ref) {
            return Ref$RefOps$.MODULE$.hashCode$extension(ref);
        }

        public static <B, F, A> Object modifyMaybe$extension(Ref ref, Function1<A, Option<Tuple2<A, B>>> function1, Monad<F> monad) {
            return Ref$RefOps$.MODULE$.modifyMaybe$extension(ref, function1, monad);
        }

        public static <E, B, F, A> Object modifyOr$extension(Ref ref, Function1<A, Either<E, Tuple2<A, B>>> function1, Monad<F> monad) {
            return Ref$RefOps$.MODULE$.modifyOr$extension(ref, function1, monad);
        }

        public static <F, A> Object updateMaybe$extension(Ref ref, Function1<A, Option<A>> function1, Monad<F> monad) {
            return Ref$RefOps$.MODULE$.updateMaybe$extension(ref, function1, monad);
        }

        public static <E, F, A> Object updateOr$extension(Ref ref, Function1<A, Either<E, A>> function1, Monad<F> monad) {
            return Ref$RefOps$.MODULE$.updateOr$extension(ref, function1, monad);
        }

        public RefOps(Ref<F, A> ref) {
            this.ref = ref;
        }

        public int hashCode() {
            return Ref$RefOps$.MODULE$.hashCode$extension(this.cats$effect$concurrent$Ref$RefOps$$ref());
        }

        public boolean equals(Object x$0) {
            return Ref$RefOps$.MODULE$.equals$extension(this.cats$effect$concurrent$Ref$RefOps$$ref(), x$0);
        }

        public Ref<F, A> cats$effect$concurrent$Ref$RefOps$$ref() {
            return this.ref;
        }

        public F updateMaybe(Function1<A, Option<A>> f, Monad<F> F) {
            return (F)Ref$RefOps$.MODULE$.updateMaybe$extension(this.cats$effect$concurrent$Ref$RefOps$$ref(), f, F);
        }

        public <B> F modifyMaybe(Function1<A, Option<Tuple2<A, B>>> f, Monad<F> F) {
            return (F)Ref$RefOps$.MODULE$.modifyMaybe$extension(this.cats$effect$concurrent$Ref$RefOps$$ref(), f, F);
        }

        public <E> F updateOr(Function1<A, Either<E, A>> f, Monad<F> F) {
            return (F)Ref$RefOps$.MODULE$.updateOr$extension(this.cats$effect$concurrent$Ref$RefOps$$ref(), f, F);
        }

        public <E, B> F modifyOr(Function1<A, Either<E, Tuple2<A, B>>> f, Monad<F> F) {
            return (F)Ref$RefOps$.MODULE$.modifyOr$extension(this.cats$effect$concurrent$Ref$RefOps$$ref(), f, F);
        }
    }

    private static final class SyncRef<F, A>
    extends Ref<F, A> {
        private final AtomicReference<A> ar;
        private final Sync<F> F;

        public SyncRef(AtomicReference<A> ar, Sync<F> F) {
            this.ar = ar;
            this.F = F;
        }

        @Override
        public F get() {
            return this.F.delay(this::get$$anonfun$1);
        }

        @Override
        public F set(A a) {
            return this.F.delay(() -> this.set$$anonfun$1(a));
        }

        @Override
        public F getAndSet(A a) {
            return this.F.delay(() -> this.getAndSet$$anonfun$1(a));
        }

        @Override
        public F access() {
            return this.F.delay(this::access$$anonfun$1);
        }

        @Override
        public F getAndUpdate(Function1<A, A> f) {
            return this.F.delay(() -> this.getAndUpdate$$anonfun$1(f));
        }

        @Override
        public F tryUpdate(Function1<A, A> f) {
            return (F)this.F.map(this.tryModify((Function1 & Serializable)a -> Tuple2$.MODULE$.apply(f.apply(a), (Object)BoxedUnit.UNIT)), (Function1 & Serializable)_$12 -> _$12.isDefined());
        }

        @Override
        public <B> F tryModify(Function1<A, Tuple2<A, B>> f) {
            return this.F.delay(() -> this.tryModify$$anonfun$1(f));
        }

        @Override
        public F update(Function1<A, A> f) {
            return this.F.delay(() -> this.update$$anonfun$1(f));
        }

        @Override
        public F updateAndGet(Function1<A, A> f) {
            return this.F.delay(() -> this.updateAndGet$$anonfun$1(f));
        }

        @Override
        public <B> F modify(Function1<A, Tuple2<A, B>> f) {
            return this.F.delay(() -> this.modify$$anonfun$1(f));
        }

        @Override
        public <B> F tryModifyState(IndexedStateT<Eval, A, A, B> state) {
            Function1 f = (Function1)((Eval)state.runF()).value();
            return this.tryModify((Function1 & Serializable)a -> (Tuple2)((Eval)f.apply(a)).value());
        }

        @Override
        public <B> F modifyState(IndexedStateT<Eval, A, A, B> state) {
            Function1 f = (Function1)((Eval)state.runF()).value();
            return this.modify((Function1 & Serializable)a -> (Tuple2)((Eval)f.apply(a)).value());
        }

        private final Object get$$anonfun$1() {
            return this.ar.get();
        }

        private final void set$$anonfun$1(Object a$4) {
            this.ar.set(a$4);
        }

        private final Object getAndSet$$anonfun$1(Object a$5) {
            return this.ar.getAndSet(a$5);
        }

        private final boolean setter$1$$anonfun$1$$anonfun$1(Object snapshot$3, AtomicBoolean hasBeenCalled$3, Object a$6) {
            return hasBeenCalled$3.compareAndSet(false, true) && this.ar.compareAndSet(snapshot$3, a$6);
        }

        private final Function1 setter$3(Object snapshot$1, AtomicBoolean hasBeenCalled$1) {
            return (Function1 & Serializable)a -> this.F.delay(() -> this.setter$1$$anonfun$1$$anonfun$1(snapshot$1, hasBeenCalled$1, a));
        }

        private final Tuple2 access$$anonfun$1() {
            A snapshot = this.ar.get();
            AtomicBoolean hasBeenCalled = new AtomicBoolean(false);
            return Tuple2$.MODULE$.apply(snapshot, (Object)this.setter$3(snapshot, hasBeenCalled));
        }

        private final Object spin$1(Function1 f$3) {
            Object u;
            A a;
            while (!this.ar.compareAndSet(a = this.ar.get(), u = f$3.apply(a))) {
            }
            return a;
        }

        private final Object getAndUpdate$$anonfun$1(Function1 f$25) {
            return this.spin$1(f$25);
        }

        private final Option tryModify$$anonfun$1(Function1 f$5) {
            A c = this.ar.get();
            Tuple2 tuple2 = (Tuple2)f$5.apply(c);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object u = tuple2._1();
            Object b = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(u, b);
            Object u2 = tuple22._1();
            Object b2 = tuple22._2();
            return this.ar.compareAndSet(c, u2) ? Some$.MODULE$.apply(b2) : None$.MODULE$;
        }

        private final void spin$2(Function1 f$6) {
            Object u;
            A a;
            while (!this.ar.compareAndSet(a = this.ar.get(), u = f$6.apply(a))) {
            }
        }

        private final void update$$anonfun$1(Function1 f$26) {
            this.spin$2(f$26);
        }

        private final Object spin$3(Function1 f$7) {
            Object u;
            A a;
            while (!this.ar.compareAndSet(a = this.ar.get(), u = f$7.apply(a))) {
            }
            return u;
        }

        private final Object updateAndGet$$anonfun$1(Function1 f$27) {
            return this.spin$3(f$27);
        }

        private final Object spin$4(Function1 f$8) {
            Object b;
            Object u;
            A c;
            do {
                Tuple2 tuple2;
                if ((tuple2 = (Tuple2)f$8.apply(c = this.ar.get())) == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object u2 = tuple2._1();
                Object b2 = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(u2, b2);
                u = tuple22._1();
                b = tuple22._2();
            } while (!this.ar.compareAndSet(c, u));
            return b;
        }

        private final Object modify$$anonfun$1(Function1 f$28) {
            return this.spin$4(f$28);
        }
    }

    public static final class TransformedRef<F, G, A>
    extends Ref<G, A> {
        private final Ref<F, A> underlying;
        private final FunctionK<F, G> trans;
        private final Functor<F> F;

        public TransformedRef(Ref<F, A> underlying, FunctionK<F, G> trans, Functor<F> F) {
            this.underlying = underlying;
            this.trans = trans;
            this.F = F;
        }

        @Override
        public G get() {
            return (G)this.trans.apply(this.underlying.get());
        }

        @Override
        public G set(A a) {
            return (G)this.trans.apply(this.underlying.set(a));
        }

        @Override
        public G getAndSet(A a) {
            return (G)this.trans.apply(this.underlying.getAndSet(a));
        }

        @Override
        public G tryUpdate(Function1<A, A> f) {
            return (G)this.trans.apply(this.underlying.tryUpdate(f));
        }

        @Override
        public <B> G tryModify(Function1<A, Tuple2<A, B>> f) {
            return (G)this.trans.apply(this.underlying.tryModify(f));
        }

        @Override
        public G update(Function1<A, A> f) {
            return (G)this.trans.apply(this.underlying.update(f));
        }

        @Override
        public <B> G modify(Function1<A, Tuple2<A, B>> f) {
            return (G)this.trans.apply(this.underlying.modify(f));
        }

        @Override
        public <B> G tryModifyState(IndexedStateT<Eval, A, A, B> state) {
            return (G)this.trans.apply(this.underlying.tryModifyState(state));
        }

        @Override
        public <B> G modifyState(IndexedStateT<Eval, A, A, B> state) {
            return (G)this.trans.apply(this.underlying.modifyState(state));
        }

        @Override
        public G access() {
            return (G)this.trans.apply(this.F.compose((Functor)Invariant$.MODULE$.catsStdInstancesForTuple2()).compose((Functor)Invariant$.MODULE$.catsDistributiveForFunction1()).map(this.underlying.access(), (Function1 & Serializable)_$21 -> this.trans.apply(_$21)));
        }
    }
}

