/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.internals;

import cats.effect.internals.RingBuffer;
import cats.effect.internals.TracingPlatform;
import cats.effect.tracing.IOEvent;
import cats.effect.tracing.IOTrace;
import cats.effect.tracing.IOTrace$;
import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.List;

public final class IOContext {
    private final RingBuffer<IOEvent> events = new RingBuffer(TracingPlatform.traceBufferLogSize);
    private int captured = 0;
    private int omitted = 0;

    public void pushEvent(IOEvent fr) {
        ++this.captured;
        if (this.events.push(fr) != null) {
            ++this.omitted;
        }
    }

    public IOTrace trace() {
        return IOTrace$.MODULE$.apply(this.events.toList(), this.captured, this.omitted);
    }

    public List<IOEvent.StackTrace> getStackTraces() {
        return this.events.toList().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(IOEvent x) {
                boolean bl;
                IOEvent iOEvent = x;
                if (iOEvent instanceof IOEvent.StackTrace) {
                    IOEvent.StackTrace ev = (IOEvent.StackTrace)iOEvent;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(IOEvent x, Function1 function1) {
                Object object;
                IOEvent iOEvent = x;
                if (iOEvent instanceof IOEvent.StackTrace) {
                    IOEvent.StackTrace ev = (IOEvent.StackTrace)iOEvent;
                    object = ev;
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        });
    }
}

