/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.tracing;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.tracing.IOEvent;
import cats.effect.tracing.IOTrace$;
import cats.effect.tracing.PrintingOptions;
import cats.effect.tracing.PrintingOptions$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class IOTrace
implements Product,
Serializable {
    private final List events;
    private final int captured;
    private final int omitted;

    public static IOTrace apply(List<IOEvent> list, int n, int n2) {
        return IOTrace$.MODULE$.apply(list, n, n2);
    }

    public static IOTrace fromProduct(Product product) {
        return IOTrace$.MODULE$.fromProduct(product);
    }

    public static Option<Tuple2<StackTraceElement, StackTraceElement>> getOpAndCallSite(List<StackTraceElement> list) {
        return IOTrace$.MODULE$.getOpAndCallSite(list);
    }

    public static IOTrace unapply(IOTrace iOTrace) {
        return IOTrace$.MODULE$.unapply(iOTrace);
    }

    public IOTrace(List<IOEvent> events, int captured, int omitted) {
        this.events = events;
        this.captured = captured;
        this.omitted = omitted;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.events()));
        n = Statics.mix((int)n, (int)this.captured());
        n = Statics.mix((int)n, (int)this.omitted());
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof IOTrace)) return false;
        IOTrace iOTrace = (IOTrace)object;
        if (this.captured() != iOTrace.captured()) return false;
        if (this.omitted() != iOTrace.omitted()) return false;
        List<IOEvent> list = this.events();
        List<IOEvent> list2 = iOTrace.events();
        if (list != null) {
            if (!list.equals(list2)) return false;
            return true;
        }
        if (list2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof IOTrace;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "IOTrace";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this._1();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this._2());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this._3());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "events";
                break;
            }
            case 1: {
                string = "captured";
                break;
            }
            case 2: {
                string = "omitted";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public List<IOEvent> events() {
        return this.events;
    }

    public int captured() {
        return this.captured;
    }

    public int omitted() {
        return this.omitted;
    }

    public IO<BoxedUnit> printFiberTrace(PrintingOptions options) {
        return IO$.MODULE$.apply(() -> this.printFiberTrace$$anonfun$1(options));
    }

    public PrintingOptions printFiberTrace$default$1() {
        return PrintingOptions$.MODULE$.Default();
    }

    public String showFiberTrace(PrintingOptions options) {
        String string;
        String TurnRight = "\u2570";
        String InverseTurnRight = "\u256d";
        String Junction = "\u251c";
        String Line = "\u2502";
        String acc0 = "IOTrace: " + this.captured() + " frames captured\n";
        if (options.showFullStackTraces()) {
            List stackTraces = this.events().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(IOEvent x) {
                    boolean bl;
                    IOEvent iOEvent = x;
                    if (iOEvent instanceof IOEvent.StackTrace) {
                        IOEvent.StackTrace e = (IOEvent.StackTrace)iOEvent;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(IOEvent x, Function1 function1) {
                    Object object;
                    IOEvent iOEvent = x;
                    if (iOEvent instanceof IOEvent.StackTrace) {
                        IOEvent.StackTrace e = (IOEvent.StackTrace)iOEvent;
                        object = e;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            String acc1 = ((List)stackTraces.zipWithIndex()).map((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                IOEvent.StackTrace st = (IOEvent.StackTrace)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                String tag = (String)IOTrace$.MODULE$.getOpAndCallSite(st.stackTrace()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    return NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                }).getOrElse(IOTrace::$anonfun$4);
                String op = index == 0 ? "" + InverseTurnRight + " " + tag + "\n" : "" + Junction + " " + tag + "\n";
                List relevantLines = ((List)st.stackTrace().drop(options.ignoreStackTraceLines())).take(options.maxStackTraceLines());
                String lines = ((List)relevantLines.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement ste = (StackTraceElement)tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    String junc = i == relevantLines.length() - 1 ? TurnRight : Junction;
                    String codeLine = IOTrace$.MODULE$.cats$effect$tracing$IOTrace$$$renderStackTraceElement(ste);
                    return "" + Line + "  " + junc + " " + codeLine;
                }).mkString("", "\n", "\n");
                return "" + op + lines + Line;
            }).mkString("\n");
            String acc2 = this.omitted() > 0 ? "\n" + TurnRight + (" ... (" + this.omitted() + " frames omitted)\n") : "\n" + TurnRight + "\n";
            string = acc0 + acc1 + acc2;
        } else {
            String acc1 = ((List)this.events().zipWithIndex()).map((Function1 & Serializable)x$12 -> {
                IOEvent.StackTrace ev;
                String junc;
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    IOEvent event = (IOEvent)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    junc = index == this.events().length() - 1 && this.omitted() == 0 ? TurnRight : Junction;
                    IOEvent iOEvent = event;
                    if (!(iOEvent instanceof IOEvent.StackTrace)) {
                        throw new MatchError((Object)iOEvent);
                    }
                    ev = (IOEvent.StackTrace)iOEvent;
                } else {
                    throw new MatchError((Object)tuple2);
                }
                String message = (String)IOTrace$.MODULE$.getOpAndCallSite(ev.stackTrace()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    StackTraceElement callSite = (StackTraceElement)tuple2._2();
                    String loc = IOTrace$.MODULE$.cats$effect$tracing$IOTrace$$$renderStackTraceElement(callSite);
                    String op = NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                    return "" + op + " @ " + loc;
                }).getOrElse(IOTrace::$anonfun$7);
                return " " + junc + " " + message;
            }).mkString(acc0, "\n", "");
            String acc2 = this.omitted() > 0 ? acc1 + "\n " + TurnRight + (" ... (" + this.omitted() + " frames omitted)") : acc1;
            string = acc2 + "\n";
        }
        return string;
    }

    public PrintingOptions showFiberTrace$default$1() {
        return PrintingOptions$.MODULE$.Default();
    }

    public IOTrace copy(List<IOEvent> events, int captured, int omitted) {
        return new IOTrace(events, captured, omitted);
    }

    public List<IOEvent> copy$default$1() {
        return this.events();
    }

    public int copy$default$2() {
        return this.captured();
    }

    public int copy$default$3() {
        return this.omitted();
    }

    public List<IOEvent> _1() {
        return this.events();
    }

    public int _2() {
        return this.captured();
    }

    public int _3() {
        return this.omitted();
    }

    private final void printFiberTrace$$anonfun$1(PrintingOptions options$1) {
        System.err.println(this.showFiberTrace(options$1));
    }

    private static final String $anonfun$4() {
        return "(...)";
    }

    private static final String $anonfun$7() {
        return "(...)";
    }
}

