/*
 * Decompiled with CFR 0.152.
 */
package laika.api;

import java.io.Serializable;
import laika.api.MarkupParser;
import laika.api.Renderer;
import laika.api.Transformer$;
import laika.api.builder.OperationConfig;
import laika.api.builder.TransformerBuilder;
import laika.api.builder.TwoPhaseTransformerBuilder;
import laika.ast.Document;
import laika.ast.Path;
import laika.ast.Path$Root$;
import laika.factory.MarkupFormat;
import laika.factory.RenderFormat;
import laika.factory.TwoPhaseRenderFormat;
import laika.parse.markup.DocumentParser;
import scala.Function1;
import scala.util.Either;

public class Transformer {
    private final MarkupParser parser;
    private final Renderer renderer;

    public static Builder from(MarkupFormat markupFormat) {
        return Transformer$.MODULE$.from(markupFormat);
    }

    public Transformer(MarkupParser parser, Renderer renderer) {
        this.parser = parser;
        this.renderer = renderer;
    }

    public MarkupParser parser() {
        return this.parser;
    }

    public Renderer renderer() {
        return this.renderer;
    }

    public Either<DocumentParser.TransformationError, String> transform(String input) {
        return this.transform(input, Path$Root$.MODULE$);
    }

    public Either<DocumentParser.TransformationError, String> transform(String input, Path path) {
        return this.parser().parse(input, path).flatMap((Function1 & Serializable)doc -> this.renderer().render((Document)doc));
    }

    public static class Builder {
        private final MarkupFormat parser;
        private final OperationConfig config;

        public Builder(MarkupFormat parser, OperationConfig config) {
            this.parser = parser;
            this.config = config;
        }

        public <FMT> TransformerBuilder<FMT> to(RenderFormat<FMT> format) {
            return new TransformerBuilder<FMT>(this.parser, format, this.config);
        }

        public <FMT, PP> TwoPhaseTransformerBuilder<FMT, PP> to(TwoPhaseRenderFormat<FMT, PP> format) {
            return new TwoPhaseTransformerBuilder<FMT, PP>(this.parser, format, this.config);
        }
    }
}

