/*
 * Decompiled with CFR 0.152.
 */
package laika.parse.markup;

import java.io.Serializable;
import laika.ast.Document;
import laika.ast.DocumentTreeRoot;
import laika.ast.Invalid;
import laika.ast.MessageFilter;
import laika.ast.Path;
import laika.ast.RootElement;
import laika.ast.StyleDeclaration;
import laika.ast.StyleDeclarationSet;
import laika.ast.TemplateDocument;
import laika.ast.TemplateRoot;
import laika.ast.UnresolvedDocument;
import laika.bundle.ConfigProvider;
import laika.bundle.MarkupExtensions;
import laika.config.ConfigError;
import laika.config.TreeConfigErrors;
import laika.factory.MarkupFormat;
import laika.parse.Parser;
import laika.parse.SourceCursor;
import laika.parse.markup.DocumentParser$;
import laika.parse.markup.DocumentParser$DocumentInput$;
import laika.parse.markup.DocumentParser$InvalidDocument$;
import laika.parse.markup.DocumentParser$InvalidDocuments$;
import laika.parse.markup.DocumentParser$ParserError$;
import laika.parse.markup.DocumentParser$RendererError$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class DocumentParser {
    public static Function1<DocumentInput, Either<ParserError, UnresolvedDocument>> forMarkup(MarkupFormat markupFormat, MarkupExtensions markupExtensions, ConfigProvider configProvider) {
        return DocumentParser$.MODULE$.forMarkup(markupFormat, markupExtensions, configProvider);
    }

    public static Function1<DocumentInput, Either<ParserError, UnresolvedDocument>> forMarkup(Parser<RootElement> parser, ConfigProvider configProvider) {
        return DocumentParser$.MODULE$.forMarkup(parser, configProvider);
    }

    public static <T> Function1<DocumentInput, Either<ParserError, T>> forParser(Function1<Path, Parser<T>> function1) {
        return DocumentParser$.MODULE$.forParser(function1);
    }

    public static Function1<DocumentInput, Either<ParserError, StyleDeclarationSet>> forStyleSheets(Parser<Set<StyleDeclaration>> parser) {
        return DocumentParser$.MODULE$.forStyleSheets(parser);
    }

    public static Function1<DocumentInput, Either<ParserError, TemplateDocument>> forTemplate(Parser<TemplateRoot> parser, ConfigProvider configProvider) {
        return DocumentParser$.MODULE$.forTemplate(parser, configProvider);
    }

    public static class DocumentInput
    implements Product,
    Serializable {
        private final Path path;
        private final SourceCursor source;

        public static DocumentInput apply(Path path, SourceCursor sourceCursor) {
            return DocumentParser$DocumentInput$.MODULE$.apply(path, sourceCursor);
        }

        public static DocumentInput apply(Path path, String string) {
            return DocumentParser$DocumentInput$.MODULE$.apply(path, string);
        }

        public static DocumentInput fromProduct(Product product) {
            return DocumentParser$DocumentInput$.MODULE$.fromProduct(product);
        }

        public static DocumentInput unapply(DocumentInput documentInput) {
            return DocumentParser$DocumentInput$.MODULE$.unapply(documentInput);
        }

        public DocumentInput(Path path, SourceCursor source) {
            this.path = path;
            this.source = source;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DocumentInput)) return false;
            DocumentInput documentInput = (DocumentInput)object;
            Path path = this.path();
            Path path2 = documentInput.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            SourceCursor sourceCursor = this.source();
            SourceCursor sourceCursor2 = documentInput.source();
            if (sourceCursor == null) {
                if (sourceCursor2 != null) {
                    return false;
                }
            } else if (!sourceCursor.equals(sourceCursor2)) return false;
            if (!documentInput.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DocumentInput;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DocumentInput";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "source";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path path() {
            return this.path;
        }

        public SourceCursor source() {
            return this.source;
        }

        public DocumentInput copy(Path path, SourceCursor source) {
            return new DocumentInput(path, source);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public SourceCursor copy$default$2() {
            return this.source();
        }

        public Path _1() {
            return this.path();
        }

        public SourceCursor _2() {
            return this.source();
        }
    }

    public static class InvalidDocument
    extends RuntimeException
    implements Product {
        private final Either errors;
        private final Path path;

        public static InvalidDocument apply(Either<Object, Object> either, Path path) {
            return DocumentParser$InvalidDocument$.MODULE$.apply(either, path);
        }

        public static InvalidDocument apply(Path path, ConfigError configError, Seq<ConfigError> seq) {
            return DocumentParser$InvalidDocument$.MODULE$.apply(path, configError, seq);
        }

        public static InvalidDocument apply(Path path, Invalid invalid, Seq<Invalid> seq) {
            return DocumentParser$InvalidDocument$.MODULE$.apply(path, invalid, seq);
        }

        public static String format(Either<Object, Object> either, Path path) {
            return DocumentParser$InvalidDocument$.MODULE$.format(either, path);
        }

        public static String format(InvalidDocument invalidDocument) {
            return DocumentParser$InvalidDocument$.MODULE$.format(invalidDocument);
        }

        public static String formatElement(Path path, Invalid invalid) {
            return DocumentParser$InvalidDocument$.MODULE$.formatElement(path, invalid);
        }

        public static Option<InvalidDocument> from(Document document, MessageFilter messageFilter) {
            return DocumentParser$InvalidDocument$.MODULE$.from(document, messageFilter);
        }

        public static InvalidDocument fromProduct(Product product) {
            return DocumentParser$InvalidDocument$.MODULE$.fromProduct(product);
        }

        public static String indent(String string) {
            return DocumentParser$InvalidDocument$.MODULE$.indent(string);
        }

        public static InvalidDocument unapply(InvalidDocument invalidDocument) {
            return DocumentParser$InvalidDocument$.MODULE$.unapply(invalidDocument);
        }

        public InvalidDocument(Either<Object, Object> errors, Path path) {
            this.errors = errors;
            this.path = path;
            super(new StringBuilder(43).append("One or more errors processing document '").append(path).append("': ").append(DocumentParser$InvalidDocument$.MODULE$.format(errors, path)).toString());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidDocument)) return false;
            InvalidDocument invalidDocument = (InvalidDocument)object;
            Either<Object, Object> either = this.errors();
            Either<Object, Object> either2 = invalidDocument.errors();
            if (either == null) {
                if (either2 != null) {
                    return false;
                }
            } else if (!either.equals(either2)) return false;
            Path path = this.path();
            Path path2 = invalidDocument.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            if (!invalidDocument.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidDocument;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "InvalidDocument";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "errors";
            }
            if (1 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Either<Object, Object> errors() {
            return this.errors;
        }

        public Path path() {
            return this.path;
        }

        public InvalidDocument copy(Either<Object, Object> errors, Path path) {
            return new InvalidDocument(errors, path);
        }

        public Either<Object, Object> copy$default$1() {
            return this.errors();
        }

        public Path copy$default$2() {
            return this.path();
        }

        public Either<Object, Object> _1() {
            return this.errors();
        }

        public Path _2() {
            return this.path();
        }
    }

    public static class InvalidDocuments
    extends RuntimeException
    implements Product {
        private final Object documents;

        public static InvalidDocuments apply(Object object) {
            return DocumentParser$InvalidDocuments$.MODULE$.apply(object);
        }

        public static String format(Object object) {
            return DocumentParser$InvalidDocuments$.MODULE$.format(object);
        }

        public static Option<InvalidDocuments> from(DocumentTreeRoot documentTreeRoot, MessageFilter messageFilter) {
            return DocumentParser$InvalidDocuments$.MODULE$.from(documentTreeRoot, messageFilter);
        }

        public static Either<InvalidDocuments, DocumentTreeRoot> from(Either<TreeConfigErrors, DocumentTreeRoot> either, MessageFilter messageFilter) {
            return DocumentParser$InvalidDocuments$.MODULE$.from(either, messageFilter);
        }

        public static InvalidDocuments fromProduct(Product product) {
            return DocumentParser$InvalidDocuments$.MODULE$.fromProduct(product);
        }

        public static InvalidDocuments unapply(InvalidDocuments invalidDocuments) {
            return DocumentParser$InvalidDocuments$.MODULE$.unapply(invalidDocuments);
        }

        public InvalidDocuments(Object documents) {
            this.documents = documents;
            super(new StringBuilder(31).append("One or more invalid documents:\n").append(DocumentParser$InvalidDocuments$.MODULE$.format(documents)).toString());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidDocuments)) return false;
            InvalidDocuments invalidDocuments = (InvalidDocuments)object;
            if (!BoxesRunTime.equals((Object)this.documents(), (Object)invalidDocuments.documents())) return false;
            if (!invalidDocuments.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidDocuments;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InvalidDocuments";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "documents";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object documents() {
            return this.documents;
        }

        public InvalidDocuments copy(Object documents) {
            return new InvalidDocuments(documents);
        }

        public Object copy$default$1() {
            return this.documents();
        }

        public Object _1() {
            return this.documents();
        }
    }

    public static class ParserError
    extends RuntimeException
    implements TransformationError,
    Product {
        private final String message;
        private final Path path;

        public static ParserError apply(ConfigError configError, Path path) {
            return DocumentParser$ParserError$.MODULE$.apply(configError, path);
        }

        public static ParserError apply(InvalidDocument invalidDocument) {
            return DocumentParser$ParserError$.MODULE$.apply(invalidDocument);
        }

        public static ParserError apply(String string, Path path) {
            return DocumentParser$ParserError$.MODULE$.apply(string, path);
        }

        public static ParserError fromProduct(Product product) {
            return DocumentParser$ParserError$.MODULE$.fromProduct(product);
        }

        public static ParserError unapply(ParserError parserError) {
            return DocumentParser$ParserError$.MODULE$.unapply(parserError);
        }

        public ParserError(String message, Path path) {
            this.message = message;
            this.path = path;
            super(new StringBuilder(27).append("Error parsing document '").append(path).append("': ").append(message).toString());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ParserError)) return false;
            ParserError parserError = (ParserError)object;
            String string = this.message();
            String string2 = parserError.message();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Path path = this.path();
            Path path2 = parserError.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            if (!parserError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ParserError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ParserError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String message() {
            return this.message;
        }

        public Path path() {
            return this.path;
        }

        public ParserError copy(String message, Path path) {
            return new ParserError(message, path);
        }

        public String copy$default$1() {
            return this.message();
        }

        public Path copy$default$2() {
            return this.path();
        }

        public String _1() {
            return this.message();
        }

        public Path _2() {
            return this.path();
        }
    }

    public static class RendererError
    extends RuntimeException
    implements TransformationError,
    Product {
        private final String message;
        private final Path path;

        public static RendererError apply(ConfigError configError, Path path) {
            return DocumentParser$RendererError$.MODULE$.apply(configError, path);
        }

        public static RendererError apply(String string, Path path) {
            return DocumentParser$RendererError$.MODULE$.apply(string, path);
        }

        public static RendererError fromProduct(Product product) {
            return DocumentParser$RendererError$.MODULE$.fromProduct(product);
        }

        public static RendererError unapply(RendererError rendererError) {
            return DocumentParser$RendererError$.MODULE$.unapply(rendererError);
        }

        public RendererError(String message, Path path) {
            this.message = message;
            this.path = path;
            super(new StringBuilder(29).append("Error rendering document '").append(path).append("': ").append(message).toString());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RendererError)) return false;
            RendererError rendererError = (RendererError)object;
            String string = this.message();
            String string2 = rendererError.message();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Path path = this.path();
            Path path2 = rendererError.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            if (!rendererError.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof RendererError;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RendererError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public String message() {
            return this.message;
        }

        public Path path() {
            return this.path;
        }

        public RendererError copy(String message, Path path) {
            return new RendererError(message, path);
        }

        public String copy$default$1() {
            return this.message();
        }

        public Path copy$default$2() {
            return this.path();
        }

        public String _1() {
            return this.message();
        }

        public Path _2() {
            return this.path();
        }
    }

    public static interface TransformationError {
        public String message();
    }
}

