/*
 * Decompiled with CFR 0.152.
 */
package laika.parse.text;

import laika.parse.markup.DocumentParser;
import laika.parse.text.WhitespacePreprocessor$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.IntRef;

public class WhitespacePreprocessor
implements Function1<String, String> {
    private final int tabStops;

    public static Function1<DocumentParser.DocumentInput, DocumentParser.DocumentInput> forInput() {
        return WhitespacePreprocessor$.MODULE$.forInput();
    }

    public static Function1<String, String> forString() {
        return WhitespacePreprocessor$.MODULE$.forString();
    }

    public WhitespacePreprocessor() {
        this.tabStops = 4;
    }

    public int tabStops() {
        return this.tabStops;
    }

    public String apply(String input) {
        int end = input.length();
        StringBuilder buf = new StringBuilder();
        IntRef i = IntRef.create((int)0);
        int col = 0;
        IntRef cur = IntRef.create((int)0);
        while (i.elem < end) {
            int n;
            char c = input.charAt(i.elem);
            switch (c) {
                case '\u000b': 
                case '\f': {
                    WhitespacePreprocessor.cut$1(input, buf, i, cur, " ");
                    ++col;
                    break;
                }
                case '\r': {
                    WhitespacePreprocessor.cut$1(input, buf, i, cur, "");
                    break;
                }
                case '\n': {
                    col = 0;
                    break;
                }
                case '\t': {
                    int spaces = this.tabStops() - col % this.tabStops();
                    WhitespacePreprocessor.cut$1(input, buf, i, cur, StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), spaces));
                    col += spaces;
                    break;
                }
                default: {
                    ++col;
                    break;
                }
            }
            i.elem = n = i.elem + 1;
        }
        buf.$plus$plus$eq(input.substring(cur.elem));
        return buf.toString();
    }

    private static final void cut$1(String input$1, StringBuilder buf$1, IntRef i$1, IntRef cur$1, String add) {
        int n;
        buf$1.$plus$plus$eq(input$1.substring(cur$1.elem, i$1.elem)).$plus$plus$eq(add);
        cur$1.elem = n = i$1.elem + 1;
    }
}

