/*
 * Decompiled with CFR 0.152.
 */
package laika.render;

import cats.data.NonEmptySetImpl$;
import cats.kernel.Eq$;
import cats.kernel.Order;
import java.io.Serializable;
import laika.ast.Block;
import laika.ast.BlockContainer;
import laika.ast.BlockSequence;
import laika.ast.BlockSequence$;
import laika.ast.BulletFormat;
import laika.ast.BulletList;
import laika.ast.BulletList$;
import laika.ast.BulletListItem;
import laika.ast.BulletListItem$;
import laika.ast.Caption;
import laika.ast.Caption$;
import laika.ast.Cell;
import laika.ast.Cell$;
import laika.ast.CellType;
import laika.ast.Choice;
import laika.ast.Citation;
import laika.ast.CitationLink;
import laika.ast.CitationLink$;
import laika.ast.CodeBlock;
import laika.ast.CodeBlock$;
import laika.ast.CodeSpan;
import laika.ast.CodeSpan$;
import laika.ast.CodeSpanSequence;
import laika.ast.CodeSpanSequence$;
import laika.ast.Column;
import laika.ast.Columns;
import laika.ast.Columns$;
import laika.ast.Comment;
import laika.ast.Comment$;
import laika.ast.Container;
import laika.ast.DefinitionList;
import laika.ast.DefinitionList$;
import laika.ast.DefinitionListItem;
import laika.ast.DefinitionListItem$;
import laika.ast.Deleted;
import laika.ast.Deleted$;
import laika.ast.Element;
import laika.ast.EmbeddedRoot;
import laika.ast.EmbeddedRoot$;
import laika.ast.Emphasized;
import laika.ast.Emphasized$;
import laika.ast.EnumFormat;
import laika.ast.EnumList;
import laika.ast.EnumList$;
import laika.ast.EnumListItem;
import laika.ast.EnumListItem$;
import laika.ast.EnumType;
import laika.ast.EnumType$Arabic$;
import laika.ast.EnumType$LowerAlpha$;
import laika.ast.EnumType$LowerRoman$;
import laika.ast.EnumType$UpperAlpha$;
import laika.ast.EnumType$UpperRoman$;
import laika.ast.ExternalTarget;
import laika.ast.Figure;
import laika.ast.Figure$;
import laika.ast.Footnote;
import laika.ast.FootnoteLink;
import laika.ast.FootnoteLink$;
import laika.ast.Header;
import laika.ast.Header$;
import laika.ast.Icon;
import laika.ast.IconGlyph;
import laika.ast.Image;
import laika.ast.Image$;
import laika.ast.InlineCode;
import laika.ast.InlineCode$;
import laika.ast.InlineSVGIcon;
import laika.ast.Inserted;
import laika.ast.Inserted$;
import laika.ast.InternalLinkTarget;
import laika.ast.InternalTarget;
import laika.ast.Invalid;
import laika.ast.InvalidBlock;
import laika.ast.InvalidBlock$;
import laika.ast.InvalidSpan$;
import laika.ast.Length;
import laika.ast.LineBreak;
import laika.ast.LineBreak$;
import laika.ast.ListContainer;
import laika.ast.ListItem;
import laika.ast.Literal;
import laika.ast.Literal$;
import laika.ast.LiteralBlock;
import laika.ast.LiteralBlock$;
import laika.ast.NavigationItem;
import laika.ast.NavigationItem$;
import laika.ast.NavigationLink;
import laika.ast.NavigationLink$;
import laika.ast.NavigationList;
import laika.ast.NoOpt$;
import laika.ast.Options;
import laika.ast.PageBreak;
import laika.ast.Paragraph;
import laika.ast.Paragraph$;
import laika.ast.ParsedLiteralBlock;
import laika.ast.ParsedLiteralBlock$;
import laika.ast.QuotedBlock;
import laika.ast.QuotedBlock$;
import laika.ast.RawContent;
import laika.ast.RawContent$;
import laika.ast.RawLink;
import laika.ast.RawLink$;
import laika.ast.Reference;
import laika.ast.RewritableContainer;
import laika.ast.RomanNumerals$;
import laika.ast.RootElement;
import laika.ast.RootElement$;
import laika.ast.Row;
import laika.ast.Row$;
import laika.ast.Rule;
import laika.ast.RuntimeMessage;
import laika.ast.Section;
import laika.ast.Section$;
import laika.ast.SectionNumber;
import laika.ast.SectionNumber$;
import laika.ast.Selection;
import laika.ast.Selection$;
import laika.ast.Span;
import laika.ast.SpanContainer;
import laika.ast.SpanLink;
import laika.ast.SpanLink$;
import laika.ast.SpanSequence;
import laika.ast.SpanSequence$;
import laika.ast.StringBullet;
import laika.ast.StringBullet$;
import laika.ast.Strong;
import laika.ast.Strong$;
import laika.ast.Style$;
import laika.ast.Styles$;
import laika.ast.Table;
import laika.ast.TableBody;
import laika.ast.TableBody$;
import laika.ast.TableElement;
import laika.ast.TableHead;
import laika.ast.TableHead$;
import laika.ast.Target;
import laika.ast.TargetFormat;
import laika.ast.TargetFormat$;
import laika.ast.TemplateElement;
import laika.ast.TemplateElement$;
import laika.ast.TemplateRoot;
import laika.ast.TemplateRoot$;
import laika.ast.TemplateSpan;
import laika.ast.TemplateSpanContainer;
import laika.ast.TemplateSpanSequence;
import laika.ast.TemplateSpanSequence$;
import laika.ast.TemplateString;
import laika.ast.TemplateString$;
import laika.ast.Text;
import laika.ast.Text$;
import laika.ast.TextContainer;
import laika.ast.Title;
import laika.ast.Title$;
import laika.ast.TitledBlock;
import laika.ast.TitledBlock$;
import laika.parse.SourceFragment;
import laika.parse.code.CodeCategory;
import laika.render.FOFormatter;
import laika.render.FOFormatter$FootnoteBody$;
import laika.render.FOFormatter$Leader$;
import laika.render.FOFormatter$ListItemBody$;
import laika.render.FOFormatter$ListItemLabel$;
import laika.render.FOFormatter$PageNumberCitation$;
import laika.render.FORenderer$WithFallback$2$;
import laika.rewrite.nav.TargetFormats;
import laika.rst.ast.Line;
import laika.rst.ast.Line$;
import laika.rst.ast.LineBlock;
import laika.rst.ast.LineBlock$;
import laika.rst.ast.LineBlockItem;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class FORenderer$
implements Function2<FOFormatter, Element, String> {
    private static final Object formats;
    public static final FORenderer$ MODULE$;

    private FORenderer$() {
    }

    static {
        MODULE$ = new FORenderer$();
        formats = cats.data.package$.MODULE$.NonEmptySet().of((Object)"pdf", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fo", "xslfo", "xsl-fo"}), (Order)Eq$.MODULE$.catsKernelInstancesForString());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FORenderer$.class);
    }

    public String apply(FOFormatter fmt, Element element) {
        LazyRef lazyRef = new LazyRef();
        Element element2 = element;
        if (element2 instanceof RuntimeMessage) {
            RuntimeMessage e = (RuntimeMessage)element2;
            return this.renderRuntimeMessage$1(fmt, e);
        }
        if (element2 instanceof Table) {
            Table e = (Table)element2;
            return this.renderTable$1(fmt, e);
        }
        if (element2 instanceof TableElement) {
            TableElement e = (TableElement)((Object)element2);
            return this.renderTableElement$1(fmt, e);
        }
        if (element2 instanceof NavigationItem) {
            NavigationItem e = (NavigationItem)element2;
            return this.renderNavigationItem$1(fmt, e);
        }
        if (element2 instanceof Reference) {
            Reference e = (Reference)((Object)element2);
            return this.renderUnresolvedReference$1(fmt, e);
        }
        if (element2 instanceof Invalid) {
            Invalid e = (Invalid)((Object)element2);
            return this.renderInvalidElement$1(fmt, e);
        }
        if (element2 instanceof BlockContainer) {
            BlockContainer e = (BlockContainer)((Object)element2);
            return this.renderBlockContainer$1(fmt, lazyRef, e);
        }
        if (element2 instanceof SpanContainer) {
            SpanContainer e = (SpanContainer)((Object)element2);
            return this.renderSpanContainer$1(fmt, lazyRef, e);
        }
        if (element2 instanceof ListContainer) {
            ListContainer e = (ListContainer)((Object)element2);
            return this.renderListContainer$1(fmt, lazyRef, e);
        }
        if (element2 instanceof TextContainer) {
            TextContainer e = (TextContainer)((Object)element2);
            return this.renderTextContainer$1(fmt, lazyRef, e);
        }
        if (element2 instanceof TemplateSpanContainer) {
            TemplateSpanContainer e = (TemplateSpanContainer)((Object)element2);
            return this.renderTemplateSpanContainer$1(fmt, e);
        }
        if (element2 instanceof Block) {
            Block e = (Block)((Object)element2);
            return this.renderSimpleBlock$1(fmt, lazyRef, e);
        }
        if (element2 instanceof Span) {
            Span e = (Span)((Object)element2);
            return this.renderSimpleSpan$1(fmt, lazyRef, e);
        }
        return "";
    }

    private final Option noneIfDefault$1(Object actual, Object object) {
        if (BoxesRunTime.equals((Object)actual, (Object)object)) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)actual.toString());
    }

    private final String renderTable$1(FOFormatter fmt$1, Table table) {
        if (table.caption().content().nonEmpty()) {
            Object[] objectArray = new Table[1];
            Caption caption = Caption$.MODULE$.apply(Caption$.MODULE$.$lessinit$greater$default$1(), Caption$.MODULE$.$lessinit$greater$default$2());
            TableHead tableHead = table.copy$default$1();
            TableBody tableBody = table.copy$default$2();
            Columns columns = table.copy$default$4();
            Options options = table.copy$default$5();
            objectArray[0] = table.copy(tableHead, tableBody, caption, columns, options);
            return fmt$1.child(TitledBlock$.MODULE$.apply(table.caption().content(), (Seq<Block>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), TitledBlock$.MODULE$.$lessinit$greater$default$3()));
        }
        Seq children = (Seq)table.columns().content().$plus$plus((IterableOnce)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new RewritableContainer[]{table.head(), table.body()}))).filterNot((Function1 & Serializable)_$1 -> ((SeqOps)((Container)((Object)_$1)).content()).isEmpty()));
        return fmt$1.indentedElement("fo:table", table, (Seq<Element>)children, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final FORenderer$WithFallback$2$ WithFallback$lzyINIT1$1(LazyRef WithFallback$lzy1$1) {
        FORenderer$WithFallback$2$ fORenderer$WithFallback$2$;
        LazyRef lazyRef = WithFallback$lzy1$1;
        synchronized (lazyRef) {
            fORenderer$WithFallback$2$ = (FORenderer$WithFallback$2$)(WithFallback$lzy1$1.initialized() ? WithFallback$lzy1$1.value() : WithFallback$lzy1$1.initialize((Object)new FORenderer$WithFallback$2$()));
        }
        return fORenderer$WithFallback$2$;
    }

    private final FORenderer$WithFallback$2$ WithFallback$1(LazyRef WithFallback$lzy1$2) {
        return (FORenderer$WithFallback$2$)(WithFallback$lzy1$2.initialized() ? WithFallback$lzy1$2.value() : this.WithFallback$lzyINIT1$1(WithFallback$lzy1$2));
    }

    private final Seq quotedBlockContent$1(Seq content, Seq attr) {
        if (attr.isEmpty()) {
            return content;
        }
        return (Seq)content.$colon$plus((Object)SpanSequence$.MODULE$.apply((Seq<Span>)attr, Style$.MODULE$.attribution()));
    }

    private final List figureContent$1(Span img, Seq caption, Seq legend) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Block[]{(Block)Paragraph$.MODULE$.apply(img, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0])), SpanSequence$.MODULE$.apply((Seq<Span>)caption, Style$.MODULE$.caption()), BlockSequence$.MODULE$.apply((Seq<Block>)legend, Style$.MODULE$.legend())}));
    }

    private final String enumLabel$1(EnumFormat format, int num) {
        String string;
        EnumType enumType = format.enumType();
        if (EnumType$Arabic$.MODULE$.equals(enumType)) {
            string = BoxesRunTime.boxToInteger((int)num).toString();
        } else if (EnumType$LowerAlpha$.MODULE$.equals(enumType)) {
            string = BoxesRunTime.boxToCharacter((char)((char)(97 + num - 1))).toString();
        } else if (EnumType$UpperAlpha$.MODULE$.equals(enumType)) {
            string = BoxesRunTime.boxToCharacter((char)((char)(65 + num - 1))).toString();
        } else if (EnumType$LowerRoman$.MODULE$.equals(enumType)) {
            string = RomanNumerals$.MODULE$.intToRoman(num).toLowerCase();
        } else if (EnumType$UpperRoman$.MODULE$.equals(enumType)) {
            string = RomanNumerals$.MODULE$.intToRoman(num).toUpperCase();
        } else {
            throw new MatchError((Object)enumType);
        }
        String pos = string;
        return new StringBuilder(0).append(format.prefix()).append(pos).append(format.suffix()).toString();
    }

    private final Span bulletLabel$1(BulletFormat format) {
        Element element;
        BulletFormat bulletFormat = format;
        if (bulletFormat instanceof StringBullet) {
            StringBullet stringBullet = StringBullet$.MODULE$.unapply((StringBullet)bulletFormat);
            String string = stringBullet._1();
            element = RawContent$.MODULE$.apply(cats.data.package$.MODULE$.NonEmptySet().one((Object)"fo", (Order)Eq$.MODULE$.catsKernelInstancesForString()), "&#x2022;", RawContent$.MODULE$.$lessinit$greater$default$3());
        } else {
            BulletFormat other = bulletFormat;
            element = Text$.MODULE$.apply(other.toString(), Text$.MODULE$.$lessinit$greater$default$2());
        }
        return element;
    }

    private final Seq replaceSpanSequences$1(Seq content) {
        return (Seq)content.map((Function1 & Serializable)x$1 -> {
            Block block = x$1;
            if (block instanceof SpanSequence) {
                SpanSequence sc = (SpanSequence)block;
                return Paragraph$.MODULE$.apply(sc.content(), sc.options());
            }
            Block other = block;
            return other;
        });
    }

    private final String renderBlockContainer$1(FOFormatter fmt$2, LazyRef WithFallback$lzy1$3, BlockContainer con) {
        Option option;
        BlockContainer blockContainer = con;
        if (blockContainer instanceof RootElement) {
            RootElement rootElement = RootElement$.MODULE$.unapply((RootElement)blockContainer);
            Seq<Block> seq = rootElement._1();
            Options options = rootElement._2();
            Seq<Block> content = seq;
            return fmt$2.childPerLine(content);
        }
        if (blockContainer instanceof EmbeddedRoot) {
            EmbeddedRoot embeddedRoot = EmbeddedRoot$.MODULE$.unapply((EmbeddedRoot)blockContainer);
            Seq<Block> seq = embeddedRoot._1();
            int n = embeddedRoot._2();
            Options options = embeddedRoot._3();
            Seq<Block> content = seq;
            int indent = n;
            return fmt$2.withMinIndentation(indent, (Function1 & Serializable)_$2 -> _$2.childPerLine((Seq<Element>)content));
        }
        if (blockContainer instanceof Section) {
            Section section = Section$.MODULE$.unapply((Section)blockContainer);
            Header header = section._1();
            Seq<Block> seq = section._2();
            Options options = section._3();
            Header header2 = header;
            Seq<Block> content = seq;
            return fmt$2.childPerLine((Seq<Element>)((Seq)content.$plus$colon((Object)header2)));
        }
        if (blockContainer instanceof TitledBlock) {
            TitledBlock titledBlock = (TitledBlock)blockContainer;
            TitledBlock titledBlock2 = TitledBlock$.MODULE$.unapply(titledBlock);
            Seq<Span> seq = titledBlock2._1();
            Seq<Block> seq2 = titledBlock2._2();
            Options options = titledBlock2._3();
            Seq<Span> title = seq;
            Seq<Block> content = seq2;
            TitledBlock e = titledBlock;
            SpanSequence spanSequence = SpanSequence$.MODULE$.apply(title, Style$.MODULE$.title());
            return fmt$2.blockContainer(e, (Seq<Block>)((Seq)content.$plus$colon((Object)spanSequence)), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof QuotedBlock) {
            QuotedBlock quotedBlock = (QuotedBlock)blockContainer;
            QuotedBlock quotedBlock2 = QuotedBlock$.MODULE$.unapply(quotedBlock);
            Seq<Block> seq = quotedBlock2._1();
            Seq<Span> seq3 = quotedBlock2._2();
            Options options = quotedBlock2._3();
            Seq<Block> content = seq;
            Seq<Span> attr = seq3;
            QuotedBlock e = quotedBlock;
            return fmt$2.blockContainer(e, (Seq<Block>)this.quotedBlockContent$1(content, attr), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof BulletListItem) {
            BulletListItem bulletListItem = (BulletListItem)blockContainer;
            BulletListItem bulletListItem2 = BulletListItem$.MODULE$.unapply(bulletListItem);
            Seq<Block> seq = bulletListItem2._1();
            BulletFormat bulletFormat = bulletListItem2._2();
            Options options = bulletListItem2._3();
            Seq<Block> content = seq;
            BulletFormat format = bulletFormat;
            BulletListItem e = bulletListItem;
            return fmt$2.listItem(e, (Seq<Span>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[]{this.bulletLabel$1(format)}))), content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof EnumListItem) {
            EnumListItem enumListItem = (EnumListItem)blockContainer;
            EnumListItem enumListItem2 = EnumListItem$.MODULE$.unapply(enumListItem);
            Seq<Block> seq = enumListItem2._1();
            EnumFormat enumFormat = enumListItem2._2();
            int n = enumListItem2._3();
            Options options = enumListItem2._4();
            Seq<Block> content = seq;
            EnumFormat format = enumFormat;
            int num = n;
            EnumListItem e = enumListItem;
            return fmt$2.listItem(e, (Seq<Span>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Text[]{Text$.MODULE$.apply(this.enumLabel$1(format, num), Text$.MODULE$.$lessinit$greater$default$2())}))), content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof DefinitionListItem) {
            DefinitionListItem definitionListItem = (DefinitionListItem)blockContainer;
            DefinitionListItem definitionListItem2 = DefinitionListItem$.MODULE$.unapply(definitionListItem);
            Seq<Span> seq = definitionListItem2._1();
            Seq<Block> seq4 = definitionListItem2._2();
            Options options = definitionListItem2._3();
            Seq<Span> term = seq;
            Seq<Block> defn = seq4;
            DefinitionListItem e = definitionListItem;
            return fmt$2.listItem(e, term, defn, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof FOFormatter.ListItemBody) {
            FOFormatter.ListItemBody listItemBody = (FOFormatter.ListItemBody)blockContainer;
            FOFormatter.ListItemBody listItemBody2 = FOFormatter$ListItemBody$.MODULE$.unapply(listItemBody);
            Seq<Block> seq = listItemBody2._1();
            Options options = listItemBody2._2();
            Seq<Block> content = seq;
            FOFormatter.ListItemBody e = listItemBody;
            return fmt$2.listItemBody(e, (Seq<Block>)this.replaceSpanSequences$1(content), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof Figure) {
            Figure figure = (Figure)blockContainer;
            Figure figure2 = Figure$.MODULE$.unapply(figure);
            Span span = figure2._1();
            Seq<Span> seq = figure2._2();
            Seq<Block> seq5 = figure2._3();
            Options options = figure2._4();
            Span img = span;
            Seq<Span> caption = seq;
            Seq<Block> legend = seq5;
            Figure e = figure;
            return fmt$2.blockContainer(e, (Seq<Block>)this.figureContent$1(img, caption, legend), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof FOFormatter.FootnoteBody) {
            FOFormatter.FootnoteBody footnoteBody = (FOFormatter.FootnoteBody)blockContainer;
            FOFormatter.FootnoteBody footnoteBody2 = FOFormatter$FootnoteBody$.MODULE$.unapply(footnoteBody);
            Seq<Block> seq = footnoteBody2._1();
            Options options = footnoteBody2._2();
            Seq<Block> content = seq;
            FOFormatter.FootnoteBody e = footnoteBody;
            return fmt$2.indentedElement("fo:footnote-body", e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (blockContainer instanceof Footnote) {
            return "";
        }
        if (blockContainer instanceof Citation) {
            return "";
        }
        if (blockContainer != null && !(option = this.WithFallback$1(WithFallback$lzy1$3).unapply((Element)((Object)blockContainer))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$2.child(fallback);
        }
        if (blockContainer instanceof BlockSequence) {
            Block block;
            SeqOps seqOps;
            BlockSequence blockSequence = BlockSequence$.MODULE$.unapply((BlockSequence)blockContainer);
            Seq<Block> seq = blockSequence._1();
            Options options = blockSequence._2();
            if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq), 1) == 0 && (block = (Block)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) instanceof SpanSequence) {
                Span span;
                SeqOps seqOps2;
                SpanSequence spanSequence = SpanSequence$.MODULE$.unapply((SpanSequence)block);
                Seq<Span> seq6 = spanSequence._1();
                Options options2 = spanSequence._2();
                if (seq6 != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq(seq6), 1) == 0 && (span = (Span)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps2, 0)) instanceof Image) {
                    Image img = (Image)span;
                    Options optSpan = options2;
                    Options optBlock = options;
                    return fmt$2.child(SpanSequence$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Image[]{(Image)img.mergeOptions(optSpan.$plus(optBlock))}))), Styles$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"align-center", "default-space"}))));
                }
            }
            Seq<Block> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$2.childPerLine(content);
            }
        }
        BlockContainer unknown = blockContainer;
        return fmt$2.blockContainer((Element)((Object)unknown), (Seq<Block>)((Seq)unknown.content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final String renderLink$1(FOFormatter fmt$3, SpanLink link) {
        Target target = fmt$3.pathTranslator().translate(link.target());
        if (target instanceof InternalTarget) {
            InternalTarget internalTarget = (InternalTarget)target;
            return fmt$3.internalLink(link, internalTarget.relativeTo(fmt$3.path()).absolutePath(), link.content(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (target instanceof ExternalTarget) {
            ExternalTarget ext = (ExternalTarget)target;
            return fmt$3.externalLink(link, ext.url(), link.content(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        throw new MatchError((Object)target);
    }

    private final Option codeStyles$1(String language) {
        if (language.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)language);
    }

    private final String renderSpanContainer$1(FOFormatter fmt$4, LazyRef WithFallback$lzy1$4, SpanContainer con) {
        Option option;
        SpanContainer spanContainer = con;
        if (spanContainer instanceof Paragraph) {
            Span span;
            SeqOps seqOps;
            Paragraph paragraph = (Paragraph)spanContainer;
            Paragraph paragraph2 = Paragraph$.MODULE$.unapply(paragraph);
            Seq<Span> seq = paragraph2._1();
            Options options = paragraph2._2();
            if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq), 1) == 0 && (span = (Span)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0)) instanceof Image) {
                Image img = (Image)span;
                return fmt$4.child(SpanSequence$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Image[]{img}))), Styles$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"align-center", "default-space"}))));
            }
            Seq<Span> content = seq;
            Paragraph e = paragraph;
            return fmt$4.block(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof ParsedLiteralBlock) {
            ParsedLiteralBlock parsedLiteralBlock = (ParsedLiteralBlock)spanContainer;
            ParsedLiteralBlock parsedLiteralBlock2 = ParsedLiteralBlock$.MODULE$.unapply(parsedLiteralBlock);
            Seq<Span> seq = parsedLiteralBlock2._1();
            Options options = parsedLiteralBlock2._2();
            Seq<Span> content = seq;
            ParsedLiteralBlock e = parsedLiteralBlock;
            return fmt$4.blockWithWS(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof CodeBlock) {
            CodeBlock codeBlock = (CodeBlock)spanContainer;
            CodeBlock codeBlock2 = CodeBlock$.MODULE$.unapply(codeBlock);
            String string = codeBlock2._1();
            Seq<Span> seq = codeBlock2._2();
            Seq<String> seq2 = codeBlock2._3();
            Options options = codeBlock2._4();
            String lang = string;
            Seq<Span> content = seq;
            CodeBlock e = codeBlock;
            return fmt$4.blockWithWS(e.withStyles((Iterable<String>)Option$.MODULE$.option2Iterable(this.codeStyles$1(lang)).toSeq()), content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Header) {
            Header header = (Header)spanContainer;
            Header header2 = Header$.MODULE$.unapply(header);
            int n = header2._1();
            Seq<Span> seq = header2._2();
            Options options = header2._3();
            int level = n;
            Seq<Span> content = seq;
            Header e = header;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keep-with-next");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"always");
            return fmt$4.block(e.mergeOptions(Style$.MODULE$.level(level)), content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (spanContainer instanceof Title) {
            Title title = (Title)spanContainer;
            Title title2 = Title$.MODULE$.unapply(title);
            Seq<Span> seq = title2._1();
            Options options = title2._2();
            Seq<Span> content = seq;
            Title e = title;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keep-with-next");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"always");
            return fmt$4.block(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (spanContainer instanceof Emphasized) {
            Emphasized emphasized = (Emphasized)spanContainer;
            Emphasized emphasized2 = Emphasized$.MODULE$.unapply(emphasized);
            Seq<Span> seq = emphasized2._1();
            Options options = emphasized2._2();
            Seq<Span> content = seq;
            Emphasized e = emphasized;
            return fmt$4.inline(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Strong) {
            Strong strong = (Strong)spanContainer;
            Strong strong2 = Strong$.MODULE$.unapply(strong);
            Seq<Span> seq = strong2._1();
            Options options = strong2._2();
            Seq<Span> content = seq;
            Strong e = strong;
            return fmt$4.inline(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Deleted) {
            Deleted deleted = (Deleted)spanContainer;
            Deleted deleted2 = Deleted$.MODULE$.unapply(deleted);
            Seq<Span> seq = deleted2._1();
            Options options = deleted2._2();
            Seq<Span> content = seq;
            Deleted e = deleted;
            return fmt$4.inline(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Inserted) {
            Inserted inserted = (Inserted)spanContainer;
            Inserted inserted2 = Inserted$.MODULE$.unapply(inserted);
            Seq<Span> seq = inserted2._1();
            Options options = inserted2._2();
            Seq<Span> content = seq;
            Inserted e = inserted;
            return fmt$4.inline(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof InlineCode) {
            InlineCode inlineCode = (InlineCode)spanContainer;
            InlineCode inlineCode2 = InlineCode$.MODULE$.unapply(inlineCode);
            String string = inlineCode2._1();
            Seq<Span> seq = inlineCode2._2();
            Options options = inlineCode2._3();
            String lang = string;
            Seq<Span> content = seq;
            InlineCode e = inlineCode;
            return fmt$4.inline(e.withStyles((Iterable<String>)Option$.MODULE$.option2Iterable(this.codeStyles$1(lang)).toSeq()), content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof Line) {
            Line line = (Line)spanContainer;
            Line line2 = Line$.MODULE$.unapply(line);
            Seq<Span> seq = line2._1();
            Options options = line2._2();
            Seq<Span> content = seq;
            Line e = line;
            return fmt$4.block(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (spanContainer instanceof SpanLink) {
            SpanLink link = (SpanLink)spanContainer;
            return this.renderLink$1(fmt$4, link);
        }
        if (spanContainer != null && !(option = this.WithFallback$1(WithFallback$lzy1$4).unapply((Element)((Object)spanContainer))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$4.child(fallback);
        }
        if (spanContainer instanceof SpanSequence) {
            SpanSequence spanSequence = SpanSequence$.MODULE$.unapply((SpanSequence)spanContainer);
            Seq<Span> seq = spanSequence._1();
            Options options = spanSequence._2();
            Seq<Span> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$4.children(content);
            }
        }
        if (spanContainer instanceof CodeSpanSequence) {
            CodeSpanSequence codeSpanSequence = CodeSpanSequence$.MODULE$.unapply((CodeSpanSequence)spanContainer);
            Seq<Span> seq = codeSpanSequence._1();
            Options options = codeSpanSequence._2();
            Seq<Span> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$4.children(content);
            }
        }
        if (spanContainer instanceof Block) {
            Block unknown = (Block)((Object)spanContainer);
            return fmt$4.block((Element)((Object)unknown), (Seq<Span>)((Seq)((Container)((Object)unknown)).content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        SpanContainer unknown = spanContainer;
        return fmt$4.inline((Element)((Object)unknown), (Seq<Span>)((Seq)unknown.content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final String renderTemplateSpanContainer$1(FOFormatter fmt$5, TemplateSpanContainer con) {
        TemplateSpanContainer templateSpanContainer = con;
        if (templateSpanContainer instanceof TemplateRoot) {
            TemplateRoot templateRoot = TemplateRoot$.MODULE$.unapply((TemplateRoot)templateSpanContainer);
            Seq<TemplateSpan> seq = templateRoot._1();
            Options options = templateRoot._2();
            Seq<TemplateSpan> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$5.children(content);
            }
        }
        if (templateSpanContainer instanceof TemplateSpanSequence) {
            TemplateSpanSequence templateSpanSequence = TemplateSpanSequence$.MODULE$.unapply((TemplateSpanSequence)templateSpanContainer);
            Seq<TemplateSpan> seq = templateSpanSequence._1();
            Options options = templateSpanSequence._2();
            Seq<TemplateSpan> content = seq;
            if (NoOpt$.MODULE$.equals(options)) {
                return fmt$5.children(content);
            }
        }
        TemplateSpanContainer unknown = templateSpanContainer;
        return fmt$5.inline((Element)((Object)unknown), (Seq<Span>)((Seq)unknown.content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final String renderListContainer$1(FOFormatter fmt$6, LazyRef WithFallback$lzy1$5, ListContainer con) {
        Option option;
        ListContainer listContainer = con;
        if (listContainer instanceof EnumList) {
            EnumList enumList = (EnumList)listContainer;
            EnumList enumList2 = EnumList$.MODULE$.unapply(enumList);
            Seq<EnumListItem> seq = enumList2._1();
            EnumFormat enumFormat = enumList2._2();
            int n = enumList2._3();
            Options options = enumList2._4();
            Seq<EnumListItem> content = seq;
            EnumList e = enumList;
            return fmt$6.listBlock(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (listContainer instanceof BulletList) {
            BulletList bulletList = (BulletList)listContainer;
            BulletList bulletList2 = BulletList$.MODULE$.unapply(bulletList);
            Seq<BulletListItem> seq = bulletList2._1();
            BulletFormat bulletFormat = bulletList2._2();
            Options options = bulletList2._3();
            Seq<BulletListItem> content = seq;
            BulletList e = bulletList;
            return fmt$6.listBlock(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (listContainer instanceof DefinitionList) {
            DefinitionList definitionList = (DefinitionList)listContainer;
            DefinitionList definitionList2 = DefinitionList$.MODULE$.unapply(definitionList);
            Seq<DefinitionListItem> seq = definitionList2._1();
            Options options = definitionList2._2();
            Seq<DefinitionListItem> content = seq;
            DefinitionList e = definitionList;
            return fmt$6.listBlock(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (listContainer instanceof NavigationList) {
            NavigationList e = (NavigationList)listContainer;
            if (e.hasStyle("bookmark")) {
                return fmt$6.bookmarkTree(e);
            }
            return fmt$6.childPerLine(e.content());
        }
        if (listContainer != null && !(option = this.WithFallback$1(WithFallback$lzy1$5).unapply((Element)((Object)listContainer))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$6.child(fallback);
        }
        ListContainer unknown = listContainer;
        return fmt$6.listBlock((Element)((Object)unknown), (Seq<ListItem>)((Seq)unknown.content()), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final String renderTextContainer$1(FOFormatter fmt$7, LazyRef WithFallback$lzy1$6, TextContainer con) {
        Option option;
        TextContainer textContainer = con;
        if (textContainer instanceof Text) {
            Text text = (Text)textContainer;
            Text text2 = Text$.MODULE$.unapply(text);
            String string = text2._1();
            Options options = text2._2();
            String content = string;
            Text e = text;
            return fmt$7.text(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof TemplateString) {
            TemplateString templateString = (TemplateString)textContainer;
            TemplateString templateString2 = TemplateString$.MODULE$.unapply(templateString);
            String string = templateString2._1();
            Options options = templateString2._2();
            String content = string;
            TemplateString e = templateString;
            return fmt$7.rawText(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof RawContent) {
            RawContent rawContent = (RawContent)textContainer;
            RawContent rawContent2 = RawContent$.MODULE$.unapply(rawContent);
            Object object = rawContent2._1();
            String string = rawContent2._2();
            Options options = rawContent2._3();
            Object f = object;
            String content = string;
            RawContent e = rawContent;
            if (NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(f).intersect(formats).nonEmpty()) {
                return fmt$7.rawText(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            return "";
        }
        if (textContainer instanceof CodeSpan) {
            CodeSpan codeSpan = (CodeSpan)textContainer;
            CodeSpan codeSpan2 = CodeSpan$.MODULE$.unapply(codeSpan);
            String string = codeSpan2._1();
            Set<CodeCategory> set = codeSpan2._2();
            Options options = codeSpan2._3();
            String content = string;
            Set<CodeCategory> categories = set;
            CodeSpan e = codeSpan;
            return fmt$7.textWithWS(e.withStyles((Iterable<String>)((Iterable)categories.map((Function1 & Serializable)_$3 -> _$3.name()))), content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof Literal) {
            Literal literal = (Literal)textContainer;
            Literal literal2 = Literal$.MODULE$.unapply(literal);
            String string = literal2._1();
            Options options = literal2._2();
            String content = string;
            Literal e = literal;
            return fmt$7.textWithWS(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof LiteralBlock) {
            LiteralBlock literalBlock = (LiteralBlock)textContainer;
            LiteralBlock literalBlock2 = LiteralBlock$.MODULE$.unapply(literalBlock);
            String string = literalBlock2._1();
            Options options = literalBlock2._2();
            String content = string;
            LiteralBlock e = literalBlock;
            return fmt$7.textBlockWithWS(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (textContainer instanceof FOFormatter.BookmarkTitle) {
            FOFormatter.BookmarkTitle e = (FOFormatter.BookmarkTitle)textContainer;
            return fmt$7.bookmarkTitle(e);
        }
        if (textContainer instanceof Comment) {
            Comment comment = Comment$.MODULE$.unapply((Comment)textContainer);
            String string = comment._1();
            Options options = comment._2();
            String content = string;
            return fmt$7.comment(content);
        }
        if (textContainer != null && !(option = this.WithFallback$1(WithFallback$lzy1$6).unapply((Element)((Object)textContainer))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$7.child(fallback);
        }
        TextContainer unknown = textContainer;
        return fmt$7.text((Element)((Object)unknown), (String)unknown.content(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final String renderChoices$1(FOFormatter fmt$8, String name, Seq choices, Options options) {
        Seq content = (Seq)choices.flatMap((Function1 & Serializable)choice -> {
            Paragraph paragraph = (Paragraph)Paragraph$.MODULE$.apply((Span)Strong$.MODULE$.apply((Span)Text$.MODULE$.apply(choice.label(), Text$.MODULE$.$lessinit$greater$default$2()), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Span[0]));
            return (IterableOnce)choice.content().$plus$colon((Object)paragraph);
        });
        return fmt$8.child(BlockSequence$.MODULE$.apply((Seq<Block>)content, options));
    }

    private final String renderSimpleBlock$1(FOFormatter fmt$9, LazyRef WithFallback$lzy1$7, Block block) {
        Option option;
        Block block2 = block;
        if (block2 instanceof FOFormatter.ContentWrapper) {
            FOFormatter.ContentWrapper e = (FOFormatter.ContentWrapper)block2;
            return this.renderContentWrapper$1(fmt$9, e);
        }
        if (block2 instanceof FOFormatter.Preamble) {
            FOFormatter.Preamble e = (FOFormatter.Preamble)block2;
            return this.renderPreamble$1(fmt$9, e);
        }
        if (block2 instanceof FOFormatter.ListItemLabel) {
            FOFormatter.ListItemLabel listItemLabel = (FOFormatter.ListItemLabel)block2;
            FOFormatter.ListItemLabel listItemLabel2 = FOFormatter$ListItemLabel$.MODULE$.unapply(listItemLabel);
            Block block3 = listItemLabel2._1();
            Options options = listItemLabel2._2();
            Block content = block3;
            FOFormatter.ListItemLabel e = listItemLabel;
            return fmt$9.listItemLabel(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (block2 instanceof Rule) {
            Rule e = (Rule)block2;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"leader-pattern");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"rule");
            return fmt$9.rawElement("fo:block", ((BlockSequence)BlockSequence$.MODULE$.empty()).withOptions(e.options().$plus(Styles$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"rule-block"})))), fmt$9.textElement("fo:leader", e, "", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (block2 instanceof Selection) {
            Selection selection = Selection$.MODULE$.unapply((Selection)block2);
            String string = selection._1();
            Seq<Choice> seq = selection._2();
            Options options = selection._3();
            String name = string;
            Seq<Choice> choices = seq;
            Options opt = options;
            return this.renderChoices$1(fmt$9, name, choices, opt);
        }
        if (block2 instanceof InternalLinkTarget) {
            InternalLinkTarget e = (InternalLinkTarget)block2;
            return fmt$9.internalLinkTarget(e);
        }
        if (block2 instanceof PageBreak) {
            PageBreak e = (PageBreak)block2;
            return fmt$9.block(e, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (block2 instanceof LineBlock) {
            LineBlock lineBlock = (LineBlock)block2;
            LineBlock lineBlock2 = LineBlock$.MODULE$.unapply(lineBlock);
            Seq<LineBlockItem> seq = lineBlock2._1();
            Options options = lineBlock2._2();
            Seq<LineBlockItem> content = seq;
            LineBlock e = lineBlock;
            return fmt$9.blockContainer(e, content, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (block2 instanceof TargetFormat) {
            TargetFormat targetFormat = TargetFormat$.MODULE$.unapply((TargetFormat)block2);
            Object object = targetFormat._1();
            Element element = targetFormat._2();
            Options options = targetFormat._3();
            Object f = object;
            Element e = element;
            if (NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(f).intersect(formats).nonEmpty()) {
                return fmt$9.child(e);
            }
        }
        if (block2 != null && !(option = this.WithFallback$1(WithFallback$lzy1$7).unapply((Element)((Object)block2))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$9.child(fallback);
        }
        return "";
    }

    private final String renderTarget$1(FOFormatter fmt$10, Target target) {
        Target target2 = fmt$10.pathTranslator().translate(target);
        if (target2 instanceof ExternalTarget) {
            ExternalTarget ext = (ExternalTarget)target2;
            return ext.url();
        }
        if (target2 instanceof InternalTarget) {
            InternalTarget internalTarget = (InternalTarget)target2;
            return fmt$10.buildId(internalTarget.relativeTo(fmt$10.path()).absolutePath());
        }
        throw new MatchError((Object)target2);
    }

    private final String $anonfun$3(InlineSVGIcon icon$1) {
        return icon$1.content();
    }

    private final String renderIcon$1(FOFormatter fmt$11, Icon icon) {
        Icon icon2 = icon;
        if (icon2 instanceof IconGlyph) {
            IconGlyph icon3 = (IconGlyph)icon2;
            return fmt$11.rawElement("fo:inline", icon3, icon3.codePointAsEntity(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (icon2 instanceof InlineSVGIcon) {
            InlineSVGIcon icon4 = (InlineSVGIcon)icon2;
            Option styles = fmt$11.styles().collectStyles(((Element)SpanSequence$.MODULE$.empty()).withStyle("svg-shape"), (Seq<Element>)fmt$11.parents()).get((Object)"color");
            String svg = (String)styles.fold(() -> this.$anonfun$3(icon4), (Function1 & Serializable)color -> {
                Object[] parts = icon4.content().split(">", 2);
                if (parts.length == 2) {
                    Object object = Predef$.MODULE$.refArrayOps(parts);
                    Object object2 = Predef$.MODULE$.refArrayOps(parts);
                    return new StringBuilder(0).append((String)ArrayOps$.MODULE$.head$extension(object)).append(new StringBuilder(41).append(">\n  <style>.svg-shape { fill: ").append((String)color).append("; }</style>").toString()).append((String)ArrayOps$.MODULE$.last$extension(object2)).toString();
                }
                return icon4.content();
            });
            return fmt$11.rawElement("fo:instream-foreign-object", icon4, svg, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        return "";
    }

    private final String renderSimpleSpan$1(FOFormatter fmt$12, LazyRef WithFallback$lzy1$8, Span span) {
        Option option;
        Span span2 = span;
        if (span2 instanceof CitationLink) {
            CitationLink citationLink = (CitationLink)span2;
            CitationLink citationLink2 = CitationLink$.MODULE$.unapply(citationLink);
            String string = citationLink2._1();
            String string2 = citationLink2._2();
            Options options = citationLink2._3();
            String ref = string;
            String label = string2;
            CitationLink e = citationLink;
            return fmt$12.withCitation(ref, (Function1<Citation, String>)(Function1 & Serializable)c -> fmt$12.footnote(e, label, c.content(), c.options()));
        }
        if (span2 instanceof FootnoteLink) {
            FootnoteLink footnoteLink = (FootnoteLink)span2;
            FootnoteLink footnoteLink2 = FootnoteLink$.MODULE$.unapply(footnoteLink);
            String string = footnoteLink2._1();
            String string3 = footnoteLink2._2();
            Options options = footnoteLink2._3();
            String ref = string;
            String label = string3;
            FootnoteLink e = footnoteLink;
            return fmt$12.withFootnote(ref, (Function1<Footnote, String>)(Function1 & Serializable)f -> fmt$12.footnote(e, label, f.content(), f.options()));
        }
        if (span2 instanceof RawLink) {
            RawLink rawLink = RawLink$.MODULE$.unapply((RawLink)span2);
            Target target = rawLink._1();
            Options options = rawLink._2();
            Target target2 = target;
            return this.renderTarget$1(fmt$12, target2);
        }
        if (span2 instanceof SectionNumber) {
            SectionNumber sectionNumber = SectionNumber$.MODULE$.unapply((SectionNumber)span2);
            Seq<Object> seq = sectionNumber._1();
            Options options = sectionNumber._2();
            Seq<Object> pos = seq;
            Options opt = options;
            return fmt$12.child(Text$.MODULE$.apply(new StringBuilder(1).append(pos.mkString(".")).append(" ").toString(), opt.$plus(Style$.MODULE$.sectionNumber())));
        }
        if (span2 instanceof Image) {
            String string;
            Image image = (Image)span2;
            Image image2 = Image$.MODULE$.unapply(image);
            Target target = image2._1();
            Option<Length> option2 = image2._2();
            Option<Length> option3 = image2._3();
            Option<String> option4 = image2._4();
            Option<String> option5 = image2._5();
            Options options = image2._6();
            Target target3 = target;
            Image e = image;
            Target target4 = target3;
            if (target4 instanceof InternalTarget) {
                InternalTarget it = (InternalTarget)target4;
                string = it.relativeTo(fmt$12.path()).absolutePath().toString();
            } else if (target4 instanceof ExternalTarget) {
                ExternalTarget et = (ExternalTarget)target4;
                string = et.url();
            } else {
                throw new MatchError((Object)target4);
            }
            String uri = string;
            return fmt$12.externalGraphic(e, uri, (Option<Length>)None$.MODULE$, (Option<Length>)None$.MODULE$);
        }
        if (span2 instanceof Icon) {
            Icon icon = (Icon)span2;
            return this.renderIcon$1(fmt$12, icon);
        }
        if (span2 instanceof FOFormatter.Leader) {
            FOFormatter.Leader e = (FOFormatter.Leader)span2;
            Object[] objectArray = new Tuple2[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"leader-pattern");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"dots");
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"padding-left");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"2mm");
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"padding-right");
            objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)"2mm");
            return fmt$12.textElement("fo:leader", e, "", (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (span2 instanceof FOFormatter.PageNumberCitation) {
            FOFormatter.PageNumberCitation pageNumberCitation = FOFormatter$PageNumberCitation$.MODULE$.unapply((FOFormatter.PageNumberCitation)span2);
            InternalTarget internalTarget = pageNumberCitation._1();
            Options options = pageNumberCitation._2();
            InternalTarget target = internalTarget;
            return new StringBuilder(37).append("<fo:page-number-citation ref-id=\"").append(fmt$12.buildId(target.relativeTo(fmt$12.path()).absolutePath())).append("\" />").toString();
        }
        if (span2 instanceof LineBreak) {
            LineBreak lineBreak = LineBreak$.MODULE$.unapply((LineBreak)span2);
            Options options = lineBreak._1();
            return "&#x2028;";
        }
        if (span2 instanceof TemplateElement) {
            TemplateElement templateElement = TemplateElement$.MODULE$.unapply((TemplateElement)span2);
            Element element = templateElement._1();
            int n = templateElement._2();
            Options options = templateElement._3();
            Element elem = element;
            int indent = n;
            return fmt$12.withMinIndentation(indent, (Function1 & Serializable)_$4 -> _$4.child(elem));
        }
        if (span2 != null && !(option = this.WithFallback$1(WithFallback$lzy1$8).unapply((Element)((Object)span2))).isEmpty()) {
            Element element;
            Element fallback = element = (Element)option.get();
            return fmt$12.child(fallback);
        }
        return "";
    }

    private final Seq addRowStyles$1(Seq rows) {
        return (Seq)((IterableOps)rows.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Row row = (Row)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return (Row)row.withStyle(index % 2 == 0 ? "cell-odd" : "cell-even");
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final String renderTableElement$1(FOFormatter fmt$15, TableElement elem) {
        TableElement tableElement = elem;
        if (tableElement instanceof TableHead) {
            TableHead tableHead = (TableHead)tableElement;
            TableHead tableHead2 = TableHead$.MODULE$.unapply(tableHead);
            Seq<Row> seq = tableHead2._1();
            Options options = tableHead2._2();
            Seq<Row> rows = seq;
            TableHead e = tableHead;
            return fmt$15.indentedElement("fo:table-header", e, rows, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof TableBody) {
            TableBody tableBody = (TableBody)tableElement;
            TableBody tableBody2 = TableBody$.MODULE$.unapply(tableBody);
            Seq<Row> seq = tableBody2._1();
            Options options = tableBody2._2();
            Seq<Row> rows = seq;
            TableBody e = tableBody;
            return fmt$15.indentedElement("fo:table-body", e, (Seq<Element>)this.addRowStyles$1(rows), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof Caption) {
            Caption caption = Caption$.MODULE$.unapply((Caption)tableElement);
            Seq<Span> seq = caption._1();
            Options options = caption._2();
            return "";
        }
        if (tableElement instanceof Columns) {
            Columns columns = Columns$.MODULE$.unapply((Columns)tableElement);
            Seq<Column> seq = columns._1();
            Options options = columns._2();
            return "";
        }
        if (tableElement instanceof Column) {
            Column e = (Column)tableElement;
            return fmt$15.emptyElement("fo:table-column", e, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof Row) {
            Row row = (Row)tableElement;
            Row row2 = Row$.MODULE$.unapply(row);
            Seq<Cell> seq = row2._1();
            Options options = row2._2();
            Seq<Cell> cells = seq;
            Row e = row;
            return fmt$15.indentedElement("fo:table-row", e, cells, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }
        if (tableElement instanceof Cell) {
            Cell cell = (Cell)tableElement;
            Cell cell2 = Cell$.MODULE$.unapply(cell);
            CellType cellType = cell2._1();
            Seq<Block> seq = cell2._2();
            int n = cell2._3();
            int n2 = cell2._4();
            Options options = cell2._5();
            Seq<Block> content = seq;
            int colspan = n;
            int rowspan = n2;
            Cell e = cell;
            Object[] objectArray = new Tuple2[2];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"number-columns-spanned");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.noneIfDefault$1(BoxesRunTime.boxToInteger((int)colspan), BoxesRunTime.boxToInteger((int)1)));
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"number-rows-spanned");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.noneIfDefault$1(BoxesRunTime.boxToInteger((int)rowspan), BoxesRunTime.boxToInteger((int)1)));
            return fmt$15.indentedElement("fo:table-cell", e, content, fmt$15.optAttributes((Seq<Tuple2<String, Option<String>>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }
        throw new MatchError((Object)tableElement);
    }

    private final Seq avoidOrphan$1(Options keepWithPrev$1, Seq content) {
        Option option;
        Seq seq = content;
        if (seq != null && !(option = package$.MODULE$.$colon$plus().unapply((SeqOps)seq)).isEmpty()) {
            Tuple2 tuple2 = (Tuple2)option.get();
            Seq init = (Seq)tuple2._1();
            NavigationItem last = (NavigationItem)tuple2._2();
            if (last.content().isEmpty()) {
                return (Seq)init.$colon$plus((Object)last.mergeOptions(keepWithPrev$1));
            }
        }
        Seq empty = seq;
        return empty;
    }

    private final String renderNavigationItem$1(FOFormatter fmt$16, NavigationItem elem) {
        NavigationItem l;
        Options keepWithNext = Styles$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keepWithNext"}));
        Options keepWithPrev = Styles$.MODULE$.apply((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"keepWithPrevious"}));
        NavigationItem navigationItem = elem;
        if (navigationItem != null && (l = navigationItem).hasStyle("bookmark")) {
            return fmt$16.bookmark(l);
        }
        if (navigationItem != null) {
            NavigationLink navigationLink;
            NavigationItem navigationItem2 = NavigationItem$.MODULE$.unapply(navigationItem);
            SpanSequence spanSequence = navigationItem2._1();
            Seq<NavigationItem> seq = navigationItem2._2();
            Option<NavigationLink> option = navigationItem2._3();
            TargetFormats targetFormats = navigationItem2._4();
            Options options = navigationItem2._5();
            SpanSequence title = spanSequence;
            Seq<NavigationItem> content = seq;
            if (option instanceof Some && (navigationLink = (NavigationLink)((Some)option).value()) != null) {
                NavigationLink navigationLink2 = NavigationLink$.MODULE$.unapply(navigationLink);
                Target target = navigationLink2._1();
                boolean bl = navigationLink2._2();
                TargetFormats targetFormats2 = navigationLink2._3();
                if (target instanceof InternalTarget) {
                    InternalTarget target2 = (InternalTarget)target;
                    Options opt = options;
                    SpanLink link = SpanLink$.MODULE$.apply((Seq<Span>)((Seq)((SeqOps)title.content().$colon$plus((Object)FOFormatter$Leader$.MODULE$.apply(FOFormatter$Leader$.MODULE$.$lessinit$greater$default$1()))).$colon$plus((Object)FOFormatter$PageNumberCitation$.MODULE$.apply(target2, FOFormatter$PageNumberCitation$.MODULE$.$lessinit$greater$default$2()))), target2, SpanLink$.MODULE$.$lessinit$greater$default$3(), SpanLink$.MODULE$.$lessinit$greater$default$4());
                    Options keep = content.isEmpty() ? NoOpt$.MODULE$ : keepWithNext;
                    Paragraph paragraph = Paragraph$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SpanLink[]{link}))), Style$.MODULE$.nav().$plus(keep).$plus(opt));
                    return fmt$16.childPerLine((Seq<Element>)((Seq)this.avoidOrphan$1(keepWithPrev, content).$plus$colon((Object)paragraph)));
                }
            }
            SpanSequence title2 = spanSequence;
            Seq<NavigationItem> content2 = seq;
            if (None$.MODULE$.equals(option)) {
                Options opt = options;
                Paragraph paragraph = Paragraph$.MODULE$.apply(title2.content(), Style$.MODULE$.nav().$plus(keepWithNext).$plus(opt));
                return fmt$16.childPerLine((Seq<Element>)((Seq)this.avoidOrphan$1(keepWithPrev, content2).$plus$colon((Object)paragraph)));
            }
        }
        return "";
    }

    private final String renderUnresolvedReference$1(FOFormatter fmt$17, Reference ref) {
        return fmt$17.child(InvalidSpan$.MODULE$.apply(new StringBuilder(22).append("unresolved reference: ").append(ref).toString(), ref.source()));
    }

    private final String renderInvalidElement$1(FOFormatter fmt$18, Invalid elem) {
        Invalid invalid = elem;
        if (invalid instanceof InvalidBlock) {
            InvalidBlock invalidBlock = InvalidBlock$.MODULE$.unapply((InvalidBlock)invalid);
            RuntimeMessage runtimeMessage = invalidBlock._1();
            SourceFragment sourceFragment = invalidBlock._2();
            Block block = invalidBlock._3();
            Options options = invalidBlock._4();
            RuntimeMessage msg = runtimeMessage;
            Block fallback = block;
            Options opt = options;
            return new StringBuilder(0).append(fmt$18.forMessage(msg, fmt$18.child(Paragraph$.MODULE$.apply((Seq<Span>)((Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RuntimeMessage[]{msg}))), opt)))).append(fmt$18.child((Element)((Object)fallback))).toString();
        }
        Invalid e = invalid;
        return new StringBuilder(0).append(fmt$18.forMessage(e.message(), new StringBuilder(1).append(fmt$18.child(e.message())).append(" ").toString())).append(fmt$18.child(e.fallback())).toString();
    }

    private final String renderRuntimeMessage$1(FOFormatter fmt$19, RuntimeMessage message) {
        return fmt$19.forMessage(message, fmt$19.text(message.withStyle(message.level().toString().toLowerCase()), message.content(), (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
    }

    private final String renderContentWrapper$1(FOFormatter fmt$20, FOFormatter.ContentWrapper cw) {
        String inner = new StringBuilder(0).append(fmt$20.newLine()).append(cw.content()).append(fmt$20.newLine()).toString();
        return fmt$20.rawElement("fo:wrapper", cw, inner, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    private final String renderPreamble$1(FOFormatter fmt$21, FOFormatter.Preamble p) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(172).append("\n         |\n         |<fo:block id=\"").append(fmt$21.buildId(fmt$21.path())).append("\" page-break-before=\"always\">\n         |  <fo:marker marker-class-name=\"chapter\"><fo:block>").append(fmt$21.text(p.title())).append("</fo:block></fo:marker>\n         |</fo:block>").toString()));
    }
}

