/*
 * Decompiled with CFR 0.152.
 */
package ambience.businessrules.logic;

import ambience.businessrules.logic.And;
import ambience.businessrules.logic.And$;
import ambience.businessrules.logic.BooleanValue;
import ambience.businessrules.logic.BooleanValue$;
import ambience.businessrules.logic.Eq;
import ambience.businessrules.logic.Eq$;
import ambience.businessrules.logic.Exists;
import ambience.businessrules.logic.Exists$;
import ambience.businessrules.logic.FieldValue;
import ambience.businessrules.logic.FieldValue$;
import ambience.businessrules.logic.FloatValue;
import ambience.businessrules.logic.FloatValue$;
import ambience.businessrules.logic.Gt;
import ambience.businessrules.logic.Gt$;
import ambience.businessrules.logic.Gte;
import ambience.businessrules.logic.Gte$;
import ambience.businessrules.logic.In;
import ambience.businessrules.logic.In$;
import ambience.businessrules.logic.IntValue;
import ambience.businessrules.logic.IntValue$;
import ambience.businessrules.logic.LogicItem;
import ambience.businessrules.logic.Lt;
import ambience.businessrules.logic.Lt$;
import ambience.businessrules.logic.Lte;
import ambience.businessrules.logic.Lte$;
import ambience.businessrules.logic.Ne;
import ambience.businessrules.logic.Ne$;
import ambience.businessrules.logic.Nin;
import ambience.businessrules.logic.Nin$;
import ambience.businessrules.logic.Not;
import ambience.businessrules.logic.Not$;
import ambience.businessrules.logic.NullValue$;
import ambience.businessrules.logic.Or;
import ambience.businessrules.logic.Or$;
import ambience.businessrules.logic.TextValue;
import ambience.businessrules.logic.TextValue$;
import ambience.businessrules.logic.Value;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JsonConverters$
implements Serializable {
    private static final String DEq;
    private static final String DNe;
    private static final String DGt;
    private static final String DLt;
    private static final String DGte;
    private static final String DLte;
    private static final String DIn;
    private static final String DNin;
    private static final String DExists;
    private static final String DAnd;
    private static final String DOr;
    private static final String DNot;
    public static final JsonConverters$ MODULE$;

    private JsonConverters$() {
    }

    static {
        MODULE$ = new JsonConverters$();
        DEq = "$eq";
        DNe = "$ne";
        DGt = "$gt";
        DLt = "$lt";
        DGte = "$gte";
        DLte = "$lte";
        DIn = "$in";
        DNin = "$nin";
        DExists = "$exists";
        DAnd = "$and";
        DOr = "$or";
        DNot = "$not";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonConverters$.class);
    }

    public String DEq() {
        return DEq;
    }

    public String DNe() {
        return DNe;
    }

    public String DGt() {
        return DGt;
    }

    public String DLt() {
        return DLt;
    }

    public String DGte() {
        return DGte;
    }

    public String DLte() {
        return DLte;
    }

    public String DIn() {
        return DIn;
    }

    public String DNin() {
        return DNin;
    }

    public String DExists() {
        return DExists;
    }

    public String DAnd() {
        return DAnd;
    }

    public String DOr() {
        return DOr;
    }

    public String DNot() {
        return DNot;
    }

    public Json toJson(LogicItem logicItem2) {
        LogicItem logicItem3 = logicItem2;
        if (NullValue$.MODULE$.equals(logicItem3)) {
            return Json$.MODULE$.Null();
        }
        if (logicItem3 instanceof TextValue) {
            TextValue value = (TextValue)logicItem3;
            return Json$.MODULE$.fromString(value.text());
        }
        if (logicItem3 instanceof FieldValue) {
            FieldValue value = (FieldValue)logicItem3;
            return Json$.MODULE$.fromString("$" + value.field());
        }
        if (logicItem3 instanceof IntValue) {
            IntValue value = (IntValue)logicItem3;
            return Json$.MODULE$.fromLong(value.num());
        }
        if (logicItem3 instanceof FloatValue) {
            FloatValue value = (FloatValue)logicItem3;
            return Json$.MODULE$.fromDoubleOrString(value.num());
        }
        if (logicItem3 instanceof BooleanValue) {
            BooleanValue value = (BooleanValue)logicItem3;
            return Json$.MODULE$.fromBoolean(value.b());
        }
        if (logicItem3 instanceof Eq) {
            Eq eq = (Eq)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)eq.field());
            Object[] objectArray2 = new Tuple2[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DEq());
            objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.toJson(eq.value()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Ne) {
            Ne ne = (Ne)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)ne.field());
            Object[] objectArray3 = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DNe());
            objectArray3[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.toJson(ne.value()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Gt) {
            Gt gt = (Gt)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)gt.field());
            Object[] objectArray4 = new Tuple2[1];
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DGt());
            objectArray4[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)this.toJson(gt.value()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Lt) {
            Lt lt = (Lt)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)lt.field());
            Object[] objectArray5 = new Tuple2[1];
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DLt());
            objectArray5[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)this.toJson(lt.value()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Gte) {
            Gte gte = (Gte)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)gte.field());
            Object[] objectArray6 = new Tuple2[1];
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DGte());
            objectArray6[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)this.toJson(gte.value()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray6)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Lte) {
            Lte lte = (Lte)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)lte.field());
            Object[] objectArray7 = new Tuple2[1];
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DLte());
            objectArray7[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)this.toJson(lte.value()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray7)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof In) {
            In in = (In)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)in.field());
            Object[] objectArray8 = new Tuple2[1];
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DIn());
            objectArray8[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)Json$.MODULE$.fromValues((Iterable)in.values().map((Function1 & Serializable)logicItem -> MODULE$.toJson((LogicItem)logicItem))));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray8)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Nin) {
            Nin nin = (Nin)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)nin.field());
            Object[] objectArray9 = new Tuple2[1];
            String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DNin());
            objectArray9[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)Json$.MODULE$.fromValues((Iterable)nin.values().map((Function1 & Serializable)logicItem -> MODULE$.toJson((LogicItem)logicItem))));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray9)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Exists) {
            Exists exists = (Exists)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)exists.field());
            Object[] objectArray10 = new Tuple2[1];
            String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DExists());
            objectArray10[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)Json$.MODULE$.fromBoolean(exists.b()));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray10)));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Or) {
            Or or = (Or)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DOr());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromValues((Iterable)or.items().map((Function1 & Serializable)logicItem -> MODULE$.toJson((LogicItem)logicItem))));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof And) {
            And and = (And)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DAnd());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromValues((Iterable)and.items().map((Function1 & Serializable)logicItem -> MODULE$.toJson((LogicItem)logicItem))));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        if (logicItem3 instanceof Not) {
            Not not = (Not)logicItem3;
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.DNot());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.toJson(not.item()));
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        throw new MatchError((Object)logicItem3);
    }

    public Either<String, LogicItem> fromJson(Json json) {
        return (Either)json.fold(JsonConverters$::fromJson$$anonfun$1, (Function1 & Serializable)bool -> JsonConverters$.fromJson$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)bool)), (Function1 & Serializable)num -> (Either)num.toLong().map((Function1 & Serializable)lng -> JsonConverters$.fromJson$$anonfun$3$$anonfun$1(BoxesRunTime.unboxToLong((Object)lng))).getOrElse(() -> JsonConverters$.fromJson$$anonfun$3$$anonfun$2(num)), (Function1 & Serializable)str -> {
            if (str.startsWith("$")) {
                return package$.MODULE$.Right().apply((Object)FieldValue$.MODULE$.apply(str.substring(1)));
            }
            return package$.MODULE$.Right().apply((Object)TextValue$.MODULE$.apply((String)str));
        }, (Function1 & Serializable)arr -> package$.MODULE$.Left().apply((Object)"Arrays are not supported as a LogicItem"), (Function1 & Serializable)obj -> MODULE$.fromJsonObject((JsonObject)obj));
    }

    public Either<String, Value> fromJsonToValue(Json json) {
        Option option = json.asString();
        if (option instanceof Some) {
            String s = (String)((Some)option).value();
            if (s.startsWith("$")) {
                return package$.MODULE$.Right().apply((Object)FieldValue$.MODULE$.apply(s.substring(1)));
            }
            return package$.MODULE$.Right().apply((Object)TextValue$.MODULE$.apply(s));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("Value expected, got " + json.noSpaces()));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, List<Value>> fromJsonToValues(Json json) {
        Option option = json.asArray();
        if (option instanceof Some) {
            Vector arr = (Vector)((Some)option).value();
            return this.fromJsonToValues((List<Json>)arr.toList());
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("Value expected, got " + json.noSpaces()));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, List<Value>> fromJsonToValues(List<Json> vs) {
        List<Json> list = vs;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Json> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil());
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Json head = (Json)colon2.head();
            List tail = list3;
            return this.fromJsonToValue(head).flatMap((Function1 & Serializable)v -> MODULE$.fromJsonToValues((List<Json>)tail).map((Function1 & Serializable)rest -> rest.$colon$colon(v)));
        }
        throw new MatchError(list);
    }

    public Either<String, LogicItem> fromJsonObject(JsonObject obj) {
        Option option = obj.apply(this.DAnd());
        if (option instanceof Some) {
            Json and = (Json)((Some)option).value();
            return this.fromAnd(and);
        }
        if (None$.MODULE$.equals(option)) {
            Option option2 = obj.apply(this.DOr());
            if (option2 instanceof Some) {
                Json or = (Json)((Some)option2).value();
                return this.fromOr(or);
            }
            if (None$.MODULE$.equals(option2)) {
                return this.fromFields(obj);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    public Either<String, LogicItem> fromFields(JsonObject obj) {
        List list = obj.toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return package$.MODULE$.Left().apply((Object)"No fields found");
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Tuple2 tuple2 = (Tuple2)colon2.head();
            List list3 = colon2.next$access$1();
            Tuple2 head = tuple2;
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                return this.fromField((String)head._1(), (Json)head._2());
            }
            Tuple2 head2 = tuple2;
            return package$.MODULE$.Left().apply((Object)("Unexpected field after " + head2._1()));
        }
        throw new MatchError((Object)list);
    }

    public Either<String, LogicItem> fromField(String field, Json value) {
        return this.buildKeyValue(value).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Json value = (Json)tuple2._2();
                return MODULE$.fromKeyValue(field, key, value);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Either<String, LogicItem> fromAnd(Json json) {
        Option option = json.asArray();
        if (option instanceof Some) {
            Vector arr = (Vector)((Some)option).value();
            return this.buildArray((List<Json>)arr.toList()).map((Function1 & Serializable)items -> And$.MODULE$.apply((List<LogicItem>)items));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)"$and expects an array");
        }
        throw new MatchError((Object)option);
    }

    public Either<String, LogicItem> fromOr(Json json) {
        Option option = json.asArray();
        if (option instanceof Some) {
            Vector arr = (Vector)((Some)option).value();
            return this.buildArray((List<Json>)arr.toList()).map((Function1 & Serializable)items -> Or$.MODULE$.apply((List<LogicItem>)items));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)"$or expects an array");
        }
        throw new MatchError((Object)option);
    }

    public Either<String, LogicItem> fromKeyValue(String field, String key, Json value) {
        String string = key;
        String string2 = this.DEq();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.fromJsonToValue(value).map((Function1 & Serializable)v -> Eq$.MODULE$.apply(field, (Value)v));
        }
        String string4 = this.DNe();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.fromJsonToValue(value).map((Function1 & Serializable)v -> Ne$.MODULE$.apply(field, (Value)v));
        }
        String string6 = this.DGt();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return this.fromJsonToValue(value).map((Function1 & Serializable)v -> Gt$.MODULE$.apply(field, (Value)v));
        }
        String string8 = this.DLt();
        String string9 = string;
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return this.fromJsonToValue(value).map((Function1 & Serializable)v -> Lt$.MODULE$.apply(field, (Value)v));
        }
        String string10 = this.DGte();
        String string11 = string;
        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
            return this.fromJsonToValue(value).map((Function1 & Serializable)v -> Gte$.MODULE$.apply(field, (Value)v));
        }
        String string12 = this.DLte();
        String string13 = string;
        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
            return this.fromJsonToValue(value).map((Function1 & Serializable)v -> Lte$.MODULE$.apply(field, (Value)v));
        }
        String string14 = this.DIn();
        String string15 = string;
        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
            return this.fromJsonToValues(value).map((Function1 & Serializable)v -> In$.MODULE$.apply(field, (List<Value>)v));
        }
        String string16 = this.DNin();
        String string17 = string;
        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
            return this.fromJsonToValues(value).map((Function1 & Serializable)v -> Nin$.MODULE$.apply(field, (List<Value>)v));
        }
        String string18 = this.DExists();
        String string19 = string;
        if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
            return (Either)value.asBoolean().map((Function1 & Serializable)v -> JsonConverters$.fromKeyValue$$anonfun$9(field, BoxesRunTime.unboxToBoolean((Object)v))).getOrElse(JsonConverters$::fromKeyValue$$anonfun$10);
        }
        String string20 = this.DNot();
        String string21 = string;
        if (!(string20 != null ? !string20.equals(string21) : string21 != null)) {
            return this.fromJson(value).map((Function1 & Serializable)li -> Not$.MODULE$.apply((LogicItem)li));
        }
        String x = string;
        return package$.MODULE$.Left().apply((Object)("Unknown operator " + x));
    }

    public Either<String, Tuple2<String, Json>> buildKeyValue(Json json) {
        Option option = json.asObject();
        if (option instanceof Some) {
            JsonObject obj = (JsonObject)((Some)option).value();
            List list = obj.toList();
            if (list.size() > 1) {
                return package$.MODULE$.Left().apply((Object)("object expected with one field, got " + list.map((Function1 & Serializable)_$1 -> (String)_$1._1())));
            }
            return (Either)list.headOption().map((Function1 & Serializable)_$2 -> package$.MODULE$.Right().apply(_$2)).getOrElse(JsonConverters$::buildKeyValue$$anonfun$3);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)"object expected");
        }
        throw new MatchError((Object)option);
    }

    public Either<String, List<LogicItem>> buildArray(List<Json> arr) {
        List<Json> list = arr;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Json> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil());
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Json head = (Json)colon2.head();
            List tail = list3;
            Either<String, LogicItem> either = this.fromJson(head);
            if (either instanceof Right) {
                LogicItem json = (LogicItem)((Right)either).value();
                return this.buildArray((List<Json>)tail).map((Function1 & Serializable)right -> right.$colon$colon((Object)json));
            }
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)err);
            }
            throw new MatchError(either);
        }
        throw new MatchError(list);
    }

    private static final Either fromJson$$anonfun$1() {
        return package$.MODULE$.Right().apply((Object)NullValue$.MODULE$);
    }

    private static final /* synthetic */ Either fromJson$$anonfun$2(boolean bool) {
        return package$.MODULE$.Right().apply((Object)BooleanValue$.MODULE$.apply(bool));
    }

    private static final /* synthetic */ Right fromJson$$anonfun$3$$anonfun$1(long lng) {
        return package$.MODULE$.Right().apply((Object)IntValue$.MODULE$.apply(lng));
    }

    private static final Right fromJson$$anonfun$3$$anonfun$2(JsonNumber num$1) {
        return package$.MODULE$.Right().apply((Object)FloatValue$.MODULE$.apply(num$1.toDouble()));
    }

    private static final /* synthetic */ Right fromKeyValue$$anonfun$9(String field$10, boolean v) {
        return package$.MODULE$.Right().apply((Object)Exists$.MODULE$.apply(field$10, v));
    }

    private static final Either fromKeyValue$$anonfun$10() {
        return package$.MODULE$.Left().apply((Object)"Boolean expected for $exists");
    }

    private static final Either buildKeyValue$$anonfun$3() {
        return package$.MODULE$.Left().apply((Object)"object expected with one field");
    }
}

