/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientSessionOptions;
import com.mongodb.ContextProvider;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.connection.ClientMetadataHelper;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.ListDatabasesPublisher;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoCluster;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.ReactiveContextProvider;
import com.mongodb.reactivestreams.client.internal.ClientSessionHelper;
import com.mongodb.reactivestreams.client.internal.MongoClusterImpl;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.mongodb.reactivestreams.client.internal.OperationExecutorImpl;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.Crypts;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

public final class MongoClientImpl
implements MongoClient {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoClientSettings settings;
    private final AutoCloseable externalResourceCloser;
    private final MongoClusterImpl delegate;
    private final AtomicBoolean closed;

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable AutoCloseable externalResourceCloser) {
        this(settings, mongoDriverInformation, cluster, null, externalResourceCloser);
    }

    public MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable OperationExecutor executor) {
        this(settings, mongoDriverInformation, cluster, executor, null);
    }

    private MongoClientImpl(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, Cluster cluster, @Nullable OperationExecutor executor, @Nullable AutoCloseable externalResourceCloser) {
        Assertions.notNull((String)"settings", (Object)settings);
        Assertions.notNull((String)"cluster", (Object)cluster);
        TimeoutSettings timeoutSettings = TimeoutSettings.create((MongoClientSettings)settings);
        ServerSessionPool serverSessionPool = new ServerSessionPool(cluster, timeoutSettings, settings.getServerApi());
        ClientSessionHelper clientSessionHelper = new ClientSessionHelper(this, serverSessionPool);
        AutoEncryptionSettings autoEncryptSettings = settings.getAutoEncryptionSettings();
        Crypt crypt = autoEncryptSettings != null ? Crypts.createCrypt(settings, autoEncryptSettings) : null;
        ContextProvider contextProvider = settings.getContextProvider();
        if (contextProvider != null && !(contextProvider instanceof ReactiveContextProvider)) {
            throw new IllegalArgumentException("The contextProvider must be an instance of " + ReactiveContextProvider.class.getName() + " when using the Reactive Streams driver");
        }
        OperationExecutor operationExecutor = executor != null ? executor : new OperationExecutorImpl(this, clientSessionHelper, timeoutSettings, (ReactiveContextProvider)contextProvider);
        MongoOperationPublisher<Document> mongoOperationPublisher = new MongoOperationPublisher<Document>(Document.class, CodecRegistries.withUuidRepresentation((CodecRegistry)settings.getCodecRegistry(), (UuidRepresentation)settings.getUuidRepresentation()), settings.getReadPreference(), settings.getReadConcern(), settings.getWriteConcern(), settings.getRetryWrites(), settings.getRetryReads(), settings.getUuidRepresentation(), settings.getAutoEncryptionSettings(), timeoutSettings, operationExecutor);
        this.delegate = new MongoClusterImpl(cluster, crypt, operationExecutor, serverSessionPool, clientSessionHelper, mongoOperationPublisher);
        this.externalResourceCloser = externalResourceCloser;
        this.settings = settings;
        this.closed = new AtomicBoolean();
        BsonDocument clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument((String)settings.getApplicationName(), (MongoDriverInformation)mongoDriverInformation);
        LOGGER.info(String.format("MongoClient with metadata %s created with settings %s", clientMetadataDocument.toJson(), settings));
    }

    Cluster getCluster() {
        return this.delegate.getCluster();
    }

    public ServerSessionPool getServerSessionPool() {
        return this.delegate.getServerSessionPool();
    }

    MongoOperationPublisher<Document> getMongoOperationPublisher() {
        return this.delegate.getMongoOperationPublisher();
    }

    @Nullable
    Crypt getCrypt() {
        return this.delegate.getCrypt();
    }

    public MongoClientSettings getSettings() {
        return this.settings;
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            Crypt crypt = this.getCrypt();
            if (crypt != null) {
                crypt.close();
            }
            this.getServerSessionPool().close();
            this.getCluster().close();
            if (this.externalResourceCloser != null) {
                try {
                    this.externalResourceCloser.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Exception closing resource", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Publisher<String> listDatabaseNames() {
        return this.delegate.listDatabaseNames();
    }

    @Override
    public Publisher<String> listDatabaseNames(ClientSession clientSession) {
        return this.delegate.listDatabaseNames(clientSession);
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases() {
        return this.delegate.listDatabases();
    }

    @Override
    public <TResult> ListDatabasesPublisher<TResult> listDatabases(Class<TResult> clazz) {
        return this.delegate.listDatabases(clazz);
    }

    @Override
    public ListDatabasesPublisher<Document> listDatabases(ClientSession clientSession) {
        return this.delegate.listDatabases(clientSession);
    }

    @Override
    public <TResult> ListDatabasesPublisher<TResult> listDatabases(ClientSession clientSession, Class<TResult> clazz) {
        return this.delegate.listDatabases(clientSession, clazz);
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.delegate.watch();
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> resultClass) {
        return this.delegate.watch(resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.delegate.watch(pipeline);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(pipeline, resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.delegate.watch(clientSession);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.delegate.watch(clientSession, pipeline);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, pipeline, resultClass);
    }

    @Override
    public Publisher<ClientSession> startSession() {
        return this.delegate.startSession();
    }

    @Override
    public Publisher<ClientSession> startSession(ClientSessionOptions options) {
        return this.delegate.startSession(options);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.delegate.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.delegate.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.delegate.getReadConcern();
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        return null;
    }

    @Override
    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return this.delegate.withCodecRegistry(codecRegistry);
    }

    @Override
    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return this.delegate.withReadPreference(readPreference);
    }

    @Override
    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return this.delegate.withWriteConcern(writeConcern);
    }

    @Override
    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return this.delegate.withReadConcern(readConcern);
    }

    @Override
    public MongoCluster withTimeout(long timeout, TimeUnit timeUnit) {
        return this.delegate.withTimeout(timeout, timeUnit);
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return this.delegate.getDatabase(name);
    }

    @Override
    public ClusterDescription getClusterDescription() {
        return this.getCluster().getCurrentDescription();
    }
}

