/*
 * Decompiled with CFR 0.152.
 */
package ambience.ie.exportdata;

import ambience.exportdata.ExportInfo;
import ambience.ie.db.ExportDB;
import ambience.ie.exportdata.ExportBuilder;
import ambience.ie.exportdata.ExportHandler;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ExportCSV
implements ExportBuilder,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ExportCSV.class.getDeclaredField("log$lzy1"));
    private ExportDB exportDB;
    private volatile Object log$lzy1;
    private final String uuid;
    private final List<String> cols;
    private final String ext;
    private final Path path;
    private final CSVPrinter writer;
    private long recordCount;

    public ExportCSV(String uuid, Data.Schema schema, List<String> cols) {
        this.uuid = uuid;
        this.cols = cols;
        ExportBuilder.$init$(this);
        this.ext = "csv";
        this.path = this.createTempFile(this.ext());
        this.writer = new CSVPrinter((Appendable)new FileWriter(this.path().toFile()), CSVFormat.EXCEL);
        this.recordCount = 0L;
        this.writer.printRecord((Object[])((String[])Arrays$.MODULE$.seqToArray(cols, String.class)));
        this.log().info(() -> ExportCSV.$init$$$anonfun$1(uuid), Line$.MODULE$.apply(25), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportCSV"));
        Statics.releaseFence();
    }

    @Override
    public ExportDB exportDB() {
        return this.exportDB;
    }

    @Override
    public void ambience$ie$exportdata$ExportBuilder$_setter_$exportDB_$eq(ExportDB x$0) {
        this.exportDB = x$0;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String ext() {
        return this.ext;
    }

    public Path path() {
        return this.path;
    }

    @Override
    public Task<Either<String, ExportHandler.ExportFileInfo>> run(ExportInfo info) {
        return this.exportDB().getAggregate(info).flatMap((Function1 & Serializable)doc -> this.add((Document)doc)).toListL().flatMap((Function1 & Serializable)_$1 -> this.close(info)).onErrorRecover((PartialFunction)new Serializable(info, this){
            private final ExportInfo info$2;
            private final /* synthetic */ ExportCSV $outer;
            {
                this.info$2 = info$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.log().error(() -> this.applyOrElse$$anonfun$1(ex), ex, Line$.MODULE$.apply(34), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportCSV.run"));
                return package$.MODULE$.Left().apply(Option$.MODULE$.apply((Object)ex.getMessage()).getOrElse(() -> ExportCSV.ambience$ie$exportdata$ExportCSV$$anon$1$$_$applyOrElse$$anonfun$2(ex)));
            }

            private final Object applyOrElse$$anonfun$1(Throwable ex$1) {
                return "run(" + this.info$2 + "): " + ex$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Throwable ), ambience$ie$exportdata$ExportCSV$$anon$1$$_$applyOrElse$$anonfun$2(java.lang.Throwable )}, serializedLambda);
            }
        }).doOnFinish((Function1 & Serializable)result -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.run$$anonfun$3$$anonfun$1((Option)result);
            return BoxedUnit.UNIT;
        }));
    }

    public Observable<Document> add(Document doc) {
        List items = this.cols.map((Function1 & Serializable)col -> (String)this.getDocValue((String)col, doc).map((Function1 & Serializable)bv -> this.format((BsonValue)bv)).getOrElse(ExportCSV::$anonfun$1$$anonfun$2));
        this.writer.printRecord((Object[])((String[])Arrays$.MODULE$.seqToArray((Seq)items, String.class)));
        ++this.recordCount;
        if (this.recordCount % 10000L == 0L) {
            this.log().debug(this::add$$anonfun$1, Line$.MODULE$.apply(44), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportCSV.add"));
        }
        return Observable$.MODULE$.empty();
    }

    public Task<Either<String, ExportHandler.ExportFileInfo>> close(ExportInfo info) {
        return Task$.MODULE$.apply(() -> this.close$$anonfun$1(info));
    }

    private static final Object $init$$$anonfun$1(String uuid$1) {
        return "[" + uuid$1 + "] Written CSV Header";
    }

    public static final String ambience$ie$exportdata$ExportCSV$$anon$1$$_$applyOrElse$$anonfun$2(Throwable ex$2) {
        return ex$2.toString();
    }

    private final Object run$$anonfun$3$$anonfun$1$$anonfun$1(Option result$2) {
        return "[" + this.uuid + "] Run finished with " + result$2;
    }

    private final void run$$anonfun$3$$anonfun$1(Option result$1) {
        this.log().info(() -> this.run$$anonfun$3$$anonfun$1$$anonfun$1(result$1), Line$.MODULE$.apply(37), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportCSV.run"));
    }

    private static final String $anonfun$1$$anonfun$2() {
        return "";
    }

    private final Object add$$anonfun$1() {
        return "[" + this.uuid + "] Written " + this.recordCount + " records";
    }

    private final Object close$$anonfun$1$$anonfun$1() {
        return "[" + this.uuid + "] Finished writing " + this.recordCount + " records";
    }

    private final Right close$$anonfun$1(ExportInfo info$3) {
        this.writer.close(true);
        this.log().info(this::close$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(51), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportCSV.close"));
        this.recordCount = 0L;
        return package$.MODULE$.Right().apply((Object)this.buildFileInfo(info$3.exportId(), this.path()));
    }
}

