/*
 * Decompiled with CFR 0.152.
 */
package ambience.ie.exportdata;

import ambience.exportdata.ExportInfo;
import ambience.ie.db.ExportDB;
import ambience.ie.exportdata.ExportBuilder;
import ambience.ie.exportdata.ExportHandler;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.mongodb.BsonUtils$;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import monix.eval.Task;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonNull$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ExportXLSX
implements ExportBuilder,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ExportXLSX.class.getDeclaredField("log$lzy1"));
    private ExportDB exportDB;
    private volatile Object log$lzy1;
    public final String ambience$ie$exportdata$ExportXLSX$$uuid;
    private final String sheetName;
    private final List<String> cols;
    private final int ROW_LIMIT;
    private final String[] colArray;
    private final int colCount;
    private final boolean[] isNested;
    private final SXSSFWorkbook workbook;
    private int nextRow;
    private SXSSFSheet sheet;
    private final String ext;

    public ExportXLSX(String uuid, String sheetName, Data.Schema schema, List<String> cols) {
        this.ambience$ie$exportdata$ExportXLSX$$uuid = uuid;
        this.sheetName = sheetName;
        this.cols = cols;
        ExportBuilder.$init$(this);
        this.ROW_LIMIT = 1048575;
        this.colArray = (String[])cols.toArray(ClassTag$.MODULE$.apply(String.class));
        this.colCount = this.colArray.length;
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.colArray);
        this.isNested = (boolean[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.contains("."), ClassTag$.MODULE$.apply(Boolean.TYPE));
        this.workbook = new SXSSFWorkbook(100);
        this.workbook.setCompressTempFiles(true);
        this.nextRow = 0;
        this.sheet = this.createSheet();
        this.ext = "xlsx";
        Statics.releaseFence();
    }

    @Override
    public ExportDB exportDB() {
        return this.exportDB;
    }

    @Override
    public void ambience$ie$exportdata$ExportBuilder$_setter_$exportDB_$eq(ExportDB x$0) {
        this.exportDB = x$0;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int ROW_LIMIT() {
        return this.ROW_LIMIT;
    }

    @Override
    public String ext() {
        return this.ext;
    }

    @Override
    public Task<Either<String, ExportHandler.ExportFileInfo>> run(ExportInfo info) {
        Path path = this.createTempFile(this.ext());
        this.log().info(() -> this.run$$anonfun$1(path), Line$.MODULE$.apply(33), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportXLSX.run"));
        Task result = this.exportDB().getAggregate(info).map((Function1)(JProcedure1 & Serializable)doc -> this.add((Document)doc)).completedL();
        return result.map((Function1 & Serializable)_$2 -> {
            this.log().infoElapsedTime(() -> this.run$$anonfun$2$$anonfun$1(path), (Function0 & Serializable)() -> {
                this.run$$anonfun$2$$anonfun$2(path);
                return BoxedUnit.UNIT;
            }, Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportXLSX.run"));
            this.workbook.close();
            this.log().info(() -> this.run$$anonfun$2$$anonfun$3(path), Line$.MODULE$.apply(44), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportXLSX.run"));
            return package$.MODULE$.Right().apply((Object)this.buildFileInfo(info.exportId(), path));
        }).onErrorRecover((PartialFunction)new Serializable(this){
            private final /* synthetic */ ExportXLSX $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                this.$outer.log().error(() -> this.applyOrElse$$anonfun$1(x), x, Line$.MODULE$.apply(48), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportXLSX.run"));
                return package$.MODULE$.Left().apply((Object)"Error in ExportXLSX.run");
            }

            private final Object applyOrElse$$anonfun$1(Throwable x$1) {
                return "[" + this.$outer.ambience$ie$exportdata$ExportXLSX$$uuid + "] Error in run: " + x$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public void add(Document doc) {
        SXSSFRow row = this.createRow();
        for (int i = 0; i < this.colCount; ++i) {
            BsonValue item = (BsonValue)this.getDocValue(this.isNested[i], this.colArray[i], doc).getOrElse(ExportXLSX::$anonfun$2);
            this.setCellValue(row.createCell(i), item);
        }
    }

    private SXSSFRow createRow() {
        if (this.nextRow > this.ROW_LIMIT()) {
            this.nextRow = 0;
            this.sheet = this.createSheet();
        }
        SXSSFRow row = this.sheet.createRow(this.nextRow);
        ++this.nextRow;
        return row;
    }

    public SXSSFSheet createSheet() {
        String sn = this.sheetName.replace(":", " ");
        int sheetNo = this.workbook.getNumberOfSheets();
        Object postfix = sheetNo == 0 ? "" : " " + sheetNo;
        String name = sn + (String)postfix;
        this.log().info(() -> this.createSheet$$anonfun$1(name), Line$.MODULE$.apply(78), FullName$.MODULE$.apply("ambience.ie.exportdata.ExportXLSX.createSheet"));
        SXSSFSheet sheet = this.workbook.createSheet(name);
        sheet.setDefaultColumnWidth(12);
        this.setSheetHeader(sheet);
        return sheet;
    }

    public void setSheetHeader(SXSSFSheet sheet) {
        SXSSFRow header = sheet.createRow(0);
        ++this.nextRow;
        ((List)this.cols.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String f = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                header.createCell(i).setCellValue(f);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void setCellValue(SXSSFCell cell, BsonValue bv) {
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonString) {
            BsonString v = (BsonString)bsonValue;
            cell.setCellValue(v.getValue());
            return;
        }
        if (bsonValue instanceof BsonDocument) {
            BsonDocument v = (BsonDocument)bsonValue;
            cell.setCellValue("Object{" + v.values().size() + " fields}");
            return;
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble v = (BsonDouble)bsonValue;
            cell.setCellValue(v.getValue());
            return;
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 v = (BsonInt32)bsonValue;
            cell.setCellValue((double)v.getValue());
            return;
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 v = (BsonInt64)bsonValue;
            cell.setCellValue((double)v.getValue());
            return;
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime v = (BsonDateTime)bsonValue;
            cell.setCellValue(BsonUtils$.MODULE$.timestampAsString(v.getValue()));
            return;
        }
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean v = (BsonBoolean)bsonValue;
            cell.setCellValue(v.getValue());
            return;
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 v = (BsonDecimal128)bsonValue;
            cell.setCellValue(v.getValue().bigDecimalValue().doubleValue());
            return;
        }
        if (bsonValue instanceof BsonObjectId) {
            BsonObjectId v = (BsonObjectId)bsonValue;
            cell.setCellValue(v.getValue().toHexString());
            return;
        }
        if (bsonValue instanceof BsonArray) {
            BsonArray v = (BsonArray)bsonValue;
            cell.setCellValue("Array[" + v.getValues().size() + "]");
            return;
        }
        if (bsonValue instanceof BsonBinary) {
            BsonBinary v = (BsonBinary)bsonValue;
            cell.setCellValue("[" + v.getData().length + " bytes]");
            return;
        }
        if (bsonValue instanceof BsonNull) {
            cell.setCellValue(null);
            return;
        }
        cell.setCellValue(null);
    }

    private final Object run$$anonfun$1(Path path$1) {
        return "[" + this.ambience$ie$exportdata$ExportXLSX$$uuid + "] Exporting xslx to temp file: " + path$1;
    }

    private final String run$$anonfun$2$$anonfun$1(Path path$3) {
        return "[" + this.ambience$ie$exportdata$ExportXLSX$$uuid + "] Writing to disk " + path$3;
    }

    private final void run$$anonfun$2$$anonfun$2(Path path$4) {
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(path$4.toFile()));
        this.workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
    }

    private final Object run$$anonfun$2$$anonfun$3(Path path$5) {
        return "[" + this.ambience$ie$exportdata$ExportXLSX$$uuid + "] Writing to disk " + path$5 + " finished";
    }

    private static final BsonValue $anonfun$2() {
        return BsonNull$.MODULE$.apply();
    }

    private final Object createSheet$$anonfun$1(String name$1) {
        return "[" + this.ambience$ie$exportdata$ExportXLSX$$uuid + "] creating sheet " + name$1;
    }
}

