/*
 * Decompiled with CFR 0.152.
 */
package ambience.ie.importdata;

import ambience.SystemScheduler$;
import ambience.ie.FileUploadUtil$;
import ambience.ie.ImportModule;
import ambience.ie.ImportModule$FileImport$;
import ambience.ie.importdata.GzipHelper$;
import ambience.ie.importdata.ImportTypeDetector;
import ambience.ie.importdata.ImportTypeDetector$BSON$;
import ambience.ie.importdata.ImportTypeDetector$CSV$;
import ambience.ie.importdata.ImportTypeDetector$JSON$;
import ambience.ie.importdata.ImportTypeDetector$XLSX$;
import ambience.ie.importdata.ImportTypeDetector$XLSXCantDecrypt$;
import ambience.ie.importdata.JsonLinesHelper$;
import ambience.ie.importdata.StoreDataHandler;
import ambience.ie.importdata.StoreDataHandler$Context$;
import ambience.ie.importdata.Util$;
import ambience.ie.importdata.analysis.BSONAnalysis$;
import ambience.ie.importdata.store.BSONStore$;
import ambience.ie.importdata.store.CSVStore$;
import ambience.ie.importdata.store.JSONStore$;
import ambience.ie.importdata.store.XLSXStore$;
import ambience.importdata.ImportModel;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.arch.FileDataBytes;
import com.elixirtech.arch.FileDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SyncDataBytes;
import com.elixirtech.gravity.Gravity;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import org.apache.poi.ss.usermodel.Workbook;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class AnalysisHandler$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AnalysisHandler$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final SimpleDateFormat simpleDateFormat;
    private static final Scheduler scheduler;
    private static final List VALIDEXTS;
    public static final AnalysisHandler$ MODULE$;

    private AnalysisHandler$() {
    }

    static {
        MODULE$ = new AnalysisHandler$();
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        scheduler = SystemScheduler$.MODULE$.global();
        VALIDEXTS = (List)new .colon.colon((Object)".jsonl", (List)new .colon.colon((Object)".json", (List)new .colon.colon((Object)".csv", (List)new .colon.colon((Object)".xlsx", (List)new .colon.colon((Object)".bson", (List)new .colon.colon((Object)".gz", (List)new .colon.colon((Object)".gzip", (List)Nil$.MODULE$)))))));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AnalysisHandler$.class);
    }

    public SimpleDateFormat simpleDateFormat() {
        return simpleDateFormat;
    }

    public Scheduler scheduler() {
        return scheduler;
    }

    public List<String> VALIDEXTS() {
        return VALIDEXTS;
    }

    public Task<ImportModel.FileAnalysisResult> handleAnalysis(ImportModule.FileImport fi, Option<String> optPassword) {
        Option<Path> option = GzipHelper$.MODULE$.unzipIfNecessary(fi.file());
        if (option instanceof Some) {
            Path gunzipPath = (Path)((Some)option).value();
            FileDataBytes fileDataBytes = FileDataBytes$.MODULE$.apply(gunzipPath.toFile());
            String string = fi.file().copy$default$1();
            String string2 = fi.file().copy$default$2();
            long l = fi.file().copy$default$3();
            Option option2 = fi.file().copy$default$5();
            Gravity.FileUploadItem newFile = fi.file().copy(string, string2, l, (SyncDataBytes)fileDataBytes, option2);
            return this.doAnalysis(fi.copy(fi.copy$default$1(), newFile, fi.copy$default$3()), optPassword).map((Function1 & Serializable)ret -> {
                MODULE$.log().info(() -> AnalysisHandler$.handleAnalysis$$anonfun$1$$anonfun$1(gunzipPath), Line$.MODULE$.apply(33), FullName$.MODULE$.apply("ambience.ie.importdata.AnalysisHandler.handleAnalysis"));
                gunzipPath.toFile().delete();
                return ret;
            });
        }
        if (None$.MODULE$.equals(option)) {
            return this.doAnalysis(fi, optPassword);
        }
        throw new MatchError(option);
    }

    public Task<ImportModel.FileAnalysisResult> doAnalysis(ImportModule.FileImport fi, Option<String> optPassword) {
        ImportTypeDetector.ImportType importType = fi.importType();
        if (!this.validExt(fi)) {
            return Task$.MODULE$.apply(() -> AnalysisHandler$.doAnalysis$$anonfun$1(fi));
        }
        if (ImportTypeDetector$CSV$.MODULE$.equals(importType)) {
            return this.handleCSVAnalysis(fi);
        }
        if (ImportTypeDetector$XLSX$.MODULE$.equals(importType)) {
            return this.handleXLSXAnalysis(fi, optPassword);
        }
        if (ImportTypeDetector$XLSXCantDecrypt$.MODULE$.equals(importType)) {
            return Task$.MODULE$.now((Object)ImportModel.AnalysisFailure$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), "Valid Password Required"));
        }
        if (importType instanceof ImportTypeDetector.JSON) {
            boolean bl;
            ImportTypeDetector.JSON jSON = ImportTypeDetector$JSON$.MODULE$.unapply((ImportTypeDetector.JSON)importType);
            boolean isArray = bl = jSON._1();
            return this.handleJSONAnalysis(fi, isArray);
        }
        if (ImportTypeDetector$BSON$.MODULE$.equals(importType)) {
            return this.handleBSONAnalysis(fi);
        }
        throw new IllegalArgumentException("Unsupported Import Type" + fi.importType());
    }

    public boolean validExt(ImportModule.FileImport fi) {
        return this.VALIDEXTS().exists((Function1 & Serializable)e -> fi.file().filename().endsWith((String)e));
    }

    public Task<ImportModel.FileAnalysisResult> handleCSVAnalysis(ImportModule.FileImport fi) {
        this.log().info(() -> AnalysisHandler$.handleCSVAnalysis$$anonfun$1(fi), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.ie.importdata.AnalysisHandler.handleCSVAnalysis"));
        boolean bl = EitherT$.MODULE$.right();
        Task res = (Task)EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.apply(AnalysisHandler$::$anonfun$1), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)colName -> EitherT$.MODULE$.apply((Object)CSVStore$.MODULE$.run(StoreDataHandler$Context$.MODULE$.apply(fi.user(), fi.file().filename(), fi.file(), (String)colName, StoreDataHandler$Context$.MODULE$.$lessinit$greater$default$5()))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            boolean bl = EitherT$.MODULE$.right();
            return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, BSONAnalysis$.MODULE$.run((String)colName), (Functor)Task$.MODULE$.catsAsync()).map((Function1 & Serializable)fields -> Tuple2$.MODULE$.apply(colName, fields), (Functor)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
        return res.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            ImportModel.AnalysisFailure analysisFailure;
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                analysisFailure = ImportModel.AnalysisFailure$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), msg);
            } else if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                String colName = (String)tuple2._1();
                List fields = (List)tuple2._2();
                analysisFailure = ImportModel.AnalysisSuccess$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), (Option)None$.MODULE$, colName, fields);
            } else {
                throw new MatchError((Object)either);
            }
            return (ImportModel.FileAnalysisResult)analysisFailure;
        });
    }

    public Task<ImportModel.FileAnalysisResult> handleXLSXAnalysis(ImportModule.FileImport fi, Option<String> optPassword) {
        this.log().info(() -> AnalysisHandler$.handleXLSXAnalysis$$anonfun$1(fi), Line$.MODULE$.apply(72), FullName$.MODULE$.apply("ambience.ie.importdata.AnalysisHandler.handleXLSXAnalysis"));
        boolean bl = EitherT$.MODULE$.right();
        Task res = (Task)EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.apply(AnalysisHandler$::$anonfun$3), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)colName -> {
            boolean bl = EitherT$.MODULE$.right();
            return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.apply(() -> AnalysisHandler$.$anonfun$4$$anonfun$1(fi, optPassword)), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)sheetNames -> EitherT$.MODULE$.apply((Object)XLSXStore$.MODULE$.run(StoreDataHandler$Context$.MODULE$.apply(fi.user(), fi.file().filename(), fi.file(), (String)colName, optPassword))).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                boolean bl = EitherT$.MODULE$.right();
                Seq tasks = (Seq)((IterableOps)sheetNames.zipWithIndex()).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String n = (String)tuple2._1();
                        int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        String cn = Util$.MODULE$.fixXLSXCollectionName(idx, (String)colName);
                        return BSONAnalysis$.MODULE$.run(cn).map((Function1 & Serializable)fs -> ImportModel.XLSXSheet$.MODULE$.apply(ImportModel.SheetName$.MODULE$.apply(n, "s" + idx), fs));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.sequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps()), (Functor)Task$.MODULE$.catsAsync()).map((Function1 & Serializable)sheets -> Tuple2$.MODULE$.apply(colName, (Object)sheets.toList()), (Functor)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value();
        return res.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            ImportModel.AnalysisFailure analysisFailure;
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                analysisFailure = ImportModel.AnalysisFailure$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), msg);
            } else if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                String colName = (String)tuple2._1();
                List sheets = (List)tuple2._2();
                analysisFailure = ImportModel.XLSXAnalysisSuccess$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), (Option)None$.MODULE$, colName, sheets);
            } else {
                throw new MatchError((Object)either);
            }
            return (ImportModel.FileAnalysisResult)analysisFailure;
        });
    }

    public Seq<String> getWorksheetNames(ImportModule.FileImport fi, Option<String> optPassword) {
        return (Seq)FileUploadUtil$.MODULE$.withFile(fi.file(), (Function1 & Serializable)xlsx -> {
            Workbook wb = Util$.MODULE$.openXSLXWorkbook((File)xlsx, optPassword);
            return (Seq)Try$.MODULE$.apply(() -> AnalysisHandler$.getWorksheetNames$$anonfun$1$$anonfun$1(wb)).getOrElse(AnalysisHandler$::getWorksheetNames$$anonfun$1$$anonfun$2);
        });
    }

    public Task<ImportModel.FileAnalysisResult> handleJSONAnalysis(ImportModule.FileImport fi, boolean isJsonArray) {
        this.log().info(() -> AnalysisHandler$.handleJSONAnalysis$$anonfun$1(fi), Line$.MODULE$.apply(100), FullName$.MODULE$.apply("ambience.ie.importdata.AnalysisHandler.handleJSONAnalysis"));
        boolean bl = EitherT$.MODULE$.right();
        Task res = (Task)EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.apply(AnalysisHandler$::$anonfun$6), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)colName -> {
            boolean bl = EitherT$.MODULE$.right();
            return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.apply(() -> AnalysisHandler$.$anonfun$7$$anonfun$1(fi, colName)), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)cxt -> EitherT$.MODULE$.apply(MODULE$.toJsonLines((StoreDataHandler.Context)cxt, isJsonArray)).flatMap((Function1 & Serializable)cxt2 -> EitherT$.MODULE$.apply((Object)JSONStore$.MODULE$.run((StoreDataHandler.Context)cxt2)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                boolean bl = EitherT$.MODULE$.right();
                return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, BSONAnalysis$.MODULE$.run((String)colName), (Functor)Task$.MODULE$.catsAsync()).map((Function1 & Serializable)fields -> Tuple2$.MODULE$.apply(colName, fields), (Functor)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value();
        return res.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            ImportModel.AnalysisFailure analysisFailure;
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                analysisFailure = ImportModel.AnalysisFailure$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), msg);
            } else if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                String colName = (String)tuple2._1();
                List fields = (List)tuple2._2();
                analysisFailure = ImportModel.AnalysisSuccess$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), (Option)None$.MODULE$, colName, fields);
            } else {
                throw new MatchError((Object)either);
            }
            return (ImportModel.FileAnalysisResult)analysisFailure;
        });
    }

    public Task<Either<String, StoreDataHandler.Context>> toJsonLines(StoreDataHandler.Context cxt, boolean isJsonArray) {
        if (isJsonArray) {
            return JsonLinesHelper$.MODULE$.run(FileUploadUtil$.MODULE$.getInputStream(cxt.file())).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String value = (String)((Left)either).value();
                    return package$.MODULE$.Left().apply((Object)value);
                }
                if (either instanceof Right) {
                    SyncDataBytes data = (SyncDataBytes)((Right)either).value();
                    Gravity.FileUploadItem fileUploadItem = cxt.file().copy(cxt.file().copy$default$1(), cxt.file().copy$default$2(), cxt.file().copy$default$3(), data, cxt.file().copy$default$5());
                    UserDB.User user = cxt.copy$default$1();
                    String string = cxt.copy$default$2();
                    String string2 = cxt.copy$default$4();
                    Option<String> option = cxt.copy$default$5();
                    return package$.MODULE$.Right().apply((Object)cxt.copy(user, string, fileUploadItem, string2, option));
                }
                throw new MatchError((Object)either);
            });
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)cxt));
    }

    public Task<ImportModel.FileAnalysisResult> handleBSONAnalysis(ImportModule.FileImport fi) {
        this.log().info(() -> AnalysisHandler$.handleBSONAnalysis$$anonfun$1(fi), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.ie.importdata.AnalysisHandler.handleBSONAnalysis"));
        boolean bl = EitherT$.MODULE$.right();
        Task res = (Task)EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.apply(AnalysisHandler$::$anonfun$8), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)colName -> EitherT$.MODULE$.apply((Object)BSONStore$.MODULE$.run(StoreDataHandler$Context$.MODULE$.apply(fi.user(), fi.file().filename(), fi.file(), (String)colName, StoreDataHandler$Context$.MODULE$.$lessinit$greater$default$5()))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            boolean bl = EitherT$.MODULE$.right();
            return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, BSONAnalysis$.MODULE$.run((String)colName), (Functor)Task$.MODULE$.catsAsync()).map((Function1 & Serializable)fields -> Tuple2$.MODULE$.apply(colName, fields), (Functor)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
        return res.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            ImportModel.AnalysisFailure analysisFailure;
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                analysisFailure = ImportModel.AnalysisFailure$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), msg);
            } else if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                String colName = (String)tuple2._1();
                List fields = (List)tuple2._2();
                analysisFailure = ImportModel.AnalysisSuccess$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi), (Option)None$.MODULE$, colName, fields);
            } else {
                throw new MatchError((Object)either);
            }
            return (ImportModel.FileAnalysisResult)analysisFailure;
        });
    }

    public String tempCollectionName() {
        return "import-" + StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(UUID.randomUUID().toString()), 30) + "-data-" + this.simpleDateFormat().format(new Date());
    }

    private static final Object handleAnalysis$$anonfun$1$$anonfun$1(Path gunzipPath$2) {
        return "reclaiming " + gunzipPath$2;
    }

    private static final ImportModel.UnsupportedFileType doAnalysis$$anonfun$1(ImportModule.FileImport fi$1) {
        return ImportModel.UnsupportedFileType$.MODULE$.apply(ImportModule$FileImport$.MODULE$.toFileInfo(fi$1));
    }

    private static final Object handleCSVAnalysis$$anonfun$1(ImportModule.FileImport fi$3) {
        return "Handling CSV file for analysis " + fi$3.file().filename();
    }

    private static final String $anonfun$1() {
        return MODULE$.tempCollectionName();
    }

    private static final Object handleXLSXAnalysis$$anonfun$1(ImportModule.FileImport fi$6) {
        return "Handling XLSX file for analysis " + fi$6.file().filename();
    }

    private static final String $anonfun$3() {
        return MODULE$.tempCollectionName();
    }

    private static final Seq $anonfun$4$$anonfun$1(ImportModule.FileImport fi$8, Option optPassword$2) {
        return MODULE$.getWorksheetNames(fi$8, (Option<String>)optPassword$2);
    }

    private static final IndexedSeq getWorksheetNames$$anonfun$1$$anonfun$1(Workbook wb$1) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), wb$1.getNumberOfSheets()).map((Function1 & Serializable)x$0 -> wb$1.getSheetName(BoxesRunTime.unboxToInt((Object)x$0)));
    }

    private static final Seq getWorksheetNames$$anonfun$1$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final Object handleJSONAnalysis$$anonfun$1(ImportModule.FileImport fi$11) {
        return "Handling JSON file for analysis " + fi$11.file().filename();
    }

    private static final String $anonfun$6() {
        return MODULE$.tempCollectionName();
    }

    private static final StoreDataHandler.Context $anonfun$7$$anonfun$1(ImportModule.FileImport fi$13, String colName$7) {
        return StoreDataHandler$Context$.MODULE$.apply(fi$13.user(), fi$13.file().filename(), fi$13.file(), colName$7, StoreDataHandler$Context$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Object handleBSONAnalysis$$anonfun$1(ImportModule.FileImport fi$15) {
        return "Handling BSON file for analysis " + fi$15.file().filename();
    }

    private static final String $anonfun$8() {
        return MODULE$.tempCollectionName();
    }
}

