/*
 * Decompiled with CFR 0.152.
 */
package ambience.ie.importdata;

import ambience.ie.importdata.AuditHelper$;
import ambience.ie.importdata.DocumentTransformer$;
import ambience.importdata.ImportModel;
import ambience.module.UserDB;
import com.elixirtech.coredata.Data;
import com.elixirtech.mongodb.BsonUtils$;
import java.io.Serializable;
import java.time.OffsetDateTime;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDecimal128$;
import org.mongodb.scala.bson.BsonDouble$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public class DocumentTransformer {
    private final UserDB.User user;
    private final ImportModel.ItemImportSettings is;

    public static Document noTransform(UserDB.User user, ImportModel.ItemImportSettings itemImportSettings, Document document) {
        return DocumentTransformer$.MODULE$.noTransform(user, itemImportSettings, document);
    }

    public static Document stripIdField(boolean bl, Document document) {
        return DocumentTransformer$.MODULE$.stripIdField(bl, document);
    }

    public DocumentTransformer(UserDB.User user, ImportModel.ItemImportSettings is) {
        this.user = user;
        this.is = is;
    }

    public Document transform(Document doc) {
        Document metadata = AuditHelper$.MODULE$.buildMetadata(this.user, this.is);
        Document updatedDoc = (Document)((BaseDocument)this.is.schema().fields().foldLeft((Object)doc, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Document d = (Document)tuple2._1();
                Data.Field field = (Data.Field)tuple2._2();
                BsonDocument bsonDoc = d.toBsonDocument();
                Option option = Option$.MODULE$.apply((Object)bsonDoc.get((Object)field.name()));
                if (option instanceof Some) {
                    BsonValue bsonValue;
                    BsonValue bv = (BsonValue)((Some)option).value();
                    BsonType bsonType = bv.getBsonType();
                    BsonType bsonType2 = BsonType.STRING;
                    BsonType bsonType3 = bsonType;
                    if (!(bsonType2 != null ? !bsonType2.equals(bsonType3) : bsonType3 != null)) {
                        bsonValue = this.convertString(field.dataType(), bv.asString());
                    } else {
                        BsonType bsonType4 = BsonType.BOOLEAN;
                        BsonType bsonType5 = bsonType;
                        if (!(bsonType4 != null ? !bsonType4.equals(bsonType5) : bsonType5 != null)) {
                            bsonValue = this.convertBoolean(field.dataType(), bv.asBoolean());
                        } else {
                            BsonType bsonType6 = BsonType.INT32;
                            BsonType bsonType7 = bsonType;
                            if (!(bsonType6 != null ? !bsonType6.equals(bsonType7) : bsonType7 != null)) {
                                bsonValue = this.convertInt32(field.dataType(), bv.asInt32());
                            } else {
                                BsonType bsonType8 = BsonType.INT64;
                                BsonType bsonType9 = bsonType;
                                if (!(bsonType8 != null ? !bsonType8.equals(bsonType9) : bsonType9 != null)) {
                                    bsonValue = this.convertInt64(field.dataType(), bv.asInt64());
                                } else {
                                    BsonType bsonType10 = BsonType.DOUBLE;
                                    BsonType bsonType11 = bsonType;
                                    if (!(bsonType10 != null ? !bsonType10.equals(bsonType11) : bsonType11 != null)) {
                                        bsonValue = this.convertDouble(field.dataType(), bv.asDouble());
                                    } else {
                                        BsonType bsonType12 = BsonType.DECIMAL128;
                                        BsonType bsonType13 = bsonType;
                                        if (!(bsonType12 != null ? !bsonType12.equals(bsonType13) : bsonType13 != null)) {
                                            bsonValue = this.convertDecimal(field.dataType(), bv.asDecimal128());
                                        } else {
                                            BsonType bsonType14 = BsonType.TIMESTAMP;
                                            BsonType bsonType15 = bsonType;
                                            if (!(bsonType14 != null ? !bsonType14.equals(bsonType15) : bsonType15 != null)) {
                                                bsonValue = this.convertTimestamp(field.dataType(), bv.asTimestamp());
                                            } else {
                                                BsonType bsonType16 = BsonType.DATE_TIME;
                                                BsonType bsonType17 = bsonType;
                                                bsonValue = !(bsonType16 != null ? !bsonType16.equals(bsonType17) : bsonType17 != null) ? this.convertDatetime(field.dataType(), bv.asDateTime()) : bv;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    BsonValue value = bsonValue;
                    return Document$.MODULE$.apply(bsonDoc.append(field.name(), value));
                }
                if (None$.MODULE$.equals(option)) {
                    return d;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        })).updated("_metadata", (Object)metadata, (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
        return DocumentTransformer$.MODULE$.stripIdField(this.is.stripIdField(), updatedDoc);
    }

    public BsonValue convertString(Data.Type dt, BsonString bs) {
        Data.Type type = dt;
        if (Data.BooleanType$.MODULE$.equals(type)) {
            return (BsonValue)StringOps$.MODULE$.toBooleanOption$extension(Predef$.MODULE$.augmentString(bs.getValue().trim())).map((Function1 & Serializable)_$1 -> BsonBoolean$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)_$1))).getOrElse(() -> DocumentTransformer.convertString$$anonfun$2(bs));
        }
        if (Data.Int32Type$.MODULE$.equals(type)) {
            return (BsonValue)StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(bs.getValue().trim())).map((Function1 & Serializable)_$2 -> BsonInt32$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)_$2))).getOrElse(() -> DocumentTransformer.convertString$$anonfun$4(bs));
        }
        if (Data.Int64Type$.MODULE$.equals(type)) {
            Option option = StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(bs.getValue().trim()));
            if (option instanceof Some) {
                long v = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                return BsonInt64$.MODULE$.apply(v);
            }
            if (None$.MODULE$.equals(option)) {
                return (BsonValue)this.toLongFromDateTime(bs.getValue()).toOption().map((Function1 & Serializable)_$3 -> BsonInt64$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)_$3))).getOrElse(() -> DocumentTransformer.convertString$$anonfun$6(bs));
            }
            throw new MatchError((Object)option);
        }
        if (Data.DoubleType$.MODULE$.equals(type)) {
            return (BsonValue)StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(bs.getValue().trim())).map((Function1 & Serializable)_$4 -> BsonDouble$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)_$4))).getOrElse(() -> DocumentTransformer.convertString$$anonfun$8(bs));
        }
        if (Data.DecimalType$.MODULE$.equals(type)) {
            return (BsonValue)Try$.MODULE$.apply(() -> DocumentTransformer.convertString$$anonfun$9(bs)).toOption().map((Function1 & Serializable)_$5 -> BsonDecimal128$.MODULE$.apply(_$5)).getOrElse(() -> DocumentTransformer.convertString$$anonfun$11(bs));
        }
        if (Data.TimestampType$.MODULE$.equals(type)) {
            return (BsonValue)Try$.MODULE$.apply(() -> DocumentTransformer.convertString$$anonfun$12(bs)).map((Function1 & Serializable)_$6 -> _$6.toEpochSecond()).orElse(() -> DocumentTransformer.convertString$$anonfun$14(bs)).map((Function1 & Serializable)_$7 -> BsonDateTime$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)_$7))).getOrElse(() -> DocumentTransformer.convertString$$anonfun$16(bs));
        }
        return bs;
    }

    public BsonValue convertBoolean(Data.Type dt, BsonBoolean bs) {
        Data.Type type = dt;
        return (BsonValue)(Data.StringType$.MODULE$.equals(type) ? BsonString$.MODULE$.apply(String.valueOf(bs.getValue())) : bs);
    }

    public BsonValue convertInt32(Data.Type dt, BsonInt32 bs) {
        Data.Type type = dt;
        return (BsonValue)(Data.StringType$.MODULE$.equals(type) ? BsonString$.MODULE$.apply(String.valueOf(bs.getValue())) : (Data.Int64Type$.MODULE$.equals(type) ? BsonInt64$.MODULE$.apply(Int$.MODULE$.int2long(bs.getValue())) : (Data.DoubleType$.MODULE$.equals(type) ? BsonDouble$.MODULE$.apply(Int$.MODULE$.int2double(bs.getValue())) : (Data.DecimalType$.MODULE$.equals(type) ? BsonDecimal128$.MODULE$.apply(Int$.MODULE$.int2long(bs.getValue())) : bs))));
    }

    public BsonValue convertInt64(Data.Type dt, BsonInt64 bs) {
        Data.Type type = dt;
        return (BsonValue)(Data.StringType$.MODULE$.equals(type) ? BsonString$.MODULE$.apply(String.valueOf(bs.getValue())) : (Data.Int32Type$.MODULE$.equals(type) ? BsonInt32$.MODULE$.apply((int)bs.getValue()) : (Data.DoubleType$.MODULE$.equals(type) ? BsonDouble$.MODULE$.apply((double)bs.getValue()) : (Data.DecimalType$.MODULE$.equals(type) ? BsonDecimal128$.MODULE$.apply(bs.getValue()) : (Data.TimestampType$.MODULE$.equals(type) ? BsonDateTime$.MODULE$.apply(bs.getValue()) : bs)))));
    }

    public BsonValue convertDouble(Data.Type dt, BsonDouble bs) {
        Data.Type type = dt;
        if (Data.StringType$.MODULE$.equals(type)) {
            return BsonString$.MODULE$.apply(String.valueOf(bs.getValue()));
        }
        if (Data.Int32Type$.MODULE$.equals(type)) {
            return BsonInt32$.MODULE$.apply((int)bs.getValue());
        }
        if (Data.Int64Type$.MODULE$.equals(type)) {
            return BsonInt64$.MODULE$.apply((long)bs.getValue());
        }
        if (Data.DecimalType$.MODULE$.equals(type)) {
            return BsonDecimal128$.MODULE$.apply(BigDecimal$.MODULE$.double2bigDecimal(bs.getValue()));
        }
        if (Data.TimestampType$.MODULE$.equals(type)) {
            return (BsonValue)Try$.MODULE$.apply(() -> DocumentTransformer.convertDouble$$anonfun$1(bs)).toOption().map((Function1 & Serializable)_$8 -> BsonDateTime$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)_$8))).getOrElse(() -> DocumentTransformer.convertDouble$$anonfun$3(bs));
        }
        return bs;
    }

    public BsonValue convertDecimal(Data.Type dt, BsonDecimal128 bs) {
        Data.Type type = dt;
        return (BsonValue)(Data.StringType$.MODULE$.equals(type) ? BsonString$.MODULE$.apply(String.valueOf(bs.getValue())) : (Data.Int32Type$.MODULE$.equals(type) ? BsonInt32$.MODULE$.apply(bs.getValue().intValue()) : (Data.Int64Type$.MODULE$.equals(type) ? BsonInt64$.MODULE$.apply(bs.getValue().longValue()) : (Data.DoubleType$.MODULE$.equals(type) ? BsonDouble$.MODULE$.apply(bs.getValue().doubleValue()) : bs))));
    }

    public BsonValue convertTimestamp(Data.Type dt, BsonTimestamp bs) {
        Data.Type type = dt;
        return (BsonValue)(Data.StringType$.MODULE$.equals(type) ? BsonString$.MODULE$.apply(BsonUtils$.MODULE$.timestampAsString(bs.getValue())) : (Data.Int64Type$.MODULE$.equals(type) ? BsonInt64$.MODULE$.apply(bs.getValue()) : bs));
    }

    public BsonValue convertDatetime(Data.Type dt, BsonDateTime bs) {
        Data.Type type = dt;
        return (BsonValue)(Data.StringType$.MODULE$.equals(type) ? BsonString$.MODULE$.apply(BsonUtils$.MODULE$.timestampAsString(bs.getValue())) : (Data.Int64Type$.MODULE$.equals(type) ? BsonInt64$.MODULE$.apply(bs.getValue()) : bs));
    }

    public Try<Object> toLongFromDateTime(String value) {
        return Try$.MODULE$.apply(() -> DocumentTransformer.toLongFromDateTime$$anonfun$1(value)).map((Function1 & Serializable)_$9 -> _$9.toEpochSecond());
    }

    private static final BsonValue convertString$$anonfun$2(BsonString bs$1) {
        return bs$1;
    }

    private static final BsonValue convertString$$anonfun$4(BsonString bs$2) {
        return bs$2;
    }

    private static final BsonValue convertString$$anonfun$6(BsonString bs$3) {
        return bs$3;
    }

    private static final BsonValue convertString$$anonfun$8(BsonString bs$4) {
        return bs$4;
    }

    private static final BigDecimal convertString$$anonfun$9(BsonString bs$5) {
        return package$.MODULE$.BigDecimal().apply(bs$5.getValue().trim());
    }

    private static final BsonValue convertString$$anonfun$11(BsonString bs$6) {
        return bs$6;
    }

    private static final OffsetDateTime convertString$$anonfun$12(BsonString bs$7) {
        return OffsetDateTime.parse(bs$7.getValue().trim());
    }

    private static final long convertString$$anonfun$14$$anonfun$1(BsonString bs$9) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(bs$9.getValue().trim()));
    }

    private static final Try convertString$$anonfun$14(BsonString bs$8) {
        return Try$.MODULE$.apply(() -> DocumentTransformer.convertString$$anonfun$14$$anonfun$1(bs$8));
    }

    private static final BsonValue convertString$$anonfun$16(BsonString bs$10) {
        return bs$10;
    }

    private static final long convertDouble$$anonfun$1(BsonDouble bs$11) {
        return package$.MODULE$.BigDecimal().apply(bs$11.getValue()).toLongExact();
    }

    private static final BsonValue convertDouble$$anonfun$3(BsonDouble bs$12) {
        return bs$12;
    }

    private static final OffsetDateTime toLongFromDateTime$$anonfun$1(String value$1) {
        return OffsetDateTime.parse(value$1);
    }
}

