/*
 * Decompiled with CFR 0.152.
 */
package ambience.ie.importdata;

import ambience.SystemScheduler$;
import ambience.api.Datasets;
import ambience.ie.db.ImportDB;
import ambience.ie.importdata.AuditHelper$;
import ambience.ie.importdata.DatasetHelper$;
import ambience.ie.importdata.DocumentTransformer;
import ambience.ie.importdata.RevertRunner$;
import ambience.ie.importdata.Util$;
import ambience.importdata.ImportModel;
import ambience.module.UserDB;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.mongodb.MongoBulkWriteException;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ImportRunner$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ImportRunner$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ImportRunner$.class.getDeclaredField("importDB$lzy1"));
    private volatile Object log$lzy1;
    private static final Scheduler scheduler;
    private volatile Object importDB$lzy1;
    public static final ImportRunner$ MODULE$;

    private ImportRunner$() {
    }

    static {
        MODULE$ = new ImportRunner$();
        scheduler = SystemScheduler$.MODULE$.global();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ImportRunner$.class);
    }

    public Scheduler scheduler() {
        return scheduler;
    }

    public ImportDB importDB() {
        Object object = this.importDB$lzy1;
        if (object instanceof ImportDB) {
            return (ImportDB)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ImportDB)this.importDB$lzyINIT1();
    }

    private Object importDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.importDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ImportDB importDB = null;
                    try {
                        importDB = (ImportDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ImportDB.class));
                        object2 = importDB == null ? LazyVals.NullValue$.MODULE$ : importDB;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.importDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return importDB;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<List<ImportModel.Result>> run(UserDB.User user, ImportModel.ItemImportRequest req) {
        this.log().info(() -> ImportRunner$.run$$anonfun$1(req), Line$.MODULE$.apply(21), FullName$.MODULE$.apply("ambience.ie.importdata.ImportRunner.run"));
        List tasks = req.settings().map((Function1 & Serializable)_$1 -> MODULE$.run(user, (ImportModel.ItemImportSettings)_$1));
        return Task$.MODULE$.sequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps());
    }

    public Task<ImportModel.Result> run(UserDB.User user, ImportModel.ItemImportSettings importSettings) {
        this.log().info(() -> ImportRunner$.run$$anonfun$2(importSettings), Line$.MODULE$.apply(27), FullName$.MODULE$.apply("ambience.ie.importdata.ImportRunner.run"));
        return this.preProcess(user, importSettings).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.runStoreData(user, importSettings).map((Function1 & Serializable)res -> res);
        });
    }

    public Task<BoxedUnit> preProcess(UserDB.User user, ImportModel.ItemImportSettings importSettings) {
        String string = importSettings.action();
        String string2 = "overwrite";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.setupRevert(user, importSettings);
        }
        return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
    }

    public Task<BoxedUnit> setupRevert(UserDB.User user, ImportModel.ItemImportSettings is) {
        String revertCol = RevertRunner$.MODULE$.getRevertCollectionName(is);
        return this.importDB().deleteTempCollection(revertCol).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.importDB().storeCollectionToTempData(is.database(), is.collection(), revertCol, user).headOptionL().map((Function1)(JProcedure1 & Serializable)countOpt -> MODULE$.log().info(() -> ImportRunner$.setupRevert$$anonfun$1$$anonfun$1$$anonfun$1(countOpt, revertCol), Line$.MODULE$.apply(44), FullName$.MODULE$.apply("ambience.ie.importdata.ImportRunner.setupRevert"))).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.importDB().clearData(is.database(), is.collection()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    public Task<ImportModel.Result> runStoreData(UserDB.User user, ImportModel.ItemImportSettings is) {
        Function1<Document, Document> fn = this.buildTransformFn(user, is);
        return this.importDB().storeTempDataToCollection(is.database(), is.collection(), is.tempCollection(), user, fn).lastL().flatMap((Function1 & Serializable)count -> ImportRunner$.runStoreData$$anonfun$1(user, is, BoxesRunTime.unboxToLong((Object)count))).onErrorRecoverWith((PartialFunction)new Serializable(user, is){
            private final UserDB.User user$6;
            private final ImportModel.ItemImportSettings is$6;
            {
                this.user$6 = user$9;
                this.is$6 = is$9;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof MongoBulkWriteException) {
                    MongoBulkWriteException e = (MongoBulkWriteException)throwable;
                    return true;
                }
                if (throwable instanceof Exception) {
                    Exception e = (Exception)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof MongoBulkWriteException) {
                    MongoBulkWriteException e = (MongoBulkWriteException)throwable;
                    return ImportRunner$.MODULE$.handleRevert(this.user$6, Util$.MODULE$.buildItemDuplicateIdErrorMsg(this.is$6, e), this.is$6);
                }
                if (throwable instanceof Exception) {
                    Exception e = (Exception)throwable;
                    return ImportRunner$.MODULE$.handleRevert(this.user$6, e.getMessage(), this.is$6);
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Task<ImportModel.Result> handleRevert(UserDB.User user, String msg, ImportModel.ItemImportSettings is) {
        ImportModel.ImportFailure res = ImportModel.ImportFailure$.MODULE$.apply(is, msg);
        AuditHelper$.MODULE$.fail(user, is, res.msg());
        return RevertRunner$.MODULE$.revert(user, is, false).map((Function1 & Serializable)_$2 -> res);
    }

    public Function1<Document, Document> buildTransformFn(UserDB.User user, ImportModel.ItemImportSettings is) {
        return (Function1 & Serializable)doc -> new DocumentTransformer(user, is).transform((Document)doc);
    }

    public Task<Either<String, BoxedUnit>> createDataset(UserDB.User user, ImportModel.ItemImportSettings is) {
        Option option = is.dataset();
        if (option instanceof Some) {
            String name = (String)((Some)option).value();
            return DatasetHelper$.MODULE$.create(user, Datasets.Name$.MODULE$.apply(name), is);
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
        }
        throw new MatchError((Object)option);
    }

    private static final Object run$$anonfun$1(ImportModel.ItemImportRequest req$1) {
        return "ImportRunner [Import] called with " + req$1.settings().size() + " import settings.";
    }

    private static final Object run$$anonfun$2(ImportModel.ItemImportSettings importSettings$1) {
        return "ImportRunner called for file " + importSettings$1.fileInfo().fileName() + " with action: " + importSettings$1.action();
    }

    private static final long setupRevert$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return 0L;
    }

    private static final Object setupRevert$$anonfun$1$$anonfun$1$$anonfun$1(Option countOpt$1, String revertCol$2) {
        return countOpt$1.getOrElse(ImportRunner$::setupRevert$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1) + " docs written to revert collection " + revertCol$2 + ".";
    }

    private static final Object runStoreData$$anonfun$1$$anonfun$1$$anonfun$1(long count$2) {
        return "ImportRunner imported " + count$2 + " documents";
    }

    private static final ImportModel.ImportSuccess runStoreData$$anonfun$1$$anonfun$1$$anonfun$2(ImportModel.ItemImportSettings is$5, long count$3) {
        return ImportModel.ImportSuccess$.MODULE$.apply(is$5, count$3);
    }

    private static final /* synthetic */ Task runStoreData$$anonfun$1(UserDB.User user$4, ImportModel.ItemImportSettings is$3, long count) {
        return MODULE$.createDataset(user$4, is$3).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return MODULE$.handleRevert(user$4, msg, is$3);
            }
            if (either instanceof Right) {
                MODULE$.log().info(() -> ImportRunner$.runStoreData$$anonfun$1$$anonfun$1$$anonfun$1(count), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.ie.importdata.ImportRunner.runStoreData"));
                AuditHelper$.MODULE$.success(user$4, is$3, count, false);
                return Task$.MODULE$.apply(() -> ImportRunner$.runStoreData$$anonfun$1$$anonfun$1$$anonfun$2(is$3, count));
            }
            throw new MatchError((Object)either);
        });
    }
}

