/*
 * Decompiled with CFR 0.152.
 */
package ambience.ie.importdata.analysis;

import ambience.ie.db.ImportDB;
import ambience.ie.importdata.analysis.Analysis;
import ambience.ie.importdata.analysis.Analysis$Field$;
import ambience.ie.importdata.analysis.Analysis$State$;
import ambience.ie.importdata.analysis.Analysis$TypeAnalysis$;
import ambience.ie.importdata.analysis.NumberUtils$;
import ambience.ie.importdata.analysis.NumericalTypeDetector;
import ambience.ie.importdata.analysis.StringUtils$;
import ambience.importdata.ImportModel;
import com.elixirtech.arch.Elixir$;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import monix.eval.Task;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public final class BSONAnalysis$
implements NumericalTypeDetector,
Analysis,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(BSONAnalysis$.class.getDeclaredField("importDB$lzy1"));
    private static DateTimeFormatter ISO_OFFSET_DATE_TIME;
    private static DateTimeFormatter ISO_LOCAL_DATE;
    private static DateTimeFormatter ISO_LOCAL_TIME;
    private volatile Object importDB$lzy1;
    public static final BSONAnalysis$ MODULE$;

    private BSONAnalysis$() {
    }

    static {
        MODULE$ = new BSONAnalysis$();
        Analysis.$init$(MODULE$);
        Statics.releaseFence();
    }

    @Override
    public DateTimeFormatter ISO_OFFSET_DATE_TIME() {
        return ISO_OFFSET_DATE_TIME;
    }

    @Override
    public DateTimeFormatter ISO_LOCAL_DATE() {
        return ISO_LOCAL_DATE;
    }

    @Override
    public DateTimeFormatter ISO_LOCAL_TIME() {
        return ISO_LOCAL_TIME;
    }

    @Override
    public void ambience$ie$importdata$analysis$Analysis$_setter_$ISO_OFFSET_DATE_TIME_$eq(DateTimeFormatter x$0) {
        ISO_OFFSET_DATE_TIME = x$0;
    }

    @Override
    public void ambience$ie$importdata$analysis$Analysis$_setter_$ISO_LOCAL_DATE_$eq(DateTimeFormatter x$0) {
        ISO_LOCAL_DATE = x$0;
    }

    @Override
    public void ambience$ie$importdata$analysis$Analysis$_setter_$ISO_LOCAL_TIME_$eq(DateTimeFormatter x$0) {
        ISO_LOCAL_TIME = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BSONAnalysis$.class);
    }

    public ImportDB importDB() {
        Object object = this.importDB$lzy1;
        if (object instanceof ImportDB) {
            return (ImportDB)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ImportDB)this.importDB$lzyINIT1();
    }

    private Object importDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.importDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ImportDB importDB = null;
                    try {
                        importDB = (ImportDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ImportDB.class));
                        object2 = importDB == null ? LazyVals.NullValue$.MODULE$ : importDB;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.importDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return importDB;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<List<ImportModel.Field>> run(String tempCollection) {
        return this.importDB().readTempData(tempCollection).foldLeftL(BSONAnalysis$::run$$anonfun$1, (Function2 & Serializable)(_$1, _$2) -> MODULE$.testDocument((Analysis.State)_$1, (Document)_$2)).map((Function1 & Serializable)state -> MODULE$.buildResult(state.fieldMap().keys().toList(), (Analysis.State)state));
    }

    public Analysis.State testDocument(Analysis.State s, Document doc) {
        Analysis.State state = this.initState(s, doc);
        doc.toList().map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                BsonValue bv = (BsonValue)tuple2._2();
                MODULE$.test(Analysis$Field$.MODULE$.apply(name), bv, state);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return state;
    }

    private Analysis.State initState(Analysis.State s, Document doc) {
        scala.collection.immutable.Set docFields = (scala.collection.immutable.Set)doc.keySet().map((Function1 & Serializable)_$3 -> new Analysis.Field(Analysis$Field$.MODULE$.apply(_$3)));
        Set set = s.fieldMap().keySet();
        scala.collection.immutable.Set newFields = (scala.collection.immutable.Set)docFields.filterNot((Function1 & Serializable)elem -> set.contains((Object)new Analysis.Field(elem == null ? null : ((Analysis.Field)elem).name())));
        newFields.foreach((Function1 & Serializable)f -> BSONAnalysis$.initState$$anonfun$1(s, f == null ? null : ((Analysis.Field)f).name()));
        return s;
    }

    private void test(String field, BsonValue data, Analysis.State state) {
        state.fieldMap().get((Object)new Analysis.Field(field)).foreach((Function1)(JProcedure1 & Serializable)analysis2 -> {
            Analysis.TypeAnalysis result;
            Function1 fn = ((Function1 & Serializable)(Function1 & Serializable)analysis -> MODULE$.testString(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testInt32(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testInt64(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testDouble(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testDecimal(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testTimestamp(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testDate(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testTime(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testBoolean(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testObjectId(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testDocument(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testArray(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testBinary(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.testNull(data, (Analysis.TypeAnalysis)analysis)).andThen((Function1 & Serializable)analysis -> MODULE$.detectType(data, (Analysis.TypeAnalysis)analysis));
            Analysis.TypeAnalysis typeAnalysis = result = (Analysis.TypeAnalysis)fn.apply(analysis2);
            Analysis.TypeAnalysis typeAnalysis2 = analysis2;
            if (typeAnalysis == null ? typeAnalysis2 != null : !((Object)typeAnalysis).equals(typeAnalysis2)) {
                state.fieldMap().update((Object)new Analysis.Field(field), (Object)result);
                return;
            }
        });
    }

    private Analysis.TypeAnalysis testString(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.string()) {
            boolean canBeString;
            BsonType bsonType = data.getBsonType();
            BsonType bsonType2 = BsonType.STRING;
            BsonType bsonType3 = bsonType;
            if (!(bsonType2 != null ? !bsonType2.equals(bsonType3) : bsonType3 != null)) {
                v1 = true;
            } else {
                BsonType bsonType4 = BsonType.BOOLEAN;
                BsonType bsonType5 = bsonType;
                if (!(bsonType4 != null ? !bsonType4.equals(bsonType5) : bsonType5 != null)) {
                    v1 = true;
                } else {
                    BsonType bsonType6 = BsonType.INT32;
                    BsonType bsonType7 = bsonType;
                    if (!(bsonType6 != null ? !bsonType6.equals(bsonType7) : bsonType7 != null)) {
                        v1 = true;
                    } else {
                        BsonType bsonType8 = BsonType.INT64;
                        BsonType bsonType9 = bsonType;
                        if (!(bsonType8 != null ? !bsonType8.equals(bsonType9) : bsonType9 != null)) {
                            v1 = true;
                        } else {
                            BsonType bsonType10 = BsonType.DOUBLE;
                            BsonType bsonType11 = bsonType;
                            if (!(bsonType10 != null ? !bsonType10.equals(bsonType11) : bsonType11 != null)) {
                                v1 = true;
                            } else {
                                BsonType bsonType12 = BsonType.DECIMAL128;
                                BsonType bsonType13 = bsonType;
                                if (!(bsonType12 != null ? !bsonType12.equals(bsonType13) : bsonType13 != null)) {
                                    v1 = true;
                                } else {
                                    BsonType bsonType14 = BsonType.TIMESTAMP;
                                    BsonType bsonType15 = bsonType;
                                    v1 = !(bsonType14 != null ? !bsonType14.equals(bsonType15) : bsonType15 != null) ? true : (canBeString = false);
                                }
                            }
                        }
                    }
                }
            }
            if (canBeString || data.isNull()) {
                return analysis;
            }
            return analysis.copy(false, analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testBoolean(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.boolean()) {
            if (data.isBoolean() || data.isNull()) {
                return analysis;
            }
            if (StringUtils$.MODULE$.isBoolean(data)) {
                return analysis;
            }
            return analysis.copy(analysis.copy$default$1(), false, analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testInt32(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.int32()) {
            if (data.isInt32() || data.isNull()) {
                return analysis;
            }
            if (data.isInt64() && NumberUtils$.MODULE$.isInt32(data.asInt64())) {
                return analysis;
            }
            if (data.isDouble() && NumberUtils$.MODULE$.isInt32(data.asDouble())) {
                return analysis;
            }
            if (data.isDecimal128() && NumberUtils$.MODULE$.isInt32(data.asDecimal128())) {
                return analysis;
            }
            if (StringUtils$.MODULE$.isInt32(data)) {
                return analysis;
            }
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), false, analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testInt64(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.int64()) {
            if (data.isInt64() || data.isInt32()) {
                return analysis;
            }
            if (data.isDouble() && NumberUtils$.MODULE$.isInt64(data.asDouble())) {
                return analysis;
            }
            if (data.isDecimal128() && NumberUtils$.MODULE$.isInt64(data.asDecimal128())) {
                return analysis;
            }
            if (StringUtils$.MODULE$.isInt64(data) || data.isNull()) {
                return analysis;
            }
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), false, analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testDouble(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.double()) {
            if (data.isDouble() || data.isInt64() || data.isInt32()) {
                return analysis;
            }
            if (data.isDecimal128() && NumberUtils$.MODULE$.isDouble(data.asDecimal128())) {
                return analysis;
            }
            if (StringUtils$.MODULE$.isDouble(data) || data.isNull()) {
                return analysis;
            }
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), false, analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testDecimal(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.decimal()) {
            if (data.isDecimal128() || data.isDouble() || data.isInt64() || data.isInt32()) {
                return analysis;
            }
            if (StringUtils$.MODULE$.isDecimal(data) || data.isNull()) {
                return analysis;
            }
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), false, analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testTimestamp(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.timestamp()) {
            if (data.isNumber()) {
                Option option = Try$.MODULE$.apply(() -> BSONAnalysis$.testTimestamp$$anonfun$1(data)).toOption();
                if (option instanceof Some) {
                    long value = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                    return (Analysis.TypeAnalysis)Try$.MODULE$.apply(() -> BSONAnalysis$.testTimestamp$$anonfun$2(value)).toOption().map((Function1 & Serializable)_$4 -> analysis).getOrElse(() -> BSONAnalysis$.testTimestamp$$anonfun$4(analysis));
                }
                if (None$.MODULE$.equals(option)) {
                    return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), false, analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
                }
                throw new MatchError((Object)option);
            }
            if (this.isTimestamp(data) || data.isNull()) {
                return analysis;
            }
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), false, analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testDate(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.isoLocalDate()) {
            if (StringUtils$.MODULE$.isDate(data) || data.isNull()) {
                return analysis;
            }
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), false, analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testTime(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.isoLocalTime()) {
            if (StringUtils$.MODULE$.isTime(data) || data.isNull()) {
                return analysis;
            }
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), false, analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testNull(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (analysis.isNull() && !data.isNull()) {
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), false, analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testObjectId(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (data.isNull()) {
            return analysis;
        }
        if (analysis.objectId() && !data.isObjectId()) {
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), false, analysis.copy$default$11(), analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testDocument(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (data.isNull()) {
            return analysis;
        }
        if (analysis.document() && !data.isDocument()) {
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), false, analysis.copy$default$12(), analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testArray(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (data.isNull()) {
            return analysis;
        }
        if (analysis.array() && !data.isArray()) {
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), false, analysis.copy$default$13(), analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    private Analysis.TypeAnalysis testBinary(BsonValue data, Analysis.TypeAnalysis analysis) {
        if (data.isNull()) {
            return analysis;
        }
        if (analysis.binary() && !data.isBinary()) {
            return analysis.copy(analysis.copy$default$1(), analysis.copy$default$2(), analysis.copy$default$3(), analysis.copy$default$4(), analysis.copy$default$5(), analysis.copy$default$6(), analysis.copy$default$7(), analysis.copy$default$8(), analysis.copy$default$9(), analysis.copy$default$10(), analysis.copy$default$11(), analysis.copy$default$12(), false, analysis.copy$default$14(), analysis.copy$default$15());
        }
        return analysis;
    }

    public boolean isTimestamp(BsonValue data) {
        return data.isTimestamp() || data.isDateTime() || StringUtils$.MODULE$.isTimestamp(data);
    }

    private static final Analysis.State run$$anonfun$1() {
        return Analysis$State$.MODULE$.apply(Analysis$State$.MODULE$.$lessinit$greater$default$1());
    }

    private static final /* synthetic */ Map initState$$anonfun$1(Analysis.State s$1, String f) {
        Analysis.Field field = (Analysis.Field)Predef$.MODULE$.ArrowAssoc((Object)new Analysis.Field(f));
        return (Map)s$1.fieldMap().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)field, (Object)Analysis$TypeAnalysis$.MODULE$.apply(Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$1(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$2(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$3(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$4(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$5(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$6(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$7(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$8(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$9(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$10(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$11(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$12(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$13(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$14(), Analysis$TypeAnalysis$.MODULE$.$lessinit$greater$default$15())));
    }

    private static final long testTimestamp$$anonfun$1(BsonValue data$17) {
        BsonType bsonType = data$17.getBsonType();
        BsonType bsonType2 = BsonType.DOUBLE;
        BsonType bsonType3 = bsonType;
        if (!(bsonType2 != null ? !bsonType2.equals(bsonType3) : bsonType3 != null)) {
            return NumberUtils$.MODULE$.toExactLong(data$17.asDouble());
        }
        BsonType bsonType4 = BsonType.INT64;
        BsonType bsonType5 = bsonType;
        if (!(bsonType4 != null ? !bsonType4.equals(bsonType5) : bsonType5 != null)) {
            return data$17.asInt64().getValue();
        }
        BsonType bsonType6 = BsonType.DECIMAL128;
        BsonType bsonType7 = bsonType;
        if (!(bsonType6 != null ? !bsonType6.equals(bsonType7) : bsonType7 != null)) {
            return NumberUtils$.MODULE$.toExactLong(data$17.asDecimal128());
        }
        return NumberUtils$.MODULE$.toExactLong(data$17.asDouble());
    }

    private static final Date testTimestamp$$anonfun$2(long value$1) {
        return new Date(value$1);
    }

    private static final Analysis.TypeAnalysis testTimestamp$$anonfun$4(Analysis.TypeAnalysis analysis$2) {
        return analysis$2.copy(analysis$2.copy$default$1(), analysis$2.copy$default$2(), analysis$2.copy$default$3(), analysis$2.copy$default$4(), analysis$2.copy$default$5(), analysis$2.copy$default$6(), analysis$2.copy$default$7(), analysis$2.copy$default$8(), false, analysis$2.copy$default$10(), analysis$2.copy$default$11(), analysis$2.copy$default$12(), analysis$2.copy$default$13(), analysis$2.copy$default$14(), analysis$2.copy$default$15());
    }
}

