/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.CloseException;
import com.monitorjbl.xlsx.exceptions.ParseException;
import com.monitorjbl.xlsx.impl.StreamingCell;
import com.monitorjbl.xlsx.impl.StreamingRow;
import com.monitorjbl.xlsx.impl.StreamingSheet;
import com.monitorjbl.xlsx.impl.StringSupplier;
import com.monitorjbl.xlsx.impl.Supplier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSheetReader
implements Iterable<Row> {
    private static final Logger log = LoggerFactory.getLogger(StreamingSheetReader.class);
    private final SharedStrings sst;
    private final StylesTable stylesTable;
    private final XMLEventReader parser;
    private final DataFormatter dataFormatter = new DataFormatter();
    private final Set<Integer> hiddenColumns = new HashSet<Integer>();
    private int lastRowNum;
    private int currentRowNum;
    private int firstColNum = 0;
    private int currentColNum;
    private int rowCacheSize;
    private List<Row> rowCache = new ArrayList<Row>();
    private Iterator<Row> rowCacheIterator;
    private String lastContents;
    private Sheet sheet;
    private StreamingRow currentRow;
    private StreamingCell currentCell;
    private boolean use1904Dates;

    public StreamingSheetReader(SharedStrings sharedStrings, StylesTable stylesTable, XMLEventReader xMLEventReader, boolean bl, int n) {
        this.sst = sharedStrings;
        this.stylesTable = stylesTable;
        this.parser = xMLEventReader;
        this.use1904Dates = bl;
        this.rowCacheSize = n;
    }

    void setSheet(StreamingSheet streamingSheet) {
        this.sheet = streamingSheet;
    }

    private boolean getRow() {
        try {
            this.rowCache.clear();
            while (this.rowCache.size() < this.rowCacheSize && this.parser.hasNext()) {
                this.handleEvent(this.parser.nextEvent());
            }
            this.rowCacheIterator = this.rowCache.iterator();
            return this.rowCacheIterator.hasNext();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ParseException("Error reading XML stream", xMLStreamException);
        }
    }

    private String[] splitCellRef(String string) {
        int n = -1;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') continue;
            n = i;
            break;
        }
        return new String[]{string.substring(0, n), string.substring(n)};
    }

    private void handleEvent(XMLEvent xMLEvent) {
        if (xMLEvent.getEventType() == 4) {
            Characters characters = xMLEvent.asCharacters();
            this.lastContents = this.lastContents + characters.getData();
        } else if (xMLEvent.getEventType() == 1 && this.isSpreadsheetTag(xMLEvent.asStartElement().getName())) {
            StartElement startElement = xMLEvent.asStartElement();
            String string = startElement.getName().getLocalPart();
            if ("row".equals(string)) {
                Attribute attribute;
                Attribute attribute2 = startElement.getAttributeByName(new QName("r"));
                int n = this.currentRowNum;
                if (attribute2 != null) {
                    this.currentRowNum = n = Integer.parseInt(attribute2.getValue()) - 1;
                }
                boolean bl = (attribute = startElement.getAttributeByName(new QName("hidden"))) != null && ("1".equals(attribute.getValue()) || "true".equals(attribute.getValue()));
                this.currentRow = new StreamingRow(this.sheet, n, bl);
                this.currentColNum = this.firstColNum;
            } else if ("col".equals(string)) {
                boolean bl;
                Attribute attribute = startElement.getAttributeByName(new QName("hidden"));
                boolean bl2 = bl = attribute != null && ("1".equals(attribute.getValue()) || "true".equals(attribute.getValue()));
                if (bl) {
                    Attribute attribute3 = startElement.getAttributeByName(new QName("min"));
                    Attribute attribute4 = startElement.getAttributeByName(new QName("max"));
                    int n = Integer.parseInt(attribute3.getValue()) - 1;
                    int n2 = Integer.parseInt(attribute4.getValue()) - 1;
                    for (int i = n; i <= n2; ++i) {
                        this.hiddenColumns.add(i);
                    }
                }
            } else if ("c".equals(string)) {
                Object object;
                Attribute attribute = startElement.getAttributeByName(new QName("r"));
                if (attribute != null) {
                    object = this.splitCellRef(attribute.getValue());
                    this.currentColNum = CellReference.convertColStringToIndex((String)object[0]);
                    this.currentCell = new StreamingCell(this.sheet, this.currentColNum, Integer.parseInt(object[1]) - 1, this.use1904Dates);
                } else {
                    this.currentCell = new StreamingCell(this.sheet, this.currentColNum, this.currentRowNum, this.use1904Dates);
                }
                this.setFormatString(startElement, this.currentCell);
                object = startElement.getAttributeByName(new QName("t"));
                if (object != null) {
                    this.currentCell.setType(object.getValue());
                } else {
                    this.currentCell.setType("n");
                }
                Attribute attribute5 = startElement.getAttributeByName(new QName("s"));
                if (attribute5 != null) {
                    String string2 = attribute5.getValue();
                    try {
                        int n = Integer.parseInt(string2);
                        this.currentCell.setCellStyle((CellStyle)this.stylesTable.getStyleAt(n));
                    }
                    catch (NumberFormatException numberFormatException) {
                        log.warn("Ignoring invalid style index {}", (Object)string2);
                    }
                } else {
                    this.currentCell.setCellStyle((CellStyle)this.stylesTable.getStyleAt(0));
                }
            } else if ("dimension".equals(string)) {
                String string3;
                Attribute attribute = startElement.getAttributeByName(new QName("ref"));
                String string4 = string3 = attribute != null ? attribute.getValue() : null;
                if (string3 != null) {
                    int n;
                    for (n = string3.length() - 1; n >= 0; --n) {
                        if (Character.isDigit(string3.charAt(n))) continue;
                        try {
                            this.lastRowNum = Integer.parseInt(string3.substring(n + 1)) - 1;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    for (n = 0; n < string3.length(); ++n) {
                        if (Character.isAlphabetic(string3.charAt(n))) continue;
                        this.firstColNum = CellReference.convertColStringToIndex((String)string3.substring(0, n));
                        break;
                    }
                }
            } else if ("f".equals(string) && this.currentCell != null) {
                this.currentCell.setFormulaType(true);
            }
            this.lastContents = "";
        } else if (xMLEvent.getEventType() == 2 && this.isSpreadsheetTag(xMLEvent.asEndElement().getName())) {
            EndElement endElement = xMLEvent.asEndElement();
            String string = endElement.getName().getLocalPart();
            if ("v".equals(string) || "t".equals(string)) {
                this.currentCell.setRawContents(this.unformattedContents());
                this.currentCell.setContentSupplier(this.formattedContents());
            } else if ("row".equals(string) && this.currentRow != null) {
                this.rowCache.add(this.currentRow);
                ++this.currentRowNum;
            } else if ("c".equals(string)) {
                this.currentRow.getCellMap().put(this.currentCell.getColumnIndex(), this.currentCell);
                this.currentCell = null;
                ++this.currentColNum;
            } else if ("f".equals(string) && this.currentCell != null) {
                this.currentCell.setFormula(this.lastContents);
            }
        }
    }

    private boolean isSpreadsheetTag(QName qName) {
        return qName.getNamespaceURI() != null && qName.getNamespaceURI().endsWith("/main");
    }

    boolean isColumnHidden(int n) {
        if (this.rowCacheIterator == null) {
            this.getRow();
        }
        return this.hiddenColumns.contains(n);
    }

    int getLastRowNum() {
        if (this.rowCacheIterator == null) {
            this.getRow();
        }
        return this.lastRowNum;
    }

    void setFormatString(StartElement startElement, StreamingCell streamingCell) {
        Attribute attribute = startElement.getAttributeByName(new QName("s"));
        String string = attribute != null ? attribute.getValue() : null;
        XSSFCellStyle xSSFCellStyle = null;
        if (string != null) {
            xSSFCellStyle = this.stylesTable.getStyleAt(Integer.parseInt(string));
        } else if (this.stylesTable.getNumCellStyles() > 0) {
            xSSFCellStyle = this.stylesTable.getStyleAt(0);
        }
        if (xSSFCellStyle != null) {
            streamingCell.setNumericFormatIndex(xSSFCellStyle.getDataFormat());
            String string2 = xSSFCellStyle.getDataFormatString();
            if (string2 != null) {
                streamingCell.setNumericFormat(string2);
            } else {
                streamingCell.setNumericFormat(BuiltinFormats.getBuiltinFormat((int)streamingCell.getNumericFormatIndex().shortValue()));
            }
        } else {
            streamingCell.setNumericFormatIndex(null);
            streamingCell.setNumericFormat(null);
        }
    }

    Supplier formattedContents() {
        return this.getFormatterForType(this.currentCell.getType());
    }

    private Supplier getFormatterForType(String string) {
        switch (string) {
            case "s": {
                if (!this.lastContents.isEmpty()) {
                    int n = Integer.parseInt(this.lastContents);
                    return new StringSupplier(this.sst.getItemAt(n).toString());
                }
                return new StringSupplier(this.lastContents);
            }
            case "inlineStr": 
            case "str": {
                return new StringSupplier(new XSSFRichTextString(this.lastContents).toString());
            }
            case "e": {
                return new StringSupplier("ERROR:  " + this.lastContents);
            }
            case "n": {
                if (this.currentCell.getNumericFormat() != null && this.lastContents.length() > 0) {
                    final String string2 = this.lastContents;
                    final short s = this.currentCell.getNumericFormatIndex();
                    final String string3 = this.currentCell.getNumericFormat();
                    return new Supplier(){
                        String cachedContent;

                        @Override
                        public Object getContent() {
                            if (this.cachedContent == null) {
                                this.cachedContent = StreamingSheetReader.this.dataFormatter.formatRawCellContents(Double.parseDouble(string2), s, string3);
                            }
                            return this.cachedContent;
                        }
                    };
                }
                return new StringSupplier(this.lastContents);
            }
        }
        return new StringSupplier(this.lastContents);
    }

    String unformattedContents() {
        switch (this.currentCell.getType()) {
            case "s": {
                if (!this.lastContents.isEmpty()) {
                    int n = Integer.parseInt(this.lastContents);
                    return this.sst.getItemAt(n).toString();
                }
                return this.lastContents;
            }
            case "inlineStr": {
                return new XSSFRichTextString(this.lastContents).toString();
            }
        }
        return this.lastContents;
    }

    @Override
    public Iterator<Row> iterator() {
        return new StreamingRowIterator();
    }

    public void close() {
        try {
            this.parser.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new CloseException(xMLStreamException);
        }
    }

    class StreamingRowIterator
    implements Iterator<Row> {
        public StreamingRowIterator() {
            if (StreamingSheetReader.this.rowCacheIterator == null) {
                this.hasNext();
            }
        }

        @Override
        public boolean hasNext() {
            return StreamingSheetReader.this.rowCacheIterator != null && StreamingSheetReader.this.rowCacheIterator.hasNext() || StreamingSheetReader.this.getRow();
        }

        @Override
        public Row next() {
            return StreamingSheetReader.this.rowCacheIterator.next();
        }

        @Override
        public void remove() {
            throw new RuntimeException("NotSupported");
        }
    }
}

