/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.MissingSheetException;
import com.monitorjbl.xlsx.impl.StreamingSheet;
import com.monitorjbl.xlsx.impl.StreamingWorkbookReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellReferenceType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.Workbook;

public class StreamingWorkbook
implements Workbook,
AutoCloseable {
    private final StreamingWorkbookReader reader;

    public StreamingWorkbook(StreamingWorkbookReader streamingWorkbookReader) {
        this.reader = streamingWorkbookReader;
    }

    int findSheetByName(String string) {
        for (int i = 0; i < this.reader.getSheetProperties().size(); ++i) {
            if (!this.reader.getSheetProperties().get(i).get("name").equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Iterator<Sheet> iterator() {
        return this.reader.iterator();
    }

    public Iterator<Sheet> sheetIterator() {
        return this.iterator();
    }

    public String getSheetName(int n) {
        return this.reader.getSheetProperties().get(n).get("name");
    }

    public int getSheetIndex(String string) {
        return this.findSheetByName(string);
    }

    public int getSheetIndex(Sheet sheet) {
        if (sheet instanceof StreamingSheet) {
            return this.findSheetByName(sheet.getSheetName());
        }
        throw new UnsupportedOperationException("Cannot use non-StreamingSheet sheets");
    }

    public int getNumberOfSheets() {
        return this.reader.getSheets().size();
    }

    public Sheet getSheetAt(int n) {
        return this.reader.getSheets().get(n);
    }

    public Sheet getSheet(String string) {
        int n = this.getSheetIndex(string);
        if (n == -1) {
            throw new MissingSheetException("Sheet '" + string + "' does not exist");
        }
        return this.reader.getSheets().get(n);
    }

    public boolean isSheetHidden(int n) {
        return "hidden".equals(this.reader.getSheetProperties().get(n).get("state"));
    }

    public boolean isSheetVeryHidden(int n) {
        return "veryHidden".equals(this.reader.getSheetProperties().get(n).get("state"));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public int getActiveSheetIndex() {
        throw new UnsupportedOperationException();
    }

    public void setActiveSheet(int n) {
        throw new UnsupportedOperationException();
    }

    public int getFirstVisibleTab() {
        throw new UnsupportedOperationException();
    }

    public void setFirstVisibleTab(int n) {
        throw new UnsupportedOperationException();
    }

    public void setSheetOrder(String string, int n) {
        throw new UnsupportedOperationException();
    }

    public void setSelectedTab(int n) {
        throw new UnsupportedOperationException();
    }

    public void setSheetName(int n, String string) {
        throw new UnsupportedOperationException();
    }

    public Sheet createSheet() {
        throw new UnsupportedOperationException();
    }

    public Sheet createSheet(String string) {
        throw new UnsupportedOperationException();
    }

    public Sheet cloneSheet(int n) {
        throw new UnsupportedOperationException();
    }

    public void removeSheetAt(int n) {
        throw new UnsupportedOperationException();
    }

    public Font createFont() {
        throw new UnsupportedOperationException();
    }

    public Font findFont(boolean bl, short s, short s2, String string, boolean bl2, boolean bl3, short s3, byte by) {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfFonts() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getNumberOfFontsAsInt() {
        throw new UnsupportedOperationException();
    }

    public Font getFontAt(int n) {
        throw new UnsupportedOperationException();
    }

    public CellStyle createCellStyle() {
        throw new UnsupportedOperationException();
    }

    public int getNumCellStyles() {
        throw new UnsupportedOperationException();
    }

    public CellStyle getCellStyleAt(int n) {
        throw new UnsupportedOperationException();
    }

    public void write(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfNames() {
        throw new UnsupportedOperationException();
    }

    public Name getName(String string) {
        throw new UnsupportedOperationException();
    }

    public List<? extends Name> getNames(String string) {
        throw new UnsupportedOperationException();
    }

    public List<? extends Name> getAllNames() {
        throw new UnsupportedOperationException();
    }

    public Name createName() {
        throw new UnsupportedOperationException();
    }

    public void removeName(Name name) {
        throw new UnsupportedOperationException();
    }

    public int linkExternalWorkbook(String string, Workbook workbook) {
        throw new UnsupportedOperationException();
    }

    public void setPrintArea(int n, String string) {
        throw new UnsupportedOperationException();
    }

    public void setPrintArea(int n, int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException();
    }

    public String getPrintArea(int n) {
        throw new UnsupportedOperationException();
    }

    public void removePrintArea(int n) {
        throw new UnsupportedOperationException();
    }

    public Row.MissingCellPolicy getMissingCellPolicy() {
        throw new UnsupportedOperationException();
    }

    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        throw new UnsupportedOperationException();
    }

    public DataFormat createDataFormat() {
        throw new UnsupportedOperationException();
    }

    public int addPicture(byte[] byArray, int n) {
        throw new UnsupportedOperationException();
    }

    public List<? extends PictureData> getAllPictures() {
        throw new UnsupportedOperationException();
    }

    public CreationHelper getCreationHelper() {
        throw new UnsupportedOperationException();
    }

    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    public void setHidden(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setSheetHidden(int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public SheetVisibility getSheetVisibility(int n) {
        throw new UnsupportedOperationException();
    }

    public void setSheetVisibility(int n, SheetVisibility sheetVisibility) {
        throw new UnsupportedOperationException();
    }

    public void addToolPack(UDFFinder uDFFinder) {
        throw new UnsupportedOperationException();
    }

    public void setForceFormulaRecalculation(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean getForceFormulaRecalculation() {
        throw new UnsupportedOperationException();
    }

    public SpreadsheetVersion getSpreadsheetVersion() {
        throw new UnsupportedOperationException();
    }

    public int addOlePackage(byte[] byArray, String string, String string2, String string3) throws IOException {
        throw new UnsupportedOperationException();
    }

    public EvaluationWorkbook createEvaluationWorkbook() {
        return null;
    }

    public CellReferenceType getCellReferenceType() {
        throw new UnsupportedOperationException();
    }

    public void setCellReferenceType(CellReferenceType cellReferenceType) {
        throw new UnsupportedOperationException();
    }
}

