/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.StreamingReader;
import com.monitorjbl.xlsx.XmlUtils;
import com.monitorjbl.xlsx.exceptions.OpenException;
import com.monitorjbl.xlsx.exceptions.ReadException;
import com.monitorjbl.xlsx.impl.StreamingSheet;
import com.monitorjbl.xlsx.impl.StreamingSheetReader;
import com.monitorjbl.xlsx.impl.TempFileUtil;
import com.monitorjbl.xlsx.sst.BufferedStringsTable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.StylesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StreamingWorkbookReader
implements Iterable<Sheet>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamingWorkbookReader.class);
    private final List<StreamingSheet> sheets;
    private final List<Map<String, String>> sheetProperties = new ArrayList<Map<String, String>>();
    private final StreamingReader.Builder builder;
    private File tmp;
    private File sstCache;
    private OPCPackage pkg;
    private SharedStrings sst;
    private boolean use1904Dates = false;

    @Deprecated
    public StreamingWorkbookReader(SharedStrings sharedStrings, File file, OPCPackage oPCPackage, StreamingSheetReader streamingSheetReader, StreamingReader.Builder builder) {
        this.sst = sharedStrings;
        this.sstCache = file;
        this.pkg = oPCPackage;
        this.sheets = Arrays.asList(new StreamingSheet(null, streamingSheetReader));
        this.builder = builder;
    }

    public StreamingWorkbookReader(StreamingReader.Builder builder) {
        this.sheets = new ArrayList<StreamingSheet>();
        this.builder = builder;
    }

    public StreamingSheetReader first() {
        return this.sheets.get(0).getReader();
    }

    public void init(InputStream inputStream) {
        File file = null;
        try {
            file = TempFileUtil.writeInputStreamToFile(inputStream, this.builder.getBufferSize());
            log.debug("Created temp file [" + file.getAbsolutePath() + "]");
            this.init(file);
            this.tmp = file;
        }
        catch (IOException iOException) {
            throw new ReadException("Unable to read input stream", iOException);
        }
        catch (RuntimeException runtimeException) {
            if (file != null) {
                file.delete();
            }
            throw runtimeException;
        }
    }

    public void init(File file) {
        try {
            Node node;
            Object object;
            EncryptionInfo encryptionInfo;
            POIFSFileSystem pOIFSFileSystem;
            if (this.builder.getPassword() != null) {
                pOIFSFileSystem = new POIFSFileSystem(file);
                encryptionInfo = new EncryptionInfo(pOIFSFileSystem);
                object = Decryptor.getInstance((EncryptionInfo)encryptionInfo);
                object.verifyPassword(this.builder.getPassword());
                this.pkg = OPCPackage.open((InputStream)object.getDataStream(pOIFSFileSystem));
            } else {
                this.pkg = OPCPackage.open((File)file);
            }
            pOIFSFileSystem = new XSSFReader(this.pkg);
            if (this.builder.getSstCacheSize() > 0) {
                this.sstCache = Files.createTempFile("", "", new FileAttribute[0]).toFile();
                log.debug("Created sst cache file [" + this.sstCache.getAbsolutePath() + "]");
                this.sst = BufferedStringsTable.getSharedStringsTable(this.sstCache, this.builder.getSstCacheSize(), this.pkg);
            } else {
                this.sst = pOIFSFileSystem.getSharedStringsTable();
            }
            encryptionInfo = pOIFSFileSystem.getStylesTable();
            object = XmlUtils.searchForNodeList(XmlUtils.document(pOIFSFileSystem.getWorkbookData()), "/ss:workbook/ss:workbookPr");
            if (object.getLength() == 1 && (node = object.item(0).getAttributes().getNamedItem("date1904")) != null) {
                this.use1904Dates = "1".equals(node.getTextContent());
            }
            this.loadSheets((XSSFReader)pOIFSFileSystem, this.sst, (StylesTable)encryptionInfo, this.builder.getRowCacheSize());
        }
        catch (IOException iOException) {
            throw new OpenException("Failed to open file", iOException);
        }
        catch (XMLStreamException | OpenXML4JException throwable) {
            throw new ReadException("Unable to read workbook", (Exception)throwable);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new ReadException("Unable to read workbook - Decryption failed", generalSecurityException);
        }
    }

    void loadSheets(XSSFReader xSSFReader, SharedStrings sharedStrings, StylesTable stylesTable, int n) throws IOException, InvalidFormatException, XMLStreamException {
        this.lookupSheetNames(xSSFReader);
        XSSFReader.SheetIterator sheetIterator = (XSSFReader.SheetIterator)xSSFReader.getSheetsData();
        LinkedHashMap<URI, InputStream> linkedHashMap = new LinkedHashMap<URI, InputStream>();
        while (sheetIterator.hasNext()) {
            InputStream inputStream = sheetIterator.next();
            linkedHashMap.put(sheetIterator.getSheetPart().getPartName().getURI(), inputStream);
        }
        int n2 = 0;
        for (URI uRI : linkedHashMap.keySet()) {
            XMLEventReader xMLEventReader = XMLHelper.newXMLInputFactory().createXMLEventReader((InputStream)linkedHashMap.get(uRI));
            this.sheets.add(new StreamingSheet(this.sheetProperties.get(n2++).get("name"), new StreamingSheetReader(sharedStrings, stylesTable, xMLEventReader, this.use1904Dates, n)));
        }
    }

    void lookupSheetNames(XSSFReader xSSFReader) throws IOException, InvalidFormatException {
        this.sheetProperties.clear();
        NodeList nodeList = XmlUtils.searchForNodeList(XmlUtils.document(xSSFReader.getWorkbookData()), "/ss:workbook/ss:sheets/ss:sheet");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", nodeList.item(i).getAttributes().getNamedItem("name").getTextContent());
            Node node = nodeList.item(i).getAttributes().getNamedItem("state");
            hashMap.put("state", node == null ? "visible" : node.getTextContent());
            this.sheetProperties.add(hashMap);
        }
    }

    List<? extends Sheet> getSheets() {
        return this.sheets;
    }

    public List<Map<String, String>> getSheetProperties() {
        return this.sheetProperties;
    }

    @Override
    public Iterator<Sheet> iterator() {
        return new StreamingSheetIterator(this.sheets.iterator());
    }

    @Override
    public void close() throws IOException {
        try {
            for (StreamingSheet streamingSheet : this.sheets) {
                streamingSheet.getReader().close();
            }
            this.pkg.revert();
        }
        finally {
            if (this.tmp != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Deleting tmp file [" + this.tmp.getAbsolutePath() + "]");
                }
                this.tmp.delete();
            }
            if (this.sst instanceof BufferedStringsTable) {
                if (log.isDebugEnabled()) {
                    log.debug("Deleting sst cache file [" + this.sstCache.getAbsolutePath() + "]");
                }
                ((BufferedStringsTable)this.sst).close();
                this.sstCache.delete();
            }
        }
    }

    static class StreamingSheetIterator
    implements Iterator<Sheet> {
        private final Iterator<StreamingSheet> iterator;

        public StreamingSheetIterator(Iterator<StreamingSheet> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Sheet next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new RuntimeException("NotSupported");
        }
    }
}

