/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.AbstractMinuteMinder$;
import com.elixirtech.arch.AbstractMinuteMinder$Line$;
import com.elixirtech.arch.AbstractMinuteMinder$Load$;
import com.elixirtech.arch.AbstractMinuteMinder$Timing$;
import com.elixirtech.arch.LoggingHelper$;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.arch.MinuteMinder;
import com.elixirtech.arch.NamedLogger;
import com.elixirtech.arch.info.JavaPID$;
import com.elixirtech.arch.info.RunInfo;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.DBUtils$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable$;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.concurrent.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class AbstractMinuteMinder
implements MinuteMinder {
    private final Scheduler exeCxt = Scheduler$.MODULE$.global();
    private final BsonString pid = new BsonString(JavaPID$.MODULE$.value());
    private final Option pidMachine = BsonUtils$.MODULE$.pidMachine(this.pid());
    private final BsonInt32 runValue;
    private final FiniteDuration duration;
    private final AtomicInteger serial;
    private final NamedLogger syncLog;
    private final Map bumpMap;
    private final Map loadMap;
    private final Map timingMap;

    public static String safe(String string) {
        return AbstractMinuteMinder$.MODULE$.safe(string);
    }

    public AbstractMinuteMinder(RunInfo runInfo) {
        this.runValue = new BsonInt32(runInfo.runId());
        this.duration = FiniteDuration$.MODULE$.apply(1L, package$.MODULE$.MINUTES());
        this.serial = new AtomicInteger(0);
        this.syncLog = new NamedLogger(LoggingHelper$.MODULE$.logName(this.getClass()) + "Sync");
        this.bumpMap = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.loadMap = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        this.timingMap = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        Observable$.MODULE$.intervalAtFixedRate(this.duration(), this.duration()).map((Function1)(JFunction1.mcVJ.sp & Serializable)_$1 -> this.output()).completedL().runAsyncAndForget(this.exeCxt());
    }

    public Scheduler exeCxt() {
        return this.exeCxt;
    }

    public BsonString pid() {
        return this.pid;
    }

    public Option<BsonString> pidMachine() {
        return this.pidMachine;
    }

    public BsonInt32 runValue() {
        return this.runValue;
    }

    public FiniteDuration duration() {
        return this.duration;
    }

    public AtomicInteger serial() {
        return this.serial;
    }

    public NamedLogger syncLog() {
        return this.syncLog;
    }

    public Map<String, AtomicInteger> bumpMap() {
        return this.bumpMap;
    }

    public Map<String, Load> loadMap() {
        return this.loadMap;
    }

    public Map<String, Timing> timingMap() {
        return this.timingMap;
    }

    public abstract void outputDoc(Document var1);

    public void bump(String s) {
        AtomicInteger ai = (AtomicInteger)this.bumpMap().getOrElseUpdate((Object)s, AbstractMinuteMinder::$anonfun$1);
        ai.incrementAndGet();
    }

    public void bump(String s, int i) {
        if (i > 0) {
            AtomicInteger ai = (AtomicInteger)this.bumpMap().getOrElseUpdate((Object)s, AbstractMinuteMinder::$anonfun$2);
            ai.addAndGet(i);
            return;
        }
    }

    public void load(String s) {
        Load ai = (Load)this.loadMap().getOrElseUpdate((Object)s, AbstractMinuteMinder::$anonfun$3);
        int now = ai.current().incrementAndGet();
        if (now > ai.max().get()) {
            ai.max().set(now);
            return;
        }
    }

    public void unload(String s) {
        Load ai = (Load)this.loadMap().getOrElseUpdate((Object)s, AbstractMinuteMinder::$anonfun$4);
        int now = ai.current().decrementAndGet();
        if (now < 0) {
            ((LoggingMixin)this).log().warn(() -> AbstractMinuteMinder.unload$$anonfun$1(s), Line$.MODULE$.apply(91), FullName$.MODULE$.apply("com.elixirtech.arch.AbstractMinuteMinder.unload"));
            ai.current().set(0);
            return;
        }
    }

    public void gauge(String s, int value) {
        Load ai = (Load)this.loadMap().getOrElseUpdate((Object)s, AbstractMinuteMinder::$anonfun$5);
        ai.current().set(value);
        if (value > ai.max().get()) {
            ai.max().set(value);
            return;
        }
    }

    public void timing(String s, long elapsed) {
        Timing t = (Timing)this.timingMap().getOrElseUpdate((Object)s, AbstractMinuteMinder::$anonfun$6);
        t.total().addAndGet(elapsed);
        t.count().incrementAndGet();
    }

    public <T> T doLoad(String s, Function0<T> fn) {
        Object object;
        this.load(s);
        try {
            object = fn.apply();
        }
        finally {
            this.unload(s);
        }
        return (T)object;
    }

    public void output() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)this.bumpMap().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                AtomicInteger count = (AtomicInteger)tuple2._2();
                return AbstractMinuteMinder$Line$.MODULE$.count(line, count.getAndSet(0));
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.apply(Line.class)));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$2 -> _$2.value() > 0));
        Object[] bumpPairs = (Line[])ArrayOps$.MODULE$.sortBy$extension(object2, (Function1 & Serializable)_$3 -> _$3.name(), (Ordering)Ordering.String$.MODULE$);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)this.loadMap().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                Load load = (Load)tuple2._2();
                return AbstractMinuteMinder$Line$.MODULE$.load(line, load.max().getAndSet(load.current().get()));
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.apply(Line.class)));
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object3, (Function1 & Serializable)_$4 -> _$4.value() > 0));
        Line[] loadPairs = (Line[])ArrayOps$.MODULE$.sortBy$extension(object4, (Function1 & Serializable)_$5 -> _$5.name(), (Ordering)Ordering.String$.MODULE$);
        Object object5 = Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)this.timingMap().flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String line = (String)tuple2._1();
                Timing timing = (Timing)tuple2._2();
                int count = timing.count().getAndSet(0);
                if (count > 0) {
                    return Some$.MODULE$.apply((Object)AbstractMinuteMinder$Line$.MODULE$.timing(line, (int)(timing.total().getAndSet(0L) / (long)count)));
                }
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.apply(Line.class)));
        Line[] timingPairs = (Line[])ArrayOps$.MODULE$.sortBy$extension(object5, (Function1 & Serializable)_$6 -> _$6.name(), (Ordering)Ordering.String$.MODULE$);
        Object object6 = Predef$.MODULE$.refArrayOps(bumpPairs);
        Object object7 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(object6, (Object)loadPairs, ClassTag$.MODULE$.apply(Line.class)));
        Object object8 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(object7, (Object)timingPairs, ClassTag$.MODULE$.apply(Line.class)));
        IndexedSeq pairs = ArrayOps$.MODULE$.toIndexedSeq$extension(object8);
        int serialId = this.serial().incrementAndGet();
        this.syncLog().info(() -> AbstractMinuteMinder.output$$anonfun$1(serialId), Line$.MODULE$.apply(141), FullName$.MODULE$.apply("com.elixirtech.arch.AbstractMinuteMinder.output"));
        this.outputDoc(this.buildDocument(serialId, (Seq<Line>)pairs));
    }

    public Document buildDocument(int serialId, Seq<Line> pairs) {
        long now = System.currentTimeMillis();
        BsonDocument doc = new BsonDocument();
        doc.append("run", (BsonValue)this.runValue());
        doc.append("minute", (BsonValue)new BsonInt32(serialId));
        doc.append("pid", (BsonValue)this.pid());
        DBUtils$.MODULE$.appendTimestamp(doc, now);
        this.pidMachine().foreach((Function1 & Serializable)s -> doc.append("pidMachine", (BsonValue)s));
        pairs.foreach((Function1 & Serializable)line -> doc.append(line.name(), (BsonValue)new BsonInt32(line.value())));
        return Document$.MODULE$.apply(doc);
    }

    private static final AtomicInteger $anonfun$1() {
        return new AtomicInteger(0);
    }

    private static final AtomicInteger $anonfun$2() {
        return new AtomicInteger(0);
    }

    private static final Load $anonfun$3() {
        return AbstractMinuteMinder$Load$.MODULE$.apply();
    }

    private static final Load $anonfun$4() {
        return AbstractMinuteMinder$Load$.MODULE$.apply();
    }

    private static final Object unload$$anonfun$1(String s$1) {
        return "Too many unloads for " + s$1;
    }

    private static final Load $anonfun$5() {
        return AbstractMinuteMinder$Load$.MODULE$.apply();
    }

    private static final Timing $anonfun$6() {
        return AbstractMinuteMinder$Timing$.MODULE$.apply();
    }

    private static final Object output$$anonfun$1(int serialId$1) {
        return BoxesRunTime.boxToInteger((int)serialId$1).toString();
    }

    public static final class Line
    implements Product,
    Serializable {
        private final String name;
        private final String lineType;
        private final int value;

        public static Line apply(String string, String string2, int n) {
            return AbstractMinuteMinder$Line$.MODULE$.apply(string, string2, n);
        }

        public static Line count(String string, int n) {
            return AbstractMinuteMinder$Line$.MODULE$.count(string, n);
        }

        public static Line fromProduct(Product product) {
            return AbstractMinuteMinder$Line$.MODULE$.fromProduct(product);
        }

        public static Line load(String string, int n) {
            return AbstractMinuteMinder$Line$.MODULE$.load(string, n);
        }

        public static Line timing(String string, int n) {
            return AbstractMinuteMinder$Line$.MODULE$.timing(string, n);
        }

        public static Line unapply(Line line) {
            return AbstractMinuteMinder$Line$.MODULE$.unapply(line);
        }

        public Line(String name, String lineType, int value) {
            this.name = name;
            this.lineType = lineType;
            this.value = value;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.lineType()));
            n = Statics.mix((int)n, (int)this.value());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Line)) return false;
            Line line = (Line)object;
            if (this.value() != line.value()) return false;
            String string = this.name();
            String string2 = line.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.lineType();
            String string4 = line.lineType();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Line;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Line";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "lineType";
                }
                case 2: {
                    return "value";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String lineType() {
            return this.lineType;
        }

        public int value() {
            return this.value;
        }

        public Line copy(String name, String lineType, int value) {
            return new Line(name, lineType, value);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.lineType();
        }

        public int copy$default$3() {
            return this.value();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.lineType();
        }

        public int _3() {
            return this.value();
        }
    }

    public static final class Load
    implements Product,
    Serializable {
        private final AtomicInteger current;
        private final AtomicInteger max;

        public static Load apply() {
            return AbstractMinuteMinder$Load$.MODULE$.apply();
        }

        public static Load apply(AtomicInteger atomicInteger, AtomicInteger atomicInteger2) {
            return AbstractMinuteMinder$Load$.MODULE$.apply(atomicInteger, atomicInteger2);
        }

        public static Load fromProduct(Product product) {
            return AbstractMinuteMinder$Load$.MODULE$.fromProduct(product);
        }

        public static Load unapply(Load load) {
            return AbstractMinuteMinder$Load$.MODULE$.unapply(load);
        }

        public Load(AtomicInteger current, AtomicInteger max) {
            this.current = current;
            this.max = max;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Load)) return false;
            Load load = (Load)object;
            if (!BoxesRunTime.equals((Object)this.current(), (Object)load.current())) return false;
            if (!BoxesRunTime.equals((Object)this.max(), (Object)load.max())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Load;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Load";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "current";
            }
            if (1 == n2) {
                return "max";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AtomicInteger current() {
            return this.current;
        }

        public AtomicInteger max() {
            return this.max;
        }

        public Load copy(AtomicInteger current, AtomicInteger max) {
            return new Load(current, max);
        }

        public AtomicInteger copy$default$1() {
            return this.current();
        }

        public AtomicInteger copy$default$2() {
            return this.max();
        }

        public AtomicInteger _1() {
            return this.current();
        }

        public AtomicInteger _2() {
            return this.max();
        }
    }

    public static final class Timing
    implements Product,
    Serializable {
        private final AtomicLong total;
        private final AtomicInteger count;

        public static Timing apply() {
            return AbstractMinuteMinder$Timing$.MODULE$.apply();
        }

        public static Timing apply(AtomicLong atomicLong, AtomicInteger atomicInteger) {
            return AbstractMinuteMinder$Timing$.MODULE$.apply(atomicLong, atomicInteger);
        }

        public static Timing fromProduct(Product product) {
            return AbstractMinuteMinder$Timing$.MODULE$.fromProduct(product);
        }

        public static Timing unapply(Timing timing) {
            return AbstractMinuteMinder$Timing$.MODULE$.unapply(timing);
        }

        public Timing(AtomicLong total, AtomicInteger count) {
            this.total = total;
            this.count = count;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Timing)) return false;
            Timing timing = (Timing)object;
            if (!BoxesRunTime.equals((Object)this.total(), (Object)timing.total())) return false;
            if (!BoxesRunTime.equals((Object)this.count(), (Object)timing.count())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Timing;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Timing";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "total";
            }
            if (1 == n2) {
                return "count";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AtomicLong total() {
            return this.total;
        }

        public AtomicInteger count() {
            return this.count;
        }

        public Timing copy(AtomicLong total, AtomicInteger count) {
            return new Timing(total, count);
        }

        public AtomicLong copy$default$1() {
            return this.total();
        }

        public AtomicInteger copy$default$2() {
            return this.count();
        }

        public AtomicLong _1() {
            return this.total();
        }

        public AtomicInteger _2() {
            return this.count();
        }
    }
}

