/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.DefaultLogging$;
import com.elixirtech.arch.HttpClientResponse;
import com.elixirtech.arch.HttpClientResponse$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import io.circe.Json$;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.client5.http.fluent.Response;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class HttpClientRequest$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HttpClientRequest$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final Charset UTF_8;
    private static final byte[] EmptyBytes;
    private static final Json EmptyJson;
    public static final HttpClientRequest$ MODULE$;

    private HttpClientRequest$() {
    }

    static {
        MODULE$ = new HttpClientRequest$();
        UTF_8 = StandardCharsets.UTF_8;
        EmptyBytes = new byte[0];
        EmptyJson = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HttpClientRequest$.class);
    }

    public Charset UTF_8() {
        return UTF_8;
    }

    public byte[] EmptyBytes() {
        return EmptyBytes;
    }

    public Json EmptyJson() {
        return EmptyJson;
    }

    public void main(String[] args) {
        DefaultLogging$.MODULE$.init();
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"hello");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"world");
        HttpClientResponse ret = this.post("https://crookbarrow:1740/etl/endpoint/Endpoint/Http%20headers", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), this.post$default$3());
        Predef$.MODULE$.println((Object)ret);
    }

    public HttpClientResponse get(String uriString, Map<String, String> data, Map<String, String> headers) {
        Either<LogMessage, URIBuilder> either = this.buildURI(uriString);
        if (either instanceof Right) {
            URIBuilder uriBuilder = (URIBuilder)((Right)either).value();
            data.foreach((Function1 & Serializable)kv -> uriBuilder.addParameter((String)kv._1(), (String)kv._2()));
            URI uri = uriBuilder.build();
            Request request = Request.get((URI)uri);
            headers.foreach((Function1 & Serializable)kv -> request.addHeader((String)kv._1(), (String)kv._2()));
            return this.buildResponse(this.execute(uri, request));
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            this.log().apply(msg, Line$.MODULE$.apply(46), FullName$.MODULE$.apply("com.elixirtech.arch.HttpClientRequest.get"));
            throw new RuntimeException("HttpClientRequest get failed: " + msg.msg());
        }
        throw new MatchError(either);
    }

    public Map<String, String> get$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> get$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Task<HttpClientResponse> getT(String uriString, Map<String, String> data, Map<String, String> headers) {
        Task task = Task$.MODULE$.apply(() -> HttpClientRequest$.$anonfun$1(uriString, data, headers));
        return task.executeOn((Scheduler)Scheduler$.MODULE$.io(Scheduler$.MODULE$.io$default$1(), Scheduler$.MODULE$.io$default$2(), Scheduler$.MODULE$.io$default$3(), Scheduler$.MODULE$.io$default$4()), task.executeOn$default$2());
    }

    public Map<String, String> getT$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> getT$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public HttpClientResponse post(String uriString, Map<String, String> data, Map<String, String> headers) {
        Either<LogMessage, URIBuilder> either = this.buildURI(uriString);
        if (either instanceof Right) {
            URIBuilder uriBuilder = (URIBuilder)((Right)either).value();
            URI uri = uriBuilder.build();
            scala.collection.immutable.Iterable nameValuePairs = (scala.collection.immutable.Iterable)data.map((Function1 & Serializable)kv -> new BasicNameValuePair((String)kv._1(), (String)kv._2()));
            Request request = Request.post((URI)uri).bodyForm(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)nameValuePairs).asJava());
            headers.foreach((Function1 & Serializable)kv -> request.addHeader((String)kv._1(), (String)kv._2()));
            return this.buildResponse(this.execute(uri, request));
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            this.log().apply(msg, Line$.MODULE$.apply(64), FullName$.MODULE$.apply("com.elixirtech.arch.HttpClientRequest.post"));
            throw new RuntimeException("HttpClientRequest post failed: " + msg.msg());
        }
        throw new MatchError(either);
    }

    public Map<String, String> post$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> post$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public HttpClientResponse postJson(String uriString, Json json, Map<String, String> headers) {
        Either<LogMessage, URIBuilder> either = this.buildURI(uriString);
        if (either instanceof Right) {
            URIBuilder uriBuilder = (URIBuilder)((Right)either).value();
            URI uri = uriBuilder.build();
            Request request = Request.post((URI)uri).bodyString(json.spaces2(), ContentType.APPLICATION_JSON);
            headers.foreach((Function1 & Serializable)kv -> request.addHeader((String)kv._1(), (String)kv._2()));
            return this.buildResponse(this.execute(uri, request));
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            this.log().apply(msg, Line$.MODULE$.apply(77), FullName$.MODULE$.apply("com.elixirtech.arch.HttpClientRequest.postJson"));
            throw new RuntimeException("HttpClientRequest postJson failed: " + msg.msg());
        }
        throw new MatchError(either);
    }

    public Json postJson$default$2() {
        return this.EmptyJson();
    }

    public Map<String, String> postJson$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Task<HttpClientResponse> postT(String uriString, Map<String, String> data, Map<String, String> headers) {
        Task task = Task$.MODULE$.apply(() -> HttpClientRequest$.$anonfun$3(uriString, data, headers));
        return task.executeOn((Scheduler)Scheduler$.MODULE$.io(Scheduler$.MODULE$.io$default$1(), Scheduler$.MODULE$.io$default$2(), Scheduler$.MODULE$.io$default$3(), Scheduler$.MODULE$.io$default$4()), task.executeOn$default$2());
    }

    public Map<String, String> postT$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> postT$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Task<HttpClientResponse> postJsonT(String uriString, Json json, Map<String, String> headers) {
        Task task = Task$.MODULE$.apply(() -> HttpClientRequest$.$anonfun$4(uriString, json, headers));
        return task.executeOn((Scheduler)Scheduler$.MODULE$.io(Scheduler$.MODULE$.io$default$1(), Scheduler$.MODULE$.io$default$2(), Scheduler$.MODULE$.io$default$3(), Scheduler$.MODULE$.io$default$4()), task.executeOn$default$2());
    }

    public Json postJsonT$default$2() {
        return this.EmptyJson();
    }

    public Map<String, String> postJsonT$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public HttpClientResponse buildResponse(Response response) {
        HttpResponse ret = response.returnResponse();
        Object object = Predef$.MODULE$.refArrayOps((Object[])ret.getHeaders());
        return HttpClientResponse$.MODULE$.apply(ret.getCode(), (byte[])this.getEntity(ret).getOrElse(HttpClientRequest$::buildResponse$$anonfun$1), (Map<String, String>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)h -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.getValue());
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Option<byte[]> getEntity(HttpResponse response) {
        HttpResponse httpResponse = response;
        if (httpResponse instanceof HttpEntityContainer) {
            HttpEntityContainer c = (HttpEntityContainer)httpResponse;
            return Option$.MODULE$.apply((Object)c.getEntity()).map((Function1 & Serializable)e -> {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                e.getContent().transferTo(baos);
                return baos.toByteArray();
            });
        }
        return None$.MODULE$;
    }

    public Either<LogMessage, URIBuilder> buildURI(String uriString) {
        Try try_ = Try$.MODULE$.apply(() -> HttpClientRequest$.buildURI$$anonfun$1(uriString));
        if (try_ instanceof Success) {
            URIBuilder uriBuilder = (URIBuilder)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)uriBuilder);
        }
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof URISyntaxException) {
                URISyntaxException ex = (URISyntaxException)throwable;
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply(uriString + " " + ex));
            }
            Throwable ex = throwable;
            return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply(uriString + " " + ex, ex));
        }
        throw new MatchError((Object)try_);
    }

    public Response execute(URI uri, Request request) {
        return request.execute();
    }

    private static final HttpClientResponse $anonfun$1(String uriString$1, Map data$1, Map headers$1) {
        return MODULE$.get(uriString$1, (Map<String, String>)data$1, (Map<String, String>)headers$1);
    }

    private static final HttpClientResponse $anonfun$3(String uriString$2, Map data$2, Map headers$2) {
        return MODULE$.post(uriString$2, (Map<String, String>)data$2, (Map<String, String>)headers$2);
    }

    private static final HttpClientResponse $anonfun$4(String uriString$3, Json json$1, Map headers$3) {
        return MODULE$.postJson(uriString$3, json$1, (Map<String, String>)headers$3);
    }

    private static final byte[] buildResponse$$anonfun$1() {
        return MODULE$.EmptyBytes();
    }

    private static final URIBuilder buildURI$$anonfun$1(String uriString$4) {
        return new URIBuilder(uriString$4);
    }
}

