/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.bson;

import java.io.Serializable;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public interface BsonETL {
    public static Option get$(BsonETL $this, Document doc, String field) {
        return $this.get(doc, field);
    }

    default public Option<BsonValue> get(Document doc, String field) {
        return this.get((BsonValue)doc.toBsonDocument(), (List<String>)Predef$.MODULE$.wrapRefArray((Object[])field.split("\\.")).toList());
    }

    public static Option getString$(BsonETL $this, Document doc, String field) {
        return $this.getString(doc, field);
    }

    default public Option<BsonString> getString(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
            BsonString bs = (BsonString)bsonValue;
            return Some$.MODULE$.apply((Object)bs);
        }
        return None$.MODULE$;
    }

    public static Option getStringList$(BsonETL $this, Document doc, String field) {
        return $this.getStringList(doc, field);
    }

    default public Option<List<BsonString>> getStringList(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonArray) {
            BsonArray bs = (BsonArray)bsonValue;
            return Some$.MODULE$.apply((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(bs.getValues()).asScala().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(BsonValue x) {
                    BsonValue bsonValue = x;
                    if (bsonValue instanceof BsonString) {
                        BsonString bs = (BsonString)bsonValue;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(BsonValue x, Function1 function1) {
                    BsonValue bsonValue = x;
                    if (bsonValue instanceof BsonString) {
                        BsonString bs = (BsonString)bsonValue;
                        return bs;
                    }
                    return function1.apply((Object)x);
                }
            })).toList());
        }
        return None$.MODULE$;
    }

    public static Option getBytes$(BsonETL $this, Document doc, String field) {
        return $this.getBytes(doc, field);
    }

    default public Option<BsonBinary> getBytes(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonBinary) {
            BsonBinary bs = (BsonBinary)bsonValue;
            return Some$.MODULE$.apply((Object)bs);
        }
        return None$.MODULE$;
    }

    public static Option getInt32$(BsonETL $this, Document doc, String field) {
        return $this.getInt32(doc, field);
    }

    default public Option<BsonInt32> getInt32(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonInt32) {
            BsonInt32 bs = (BsonInt32)bsonValue;
            return Some$.MODULE$.apply((Object)bs);
        }
        return None$.MODULE$;
    }

    public static Option getInt64$(BsonETL $this, Document doc, String field) {
        return $this.getInt64(doc, field);
    }

    default public Option<BsonInt64> getInt64(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonInt64) {
            BsonInt64 bs = (BsonInt64)bsonValue;
            return Some$.MODULE$.apply((Object)bs);
        }
        return None$.MODULE$;
    }

    public static Option getDouble$(BsonETL $this, Document doc, String field) {
        return $this.getDouble(doc, field);
    }

    default public Option<BsonDouble> getDouble(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonDouble) {
            BsonDouble bd = (BsonDouble)bsonValue;
            return Some$.MODULE$.apply((Object)bd);
        }
        return None$.MODULE$;
    }

    public static Option getDecimal$(BsonETL $this, Document doc, String field) {
        return $this.getDecimal(doc, field);
    }

    default public Option<BsonDecimal128> getDecimal(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonDecimal128) {
            BsonDecimal128 bd = (BsonDecimal128)bsonValue;
            return Some$.MODULE$.apply((Object)bd);
        }
        return None$.MODULE$;
    }

    public static Option getArray$(BsonETL $this, Document doc, String field) {
        return $this.getArray(doc, field);
    }

    default public Option<BsonArray> getArray(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonArray) {
            BsonArray ba = (BsonArray)bsonValue;
            return Some$.MODULE$.apply((Object)ba);
        }
        return None$.MODULE$;
    }

    public static Option getDocument$(BsonETL $this, Document doc, String field) {
        return $this.getDocument(doc, field);
    }

    default public Option<BsonDocument> getDocument(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonDocument) {
            BsonDocument bd = (BsonDocument)bsonValue;
            return Some$.MODULE$.apply((Object)bd);
        }
        return None$.MODULE$;
    }

    public static Option getDateTime$(BsonETL $this, Document doc, String field) {
        return $this.getDateTime(doc, field);
    }

    default public Option<BsonDateTime> getDateTime(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonDateTime) {
            BsonDateTime bs = (BsonDateTime)bsonValue;
            return Some$.MODULE$.apply((Object)bs);
        }
        return None$.MODULE$;
    }

    public static Option getBoolean$(BsonETL $this, Document doc, String field) {
        return $this.getBoolean(doc, field);
    }

    default public Option<BsonBoolean> getBoolean(Document doc, String field) {
        BsonValue bsonValue;
        Option<BsonValue> option = this.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonBoolean) {
            BsonBoolean bs = (BsonBoolean)bsonValue;
            return Some$.MODULE$.apply((Object)bs);
        }
        return None$.MODULE$;
    }

    public static Option get$(BsonETL $this, BsonValue bson, List field) {
        return $this.get(bson, (List<String>)field);
    }

    default public Option<BsonValue> get(BsonValue bson, List<String> field) {
        List<String> list = field;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Some$.MODULE$.apply((Object)bson);
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list3 = colon2.next$access$1();
            if ("length".equals(string)) {
                Nil$ nil$2 = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null) && bson.isArray()) {
                    return Some$.MODULE$.apply((Object)BsonInt32$.MODULE$.apply(bson.asArray().size()));
                }
            }
            String head = string;
            List tail = list3;
            return this.descend(bson, head).flatMap((Function1 & Serializable)child -> this.get((BsonValue)child, (List<String>)tail));
        }
        throw new MatchError(list);
    }

    public static Document put$(BsonETL $this, Document doc, String field, BsonValue value) {
        return $this.put(doc, field, value);
    }

    default public Document put(Document doc, String field, BsonValue value) {
        return this.put(doc, (List<String>)Predef$.MODULE$.wrapRefArray((Object[])field.split("\\.")).toList(), value);
    }

    public static Document put$(BsonETL $this, Document doc, List field, BsonValue value) {
        return $this.put(doc, (List<String>)field, value);
    }

    default public Document put(Document doc, List<String> field, BsonValue value) {
        List<String> list = field;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return doc;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list3 = colon2.next$access$1();
            String head = string;
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)this.safeFieldName(head));
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)value), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
            String head2 = string;
            List tail = list3;
            BsonDocument child = (BsonDocument)doc.get(head2, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).getOrElse(BsonETL::$anonfun$1);
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)head2);
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.put(Document$.MODULE$.apply(child), (List<String>)tail, value)), (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
            return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        throw new MatchError(list);
    }

    public static Document remove$(BsonETL $this, Document doc, String field) {
        return $this.remove(doc, field);
    }

    default public Document remove(Document doc, String field) {
        return this.remove(doc, (List<String>)Predef$.MODULE$.wrapRefArray((Object[])field.split("\\.")).toList());
    }

    public static Document remove$(BsonETL $this, Document doc, List field) {
        return $this.remove(doc, (List<String>)field);
    }

    default public Document remove(Document doc, List<String> field) {
        List<String> list = field;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return doc;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list3 = colon2.next$access$1();
            String head = string;
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                return (Document)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{head}));
            }
            String head2 = string;
            List tail = list3;
            Option optChild = doc.get(head2, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class));
            return (Document)optChild.map((Function1 & Serializable)child -> {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)head2);
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.remove(Document$.MODULE$.apply(child), (List<String>)tail)), (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
                return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }).getOrElse(() -> BsonETL.remove$$anonfun$2(doc));
        }
        throw new MatchError(list);
    }

    public static String safeFieldName$(BsonETL $this, String part) {
        return $this.safeFieldName(part);
    }

    default public String safeFieldName(String part) {
        if (part.startsWith("$")) {
            return "<dollar>" + part.substring(1);
        }
        return part;
    }

    public static Option descend$(BsonETL $this, BsonValue bson, String field) {
        return $this.descend(bson, field);
    }

    default public Option<BsonValue> descend(BsonValue bson, String field) {
        BsonValue bsonValue = bson;
        if (bsonValue instanceof BsonDocument) {
            BsonDocument doc = (BsonDocument)bsonValue;
            return Option$.MODULE$.apply((Object)doc.get((Object)field));
        }
        return None$.MODULE$;
    }

    public static Option descendDoc$(BsonETL $this, Document doc, String name) {
        return $this.descendDoc(doc, name);
    }

    default public Option<BsonDocument> descendDoc(Document doc, String name) {
        return doc.get(name, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class));
    }

    public static Document deepMerge$(BsonETL $this, Document a, Document b) {
        return $this.deepMerge(a, b);
    }

    default public Document deepMerge(Document a, Document b) {
        Iterator nb = b.iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String s = (String)tuple2._1();
                BsonValue v = (BsonValue)tuple2._2();
                BsonValue bsonValue = v;
                if (bsonValue instanceof BsonDocument) {
                    BsonDocument c = (BsonDocument)bsonValue;
                    return (Tuple2)a.get(s, DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)na -> {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)s);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.deepMerge((BsonDocument)na, c));
                    }).getOrElse(() -> BsonETL.$anonfun$2$$anonfun$2(s, c));
                }
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)s);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
            }
            throw new MatchError((Object)tuple2);
        });
        return a.$plus$plus((IterableOnce)nb);
    }

    public static BsonDocument deepMerge$(BsonETL $this, BsonDocument a, BsonDocument b) {
        return $this.deepMerge(a, b);
    }

    default public BsonDocument deepMerge(BsonDocument a, BsonDocument b) {
        return this.deepMerge(Document$.MODULE$.apply(a), Document$.MODULE$.apply(b)).toBsonDocument();
    }

    private static BsonDocument $anonfun$1() {
        return new BsonDocument();
    }

    private static Document remove$$anonfun$2(Document doc$2) {
        return doc$2;
    }

    private static Tuple2 $anonfun$2$$anonfun$2(String s$2, BsonDocument c$2) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)s$2);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)c$2);
    }
}

