/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.bson;

import com.elixirtech.bson.RichBson$;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RichBson {
    public static RichBson1 RichBson1(Document document) {
        return RichBson$.MODULE$.RichBson1(document);
    }

    public static RichBson2 RichBson2(BsonDocument bsonDocument) {
        return RichBson$.MODULE$.RichBson2(bsonDocument);
    }

    public static class RichBson1 {
        private final Document doc;

        public RichBson1(Document doc) {
            this.doc = doc;
        }

        public Option<String> extractString(String key) {
            BsonValue bsonValue;
            Option option = this.doc.get(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return Some$.MODULE$.apply((Object)s.getValue());
            }
            return None$.MODULE$;
        }

        public Option<String> extractObjectId(String key) {
            BsonValue bsonValue;
            Option option = this.doc.get(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonObjectId) {
                BsonObjectId s = (BsonObjectId)bsonValue;
                return Some$.MODULE$.apply((Object)s.getValue().toHexString());
            }
            return None$.MODULE$;
        }

        public Option<Object> extractBoolean(String key) {
            BsonValue bsonValue;
            Option option = this.doc.get(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonBoolean) {
                BsonBoolean i = (BsonBoolean)bsonValue;
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)i.getValue()));
            }
            return None$.MODULE$;
        }

        public Option<Object> extractInt(String key) {
            BsonValue bsonValue;
            Option option = this.doc.get(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonInt32) {
                BsonInt32 i = (BsonInt32)bsonValue;
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i.getValue()));
            }
            return None$.MODULE$;
        }

        public Option<Object> extractLong(String key) {
            Option option = this.doc.get(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option).value();
                if (bsonValue instanceof BsonInt32) {
                    BsonInt32 i = (BsonInt32)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(i.getValue())));
                }
                if (bsonValue instanceof BsonInt64) {
                    BsonInt64 i = (BsonInt64)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)i.getValue()));
                }
            }
            return None$.MODULE$;
        }

        public Option<Object> extractDouble(String key) {
            Option option = this.doc.get(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option).value();
                if (bsonValue instanceof BsonInt32) {
                    BsonInt32 i = (BsonInt32)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.int2Integer(i.getValue()).doubleValue()));
                }
                if (bsonValue instanceof BsonInt64) {
                    BsonInt64 i = (BsonInt64)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.long2Long(i.getValue()).doubleValue()));
                }
                if (bsonValue instanceof BsonDouble) {
                    BsonDouble i = (BsonDouble)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)i.getValue()));
                }
            }
            return None$.MODULE$;
        }

        public Option<List<BsonValue>> extractList(String key) {
            BsonValue bsonValue;
            Option option = this.doc.get(key, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonArray) {
                BsonArray a = (BsonArray)bsonValue;
                return Some$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(a.getValues()).asScala().toList());
            }
            return None$.MODULE$;
        }

        public Option<List<String>> extractStringList(String key) {
            return this.extractList(key).map(RichBson$::com$elixirtech$bson$RichBson$RichBson1$$_$extractStringList$$anonfun$1);
        }
    }

    public static class RichBson2 {
        private final BsonDocument doc;

        public RichBson2(BsonDocument doc) {
            this.doc = doc;
        }

        public Option<String> extractString(String key) {
            BsonValue bsonValue;
            Option option = Option$.MODULE$.apply((Object)this.doc.get((Object)key));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return Some$.MODULE$.apply((Object)s.getValue());
            }
            return None$.MODULE$;
        }

        public Option<String> extractObjectId(String key) {
            BsonValue bsonValue;
            Option option = Option$.MODULE$.apply((Object)this.doc.get((Object)key));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonObjectId) {
                BsonObjectId s = (BsonObjectId)bsonValue;
                return Some$.MODULE$.apply((Object)s.getValue().toHexString());
            }
            return None$.MODULE$;
        }

        public Option<Object> extractBoolean(String key) {
            BsonValue bsonValue;
            Option option = Option$.MODULE$.apply((Object)this.doc.get((Object)key));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonBoolean) {
                BsonBoolean i = (BsonBoolean)bsonValue;
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)i.getValue()));
            }
            return None$.MODULE$;
        }

        public Option<Object> extractInt(String key) {
            BsonValue bsonValue;
            Option option = Option$.MODULE$.apply((Object)this.doc.get((Object)key));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonInt32) {
                BsonInt32 i = (BsonInt32)bsonValue;
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i.getValue()));
            }
            return None$.MODULE$;
        }

        public Option<Object> extractLong(String key) {
            Option option = Option$.MODULE$.apply((Object)this.doc.get((Object)key));
            if (option instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option).value();
                if (bsonValue instanceof BsonInt32) {
                    BsonInt32 i = (BsonInt32)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(i.getValue())));
                }
                if (bsonValue instanceof BsonInt64) {
                    BsonInt64 i = (BsonInt64)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)i.getValue()));
                }
            }
            return None$.MODULE$;
        }

        public Option<Object> extractDouble(String key) {
            Option option = Option$.MODULE$.apply((Object)this.doc.get((Object)key));
            if (option instanceof Some) {
                BsonValue bsonValue = (BsonValue)((Some)option).value();
                if (bsonValue instanceof BsonInt32) {
                    BsonInt32 i = (BsonInt32)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.int2Integer(i.getValue()).doubleValue()));
                }
                if (bsonValue instanceof BsonInt64) {
                    BsonInt64 i = (BsonInt64)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Predef$.MODULE$.long2Long(i.getValue()).doubleValue()));
                }
                if (bsonValue instanceof BsonDouble) {
                    BsonDouble i = (BsonDouble)bsonValue;
                    return Some$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)i.getValue()));
                }
            }
            return None$.MODULE$;
        }

        public Option<List<BsonValue>> extractList(String key) {
            BsonValue bsonValue;
            Option option = Option$.MODULE$.apply((Object)this.doc.get((Object)key));
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonArray) {
                BsonArray a = (BsonArray)bsonValue;
                return Some$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala(a.getValues()).asScala().toList());
            }
            return None$.MODULE$;
        }

        public Option<List<String>> extractStringList(String key) {
            return this.extractList(key).map(RichBson$::com$elixirtech$bson$RichBson$RichBson2$$_$extractStringList$$anonfun$2);
        }
    }
}

