/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.codex.memory;

import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexDB$DeleteResult$;
import com.elixirtech.codex.CodexDB$InsertManyResult$;
import com.elixirtech.codex.CodexDB$InsertOneResult$;
import com.elixirtech.codex.CodexDB$UpdateResult$;
import com.elixirtech.codex.CodexException;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexIndex;
import com.elixirtech.codex.CodexIndex$;
import com.elixirtech.codex.CodexUpdate;
import com.elixirtech.codex.memory.FilterLogic;
import com.elixirtech.codex.memory.FindLogic$;
import com.elixirtech.codex.memory.InMemoryCodexCollection$;
import com.elixirtech.codex.memory.InMemoryCodexCollection$InsertManyState$;
import com.elixirtech.codex.memory.InMemoryCodexDB;
import com.elixirtech.codex.memory.InMemoryCodexDB$;
import com.elixirtech.codex.memory.InMemoryContent;
import com.elixirtech.codex.memory.InMemoryContent$;
import com.elixirtech.codex.memory.InMemoryIndexes;
import com.elixirtech.codex.memory.InMemoryIndexes$;
import com.elixirtech.codex.memory.UpdateLogic;
import com.elixirtech.mongodb.BsonETL$;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.execution.atomic.Atomic;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicBuilder;
import monix.execution.atomic.AtomicBuilder$;
import monix.execution.atomic.AtomicLong;
import monix.execution.atomic.AtomicLong$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.schedulers.SchedulerService;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.apache.commons.io.FileUtils;
import org.bson.BsonDateTime;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class InMemoryCodexCollection
implements CodexCollection {
    private final InMemoryCodexDB db;
    private final InMemoryCodexDB.CltnInfo cltnInfo;
    private final SchedulerService myThread;
    private final String uuid;
    private final InMemoryContentHolder holder;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(InMemoryCodexCollection$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(InMemoryCodexCollection$.class.getDeclaredField("DebugCollections$lzy1"));

    public static Set<String> DebugCollections() {
        return InMemoryCodexCollection$.MODULE$.DebugCollections();
    }

    public static String docToJson(Document document) {
        return InMemoryCodexCollection$.MODULE$.docToJson(document);
    }

    public static LoggingInterface log() {
        return InMemoryCodexCollection$.MODULE$.log();
    }

    public InMemoryCodexCollection(InMemoryCodexDB db, InMemoryCodexDB.CltnInfo cltnInfo, Option<InMemoryContent> optContent, Option<InMemoryIndexes> optIndexes) {
        this.db = db;
        this.cltnInfo = cltnInfo;
        this.myThread = Scheduler$.MODULE$.singleThread(cltnInfo.name(), Scheduler$.MODULE$.singleThread$default$2(), Scheduler$.MODULE$.singleThread$default$3(), Scheduler$.MODULE$.singleThread$default$4());
        this.uuid = UUID.randomUUID().toString();
        InMemoryCodexCollection$.MODULE$.log().info(() -> this.$init$$$anonfun$1(cltnInfo), Line$.MODULE$.apply(111), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection"));
        this.holder = new InMemoryContentHolder(this.uuid, this.isDebug(), optContent, optIndexes);
    }

    public InMemoryCodexDB.CltnInfo cltnInfo() {
        return this.cltnInfo;
    }

    public Task<BoxedUnit> expireOldDocuments() {
        Task task = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$1();
            return BoxedUnit.UNIT;
        });
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    public Vector<CodexIndex> getIndexes() {
        return this.holder.indexes();
    }

    @Override
    public Task<Object> countDocumentsT() {
        return Task$.MODULE$.apply(this::countDocumentsT$$anonfun$1);
    }

    @Override
    public Task<Object> countDocumentsT(CodexFilter filter) {
        return Task$.MODULE$.apply(() -> this.countDocumentsT$$anonfun$2(filter));
    }

    @Override
    public Task<BoxedUnit> createIndexT(CodexIndex ci) {
        if (this.holder.indexes().contains((Object)ci)) {
            return Task$.MODULE$.unit();
        }
        Task task = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$3(ci);
            return BoxedUnit.UNIT;
        });
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<CodexDB.DeleteResult> deleteOneT(CodexFilter filter) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$4(filter));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<CodexDB.DeleteResult> deleteManyT(CodexFilter filter) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$6(filter));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Observable<BsonValue> distinctO(String fieldName) {
        return Observable$.MODULE$.fromIterable((Iterable)((SeqOps)this.holder.records().flatMap((Function1 & Serializable)_$1 -> _$1.get(fieldName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)))).distinct());
    }

    @Override
    public Observable<BsonValue> distinctO(String fieldName, CodexFilter filter) {
        FilterLogic test = new FilterLogic(filter);
        return Observable$.MODULE$.fromIterable((Iterable)((SeqOps)((StrictOptimizedIterableOps)this.holder.records().filter((Function1 & Serializable)doc -> test.matches((Document)doc))).flatMap((Function1 & Serializable)_$2 -> _$2.get(fieldName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)))).distinct());
    }

    @Override
    public Task<BoxedUnit> dropT() {
        Task task = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$8();
            return BoxedUnit.UNIT;
        });
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<BoxedUnit> dropIndexT(CodexIndex ci) {
        Task task = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$9(ci);
            return BoxedUnit.UNIT;
        });
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<BoxedUnit> dropIndexesT() {
        Task task = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$10();
            return BoxedUnit.UNIT;
        });
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Observable<Document> findO() {
        return Observable$.MODULE$.fromIterable(this.holder.records());
    }

    @Override
    public Observable<Document> findO(CodexFindOptions options) {
        return Observable$.MODULE$.fromIterable(FindLogic$.MODULE$.apply(this.holder.records(), options));
    }

    @Override
    public Observable<Document> findO(CodexFilter filter) {
        FilterLogic test = new FilterLogic(filter);
        return this.findO().filter((Function1 & Serializable)doc -> test.matches((Document)doc));
    }

    @Override
    public Observable<Document> findO(CodexFilter filter, CodexFindOptions options) {
        FilterLogic test = new FilterLogic(filter);
        return Observable$.MODULE$.fromIterable(FindLogic$.MODULE$.apply((Vector<Document>)((Vector)this.holder.records().filter((Function1 & Serializable)doc -> test.matches((Document)doc))), options));
    }

    @Override
    public Observable<Document> findOneO(CodexFilter filter) {
        FilterLogic test = new FilterLogic(filter);
        return this.findO().filter((Function1 & Serializable)doc -> test.matches((Document)doc)).take(1L);
    }

    @Override
    public Task<Option<Document>> findOneAndUpdateT(CodexFilter filter, CodexUpdate update) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$11(filter, update));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2()).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                InMemoryCodexCollection$.MODULE$.log().error(() -> InMemoryCodexCollection.com$elixirtech$codex$memory$InMemoryCodexCollection$$anon$2$$_$applyOrElse$$anonfun$1(x), x, Line$.MODULE$.apply(234), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.findOneAndUpdateT"));
                return None$.MODULE$;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$elixirtech$codex$memory$InMemoryCodexCollection$$anon$2$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    @Override
    public Task<Option<Document>> findOneAndUpdateT(CodexFilter filter, CodexUpdate update, CodexFindOptions.Sort sort) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$13(filter, update, sort));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2()).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                InMemoryCodexCollection$.MODULE$.log().error(() -> InMemoryCodexCollection.com$elixirtech$codex$memory$InMemoryCodexCollection$$anon$3$$_$applyOrElse$$anonfun$2(x), x, Line$.MODULE$.apply(256), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.findOneAndUpdateT"));
                return None$.MODULE$;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$elixirtech$codex$memory$InMemoryCodexCollection$$anon$3$$_$applyOrElse$$anonfun$2(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    @Override
    public Task<CodexDB.InsertOneResult> insertOneT(Document doc) {
        Task task = Task$.MODULE$.apply(this::$anonfun$14).flatMap((Function1 & Serializable)init -> this.insertOneQuietlyT((InsertManyState)init, doc).flatMap((Function1 & Serializable)ret -> Task$.MODULE$.apply(() -> this.$anonfun$15$$anonfun$1$$anonfun$1(ret)).map((Function1 & Serializable)result -> result)));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<CodexDB.InsertManyResult> insertManyT(Seq<Document> docs) {
        Task task = docs.nonEmpty() ? Task$.MODULE$.apply(this::$anonfun$16).flatMap((Function1 & Serializable)init -> this.insertManyListT((InsertManyState)init, (List<Document>)docs.toList()).map((Function1 & Serializable)list -> CodexDB$InsertManyResult$.MODULE$.apply((List<Option<BsonValue>>)list)).map((Function1 & Serializable)result -> result)) : Task$.MODULE$.now((Object)CodexDB$InsertManyResult$.MODULE$.apply((List<Option<BsonValue>>)package$.MODULE$.Nil()));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<CodexDB.UpdateResult> replaceOneT(CodexFilter filter, Document doc) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$18(filter, doc));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<CodexDB.UpdateResult> upsertOneT(CodexFilter filter, Document doc) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$20(filter, doc));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<Document> upsertOneAndReturnT(CodexFilter filter, CodexUpdate update) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$22(filter, update));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<CodexDB.UpdateResult> updateOneT(CodexFilter filter, CodexUpdate update) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$24(filter, update));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    @Override
    public Task<CodexDB.UpdateResult> updateManyT(CodexFilter filter, CodexUpdate update) {
        Task task = Task$.MODULE$.apply(() -> this.$anonfun$26(filter, update));
        return task.executeOn((Scheduler)this.myThread, task.executeOn$default$2());
    }

    private boolean hasExpired(String field, long now, Document doc) {
        BsonValue bsonValue;
        Option option = BsonETL$.MODULE$.get(doc, field);
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonDateTime) {
            BsonDateTime dt = (BsonDateTime)bsonValue;
            return dt.getValue() <= now;
        }
        return false;
    }

    private Task<InsertManyState> insertOneQuietlyT(InsertManyState in, Document doc) {
        return Task$.MODULE$.apply(() -> InMemoryCodexCollection.insertOneQuietlyT$$anonfun$1(doc, in));
    }

    private Task<List<Option<BsonValue>>> insertManyListT(InsertManyState in, List<Document> docs) {
        List<Document> list = docs;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Document> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.apply(() -> this.insertManyListT$$anonfun$1(in));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Document head = (Document)colon2.head();
            List tail = list3;
            return this.insertOneQuietlyT(in, head).flatMap((Function1 & Serializable)out -> this.insertManyListT((InsertManyState)out, (List<Document>)tail));
        }
        throw new MatchError(list);
    }

    private void saveContentChanges() {
        InMemoryCodexDB$.MODULE$.writeRecords(this.cltnInfo(), this.holder.records());
    }

    private void saveIndexChanges() {
        InMemoryCodexDB$.MODULE$.writeIndexes(this.cltnInfo(), (Vector<Document>)((Vector)this.holder.indexes().map((Function1 & Serializable)ci -> CodexIndex$.MODULE$.toDocument((CodexIndex)ci))));
    }

    private boolean isDebug() {
        return InMemoryCodexCollection$.MODULE$.isDebug(this.cltnInfo().name());
    }

    private final Object $init$$$anonfun$1(InMemoryCodexDB.CltnInfo cltnInfo$1) {
        return "Created InMemoryCodexCollection " + cltnInfo$1.name() + " " + this.uuid;
    }

    private final void $anonfun$1() {
        long now = System.currentTimeMillis();
        Vector expiry = (Vector)this.holder.indexes().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(CodexIndex x) {
                CodexIndex codexIndex = x;
                if (codexIndex instanceof CodexIndex.ExpireAt) {
                    CodexIndex.ExpireAt ci = (CodexIndex.ExpireAt)codexIndex;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(CodexIndex x, Function1 function1) {
                CodexIndex codexIndex = x;
                if (codexIndex instanceof CodexIndex.ExpireAt) {
                    CodexIndex.ExpireAt ci = (CodexIndex.ExpireAt)codexIndex;
                    return ci;
                }
                return function1.apply((Object)x);
            }
        });
        int count = this.holder.records().size();
        Vector remainder = (Vector)expiry.foldLeft(this.holder.records(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Vector docs = (Vector)tuple2._1();
                CodexIndex.ExpireAt expireAt = (CodexIndex.ExpireAt)tuple2._2();
                return (Vector)docs.filterNot((Function1 & Serializable)doc -> this.hasExpired(expireAt.field(), now, (Document)doc));
            }
            throw new MatchError((Object)tuple2);
        });
        if (remainder.length() < count) {
            this.holder.setContent((Vector<Document>)remainder);
            return;
        }
    }

    private final long countDocumentsT$$anonfun$1() {
        return this.holder.records().length();
    }

    private final long countDocumentsT$$anonfun$2(CodexFilter filter$1) {
        FilterLogic test = new FilterLogic(filter$1);
        return this.holder.records().count((Function1 & Serializable)doc -> test.matches((Document)doc));
    }

    private final void $anonfun$3(CodexIndex ci$1) {
        this.holder.setIndexes((Vector<CodexIndex>)((Vector)this.holder.indexes().$colon$plus((Object)ci$1)));
        this.saveIndexChanges();
    }

    private final CodexDB.DeleteResult $anonfun$4(CodexFilter filter$2) {
        FilterLogic test = new FilterLogic(filter$2);
        int idx = this.holder.records().indexWhere((Function1 & Serializable)doc -> test.matches((Document)doc));
        if (idx >= 0) {
            this.holder.setContent((Vector<Document>)((Vector)this.holder.records().patch(idx, (IterableOnce)package$.MODULE$.Nil(), 1)));
            this.saveContentChanges();
            return CodexDB$DeleteResult$.MODULE$.apply(1L);
        }
        return CodexDB$DeleteResult$.MODULE$.apply(0L);
    }

    private final CodexDB.DeleteResult $anonfun$6(CodexFilter filter$3) {
        Vector remaining;
        FilterLogic test = new FilterLogic(filter$3);
        int initialLength = this.holder.records().length();
        int deleted = initialLength - (remaining = (Vector)this.holder.records().filterNot((Function1 & Serializable)doc -> test.matches((Document)doc))).length();
        if (deleted > 0) {
            this.holder.setContent((Vector<Document>)remaining);
            this.saveContentChanges();
        }
        return CodexDB$DeleteResult$.MODULE$.apply(Int$.MODULE$.int2long(deleted));
    }

    private final void $anonfun$8() {
        this.holder.setContent(InMemoryContent$.MODULE$.empty());
        this.saveContentChanges();
        if (this.cltnInfo().isTemp()) {
            this.db.uncache(this.cltnInfo());
            FileUtils.deleteDirectory((File)InMemoryCodexDB$.MODULE$.getDir(this.cltnInfo()));
            return;
        }
    }

    private final void $anonfun$9(CodexIndex ci$2) {
        this.holder.setIndexes((Vector<CodexIndex>)((Vector)this.holder.indexes().filterNot((Function1 & Serializable)_$3 -> {
            CodexIndex codexIndex = _$3;
            CodexIndex codexIndex2 = ci$2;
            return !(codexIndex != null ? !codexIndex.equals(codexIndex2) : codexIndex2 != null);
        })));
        this.saveIndexChanges();
    }

    private final void $anonfun$10() {
        this.holder.setIndexes(InMemoryIndexes$.MODULE$.apply((Vector<CodexIndex>)package$.MODULE$.Vector().empty()));
        this.saveIndexChanges();
    }

    private final Object $anonfun$11$$anonfun$1(int idx$1, Document docBefore$1) {
        return "findOneAndUpdate[" + idx$1 + "][hv=" + this.holder.version() + "] " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.uuid), 8) + " before: " + InMemoryCodexCollection$.MODULE$.docToJson(docBefore$1);
    }

    private final Object $anonfun$11$$anonfun$2(int idx$2, Document docAfter$1) {
        return "findOneAndUpdate[" + idx$2 + "][hv=" + this.holder.version() + "] " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.uuid), 8) + " after: " + InMemoryCodexCollection$.MODULE$.docToJson(docAfter$1);
    }

    private final Option $anonfun$11(CodexFilter filter$4, CodexUpdate update$1) {
        FilterLogic test = new FilterLogic(filter$4);
        UpdateLogic updater = new UpdateLogic(update$1);
        int idx = this.holder.records().indexWhere((Function1 & Serializable)doc -> test.matches((Document)doc));
        if (idx >= 0) {
            Document docBefore = (Document)this.holder.records().apply(idx);
            if (this.isDebug()) {
                InMemoryCodexCollection$.MODULE$.log().info(() -> this.$anonfun$11$$anonfun$1(idx, docBefore), Line$.MODULE$.apply(222), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.findOneAndUpdateT"));
            }
            Document docAfter = updater.update(docBefore);
            if (this.isDebug()) {
                InMemoryCodexCollection$.MODULE$.log().info(() -> this.$anonfun$11$$anonfun$2(idx, docAfter), Line$.MODULE$.apply(226), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.findOneAndUpdateT"));
            }
            this.holder.setContent((Vector<Document>)((Vector)this.holder.records().patch(idx, (IterableOnce)new .colon.colon((Object)docAfter, (List)Nil$.MODULE$), 1)));
            this.saveContentChanges();
            return Some$.MODULE$.apply((Object)docAfter);
        }
        return None$.MODULE$;
    }

    public static final Object com$elixirtech$codex$memory$InMemoryCodexCollection$$anon$2$$_$applyOrElse$$anonfun$1(Throwable x$1) {
        return "Error: " + x$1;
    }

    private final Object $anonfun$13$$anonfun$2$$anonfun$1(int idx$3, Document docBefore$2) {
        return "findOneAndUpdate[" + idx$3 + "][hv=" + this.holder.version() + "] " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.uuid), 8) + " before: " + InMemoryCodexCollection$.MODULE$.docToJson(docBefore$2);
    }

    private final Object $anonfun$13$$anonfun$2$$anonfun$2(int idx$4, Document docAfter$2) {
        return "findOneAndUpdate[" + idx$4 + "][hv=" + this.holder.version() + "] " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.uuid), 8) + " after: " + InMemoryCodexCollection$.MODULE$.docToJson(docAfter$2);
    }

    private final Option $anonfun$13(CodexFilter filter$5, CodexUpdate update$2, CodexFindOptions.Sort sort$1) {
        FilterLogic test = new FilterLogic(filter$5);
        UpdateLogic updater = new UpdateLogic(update$2);
        Vector<Document> sorted = FindLogic$.MODULE$.buildSorts(this.holder.records(), sort$1);
        return sorted.find((Function1 & Serializable)doc -> test.matches((Document)doc)).map((Function1 & Serializable)rec -> {
            int idx = this.holder.records().indexOf(rec);
            Document docBefore = (Document)this.holder.records().apply(idx);
            if (this.isDebug()) {
                InMemoryCodexCollection$.MODULE$.log().info(() -> this.$anonfun$13$$anonfun$2$$anonfun$1(idx, docBefore), Line$.MODULE$.apply(245), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.findOneAndUpdateT"));
            }
            Document docAfter = updater.update(docBefore);
            if (this.isDebug()) {
                InMemoryCodexCollection$.MODULE$.log().info(() -> this.$anonfun$13$$anonfun$2$$anonfun$2(idx, docAfter), Line$.MODULE$.apply(249), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.findOneAndUpdateT"));
            }
            this.holder.setContent((Vector<Document>)((Vector)this.holder.records().patch(idx, (IterableOnce)new .colon.colon((Object)docAfter, (List)Nil$.MODULE$), 1)));
            this.saveContentChanges();
            return docAfter;
        });
    }

    public static final Object com$elixirtech$codex$memory$InMemoryCodexCollection$$anon$3$$_$applyOrElse$$anonfun$2(Throwable x$2) {
        return "Error: " + x$2;
    }

    private final InsertManyState $anonfun$14() {
        return InMemoryCodexCollection$InsertManyState$.MODULE$.apply(this.holder.records(), (List<Option<BsonValue>>)package$.MODULE$.Nil());
    }

    private final CodexDB.InsertOneResult $anonfun$15$$anonfun$1$$anonfun$1(InsertManyState ret$1) {
        Option newId = ret$1.ids().headOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.holder.setContent(ret$1.records());
        this.saveContentChanges();
        return CodexDB$InsertOneResult$.MODULE$.apply((Option<BsonValue>)newId);
    }

    private final InsertManyState $anonfun$16() {
        return InMemoryCodexCollection$InsertManyState$.MODULE$.apply(this.holder.records(), (List<Option<BsonValue>>)package$.MODULE$.Nil());
    }

    private final Object $anonfun$18$$anonfun$1(int idx$5, Document doc2$1) {
        return "replaceOneT[" + idx$5 + "][hv=" + this.holder.version() + "] " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.uuid), 8) + " after: " + InMemoryCodexCollection$.MODULE$.docToJson(doc2$1);
    }

    private final CodexDB.UpdateResult $anonfun$18(CodexFilter filter$6, Document doc$2) {
        FilterLogic test = new FilterLogic(filter$6);
        int idx = this.holder.records().indexWhere((Function1 & Serializable)doc -> test.matches((Document)doc));
        if (idx >= 0) {
            Tuple2 tuple2;
            Option option = doc$2.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some) {
                BsonValue id = (BsonValue)((Some)option).value();
                tuple2 = Tuple2$.MODULE$.apply((Object)doc$2, (Object)id);
            } else if (None$.MODULE$.equals(option)) {
                BsonObjectId id = new BsonObjectId();
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                tuple2 = Tuple2$.MODULE$.apply(doc$2.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Object)id);
            } else {
                throw new MatchError((Object)option);
            }
            Tuple2 tuple22 = tuple2;
            Document doc2 = (Document)tuple22._1();
            if (this.isDebug()) {
                InMemoryCodexCollection$.MODULE$.log().info(() -> this.$anonfun$18$$anonfun$1(idx, doc2), Line$.MODULE$.apply(294), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.replaceOneT"));
            }
            this.holder.setContent((Vector<Document>)((Vector)this.holder.records().patch(idx, (IterableOnce)new .colon.colon((Object)doc2, (List)Nil$.MODULE$), 1)));
            this.saveContentChanges();
            return CodexDB$UpdateResult$.MODULE$.apply(1L, 1L, (Option<BsonValue>)None$.MODULE$);
        }
        return CodexDB$UpdateResult$.MODULE$.apply(0L, 0L, (Option<BsonValue>)None$.MODULE$);
    }

    private final Object $anonfun$20$$anonfun$1(int idx$6, Document doc2$2) {
        return "upsertOneT[" + idx$6 + "][hv=" + this.holder.version() + "] " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.uuid), 8) + " after: " + InMemoryCodexCollection$.MODULE$.docToJson(doc2$2);
    }

    private final CodexDB.UpdateResult $anonfun$20(CodexFilter filter$7, Document doc$3) {
        Tuple2 tuple2;
        FilterLogic test = new FilterLogic(filter$7);
        int idx = this.holder.records().indexWhere((Function1 & Serializable)doc -> test.matches((Document)doc));
        if (idx >= 0) {
            Tuple2 tuple22;
            Option option = doc$3.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            if (option instanceof Some) {
                BsonValue id = (BsonValue)((Some)option).value();
                tuple22 = Tuple2$.MODULE$.apply((Object)doc$3, (Object)id);
            } else if (None$.MODULE$.equals(option)) {
                BsonObjectId id = new BsonObjectId();
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                tuple22 = Tuple2$.MODULE$.apply(doc$3.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Object)id);
            } else {
                throw new MatchError((Object)option);
            }
            Tuple2 tuple23 = tuple22;
            Document doc2 = (Document)tuple23._1();
            if (this.isDebug()) {
                InMemoryCodexCollection$.MODULE$.log().info(() -> this.$anonfun$20$$anonfun$1(idx, doc2), Line$.MODULE$.apply(315), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.upsertOneT"));
            }
            this.holder.setContent((Vector<Document>)((Vector)this.holder.records().patch(idx, (IterableOnce)new .colon.colon((Object)doc2, (List)Nil$.MODULE$), 1)));
            this.saveContentChanges();
            return CodexDB$UpdateResult$.MODULE$.apply(1L, 1L, (Option<BsonValue>)None$.MODULE$);
        }
        Option option = doc$3.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue id = (BsonValue)((Some)option).value();
            tuple2 = Tuple2$.MODULE$.apply((Object)doc$3, (Object)id);
        } else if (None$.MODULE$.equals(option)) {
            BsonObjectId id = new BsonObjectId();
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            tuple2 = Tuple2$.MODULE$.apply(doc$3.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Object)id);
        } else {
            throw new MatchError((Object)option);
        }
        Tuple2 tuple24 = tuple2;
        Document docWithId = (Document)tuple24._1();
        BsonValue id = (BsonValue)tuple24._2();
        this.holder.setContent((Vector<Document>)((Vector)this.holder.records().$colon$plus((Object)docWithId)));
        this.saveContentChanges();
        return CodexDB$UpdateResult$.MODULE$.apply(0L, 0L, (Option<BsonValue>)Some$.MODULE$.apply((Object)id));
    }

    private final Object $anonfun$22$$anonfun$1(int idx$7, Document docAfter$3) {
        return "upsertOneAndReturnT[" + idx$7 + "][hv=" + this.holder.version() + "] " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.uuid), 8) + " after: " + InMemoryCodexCollection$.MODULE$.docToJson(docAfter$3);
    }

    private final Document $anonfun$22(CodexFilter filter$8, CodexUpdate update$3) {
        Document document;
        FilterLogic test = new FilterLogic(filter$8);
        UpdateLogic updater = new UpdateLogic(update$3);
        int idx = this.holder.records().indexWhere((Function1 & Serializable)doc -> test.matches((Document)doc));
        if (idx >= 0) {
            document = (Document)this.holder.records().apply(idx);
        } else {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new BsonObjectId()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            document = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        Document docBefore = document;
        Document docAfter = updater.update(docBefore);
        if (this.isDebug()) {
            InMemoryCodexCollection$.MODULE$.log().info(() -> this.$anonfun$22$$anonfun$1(idx, docAfter), Line$.MODULE$.apply(341), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.upsertOneAndReturnT"));
        }
        if (idx >= 0) {
            this.holder.setContent((Vector<Document>)((Vector)this.holder.records().patch(idx, (IterableOnce)new .colon.colon((Object)docAfter, (List)Nil$.MODULE$), 1)));
        } else {
            this.holder.setContent((Vector<Document>)((Vector)this.holder.records().$colon$plus((Object)docAfter)));
        }
        this.saveContentChanges();
        return docAfter;
    }

    private final Object $anonfun$24$$anonfun$1(int idx$8, Document docAfter$4) {
        return "updateOneT[" + idx$8 + "][hv=" + this.holder.version() + "] " + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(this.uuid), 8) + " after: " + InMemoryCodexCollection$.MODULE$.docToJson(docAfter$4);
    }

    private final CodexDB.UpdateResult $anonfun$24(CodexFilter filter$9, CodexUpdate update$4) {
        FilterLogic test = new FilterLogic(filter$9);
        UpdateLogic updater = new UpdateLogic(update$4);
        int idx = this.holder.records().indexWhere((Function1 & Serializable)doc -> test.matches((Document)doc));
        if (idx >= 0) {
            Document docBefore = (Document)this.holder.records().apply(idx);
            Document docAfter = updater.update(docBefore);
            if (this.isDebug()) {
                InMemoryCodexCollection$.MODULE$.log().info(() -> this.$anonfun$24$$anonfun$1(idx, docAfter), Line$.MODULE$.apply(357), FullName$.MODULE$.apply("com.elixirtech.codex.memory.InMemoryCodexCollection.updateOneT"));
            }
            this.holder.setContent((Vector<Document>)((Vector)this.holder.records().patch(idx, (IterableOnce)new .colon.colon((Object)docAfter, (List)Nil$.MODULE$), 1)));
            this.saveContentChanges();
            return CodexDB$UpdateResult$.MODULE$.apply(1L, 1L, (Option<BsonValue>)None$.MODULE$);
        }
        return CodexDB$UpdateResult$.MODULE$.apply(0L, 0L, (Option<BsonValue>)None$.MODULE$);
    }

    private final CodexDB.UpdateResult $anonfun$26(CodexFilter filter$10, CodexUpdate update$5) {
        IntRef count = IntRef.create((int)0);
        FilterLogic test = new FilterLogic(filter$10);
        UpdateLogic updater = new UpdateLogic(update$5);
        Vector newRecords = (Vector)this.holder.records().map((Function1 & Serializable)doc -> {
            if (test.matches((Document)doc)) {
                ++count$1.elem;
                return updater.update((Document)doc);
            }
            return doc;
        });
        this.holder.setContent((Vector<Document>)newRecords);
        this.saveContentChanges();
        return CodexDB$UpdateResult$.MODULE$.apply(Int$.MODULE$.int2long(count.elem), Int$.MODULE$.int2long(count.elem), (Option<BsonValue>)None$.MODULE$);
    }

    private static final InsertManyState insertOneQuietlyT$$anonfun$1(Document doc$4, InsertManyState in$1) {
        Option option = doc$4.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue id = (BsonValue)((Some)option).value();
            Some some = Some$.MODULE$.apply((Object)id);
            return InMemoryCodexCollection$InsertManyState$.MODULE$.apply((Vector<Document>)((Vector)in$1.records().$colon$plus((Object)doc$4)), (List<Option<BsonValue>>)in$1.ids().$colon$colon((Object)some));
        }
        if (None$.MODULE$.equals(option)) {
            BsonObjectId id = new BsonObjectId();
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            Some some = Some$.MODULE$.apply((Object)id);
            return InMemoryCodexCollection$InsertManyState$.MODULE$.apply((Vector<Document>)((Vector)in$1.records().$colon$plus(doc$4.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))), (List<Option<BsonValue>>)in$1.ids().$colon$colon((Object)some));
        }
        throw new MatchError((Object)option);
    }

    private final List insertManyListT$$anonfun$1(InsertManyState in$2) {
        this.holder.setContent(in$2.records());
        this.saveContentChanges();
        return in$2.ids().reverse();
    }

    public static class InMemoryContentHolder {
        private final Atomic<InMemoryContent> imContent;
        private final Atomic<InMemoryIndexes> imIndexes;
        private final AtomicLong auditIdx;

        public InMemoryContentHolder(String uuid, boolean isDebug, Option<InMemoryContent> initialContent, Option<InMemoryIndexes> initialIndexes) {
            InMemoryContent initialValue$proxy1 = (InMemoryContent)initialContent.getOrElse(this::$anonfun$28);
            AtomicBuilder builder$proxy1 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
            this.imContent = (AtomicAny)builder$proxy1.buildInstance((Object)initialValue$proxy1, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            InMemoryIndexes initialValue$proxy2 = (InMemoryIndexes)initialIndexes.getOrElse(this::$anonfun$29);
            AtomicBuilder builder$proxy2 = AtomicBuilder$.MODULE$.AtomicRefBuilder();
            this.imIndexes = (AtomicAny)builder$proxy2.buildInstance((Object)initialValue$proxy2, (PaddingStrategy)PaddingStrategy.NoPadding$.MODULE$, true);
            this.auditIdx = AtomicLong$.MODULE$.apply(0L);
        }

        public Vector<Document> records() {
            return ((InMemoryContent)this.imContent.get()).records();
        }

        public Vector<CodexIndex> indexes() {
            return ((InMemoryIndexes)this.imIndexes.get()).indexes();
        }

        public long version() {
            return this.auditIdx.get();
        }

        public void setContent(Vector<Document> recs) {
            this.setContent(InMemoryContent$.MODULE$.apply(recs));
        }

        public void setContent(InMemoryContent imc) {
            Either<String, BoxedUnit> either = ((InMemoryIndexes)this.imIndexes.get()).validate(imc);
            if (either instanceof Right) {
                this.auditIdx.increment(this.auditIdx.increment$default$1());
                Atomic<InMemoryContent> Atomic_this = this.imContent;
                Atomic_this.set((Object)imc);
                return;
            }
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                throw new CodexException(err);
            }
            throw new MatchError(either);
        }

        public void setIndexes(Vector<CodexIndex> idxs) {
            this.setIndexes(InMemoryIndexes$.MODULE$.apply(idxs));
        }

        public void setIndexes(InMemoryIndexes imi) {
            Either<String, BoxedUnit> either = imi.validate((InMemoryContent)this.imContent.get());
            if (either instanceof Right) {
                Atomic<InMemoryIndexes> Atomic_this = this.imIndexes;
                Atomic_this.set((Object)imi);
                return;
            }
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                throw new CodexException(err);
            }
            throw new MatchError(either);
        }

        private final InMemoryContent $anonfun$28() {
            return InMemoryContent$.MODULE$.empty();
        }

        private final InMemoryIndexes $anonfun$29() {
            return InMemoryIndexes$.MODULE$.empty();
        }
    }

    public static final class InsertManyState
    implements Product,
    Serializable {
        private final Vector records;
        private final List ids;

        public static InsertManyState apply(Vector<Document> vector, List<Option<BsonValue>> list) {
            return InMemoryCodexCollection$InsertManyState$.MODULE$.apply(vector, list);
        }

        public static InsertManyState fromProduct(Product product) {
            return InMemoryCodexCollection$InsertManyState$.MODULE$.fromProduct(product);
        }

        public static InsertManyState unapply(InsertManyState insertManyState) {
            return InMemoryCodexCollection$InsertManyState$.MODULE$.unapply(insertManyState);
        }

        public InsertManyState(Vector<Document> records, List<Option<BsonValue>> ids) {
            this.records = records;
            this.ids = ids;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InsertManyState)) return false;
            InsertManyState insertManyState = (InsertManyState)object;
            Vector<Document> vector = this.records();
            Vector<Document> vector2 = insertManyState.records();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            List<Option<BsonValue>> list = this.ids();
            List<Option<BsonValue>> list2 = insertManyState.ids();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InsertManyState;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "InsertManyState";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "records";
            }
            if (1 == n2) {
                return "ids";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Vector<Document> records() {
            return this.records;
        }

        public List<Option<BsonValue>> ids() {
            return this.ids;
        }

        public InsertManyState copy(Vector<Document> records, List<Option<BsonValue>> ids) {
            return new InsertManyState(records, ids);
        }

        public Vector<Document> copy$default$1() {
            return this.records();
        }

        public List<Option<BsonValue>> copy$default$2() {
            return this.ids();
        }

        public Vector<Document> _1() {
            return this.records();
        }

        public List<Option<BsonValue>> _2() {
            return this.ids();
        }
    }
}

