/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.imap;

import com.elixirtech.arch.HttpClientRequest$;
import com.elixirtech.arch.HttpClientResponse;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.imap.GMailReceiver$;
import com.elixirtech.imap.GMailReceiver$AccessToken$;
import com.elixirtech.imap.GMailReceiver$Reply$;
import com.elixirtech.imap.IMapReceiver;
import com.elixirtech.imap.IMapReceiver$IMapFolder$;
import com.elixirtech.imap.IMapUtils$;
import com.sun.mail.imap.IMAPFolder;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import java.io.Serializable;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class GMailReceiver
implements IMapReceiver,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(GMailReceiver.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Scheduler executionContext = Scheduler$.MODULE$.global();
    private final String host;
    private final String TOKEN_URL;
    private final String oauthUserName;
    private final String oauthClientId;
    private final String oauthSecret;
    private final String oauthRefreshToken;
    private AccessToken accessToken;

    public static String NAME() {
        return GMailReceiver$.MODULE$.NAME();
    }

    public static String UTF_8() {
        return GMailReceiver$.MODULE$.UTF_8();
    }

    public GMailReceiver(Config gmailConfig) {
        this.host = gmailConfig.getString("host");
        Config oauth2Config = gmailConfig.getConfig("oauth2");
        this.TOKEN_URL = "https://oauth2.googleapis.com/token";
        this.oauthUserName = oauth2Config.getString("userName");
        this.oauthClientId = oauth2Config.getString("clientId");
        this.oauthSecret = oauth2Config.getString("clientSecret");
        this.oauthRefreshToken = oauth2Config.getString("refreshToken");
        this.accessToken = GMailReceiver$AccessToken$.MODULE$.apply("", 0L);
    }

    @Override
    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler executionContext() {
        return this.executionContext;
    }

    @Override
    public Observable<IMapReceiver.IMapFolder> folders() {
        return this.ensureValidAccessToken().flatMap((Function1 & Serializable)x$1 -> {
            AccessToken accessToken = x$1;
            return this.getFolders().map((Function1 & Serializable)folders -> folders);
        });
    }

    public Observable<IMapReceiver.IMapFolder> getFolders() {
        Observable observable;
        try {
            Store store = this.getStore();
            Object[] folders = store.getDefaultFolder().list("*");
            Object object = Predef$.MODULE$.refArrayOps(folders);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)f -> IMapUtils$.MODULE$.isMessageHolder((Folder)f)));
            Object[] fs = (IMapReceiver.IMapFolder[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$1 -> {
                Folder folder = x$1;
                if (folder instanceof IMAPFolder) {
                    IMAPFolder f = (IMAPFolder)folder;
                    return Some$.MODULE$.apply((Object)IMapReceiver$IMapFolder$.MODULE$.apply(f.getFullName(), f.getMessageCount(), f.getUnreadMessageCount()));
                }
                return None$.MODULE$;
            }, ClassTag$.MODULE$.apply(IMapReceiver.IMapFolder.class));
            store.close();
            observable = Observable$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray(fs));
        }
        catch (Exception ex) {
            this.log().error(() -> GMailReceiver.getFolders$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(84), FullName$.MODULE$.apply("com.elixirtech.imap.GMailReceiver.getFolders"));
            observable = Observable$.MODULE$.empty();
        }
        return observable;
    }

    @Override
    public Observable<IMapReceiver.Mail> mails(String folderName, int start, int limit) {
        return this.ensureValidAccessToken().flatMap((Function1 & Serializable)x$1 -> {
            AccessToken accessToken = x$1;
            return this.getMails(folderName, start, limit).map((Function1 & Serializable)mails -> mails);
        });
    }

    public Observable<IMapReceiver.Mail> getMails(String folderName, int start, int limit) {
        Observable observable;
        block4: {
            try {
                Store store = this.getStore();
                Option option = Try$.MODULE$.apply(() -> GMailReceiver.getMails$$anonfun$1(store, folderName)).toOption();
                if (option instanceof Some) {
                    Folder folder = (Folder)((Some)option).value();
                    folder.open(1);
                    int from = scala.math.package$.MODULE$.max(1, start);
                    int to = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.max(from, from + limit - 1), folder.getMessageCount());
                    Nil$ messages = from <= to ? Predef$.MODULE$.wrapRefArray((Object[])folder.getMessages(from, to)).toList() : package$.MODULE$.Nil();
                    List reply = messages.map((Function1 & Serializable)msg -> IMapUtils$.MODULE$.buildMail((Message)msg));
                    folder.close(false);
                    observable = Observable$.MODULE$.fromIterable((Iterable)reply);
                    break block4;
                }
                if (None$.MODULE$.equals(option)) {
                    observable = Observable$.MODULE$.empty();
                    break block4;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception ex) {
                this.log().error(() -> GMailReceiver.getMails$$anonfun$2(folderName, ex), (Throwable)ex, Line$.MODULE$.apply(113), FullName$.MODULE$.apply("com.elixirtech.imap.GMailReceiver.getMails"));
                observable = Observable$.MODULE$.empty();
            }
        }
        return observable;
    }

    public Observable<AccessToken> ensureValidAccessToken() {
        if (System.currentTimeMillis() >= this.accessToken.expires()) {
            return Observable$.MODULE$.fromTask(this.getAccessToken()).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    this.log().warn(() -> GMailReceiver.ensureValidAccessToken$$anonfun$1$$anonfun$1(msg), Line$.MODULE$.apply(123), FullName$.MODULE$.apply("com.elixirtech.imap.GMailReceiver.ensureValidAccessToken"));
                    return Observable$.MODULE$.empty();
                }
                if (either instanceof Right) {
                    AccessToken at;
                    this.accessToken = at = (AccessToken)((Right)either).value();
                    return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessToken[]{this.accessToken}));
                }
                throw new MatchError((Object)either);
            });
        }
        return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessToken[]{this.accessToken}));
    }

    public Store getStore() {
        Store store;
        Properties props = new Properties();
        props.put("mail.imap.port", "993");
        props.put("mail.store.protocol", "imaps");
        props.put("mail.imap.ssl.enable", "true");
        props.put("mail.imap.auth.mechanisms", "XOAUTH2");
        Thread t = Thread.currentThread();
        ClassLoader ccl = t.getContextClassLoader();
        try {
            Session session = Session.getDefaultInstance((Properties)props);
            t.setContextClassLoader(session.getClass().getClassLoader());
            Store store2 = session.getStore("imap");
            this.log().debug(GMailReceiver::getStore$$anonfun$1, Line$.MODULE$.apply(146), FullName$.MODULE$.apply("com.elixirtech.imap.GMailReceiver.getStore"));
            store2.connect(this.host, this.oauthUserName, this.accessToken.value());
            store = store2;
        }
        finally {
            t.setContextClassLoader(ccl);
        }
        return store;
    }

    private Task<Either<String, AccessToken>> getAccessToken() {
        return Task$.MODULE$.apply(this::getAccessToken$$anonfun$1);
    }

    private Map<String, String> getTokenFormData() {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.oauthClientId);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"client_secret");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.oauthSecret);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"refresh_token");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.oauthRefreshToken);
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"grant_type");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"refresh_token");
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private Either<String, AccessToken> buildAccessToken(String body) {
        long now = System.currentTimeMillis();
        String string = "access_token";
        String string2 = "expires_in";
        int size = 2;
        Either either = io.circe.parser.package$.MODULE$.decode(body, Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Reply", GMailReceiver::buildAccessToken$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), GMailReceiver::buildAccessToken$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GMailReceiver::buildAccessToken$$anonfun$3)))));
        if (either instanceof Right) {
            Reply reply = (Reply)((Right)either).value();
            return Right$.MODULE$.apply((Object)GMailReceiver$AccessToken$.MODULE$.apply(reply.access_token(), now + reply.expires_in() * 1000L));
        }
        if (either instanceof Left) {
            Error err = (Error)((Left)either).value();
            this.log().error(() -> GMailReceiver.buildAccessToken$$anonfun$4(body), (Throwable)err, Line$.MODULE$.apply(178), FullName$.MODULE$.apply("com.elixirtech.imap.GMailReceiver.buildAccessToken"));
            return Left$.MODULE$.apply((Object)("Can't read json [" + body + "]"));
        }
        throw new MatchError((Object)either);
    }

    private static final Object getFolders$$anonfun$1(Exception ex$1) {
        return "Error listing emails: " + ex$1;
    }

    private static final Folder getMails$$anonfun$1(Store store$1, String folderName$2) {
        return store$1.getFolder(folderName$2);
    }

    private static final Object getMails$$anonfun$2(String folderName$3, Exception ex$2) {
        return "Error reading emails from " + folderName$3 + ": " + ex$2;
    }

    private static final Object ensureValidAccessToken$$anonfun$1$$anonfun$1(String msg$1) {
        return "Unable to get AccessToken: " + msg$1;
    }

    private static final Object getStore$$anonfun$1() {
        return "Store obtained";
    }

    private final Object getAccessToken$$anonfun$1$$anonfun$1(HttpClientResponse response$1) {
        return "Getting token from " + this.TOKEN_URL + " returned " + response$1.statusCode() + ": " + response$1.bodyUtf8();
    }

    private final Either getAccessToken$$anonfun$1() {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Accept");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"application/json;q=1.0");
        HttpClientResponse response = HttpClientRequest$.MODULE$.post(this.TOKEN_URL, this.getTokenFormData(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        if (response.statusCode() == 200) {
            return this.buildAccessToken(response.bodyUtf8());
        }
        this.log().warn(() -> this.getAccessToken$$anonfun$1$$anonfun$1(response), Line$.MODULE$.apply(159), FullName$.MODULE$.apply("com.elixirtech.imap.GMailReceiver.getAccessToken"));
        return Left$.MODULE$.apply((Object)("getAccessToken returned a " + response.statusCode()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List buildAccessToken$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeLong();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 buildAccessToken$$anonfun$2() {
        GMailReceiver$Reply$ gMailReceiver$Reply$ = GMailReceiver$Reply$.MODULE$;
        return (Function1 & Serializable)p -> (Reply)gMailReceiver$Reply$.fromProduct((Product)p);
    }

    private static final Product buildAccessToken$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object buildAccessToken$$anonfun$4(String body$1) {
        return "Can't read json " + body$1;
    }

    public static final class AccessToken
    implements Product,
    Serializable {
        private final String value;
        private final long expires;

        public static AccessToken apply(String string, long l) {
            return GMailReceiver$AccessToken$.MODULE$.apply(string, l);
        }

        public static AccessToken fromProduct(Product product) {
            return GMailReceiver$AccessToken$.MODULE$.fromProduct(product);
        }

        public static AccessToken unapply(AccessToken accessToken) {
            return GMailReceiver$AccessToken$.MODULE$.unapply(accessToken);
        }

        public AccessToken(String value, long expires) {
            this.value = value;
            this.expires = expires;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.value()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.expires()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AccessToken)) return false;
            AccessToken accessToken = (AccessToken)object;
            if (this.expires() != accessToken.expires()) return false;
            String string = this.value();
            String string2 = accessToken.value();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AccessToken;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AccessToken";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            if (1 == n2) {
                return "expires";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String value() {
            return this.value;
        }

        public long expires() {
            return this.expires;
        }

        public AccessToken copy(String value, long expires) {
            return new AccessToken(value, expires);
        }

        public String copy$default$1() {
            return this.value();
        }

        public long copy$default$2() {
            return this.expires();
        }

        public String _1() {
            return this.value();
        }

        public long _2() {
            return this.expires();
        }
    }

    public static final class Reply
    implements Product,
    Serializable {
        private final String access_token;
        private final long expires_in;

        public static Reply apply(String string, long l) {
            return GMailReceiver$Reply$.MODULE$.apply(string, l);
        }

        public static Reply fromProduct(Product product) {
            return GMailReceiver$Reply$.MODULE$.fromProduct(product);
        }

        public static Reply unapply(Reply reply) {
            return GMailReceiver$Reply$.MODULE$.unapply(reply);
        }

        public Reply(String access_token, long expires_in) {
            this.access_token = access_token;
            this.expires_in = expires_in;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.access_token()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.expires_in()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Reply)) return false;
            Reply reply = (Reply)object;
            if (this.expires_in() != reply.expires_in()) return false;
            String string = this.access_token();
            String string2 = reply.access_token();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Reply;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Reply";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong((long)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "access_token";
            }
            if (1 == n2) {
                return "expires_in";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String access_token() {
            return this.access_token;
        }

        public long expires_in() {
            return this.expires_in;
        }

        public Reply copy(String access_token, long expires_in) {
            return new Reply(access_token, expires_in);
        }

        public String copy$default$1() {
            return this.access_token();
        }

        public long copy$default$2() {
            return this.expires_in();
        }

        public String _1() {
            return this.access_token();
        }

        public long _2() {
            return this.expires_in();
        }
    }
}

