/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.imap;

import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.imap.IMapReceiver;
import com.elixirtech.imap.IMapReceiver$IMapFolder$;
import com.elixirtech.imap.IMapUtils$;
import com.sun.mail.imap.IMAPFolder;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class GenericReceiver
implements IMapReceiver,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(GenericReceiver.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String storeType;

    public GenericReceiver(Config imapConfig) {
        this.host = imapConfig.getString("host");
        this.port = imapConfig.getInt("port");
        this.username = imapConfig.getString("username");
        this.password = Crypt$.MODULE$.encPrefixDecrypt(imapConfig.getString("password"));
        this.storeType = imapConfig.getString("store");
    }

    @Override
    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Observable<IMapReceiver.IMapFolder> folders() {
        Observable observable;
        try {
            Store store = this.getStore();
            Object[] folders = store.getDefaultFolder().list("*");
            Object object = Predef$.MODULE$.refArrayOps(folders);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)f -> IMapUtils$.MODULE$.isMessageHolder((Folder)f)));
            Object[] fs = (IMapReceiver.IMapFolder[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)x$1 -> {
                Folder folder = x$1;
                if (folder instanceof IMAPFolder) {
                    IMAPFolder f = (IMAPFolder)folder;
                    return Some$.MODULE$.apply((Object)IMapReceiver$IMapFolder$.MODULE$.apply(f.getFullName(), f.getMessageCount(), f.getUnreadMessageCount()));
                }
                return None$.MODULE$;
            }, ClassTag$.MODULE$.apply(IMapReceiver.IMapFolder.class));
            store.close();
            observable = Observable$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray(fs));
        }
        catch (Exception ex) {
            this.log().error(() -> GenericReceiver.folders$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(32), FullName$.MODULE$.apply("com.elixirtech.imap.GenericReceiver.folders"));
            observable = Observable$.MODULE$.empty();
        }
        return observable;
    }

    @Override
    public Observable<IMapReceiver.Mail> mails(String folderName, int start, int limit) {
        Observable observable;
        block4: {
            try {
                Store store = this.getStore();
                Option option = Try$.MODULE$.apply(() -> GenericReceiver.mails$$anonfun$1(store, folderName)).toOption();
                if (option instanceof Some) {
                    Folder folder = (Folder)((Some)option).value();
                    folder.open(1);
                    int from = package$.MODULE$.max(1, start);
                    int to = package$.MODULE$.min(package$.MODULE$.max(from, from + limit - 1), folder.getMessageCount());
                    Nil$ messages = from <= to ? Predef$.MODULE$.wrapRefArray((Object[])folder.getMessages(from, to)).toList() : scala.package$.MODULE$.Nil();
                    List reply = messages.map((Function1 & Serializable)msg -> IMapUtils$.MODULE$.buildMail((Message)msg));
                    folder.close(false);
                    observable = Observable$.MODULE$.fromIterable((Iterable)reply);
                    break block4;
                }
                if (None$.MODULE$.equals(option)) {
                    observable = Observable$.MODULE$.empty();
                    break block4;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception ex) {
                this.log().error(() -> GenericReceiver.mails$$anonfun$2(folderName, ex), (Throwable)ex, Line$.MODULE$.apply(54), FullName$.MODULE$.apply("com.elixirtech.imap.GenericReceiver.mails"));
                observable = Observable$.MODULE$.empty();
            }
        }
        return observable;
    }

    public Store getStore() {
        Properties props = new Properties();
        props.put("mail.imap.port", BoxesRunTime.boxToInteger((int)this.port).toString());
        props.put("mail.store.protocol", "imaps");
        props.put("mail.imap.ssl.enable", "true");
        Session session = Session.getDefaultInstance((Properties)props);
        Store store = session.getStore(this.storeType);
        this.log().debug(this::getStore$$anonfun$1, Line$.MODULE$.apply(66), FullName$.MODULE$.apply("com.elixirtech.imap.GenericReceiver.getStore"));
        store.connect(this.host, this.username, this.password);
        return store;
    }

    private static final Object folders$$anonfun$1(Exception ex$1) {
        return "Error listing emails: " + ex$1;
    }

    private static final Folder mails$$anonfun$1(Store store$1, String folderName$1) {
        return store$1.getFolder(folderName$1);
    }

    private static final Object mails$$anonfun$2(String folderName$2, Exception ex$2) {
        return "Error reading emails from " + folderName$2 + ": " + ex$2;
    }

    private final Object getStore$$anonfun$1() {
        return "Store " + this.storeType + " obtained";
    }
}

