/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import com.elixirtech.api.AuditAPI;
import com.elixirtech.api.AuditAPI$Action$;
import com.elixirtech.api.AuditAPI$AuditId$;
import com.elixirtech.api.AuditAPI$AuditIds$;
import com.elixirtech.api.AuditAPI$AuditMessage$;
import com.elixirtech.api.AuditAPI$Component$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.info.JavaPID$;
import com.elixirtech.arch.info.RunInfo;
import com.elixirtech.mongodb.BsonTransform$;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.DBUtils$;
import com.elixirtech.mongodb.MongoDBAuditAppender;
import java.io.Serializable;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;

public final class MongoDBAuditAppender$
implements Serializable {
    private static final String Collection;
    private static final BsonString pid;
    private static final Option<BsonString> pidMachine;
    private volatile Object runValue$lzy1;
    public static final MongoDBAuditAppender$ MODULE$;

    private MongoDBAuditAppender$() {
    }

    static {
        MODULE$ = new MongoDBAuditAppender$();
        Collection = "LogAudit";
        pid = new BsonString(JavaPID$.MODULE$.value());
        pidMachine = BsonUtils$.MODULE$.pidMachine(pid);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MongoDBAuditAppender$.class);
    }

    public String Collection() {
        return Collection;
    }

    private BsonInt32 runValue() {
        Object object = this.runValue$lzy1;
        if (object instanceof BsonInt32) {
            return (BsonInt32)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (BsonInt32)this.runValue$lzyINIT1();
    }

    private Object runValue$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.runValue$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, MongoDBAuditAppender.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    BsonInt32 bsonInt32 = null;
                    try {
                        bsonInt32 = new BsonInt32(((RunInfo)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RunInfo.class))).runId());
                        object2 = bsonInt32 == null ? LazyVals.NullValue$.MODULE$ : bsonInt32;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, MongoDBAuditAppender.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.runValue$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, MongoDBAuditAppender.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bsonInt32;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, MongoDBAuditAppender.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Document toMongoDocument(AuditAPI.AuditMessage am) {
        BsonDocument doc = new BsonDocument();
        doc.append("user", (BsonValue)new BsonString(am.user()));
        DBUtils$.MODULE$.appendTimestamp(doc, System.currentTimeMillis());
        doc.append("run", (BsonValue)this.runValue());
        doc.append("pid", (BsonValue)pid);
        pidMachine.foreach((Function1 & Serializable)s -> doc.append("pidMachine", (BsonValue)s));
        doc.append("module", (BsonValue)new BsonString(am.component().module()));
        doc.append("component", (BsonValue)new BsonString(am.component().component()));
        doc.append("success", (BsonValue)new BsonBoolean(am.action().success()));
        AuditAPI.AuditObject auditObject = am.action().obj();
        if (auditObject instanceof AuditAPI.AuditId) {
            String string;
            AuditAPI.AuditId auditId = AuditAPI$AuditId$.MODULE$.unapply((AuditAPI.AuditId)auditObject);
            String obj = string = auditId._1();
            v0 = doc.append("object", (BsonValue)new BsonString(obj));
        } else if (auditObject instanceof AuditAPI.AuditIds) {
            List<String> list;
            AuditAPI.AuditIds auditIds = AuditAPI$AuditIds$.MODULE$.unapply((AuditAPI.AuditIds)auditObject);
            List<String> list2 = list = auditIds._1();
            v0 = doc.append("object", (BsonValue)this.buildArray(list2));
        } else {
            throw new MatchError((Object)auditObject);
        }
        doc.append("verb", (BsonValue)new BsonString(am.action().verb()));
        am.action().info().foreach((Function1 & Serializable)info -> doc.append("info", (BsonValue)new BsonString(info)));
        if (am.action().extras().nonEmpty()) {
            doc.append("extras", (BsonValue)DBUtils$.MODULE$.toBsonMap(am.action().extras()));
        }
        return Document$.MODULE$.apply(doc);
    }

    public BsonArray buildArray(List<String> identifiers) {
        return BsonArray$.MODULE$.fromIterable((Iterable)identifiers.map((Function1 & Serializable)value -> BsonString$.MODULE$.apply(value)));
    }

    public AuditAPI.AuditMessage fromMongoDocument(Document doc2) {
        String user = doc2.apply("user", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue();
        String module = doc2.apply("module", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue();
        String component = doc2.apply("component", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue();
        boolean success = doc2.apply("success", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asBoolean().getValue();
        AuditAPI.AuditObject obj = this.buildAuditObject(doc2.apply("object", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)));
        String verb = doc2.apply("verb", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).asString().getValue();
        Option info = doc2.get("info", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$1 -> _$1.asString().getValue());
        Map extras = (Map)doc2.get("extras", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)doc -> DBUtils$.MODULE$.toMap((BsonValue)doc)).getOrElse(MongoDBAuditAppender$::$anonfun$4);
        return AuditAPI$AuditMessage$.MODULE$.apply(user, AuditAPI$Component$.MODULE$.apply(module, component), AuditAPI$Action$.MODULE$.apply(success, obj, verb, (Option<String>)info, (Map<String, String>)extras));
    }

    public AuditAPI.AuditObject buildAuditObject(BsonValue b) {
        Product product;
        BsonValue bsonValue = b;
        if (bsonValue instanceof BsonString) {
            BsonString bs = (BsonString)bsonValue;
            product = AuditAPI$AuditId$.MODULE$.apply(bs.getValue());
        } else if (bsonValue instanceof BsonArray) {
            BsonArray ba = (BsonArray)bsonValue;
            product = AuditAPI$AuditIds$.MODULE$.apply((List<String>)CollectionConverters$.MODULE$.ListHasAsScala(ba.getValues()).asScala().toList().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(BsonValue x) {
                    BsonValue bsonValue = x;
                    if (bsonValue instanceof BsonString) {
                        BsonString bs = (BsonString)bsonValue;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(BsonValue x, Function1 function1) {
                    BsonValue bsonValue = x;
                    if (bsonValue instanceof BsonString) {
                        BsonString bs = (BsonString)bsonValue;
                        return bs.getValue();
                    }
                    return function1.apply((Object)x);
                }
            }));
        } else {
            BsonValue x = bsonValue;
            product = AuditAPI$AuditId$.MODULE$.apply(BsonTransform$.MODULE$.toJson(x).noSpaces());
        }
        return product;
    }

    private static final Map $anonfun$4() {
        return Predef$.MODULE$.Map().empty();
    }
}

