/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.elixirtech.arch.info.JavaPID$;
import com.elixirtech.arch.info.RunInfo;
import com.elixirtech.arch.logging.SLF4J$;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.DBUtils$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.MongoDBEventAppender$;
import com.elixirtech.mongodb.MongoDBEventAppender$BrowserError$;
import com.elixirtech.mongodb.RichMongoCollection;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Map;
import monix.eval.Task;
import monix.execution.Scheduler$;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Indexes$;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class MongoDBEventAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MongoDBEventAppender.class.getDeclaredField("eventsCollection$lzy1"));
    private final MongoDB mongoDB;
    private final ExecutionContext exeCxt;
    private volatile Object eventsCollection$lzy1;
    private final BsonString pid;
    private final Option<BsonString> pidMachine;
    private final BsonInt32 runValue;
    private final Level filterLevel;

    public static BsonString BrowserLogger() {
        return MongoDBEventAppender$.MODULE$.BrowserLogger();
    }

    public static BsonString BrowserLoggerName() {
        return MongoDBEventAppender$.MODULE$.BrowserLoggerName();
    }

    public static String Collection() {
        return MongoDBEventAppender$.MODULE$.Collection();
    }

    public MongoDBEventAppender(MongoDB mongoDB, RunInfo runInfo) {
        this.mongoDB = mongoDB;
        this.exeCxt = mongoDB.sysConfig().exeCxt();
        this.pid = new BsonString(JavaPID$.MODULE$.value());
        this.pidMachine = BsonUtils$.MODULE$.pidMachine(this.pid);
        this.runValue = new BsonInt32(runInfo.runId());
        this.filterLevel = this.getLevel(mongoDB.sysConfig().config().getString("elixir.logging.mongo-appender.level"));
        this.initIndexes();
        this.init();
    }

    public ExecutionContext exeCxt() {
        return this.exeCxt;
    }

    private RichMongoCollection eventsCollection() {
        Object object = this.eventsCollection$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.eventsCollection$lzyINIT1();
    }

    private Object eventsCollection$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.eventsCollection$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection((MongoCollection<Document>)this.mongoDB.logs().getCollection(MongoDBEventAppender$.MODULE$.Collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.eventsCollection$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void initIndexes() {
        Task task = this.eventsCollection().createIndexT(Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"when.timestamp"}))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.eventsCollection().createIndexT(Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"when.date"}))).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.eventsCollection().createIndexT(Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"level"}))).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.eventsCollection().createIndexT(Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"levelId"}))).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.eventsCollection().createIndexT(Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"run"}))).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return this.eventsCollection().createIndexT(Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"logger"}))).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return this.eventsCollection().createIndexT(Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"loggerName"}))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                });
                            });
                        });
                    });
                });
            });
        });
        task.onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> Predef$.MODULE$.println((Object)("Error configuring log event indexes: " + ex))).runAsyncAndForget(Scheduler$.MODULE$.global());
    }

    public void init() {
        Config config = this.mongoDB.sysConfig().config();
        boolean enabled = config.getBoolean("elixir.logging.mongo-appender.enabled");
        if (enabled) {
            try {
                this.start();
                Logger logger = LoggerFactory.getLogger((String)"ROOT");
                if (!(logger instanceof ch.qos.logback.classic.Logger)) {
                    Logger x = logger;
                    throw new RuntimeException("Logger cannot be initialised with " + x);
                }
                ch.qos.logback.classic.Logger x = (ch.qos.logback.classic.Logger)logger;
                ch.qos.logback.classic.Logger logger2 = x;
                ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
                if (!(iLoggerFactory instanceof LoggerContext)) {
                    ILoggerFactory x2 = iLoggerFactory;
                    throw new RuntimeException("LoggerContext cannot be initialised with " + x2);
                }
                LoggerContext x3 = (LoggerContext)iLoggerFactory;
                LoggerContext cxt = x3;
                this.setContext((Context)cxt);
                logger2.addAppender((Appender)this);
                logger2.setAdditive(true);
                logger2.info(this.mongoDB.sysConfig().info());
            }
            catch (Exception ex) {
                Predef$.MODULE$.println((Object)("Error running MongoDBEventAppender: " + ex));
            }
            return;
        }
    }

    public Level getLevel(String s) {
        String string = s.toUpperCase();
        switch (string == null ? 0 : string.hashCode()) {
            case 2251950: {
                if (!"INFO".equals(string)) break;
                return Level.INFO;
            }
            case 2656902: {
                if (!"WARN".equals(string)) break;
                return Level.WARN;
            }
            case 64921139: {
                if (!"DEBUG".equals(string)) break;
                return Level.DEBUG;
            }
            case 66247144: {
                if (!"ERROR".equals(string)) break;
                return Level.ERROR;
            }
        }
        return Level.WARN;
    }

    public void append(ILoggingEvent eventObject) {
        if (eventObject.getLevel().isGreaterOrEqual(this.filterLevel)) {
            this.append(this.toMongoDocument(eventObject));
            return;
        }
    }

    public void append(BrowserError eventObject) {
        this.append(this.toMongoDocument(eventObject));
    }

    public void append(Document doc) {
        this.eventsCollection().insertOneT(doc).void().onErrorHandle((Function1)(JProcedure1 & Serializable)ex -> {}).runAsyncAndForget(Scheduler$.MODULE$.global());
    }

    public Document toMongoDocument(BrowserError event) {
        BsonDocument doc = new BsonDocument();
        DBUtils$.MODULE$.appendTimestamp(doc, System.currentTimeMillis());
        doc.append("run", (BsonValue)this.runValue);
        doc.append("pid", (BsonValue)this.pid);
        this.pidMachine.foreach((Function1 & Serializable)s -> doc.append("pidMachine", (BsonValue)s));
        doc.append("level", (BsonValue)new BsonString(Level.ERROR.levelStr));
        doc.append("levelId", (BsonValue)new BsonInt32(40000));
        doc.append("sourceName", (BsonValue)new BsonString(event.url()));
        doc.append("sourceLine", (BsonValue)new BsonInt32(event.lineNumber()));
        doc.append("logger", (BsonValue)MongoDBEventAppender$.MODULE$.BrowserLogger());
        doc.append("loggerName", (BsonValue)new BsonString(event.module()));
        doc.append("message", (BsonValue)new BsonString(event.message()));
        event.userAgent().foreach((Function1 & Serializable)ua -> doc.append("userAgent", (BsonValue)new BsonString(ua)));
        event.user().foreach((Function1 & Serializable)s -> doc.append("user", (BsonValue)new BsonString(s)));
        return Document$.MODULE$.apply(doc);
    }

    public Document toMongoDocument(ILoggingEvent event) {
        BsonDocument doc = new BsonDocument();
        DBUtils$.MODULE$.appendTimestamp(doc, event.getTimeStamp());
        doc.append("run", (BsonValue)this.runValue);
        doc.append("pid", (BsonValue)this.pid);
        this.pidMachine.foreach((Function1 & Serializable)s -> doc.append("pidMachine", (BsonValue)s));
        doc.append("level", (BsonValue)new BsonString(event.getLevel().levelStr));
        doc.append("levelId", (BsonValue)new BsonInt32(event.getLevel().levelInt));
        doc.append("thread", (BsonValue)new BsonString(event.getThreadName()));
        Map mdc = event.getMDCPropertyMap();
        Option$.MODULE$.apply(mdc.get(SLF4J$.MODULE$.SourceName())).foreach((Function1 & Serializable)s -> doc.append("sourceName", (BsonValue)new BsonString(s)));
        Option$.MODULE$.apply(mdc.get(SLF4J$.MODULE$.SourceLine())).foreach((Function1 & Serializable)s -> doc.append("sourceLine", (BsonValue)new BsonInt32(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)))));
        Option$.MODULE$.apply(mdc.get(SLF4J$.MODULE$.ElapsedTime())).foreach((Function1 & Serializable)s -> doc.append("elapsedTime", (BsonValue)new BsonInt64(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s)))));
        Option$.MODULE$.apply(mdc.get(SLF4J$.MODULE$.User())).foreach((Function1 & Serializable)s -> doc.append("user", (BsonValue)new BsonString(s)));
        scala.collection.immutable.Map remainder = ((scala.collection.immutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(mdc).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$minus$minus((IterableOnce)SLF4J$.MODULE$.All())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (remainder.nonEmpty()) {
            doc.append("mdc", (BsonValue)this.toBsonDoc((scala.collection.immutable.Map<String, String>)remainder));
        }
        doc.append("logger", (BsonValue)new BsonString(event.getLoggerName()));
        doc.append("loggerPackage", (BsonValue)new BsonString(this.loggerPackage(event.getLoggerName())));
        doc.append("loggerName", (BsonValue)new BsonString(this.loggerName(event.getLoggerName())));
        doc.append("message", (BsonValue)new BsonString(event.getFormattedMessage()));
        if (event.getArgumentArray() != null && event.getArgumentArray().length > 0) {
            doc.append("arguments", (BsonValue)this.toBsonArray(event.getArgumentArray()));
        }
        this.appendThrowableIfAvailable(doc, event);
        return Document$.MODULE$.apply(doc);
    }

    private String loggerPackage(String logger) {
        int idx = logger.lastIndexOf(".");
        if (idx > 0) {
            return logger.substring(0, idx);
        }
        return "";
    }

    private String loggerName(String logger) {
        return logger.substring(logger.lastIndexOf(".") + 1);
    }

    private BsonDocument toBsonDoc(scala.collection.immutable.Map<String, String> map) {
        BsonDocument doc = new BsonDocument();
        map.foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return doc.append(k, (BsonValue)new BsonString(v));
            }
            throw new MatchError((Object)tuple2);
        });
        return doc;
    }

    private BsonArray toBsonArray(Object[] arr) {
        BsonArray ret = new BsonArray();
        Object object = Predef$.MODULE$.refArrayOps(arr);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)obj -> ret.add((BsonValue)new BsonString(String.valueOf(obj))));
        return ret;
    }

    private void appendThrowableIfAvailable(BsonDocument doc, ILoggingEvent event) {
        Option$.MODULE$.apply((Object)event.getThrowableProxy()).foreach((Function1 & Serializable)proxy -> doc.append("throwable", (BsonValue)this.toMongoDocument((IThrowableProxy)proxy)));
    }

    private BsonDocument toMongoDocument(IThrowableProxy throwable) {
        BsonDocument throwableDoc = new BsonDocument();
        throwableDoc.append("class", (BsonValue)new BsonString(throwable.getClassName()));
        throwableDoc.append("message", (BsonValue)new BsonString(throwable.getMessage()));
        throwableDoc.append("stackTrace", (BsonValue)this.toSteArray(throwable));
        Option$.MODULE$.apply((Object)throwable.getCause()).map((Function1 & Serializable)cause -> throwableDoc.append("cause", (BsonValue)this.toMongoDocument((IThrowableProxy)cause)));
        return throwableDoc;
    }

    private BsonArray toSteArray(IThrowableProxy throwableProxy) {
        Object[] elementProxies = throwableProxy.getStackTraceElementProxyArray();
        int totalFrames = elementProxies.length - throwableProxy.getCommonFrames();
        BsonArray array = new BsonArray();
        Object object = Predef$.MODULE$.refArrayOps(elementProxies);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(object, totalFrames));
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)ep -> array.add((BsonValue)new BsonString(ep.getStackTraceElement().toString())));
        return array;
    }

    public static final class BrowserError
    implements Product,
    Serializable {
        private final String module;
        private final String url;
        private final int lineNumber;
        private final String message;
        private final Option userAgent;
        private final Option user;

        public static BrowserError apply(String string, String string2, int n, String string3, Option<String> option, Option<String> option2) {
            return MongoDBEventAppender$BrowserError$.MODULE$.apply(string, string2, n, string3, option, option2);
        }

        public static BrowserError fromProduct(Product product) {
            return MongoDBEventAppender$BrowserError$.MODULE$.fromProduct(product);
        }

        public static BrowserError unapply(BrowserError browserError) {
            return MongoDBEventAppender$BrowserError$.MODULE$.unapply(browserError);
        }

        public BrowserError(String module, String url, int lineNumber, String message, Option<String> userAgent, Option<String> user) {
            this.module = module;
            this.url = url;
            this.lineNumber = lineNumber;
            this.message = message;
            this.userAgent = userAgent;
            this.user = user;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.module()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.url()));
            n = Statics.mix((int)n, (int)this.lineNumber());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.message()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.userAgent()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.user()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BrowserError)) return false;
            BrowserError browserError = (BrowserError)object;
            if (this.lineNumber() != browserError.lineNumber()) return false;
            String string = this.module();
            String string2 = browserError.module();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.url();
            String string4 = browserError.url();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.message();
            String string6 = browserError.message();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Option<String> option = this.userAgent();
            Option<String> option2 = browserError.userAgent();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.user();
            Option<String> option4 = browserError.user();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BrowserError;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "BrowserError";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "module";
                }
                case 1: {
                    return "url";
                }
                case 2: {
                    return "lineNumber";
                }
                case 3: {
                    return "message";
                }
                case 4: {
                    return "userAgent";
                }
                case 5: {
                    return "user";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String module() {
            return this.module;
        }

        public String url() {
            return this.url;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public String message() {
            return this.message;
        }

        public Option<String> userAgent() {
            return this.userAgent;
        }

        public Option<String> user() {
            return this.user;
        }

        public BrowserError copy(String module, String url, int lineNumber, String message, Option<String> userAgent, Option<String> user) {
            return new BrowserError(module, url, lineNumber, message, userAgent, user);
        }

        public String copy$default$1() {
            return this.module();
        }

        public String copy$default$2() {
            return this.url();
        }

        public int copy$default$3() {
            return this.lineNumber();
        }

        public String copy$default$4() {
            return this.message();
        }

        public Option<String> copy$default$5() {
            return this.userAgent();
        }

        public Option<String> copy$default$6() {
            return this.user();
        }

        public String _1() {
            return this.module();
        }

        public String _2() {
            return this.url();
        }

        public int _3() {
            return this.lineNumber();
        }

        public String _4() {
            return this.message();
        }

        public Option<String> _5() {
            return this.userAgent();
        }

        public Option<String> _6() {
            return this.user();
        }
    }
}

