/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.mongodb;

import com.elixirtech.mongodb.FindOptions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import monix.eval.Task;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.FindObservable;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.reactivestreams.Publisher;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public class RichMongoCollection {
    private final MongoCollection cltn;

    public RichMongoCollection(MongoCollection<Document> cltn) {
        this.cltn = cltn;
    }

    public MongoCollection<Document> cltn() {
        return this.cltn;
    }

    public Observable<Document> aggregateO(Seq<Bson> pipeline) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().aggregate(pipeline, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
    }

    public Task<BulkWriteResult> bulkWriteT(Seq<WriteModel<Document>> items) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().bulkWrite(items)).firstL();
    }

    public Task<BulkWriteResult> bulkWriteT(Seq<WriteModel<Document>> items, BulkWriteOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().bulkWrite(items, options)).firstL();
    }

    public Task<Object> countDocumentsT() {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().countDocuments()).firstL();
    }

    public Task<Object> countDocumentsT(Bson filter) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().countDocuments(filter)).firstL();
    }

    public Task<BoxedUnit> createIndexT(Bson key) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().createIndex(key)).completedL();
    }

    public Task<BoxedUnit> createIndexT(Bson key, IndexOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().createIndex(key, options)).completedL();
    }

    public Task<DeleteResult> deleteOneT(Bson filter) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().deleteOne(filter)).firstL();
    }

    public Task<DeleteResult> deleteOneT(Bson filter, DeleteOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().deleteOne(filter, options)).firstL();
    }

    public Task<DeleteResult> deleteManyT(Bson filter) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().deleteMany(filter)).firstL();
    }

    public Task<DeleteResult> deleteManyT(Bson filter, DeleteOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().deleteMany(filter, options)).firstL();
    }

    public Observable<BsonValue> distinctO(String fieldName) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().distinct(fieldName, ClassTag$.MODULE$.apply(BsonValue.class)));
    }

    public Observable<BsonValue> distinctO(String fieldName, Bson filter) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().distinct(fieldName, filter, ClassTag$.MODULE$.apply(BsonValue.class)));
    }

    public Task<BoxedUnit> dropT() {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().drop()).completedL();
    }

    public Task<BoxedUnit> dropIndexT(Bson bson) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().dropIndex(bson)).completedL();
    }

    public Task<BoxedUnit> dropIndexT(Bson bson, DropIndexOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().dropIndex(bson, options)).completedL();
    }

    public Task<BoxedUnit> dropIndexesT() {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().dropIndexes()).completedL();
    }

    public Task<BoxedUnit> dropIndexesT(DropIndexOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().dropIndexes(options)).completedL();
    }

    public Observable<Document> findO() {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
    }

    public Observable<Document> findO(FindOptions options) {
        return Observable$.MODULE$.fromReactivePublisher(options.apply((FindObservable<Document>)this.cltn().find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))));
    }

    public Observable<Document> findO(Bson filter) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().find(filter, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
    }

    public Observable<Document> findO(Bson filter, FindOptions options) {
        return Observable$.MODULE$.fromReactivePublisher(options.apply((FindObservable<Document>)this.cltn().find(filter, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))));
    }

    public Observable<Document> findOneO(Bson filter) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().find(filter, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).limit(1));
    }

    public Task<Option<Document>> findOneAndReplaceT(Bson filter, Document replacement) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().findOneAndReplace(filter, (Object)replacement)).firstOptionL();
    }

    public Task<Option<Document>> findOneAndReplaceT(Bson filter, Document replacement, FindOneAndReplaceOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().findOneAndReplace(filter, (Object)replacement, options)).firstOptionL();
    }

    public Task<Option<Document>> findOneAndUpdateT(Bson filter, Bson update) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().findOneAndUpdate(filter, update)).firstOptionL();
    }

    public Task<Option<Document>> findOneAndUpdateT(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().findOneAndUpdate(filter, update, options)).firstOptionL();
    }

    public Task<InsertOneResult> insertOneT(Document doc) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().insertOne((Object)doc)).firstL();
    }

    public Task<InsertOneResult> insertOneT(Document doc, InsertOneOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().insertOne((Object)doc, options)).firstL();
    }

    public Task<InsertManyResult> insertManyT(Seq<Document> docs) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().insertMany(docs)).firstL();
    }

    public Task<InsertManyResult> insertManyT(Seq<Document> docs, InsertManyOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().insertMany(docs, options)).firstL();
    }

    public Task<UpdateResult> replaceOneT(Bson filter, Document doc) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().replaceOne(filter, (Object)doc)).firstL();
    }

    public Task<UpdateResult> replaceOneT(Bson filter, Document doc, ReplaceOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().replaceOne(filter, (Object)doc, options)).firstL();
    }

    public Task<UpdateResult> updateOneT(Bson filter, Bson update) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().updateOne(filter, update)).firstL();
    }

    public Task<UpdateResult> updateOneT(Bson filter, Bson update, UpdateOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().updateOne(filter, update, options)).firstL();
    }

    public Task<UpdateResult> updateManyT(Bson filter, Bson update) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().updateMany(filter, update)).firstL();
    }

    public Task<UpdateResult> updateManyT(Bson filter, Bson update, UpdateOptions options) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().updateMany(filter, update, options)).firstL();
    }
}

