/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.mqtt;

import ambience.etl.Builder;
import ambience.etl.mqtt.MQTTReader;
import ambience.etl.mqtt.MongoPersistence;
import ambience.module.ProjectConfig;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.mongodb.MongoDB;
import java.util.UUID;
import monix.execution.Ack;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.execution.schedulers.SchedulerService;
import monix.reactive.Observable;
import monix.reactive.observers.Subscriber;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class MQTTReaderObservable
extends Observable<Document> {
    private final Builder.Context cxt;
    public final MQTTReader.Info ambience$etl$mqtt$MQTTReaderObservable$$info;
    private final Document doc;
    private final Logger logger;
    private final String clientId;
    private final IMqttActionListener connectionListener;
    private Subscriber subscriber;

    public MQTTReaderObservable(Builder.Context cxt, MQTTReader.Info info, Document doc) {
        this.cxt = cxt;
        this.ambience$etl$mqtt$MQTTReaderObservable$$info = info;
        this.doc = doc;
        this.logger = new Logger(cxt);
        this.clientId = info.sessionId().isEmpty() ? UUID.randomUUID().toString() : info.sessionId();
        this.connectionListener = new IMqttActionListener(this){
            private final /* synthetic */ MQTTReaderObservable $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onSuccess(IMqttToken asyncActionToken) {
                this.$outer.logger().log((LogMessage)LogMessage.Info$.MODULE$.apply("Connected clientId=" + this.$outer.clientId() + " QOS=" + this.$outer.ambience$etl$mqtt$MQTTReaderObservable$$info.qos() + " hasSession=" + asyncActionToken.getSessionPresent()));
            }

            public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                this.$outer.logger().log((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Connection failure", exception));
            }
        };
    }

    public Logger logger() {
        return this.logger;
    }

    public String clientId() {
        return this.clientId;
    }

    public IMqttActionListener connectionListener() {
        return this.connectionListener;
    }

    public Subscriber<Document> subscriber() {
        return this.subscriber;
    }

    public void subscriber_$eq(Subscriber<Document> x$1) {
        this.subscriber = x$1;
    }

    public Cancelable unsafeSubscribeFn(Subscriber<Document> subscriber) {
        this.subscriber_$eq(subscriber);
        ProjectConfig projectConfig = (ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class));
        MongoDB mongoDB = (MongoDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDB.class));
        MongoPersistence persistence = new MongoPersistence(projectConfig, mongoDB);
        MqttAsyncClient client = new MqttAsyncClient(this.ambience$etl$mqtt$MQTTReaderObservable$$info.broker(), this.clientId(), (MqttClientPersistence)persistence);
        client.setManualAcks(true);
        MqttConnectOptions connOpts = new MqttConnectOptions();
        connOpts.setCleanSession(false);
        Callback cb = new Callback(this.cxt, this.logger(), this.ambience$etl$mqtt$MQTTReaderObservable$$info, client, this.doc, subscriber);
        client.setCallback(cb.cb());
        this.logger().log((LogMessage)LogMessage.Info$.MODULE$.apply("Connecting to " + this.ambience$etl$mqtt$MQTTReaderObservable$$info.broker()));
        client.connect(connOpts).waitForCompletion();
        client.subscribe(this.ambience$etl$mqtt$MQTTReaderObservable$$info.topic(), this.ambience$etl$mqtt$MQTTReaderObservable$$info.qos(), (Object)"context", this.connectionListener());
        return Cancelable$.MODULE$.empty();
    }

    public static class Callback {
        public final Logger ambience$etl$mqtt$MQTTReaderObservable$Callback$$logger;
        public final MqttAsyncClient ambience$etl$mqtt$MQTTReaderObservable$Callback$$client;
        public final Document ambience$etl$mqtt$MQTTReaderObservable$Callback$$doc;
        public final Subscriber<Document> ambience$etl$mqtt$MQTTReaderObservable$Callback$$subscriber;
        private boolean terminated;
        private final MqttCallback cb;

        public Callback(Builder.Context cxt, Logger logger, MQTTReader.Info info, MqttAsyncClient client, Document doc, Subscriber<Document> subscriber) {
            this.ambience$etl$mqtt$MQTTReaderObservable$Callback$$logger = logger;
            this.ambience$etl$mqtt$MQTTReaderObservable$Callback$$client = client;
            this.ambience$etl$mqtt$MQTTReaderObservable$Callback$$doc = doc;
            this.ambience$etl$mqtt$MQTTReaderObservable$Callback$$subscriber = subscriber;
            this.terminated = false;
            this.cb = new MqttCallback(this){
                private final /* synthetic */ Callback $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void messageArrived(String topic, MqttMessage message) {
                    this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$logger.log((LogMessage)LogMessage.Info$.MODULE$.apply("Message arrived " + message.getId()));
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBinary$.MODULE$.apply(message.getPayload())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"topic");
                    objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(topic)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    Future future = this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$subscriber.onNext(this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    if (Ack.Continue$.MODULE$.equals(future)) {
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$client.messageArrivedComplete(message.getId(), message.getQos());
                    } else if (Ack.Stop$.MODULE$.equals(future)) {
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$client.messageArrivedComplete(message.getId(), message.getQos());
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$logger.log((LogMessage)LogMessage.Info$.MODULE$.apply("Downstream requested stop"));
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$subscriber.onComplete();
                        this.$outer.terminated_$eq(true);
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$client.disconnect().waitForCompletion();
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$client.close();
                    } else {
                        Future x = future;
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$logger.log((LogMessage)LogMessage.Info$.MODULE$.apply("Unexpected message: " + x));
                    }
                }

                public void connectionLost(Throwable cause) {
                    if (!this.$outer.terminated()) {
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$logger.log((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Connection lost", cause));
                        this.$outer.ambience$etl$mqtt$MQTTReaderObservable$Callback$$subscriber.onError(cause);
                        return;
                    }
                }

                public void deliveryComplete(IMqttDeliveryToken token) {
                }
            };
        }

        public boolean terminated() {
            return this.terminated;
        }

        public void terminated_$eq(boolean x$1) {
            this.terminated = x$1;
        }

        public MqttCallback cb() {
            return this.cb;
        }
    }

    public static class Logger {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Logger.class.getDeclaredField("io$lzy1"));
        private final Builder.Context cxt;
        private volatile Object io$lzy1;

        public Logger(Builder.Context cxt) {
            this.cxt = cxt;
        }

        public SchedulerService io() {
            Object object = this.io$lzy1;
            if (object instanceof SchedulerService) {
                return (SchedulerService)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (SchedulerService)this.io$lzyINIT1();
        }

        private Object io$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.io$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        SchedulerService schedulerService = null;
                        try {
                            schedulerService = Scheduler$.MODULE$.cached("MQTT-Logger", 1, 1, Scheduler$.MODULE$.cached$default$4(), Scheduler$.MODULE$.cached$default$5(), Scheduler$.MODULE$.cached$default$6(), Scheduler$.MODULE$.cached$default$7());
                            object2 = schedulerService == null ? LazyVals.NullValue$.MODULE$ : schedulerService;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.io$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return schedulerService;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public void log(LogMessage msg) {
            this.cxt.logT(msg).runAsyncAndForget((Scheduler)this.io());
        }
    }
}

