/*
 * Decompiled with CFR 0.152.
 */
package ambience.workgroups;

import ambience.api.WorkgroupsAPI;
import ambience.codex.BulkDownload$;
import ambience.codex.URFilter$;
import ambience.framework.UserRoleInfo2$;
import ambience.module.UserDB;
import ambience.workgroups.BuildDownload;
import ambience.workgroups.BuildDownload$Download$;
import ambience.workgroups.Collections$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexFilter;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class BuildDownload$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(BuildDownload$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final BuildDownload$Download$ Download;
    public static final BuildDownload$ MODULE$;

    private BuildDownload$() {
    }

    static {
        MODULE$ = new BuildDownload$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BuildDownload$.class);
    }

    public Task<Either<LogMessage, BuildDownload.Download>> apply(UserDB.User user, String workgroupId, List<WorkgroupsAPI.ArtifactSupplier> suppliers) {
        return this.getWorkgroup(user, workgroupId).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document wdoc = (Document)((Some)option).value();
                return MODULE$.apply(user, workgroupId, wdoc, suppliers);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Workgroup not found")));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<LogMessage, BuildDownload.Download>> apply(UserDB.User user, String workgroupId, Document wdoc, List<WorkgroupsAPI.ArtifactSupplier> suppliers) {
        this.log().info(() -> BuildDownload$.apply$$anonfun$2(workgroupId, user), Line$.MODULE$.apply(30), FullName$.MODULE$.apply("ambience.workgroups.BuildDownload.apply"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        String name = this.addWorkgroup(zos, wdoc);
        List all = suppliers.map((Function1 & Serializable)supplier -> supplier.artifactsWithWorkgroup(user, workgroupId).toListL().map((Function1)(JProcedure1 & Serializable)artifacts -> {
            MODULE$.log().info(() -> BuildDownload$.$anonfun$1$$anonfun$1$$anonfun$1(artifacts, supplier), Line$.MODULE$.apply(36), FullName$.MODULE$.apply("ambience.workgroups.BuildDownload.all"));
            artifacts.foreach((Function1 & Serializable)a -> supplier.nameLens().getOption(a).map((Function1)(JProcedure1 & Serializable)name -> {
                String filename = name + supplier.fileExtension();
                ZipEntry ze = new ZipEntry(filename);
                zos.putNextEntry(ze);
                zos.write(a.spaces2().getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
            }));
        }));
        return Task$.MODULE$.sequence((Iterable)all, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)_$1 -> {
            zos.close();
            byte[] bytes = baos.toByteArray();
            return package$.MODULE$.Right().apply((Object)BuildDownload$Download$.MODULE$.apply(name + ".zip", bytes));
        });
    }

    public Task<Option<Document>> getWorkgroup(UserDB.User user, String workgroupId) {
        return URFilter$.MODULE$.accessFilterT(user).flatMap((Function1 & Serializable)userAccess -> UserRoleInfo2$.MODULE$.load().flatMap((Function1 & Serializable)info -> {
            CodexFilter.Eq withId = CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(workgroupId));
            CodexFilter.Exists hasName = CodexFilter.Exists$.MODULE$.apply("name");
            return Collections$.MODULE$.workgroups().flatMap((Function1 & Serializable)_$2 -> _$2.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{userAccess, withId, hasName}))).firstOptionL());
        }));
    }

    public String addWorkgroup(ZipOutputStream zos, Document doc) {
        String name = (String)doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$3 -> _$3.getValue()).getOrElse(BuildDownload$::$anonfun$3);
        String filename = name + ".workgroup.json";
        ZipEntry ze = new ZipEntry(filename);
        zos.putNextEntry(ze);
        byte[] bytes = doc.toJson(BulkDownload$.MODULE$.RelaxedJsonSettings()).getBytes(StandardCharsets.UTF_8);
        zos.write(bytes);
        zos.closeEntry();
        return name;
    }

    private static final Object apply$$anonfun$2(String workgroupId$2, UserDB.User user$2) {
        return "Building download of " + workgroupId$2 + " for " + user$2.name();
    }

    private static final Object $anonfun$1$$anonfun$1$$anonfun$1(List artifacts$1, WorkgroupsAPI.ArtifactSupplier supplier$1) {
        return "Found " + artifacts$1.size() + " artifacts from " + supplier$1.label();
    }

    private static final String $anonfun$3() {
        return "unknown";
    }
}

