/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.designer.db;

import ambience.cms.Lenses$;
import ambience.module.AmbienceDB$;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexFindOptions$;
import com.elixirtech.codex.CodexUpdate;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface DesignerCodex
extends LoggingHelper2 {
    public static void $init$(DesignerCodex $this) {
        $this.ambience$cms$designer$db$DesignerCodex$_setter_$UniqueKeyExists_$eq(CodexFilter.Exists$.MODULE$.apply("uniqueKey"));
        $this.ambience$cms$designer$db$DesignerCodex$_setter_$Enabled_$eq(CodexFilter.Eq$.MODULE$.apply("enabled", (BsonValue)AmbienceDB$.MODULE$.BsonTrue()));
    }

    public String artifactName();

    public Task<CodexCollection> collectionT();

    public CodexFilter.Exists UniqueKeyExists();

    public void ambience$cms$designer$db$DesignerCodex$_setter_$UniqueKeyExists_$eq(CodexFilter.Exists var1);

    public CodexFilter.Eq Enabled();

    public void ambience$cms$designer$db$DesignerCodex$_setter_$Enabled_$eq(CodexFilter.Eq var1);

    public static CodexFilter.Eq withId$(DesignerCodex $this, String id) {
        return $this.withId(id);
    }

    default public CodexFilter.Eq withId(String id) {
        return CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(id));
    }

    public static CodexFilter.Eq withName$(DesignerCodex $this, String name) {
        return $this.withName(name);
    }

    default public CodexFilter.Eq withName(String name) {
        return CodexFilter.Eq$.MODULE$.apply("name", (BsonValue)BsonString$.MODULE$.apply(name));
    }

    public static Task load$(DesignerCodex $this, UserDB.User user, String id) {
        return $this.load(user, id);
    }

    default public Task<Either<String, Json>> load(UserDB.User user, String id) {
        this.log().info(() -> this.load$$anonfun$1(id), Line$.MODULE$.apply(27), FullName$.MODULE$.apply("ambience.cms.designer.db.DesignerCodex.load"));
        CodexFilter.And filters = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{this.UniqueKeyExists(), this.withId(id), this.Enabled()}));
        return this.collectionT().flatMap((Function1 & Serializable)_$1 -> _$1.findOneO((CodexFilter)filters).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)(this.artifactName() + " not found with id:" + id));
            }
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return io.circe.parser.package$.MODULE$.parse(doc.toJson()).left().map((Function1 & Serializable)_$2 -> _$2.message());
            }
            throw new MatchError((Object)option);
        }));
    }

    public static Task loadByName$(DesignerCodex $this, UserDB.User user, String name) {
        return $this.loadByName(user, name);
    }

    default public Task<Either<String, Json>> loadByName(UserDB.User user, String name) {
        this.log().info(() -> this.loadByName$$anonfun$1(name), Line$.MODULE$.apply(36), FullName$.MODULE$.apply("ambience.cms.designer.db.DesignerCodex.loadByName"));
        CodexFilter.And filters = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{this.UniqueKeyExists(), this.withName(name), this.Enabled()}));
        CodexFindOptions sort = CodexFindOptions$.MODULE$.sorts((CodexFindOptions.Sort)CodexFindOptions.Descending$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"contentVersion"})));
        return this.collectionT().flatMap((Function1 & Serializable)_$3 -> _$3.findO((CodexFilter)filters, sort).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)(this.artifactName() + " not found with name:" + name));
            }
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return io.circe.parser.package$.MODULE$.parse(doc.toJson()).left().map((Function1 & Serializable)_$4 -> _$4.message());
            }
            throw new MatchError((Object)option);
        }));
    }

    public static Task save$(DesignerCodex $this, UserDB.User user, Json json) {
        return $this.save(user, json);
    }

    default public Task<BoxedUnit> save(UserDB.User user, Json json) {
        this.log().info(this::save$$anonfun$1, Line$.MODULE$.apply(46), FullName$.MODULE$.apply("ambience.cms.designer.db.DesignerCodex.save"));
        Either<String, String> either = this.getId(json);
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            this.log().error(() -> DesignerCodex.save$$anonfun$2(msg), Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.cms.designer.db.DesignerCodex.save"));
            return Task$.MODULE$.unit();
        }
        if (either instanceof Right) {
            String id = (String)((Right)either).value();
            return this.load(user, id).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Right) {
                    return this.update(id, json);
                }
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    this.log().error(() -> DesignerCodex.save$$anonfun$3$$anonfun$1(msg), Line$.MODULE$.apply(55), FullName$.MODULE$.apply("ambience.cms.designer.db.DesignerCodex.save"));
                    return Task$.MODULE$.unit();
                }
                throw new MatchError((Object)either);
            });
        }
        throw new MatchError(either);
    }

    public static Task update$(DesignerCodex $this, UserDB.User user, String pageId, Json json) {
        return $this.update(user, pageId, json);
    }

    default public Task<Either<String, BoxedUnit>> update(UserDB.User user, String pageId, Json json) {
        Document newDoc = Document$.MODULE$.apply(json.noSpaces());
        CodexFilter.Eq ownerFilter = CodexFilter.Eq$.MODULE$.apply("owner", (BsonValue)BsonString$.MODULE$.apply(user.id()));
        CodexUpdate.CurrentTimestamp updateLastModified = CodexUpdate.CurrentTimestamp$.MODULE$.apply("lastModified");
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{this.withId(pageId), ownerFilter}));
        Option optUpdates = newDoc.get("name", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$5 -> CodexUpdate.Set$.MODULE$.apply("name", _$5)).flatMap((Function1 & Serializable)name -> newDoc.get("nextIndex", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$6 -> CodexUpdate.Set$.MODULE$.apply("nextIndex", _$6)).flatMap((Function1 & Serializable)nextIndex -> newDoc.get("items", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$7 -> CodexUpdate.Set$.MODULE$.apply("items", _$7)).map((Function1 & Serializable)items -> CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{name, nextIndex, items, updateLastModified})))));
        Option option = optUpdates;
        if (option instanceof Some) {
            CodexUpdate.Combine updates = (CodexUpdate.Combine)((Some)option).value();
            return this.collectionT().flatMap((Function1 & Serializable)_$8 -> _$8.updateOneT((CodexFilter)filter, (CodexUpdate)updates).map((Function1 & Serializable)reply -> {
                if (reply.getMatchedCount() == 1L) {
                    return Right$.MODULE$.apply((Object)BoxedUnit.UNIT);
                }
                this.log().warn(() -> DesignerCodex.update$$anonfun$1$$anonfun$1$$anonfun$1(pageId, user), Line$.MODULE$.apply(76), FullName$.MODULE$.apply("ambience.cms.designer.db.DesignerCodex.update"));
                return package$.MODULE$.Left().apply((Object)("Can't update page " + pageId + " with owner " + user.id() + " (" + user.name() + ")"));
            }));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.apply(DesignerCodex::update$$anonfun$2);
        }
        throw new MatchError((Object)option);
    }

    private Task<BoxedUnit> update(String id, Json json) {
        Option optUpdate = Document$.MODULE$.apply(json.noSpaces()).get("content", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)).map((Function1 & Serializable)_$9 -> CodexUpdate.Set$.MODULE$.apply("content", _$9)).map((Function1 & Serializable)uc -> CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{uc, CodexUpdate.CurrentTimestamp$.MODULE$.apply("lastModified")})));
        Option option = optUpdate;
        if (option instanceof Some) {
            CodexUpdate.Combine updates = (CodexUpdate.Combine)((Some)option).value();
            return this.collectionT().flatMap((Function1 & Serializable)_$10 -> _$10.updateOneT((CodexFilter)this.withId(id), (CodexUpdate)updates).map((Function1)(JProcedure1 & Serializable)_$11 -> {}));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.unit();
        }
        throw new MatchError((Object)option);
    }

    public static Either getId$(DesignerCodex $this, Json json) {
        return $this.getId(json);
    }

    default public Either<String, String> getId(Json json) {
        Option option = Lenses$.MODULE$._Id().getOption((Object)json);
        if (option instanceof Some) {
            String id = (String)((Some)option).value();
            return Right$.MODULE$.apply((Object)id);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("id not found in " + json));
        }
        throw new MatchError((Object)option);
    }

    private Object load$$anonfun$1(String id$1) {
        return "Loading " + this.artifactName() + " with id:" + id$1;
    }

    private Object loadByName$$anonfun$1(String name$1) {
        return "Loading " + this.artifactName() + " with name:" + name$1;
    }

    private Object save$$anonfun$1() {
        return "Saving Contents " + this.artifactName();
    }

    private static Object save$$anonfun$2(String msg$1) {
        return msg$1;
    }

    private static Object save$$anonfun$3$$anonfun$1(String msg$2) {
        return msg$2;
    }

    private static Object update$$anonfun$1$$anonfun$1$$anonfun$1(String pageId$3, UserDB.User user$3) {
        return "Can't update page " + pageId$3 + " with owner " + user$3.id() + " (" + user$3.name() + ")";
    }

    private static Right update$$anonfun$2() {
        return Right$.MODULE$.apply((Object)BoxedUnit.UNIT);
    }
}

