/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management;

import ambience.cms.Lenses$;
import ambience.framework.SafeUploadHandler;
import ambience.framework.SafeUploadHandler$;
import ambience.module.UserDB;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonValue;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class CMSUploadHandler
extends SafeUploadHandler {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CMSUploadHandler.class.getDeclaredField("component$lzy1"));
    private String id;
    private volatile Object component$lzy1;

    public CMSUploadHandler(String id) {
        this.id = id;
    }

    public abstract List<Json> getVersions(Json var1);

    public AuditAPI.Component component() {
        Object object = this.component$lzy1;
        if (object instanceof AuditAPI.Component) {
            return (AuditAPI.Component)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AuditAPI.Component)this.component$lzyINIT1();
    }

    private Object component$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.component$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AuditAPI.Component component = null;
                    try {
                        component = AuditAPI.Component$.MODULE$.apply("cms", this.id);
                        object2 = component == null ? LazyVals.NullValue$.MODULE$ : component;
                        this.id = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.component$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return component;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<GravityRequest, Task<GravityResponse>> postUpload(UserDB.User user) {
        return (Function1 & Serializable)request -> (Task)request.formParameter("name").map((Function1 & Serializable)name -> {
            Object object = request.formParameter("overwrite").getOrElse(CMSUploadHandler::$anonfun$1);
            String string = "true";
            boolean overwrite = !(object != null ? !object.equals(string) : string != null);
            return this.log().infoT(() -> CMSUploadHandler.postUpload$$anonfun$1$$anonfun$1$$anonfun$1(user, name, overwrite), Line$.MODULE$.apply(25), FullName$.MODULE$.apply("ambience.cms.management.CMSUploadHandler.postUpload")).flatMap((Function1 & Serializable)_$1 -> {
                Gravity.FormItem formItem;
                Option option = request.formItems().get("file");
                if (option instanceof Some && (formItem = (Gravity.FormItem)((Some)option).value()) instanceof Gravity.FileUploadItem) {
                    Gravity.FileUploadItem file = (Gravity.FileUploadItem)formItem;
                    return this.handleUpload(user, file.data().bytes(), (Option)Some$.MODULE$.apply(name), overwrite).map((Function1 & Serializable)result -> this.buildResponse((SafeUploadHandler.Result)result));
                }
                return Gravity$.MODULE$.BadRequestResponseT("Can't read file");
            });
        }).getOrElse(CMSUploadHandler::postUpload$$anonfun$1$$anonfun$2);
    }

    public Function1<GravityRequest, Task<GravityResponse>> postUploadZip(UserDB.User user) {
        return (Function1 & Serializable)request -> {
            Object object = request.formParameter("overwrite").getOrElse(CMSUploadHandler::$anonfun$2);
            String string = "true";
            boolean overwrite = !(object != null ? !object.equals(string) : string != null);
            return this.log().infoT(() -> CMSUploadHandler.postUploadZip$$anonfun$1$$anonfun$1(user, overwrite), Line$.MODULE$.apply(38), FullName$.MODULE$.apply("ambience.cms.management.CMSUploadHandler.postUploadZip")).flatMap((Function1 & Serializable)_$2 -> {
                Gravity.FormItem formItem;
                Option option = request.formItems().get("file");
                if (option instanceof Some && (formItem = (Gravity.FormItem)((Some)option).value()) instanceof Gravity.FileUploadItem) {
                    Gravity.FileUploadItem file = (Gravity.FileUploadItem)formItem;
                    return this.handleUploadZip(user, file.data().bytes(), overwrite).map((Function1 & Serializable)result -> this.buildZipResponse((List<SafeUploadHandler.Result>)result));
                }
                return Gravity$.MODULE$.BadRequestResponseT("Can't read file");
            });
        };
    }

    public Task<SafeUploadHandler.Result> handleUpload(UserDB.User user, Json json, Option<String> optName, boolean overwrite) {
        List<Json> versions = this.getVersions(json);
        Either either = this.isValidContent(json);
        if (either instanceof Right) {
            SafeUploadHandler.ExtractedInfo extractedInfo;
            SafeUploadHandler.ExtractedInfo incoming = extractedInfo = (SafeUploadHandler.ExtractedInfo)((Right)either).value();
            if (optName.isEmpty() && incoming.name().isEmpty()) {
                return Task$.MODULE$.now((Object)SafeUploadHandler.Result$.MODULE$.apply("", (LogMessage)LogMessage.Error$.MODULE$.apply("Empty name not allowed"), SafeUploadHandler.Result$.MODULE$.$lessinit$greater$default$3()));
            }
            SafeUploadHandler.ExtractedInfo incoming2 = extractedInfo;
            if (versions.isEmpty()) {
                return this.handleRequest(SafeUploadHandler.Request$.MODULE$.apply(user, json, incoming2._id(), (String)optName.getOrElse(() -> CMSUploadHandler.handleUpload$$anonfun$1(incoming2)), overwrite));
            }
            SafeUploadHandler.ExtractedInfo incoming3 = extractedInfo;
            return this.handleRequests(versions, SafeUploadHandler.Request$.MODULE$.apply(user, json, incoming3._id(), (String)optName.getOrElse(() -> CMSUploadHandler.handleUpload$$anonfun$2(incoming3)), overwrite));
        }
        if (either instanceof Left) {
            Task result = (Task)((Left)either).value();
            return result;
        }
        throw new MatchError((Object)either);
    }

    public Task<SafeUploadHandler.Result> handleRequests(List<Json> versions, SafeUploadHandler.Request request2) {
        return Task$.MODULE$.sequence((Iterable)versions.map((Function1 & Serializable)j -> request2.copy(request2.copy$default$1(), j, request2.copy$default$3(), request2.copy$default$4(), request2.copy$default$5())).map((Function1 & Serializable)request -> this.handleRequest((SafeUploadHandler.Request)request)), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)reqs -> {
            Option option = ((IterableOnceOps)reqs.groupBy((Function1 & Serializable)_$3 -> _$3.name()).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String n = (String)tuple2._1();
                    List ls = (List)tuple2._2();
                    return SafeUploadHandler.Result$.MODULE$.apply(n, (LogMessage)LogMessage.LogMessageList$.MODULE$.apply(ls.map((Function1 & Serializable)_$4 -> _$4.msg())), SafeUploadHandler.Result$.MODULE$.$lessinit$greater$default$3());
                }
                throw new MatchError((Object)tuple2);
            })).toList().headOption();
            if (option instanceof Some) {
                SafeUploadHandler.Result res = (SafeUploadHandler.Result)((Some)option).value();
                return res;
            }
            if (None$.MODULE$.equals(option)) {
                return SafeUploadHandler.Result$.MODULE$.apply(request2.name(), (LogMessage)LogMessage.Error$.MODULE$.apply("No Requests found"), SafeUploadHandler.Result$.MODULE$.$lessinit$greater$default$3());
            }
            throw new MatchError((Object)option);
        });
    }

    public GravityResponse buildResponse(SafeUploadHandler.Result result) {
        LogMessage logMessage = result.msg();
        if (LogMessage.None$.MODULE$.equals(logMessage)) {
            return GravityResponse$.MODULE$.text("Upload completed");
        }
        if (logMessage instanceof LogMessage.Info) {
            LogMessage.Info msg = (LogMessage.Info)logMessage;
            return GravityResponse$.MODULE$.text(msg.msg());
        }
        if (logMessage instanceof LogMessage.LogMessageList) {
            LogMessage.LogMessageList logMessageList = (LogMessage.LogMessageList)logMessage;
            LogMessage.LogMessageList msg = logMessageList;
            if (msg.logs().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(LogMessage x) {
                    LogMessage logMessage = x;
                    if (logMessage instanceof LogMessage.Error) {
                        LogMessage.Error lm = (LogMessage.Error)logMessage;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(LogMessage x, Function1 function1) {
                    LogMessage logMessage = x;
                    if (logMessage instanceof LogMessage.Error) {
                        LogMessage.Error lm = (LogMessage.Error)logMessage;
                        return lm;
                    }
                    return function1.apply((Object)x);
                }
            }).isEmpty()) {
                return GravityResponse$.MODULE$.text(msg.msg());
            }
            LogMessage.LogMessageList msg2 = logMessageList;
            return Gravity$.MODULE$.BadRequestResponse(msg2.msg());
        }
        return Gravity$.MODULE$.BadRequestResponse(result.msg().msg());
    }

    public GravityResponse buildZipResponse(List<SafeUploadHandler.Result> result2) {
        return GravityResponse$.MODULE$.json(Json$.MODULE$.fromValues((Iterable)result2.map((Function1 & Serializable)result -> this.buildResultJson((SafeUploadHandler.Result)result))));
    }

    public Json buildResultJson(SafeUploadHandler.Result result) {
        LogMessage.LogMessageList lm;
        LogMessage logMessage = result.msg();
        String msg = LogMessage.None$.MODULE$.equals(logMessage) ? "Upload completed" : result.msg().msg();
        LogMessage logMessage2 = result.msg();
        boolean error = LogMessage.None$.MODULE$.equals(logMessage2) ? false : (logMessage2 instanceof LogMessage.Info ? false : !(logMessage2 instanceof LogMessage.LogMessageList) || !(lm = (LogMessage.LogMessageList)logMessage2).logs().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(LogMessage x) {
                LogMessage logMessage = x;
                if (logMessage instanceof LogMessage.Error) {
                    LogMessage.Error lm = (LogMessage.Error)logMessage;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(LogMessage x, Function1 function1) {
                LogMessage logMessage = x;
                if (logMessage instanceof LogMessage.Error) {
                    LogMessage.Error lm = (LogMessage.Error)logMessage;
                    return lm;
                }
                return function1.apply((Object)x);
            }
        }).isEmpty());
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"file");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(result.name()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"msg");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(msg));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromBoolean(error));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Task<BoxedUnit> audit(SafeUploadHandler.Request request, SafeUploadHandler.Result result) {
        return SafeUploadHandler$.MODULE$.audit(this.component(), request, result);
    }

    public SafeUploadHandler.Request updateName(SafeUploadHandler.Request request) {
        Json json = (Json)Lenses$.MODULE$.Name().modify((Function1 & Serializable)_$5 -> request.name()).apply((Object)request.incomingJson());
        UserDB.User user = request.copy$default$1();
        BsonValue bsonValue = request.copy$default$3();
        String string = request.copy$default$4();
        boolean bl = request.copy$default$5();
        return request.copy(user, json, bsonValue, string, bl);
    }

    private static final String $anonfun$1() {
        return "false";
    }

    private static final Object postUpload$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$4, String name$2, boolean overwrite$2) {
        return "upload by " + user$4.name() + " parameters: name=" + name$2 + ", overwrite=" + overwrite$2;
    }

    private static final Task postUpload$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing form item 'name'");
    }

    private static final String $anonfun$2() {
        return "false";
    }

    private static final Object postUploadZip$$anonfun$1$$anonfun$1(UserDB.User user$7, boolean overwrite$4) {
        return "upload-zip by " + user$7.name() + " parameters: overwrite=" + overwrite$4;
    }

    private static final String handleUpload$$anonfun$1(SafeUploadHandler.ExtractedInfo incoming$1) {
        return incoming$1.name();
    }

    private static final String handleUpload$$anonfun$2(SafeUploadHandler.ExtractedInfo incoming$2) {
        return incoming$2.name();
    }
}

