/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management;

import ambience.cms.GroupId$;
import ambience.cms.Lenses$;
import ambience.cms.TemplateName;
import ambience.cms.TemplateName$;
import ambience.cms.management.CMSManagementModule;
import ambience.cms.management.ZipHelper$;
import ambience.cms.management.ZipItem;
import ambience.cms.management.ZipItem$;
import ambience.cms.management.pages.MergedPageSystemInfo;
import ambience.cms.management.pages.PageResourceHelper$;
import ambience.cms.management.pages.PageSystemInfoHelper$;
import ambience.cms.management.snapshots.resources.BinaryStoreResource;
import ambience.cms.management.snapshots.resources.BinaryStoreResource$;
import ambience.gravity.GravityHelper$;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.FullDataBytes;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface ExportRoute
extends LoggingHelper2 {
    public static Function1 exportRoute$(ExportRoute $this, UserDB.User user) {
        return $this.exportRoute(user);
    }

    default public Function1<GravityRequest, Task<GravityResponse>> exportRoute(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)groupId -> (Function1 & Serializable)_$1 -> this.doExport(user, GroupId$.MODULE$.apply(groupId.value())));
    }

    public static Task doExport$(ExportRoute $this, UserDB.User user, String groupId) {
        return $this.doExport(user, groupId);
    }

    default public Task<GravityResponse> doExport(UserDB.User user, String groupId) {
        this.log().info(ExportRoute::doExport$$anonfun$1, Line$.MODULE$.apply(27), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
        return ((Task)OptionT$.MODULE$.apply((Object)((CMSManagementModule)this).groupsManager().get(user, groupId)).flatMap((Function1 & Serializable)group -> OptionT$.MODULE$.liftF(((CMSManagementModule)this).pagesManager().getByGroup(groupId), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)pages -> OptionT$.MODULE$.liftF(((CMSManagementModule)this).templatesManager().get(user, (Set<TemplateName>)pages.flatMap((Function1 & Serializable)_$2 -> Lenses$.MODULE$.Template().getOption(_$2).map((Function1 & Serializable)value -> new TemplateName(TemplateName$.MODULE$.apply(value)))).toSet()), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)templates -> OptionT$.MODULE$.liftF((Object)Task$.MODULE$.now(this.getPageResources((List<Json>)pages, (List<Json>)templates)), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)pageResources -> OptionT$.MODULE$.liftF(((CMSManagementModule)this).resourcesManager().getByUniqueKeys(user, (Set<String>)pageResources.map((Function1 & Serializable)r -> BinaryStoreResource$.MODULE$.asStringIdentifer((BinaryStoreResource)r)).toSet()), (Functor)Task$.MODULE$.catsAsync()).map((Function1 & Serializable)resources -> {
            String groupName = ExportRoute.name$1(group);
            this.log().info(() -> ExportRoute.doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(groupName), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
            this.log().info(() -> ExportRoute.doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(pages), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
            this.info$1(pages.map((Function1 & Serializable)json -> ExportRoute.nameVersion$1(json)));
            this.log().info(() -> ExportRoute.doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$4(templates), Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
            this.info$1(templates.map((Function1 & Serializable)json -> ExportRoute.nameVersion$1(json)));
            this.log().info(() -> ExportRoute.doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$6(resources), Line$.MODULE$.apply(44), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
            this.info$1(resources.map((Function1 & Serializable)json -> ExportRoute.name$1(json)));
            this.log().info(() -> ExportRoute.doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$8(resources), Line$.MODULE$.apply(46), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
            this.info$1(pageResources.map((Function1 & Serializable)p -> "store=" + p.store() + ", category=" + p.category() + ", name=" + p.name()));
            String groupUrlPrefix = (String)Lenses$.MODULE$.URLPrefix().getOption(group).getOrElse(ExportRoute::$anonfun$1);
            return PageResourceHelper$.MODULE$.fetchResourceZipItemList(user, groupUrlPrefix, (List<BinaryStoreResource>)pageResources).map((Function1 & Serializable)zipItems -> {
                ZipItem zipItem = this.toZipItem((Json)group, (List<Json>)pages, (List<Json>)templates, (List<Json>)resources);
                List items = ((List)package$.MODULE$.Nil().$plus$plus((IterableOnce)zipItems)).$colon$colon((Object)zipItem);
                this.log().info(() -> ExportRoute.doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$10$$anonfun$1(items), Line$.MODULE$.apply(51), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
                this.info$1(items.map((Function1 & Serializable)i -> i.name() + ", bytes=" + i.bytes().length));
                Either<String, byte[]> either = ZipHelper$.MODULE$.resourcesToZippedByteArray((List<ZipItem>)items);
                if (either instanceof Left) {
                    String msg = (String)((Left)either).value();
                    return Gravity$.MODULE$.BadRequestResponse(msg);
                }
                if (either instanceof Right) {
                    byte[] bytes = (byte[])((Right)either).value();
                    String filename = "export-" + groupName + ".zip";
                    this.log().info(() -> ExportRoute.doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$10$$anonfun$3(bytes, filename), Line$.MODULE$.apply(57), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
                    this.log().info(ExportRoute::doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$10$$anonfun$4, Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.doExport"));
                    Gravity.Header contentType = Gravity.Header$.MODULE$.ContentType("application/octet-stream");
                    Gravity.Header contentDisposition = GravityResponse.ContentDisposition$.MODULE$.attachment(filename);
                    Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{contentType, contentDisposition}));
                    FullDataBytes fullDataBytes = FullDataBytes$.MODULE$.apply(bytes);
                    int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
                    return GravityResponse$.MODULE$.apply(n, headers, (DataBytes)fullDataBytes);
                }
                throw new MatchError(either);
            });
        }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Task res = (Task)((Some)option).value();
                return res;
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.BadRequestResponseT("Export failed");
            }
            throw new MatchError((Object)option);
        });
    }

    public static ZipItem toZipItem$(ExportRoute $this, Json group, List pages, List templates, List resources) {
        return $this.toZipItem(group, (List<Json>)pages, (List<Json>)templates, (List<Json>)resources);
    }

    default public ZipItem toZipItem(Json group, List<Json> pages, List<Json> templates, List<Json> resources) {
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"group");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)group);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"pages");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromValues(pages));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"templates");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromValues(templates));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"resources");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromValues(resources));
        Json json = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return ZipItem$.MODULE$.apply("metadata.json", json.noSpaces().getBytes(StandardCharsets.UTF_8));
    }

    public static List getPageResources$(ExportRoute $this, List pages, List templates) {
        return $this.getPageResources((List<Json>)pages, (List<Json>)templates);
    }

    default public List<BinaryStoreResource> getPageResources(List<Json> pages, List<Json> templates) {
        Either<String, List<MergedPageSystemInfo>> either = PageSystemInfoHelper$.MODULE$.getMergedPageInfoList(pages, templates);
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            this.log().warn(() -> ExportRoute.getPageResources$$anonfun$1(msg), Line$.MODULE$.apply(84), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.getPageResources"));
            return package$.MODULE$.Nil();
        }
        if (either instanceof Right) {
            List infoList = (List)((Right)either).value();
            return (List)infoList.flatMap((Function1 & Serializable)info -> PageResourceHelper$.MODULE$.getPageResources((MergedPageSystemInfo)info)).distinct();
        }
        throw new MatchError(either);
    }

    public static Task getResources$(ExportRoute $this, UserDB.User user, List bsResources) {
        return $this.getResources(user, (List<BinaryStoreResource>)bsResources);
    }

    default public Task<List<Json>> getResources(UserDB.User user, List<BinaryStoreResource> bsResources) {
        Set ids = bsResources.map((Function1 & Serializable)r -> BinaryStoreResource$.MODULE$.asStringIdentifer((BinaryStoreResource)r)).toSet();
        return ((CMSManagementModule)this).resourcesManager().getByUniqueKeys(user, (Set<String>)ids);
    }

    private static Object doExport$$anonfun$1() {
        return "Export Started";
    }

    private static String name$1$$anonfun$1() {
        return "";
    }

    private static String name$1(Json json) {
        return (String)Lenses$.MODULE$.Name().getOption((Object)json).getOrElse(ExportRoute::name$1$$anonfun$1);
    }

    private static Object nameVersion$1$$anonfun$1() {
        return "";
    }

    private static String nameVersion$1(Json json) {
        return ExportRoute.name$1(json) + "-v" + Lenses$.MODULE$.ContentVersion().getOption((Object)json).getOrElse(ExportRoute::nameVersion$1$$anonfun$1);
    }

    private static Object info$1$$anonfun$1$$anonfun$1(String _$3$1) {
        return _$3$1;
    }

    private void info$1(List l) {
        ((List)l.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)_$3 -> this.log().info(() -> ExportRoute.info$1$$anonfun$1$$anonfun$1(_$3), Line$.MODULE$.apply(37), FullName$.MODULE$.apply("ambience.cms.management.ExportRoute.info")));
    }

    private static Object doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(String groupName$1) {
        return "Exporting Group=" + groupName$1;
    }

    private static Object doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(List pages$4) {
        return "Pages (" + pages$4.size() + ") ======";
    }

    private static Object doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$4(List templates$3) {
        return "Templates (" + templates$3.size() + ") ======";
    }

    private static Object doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$6(List resources$1) {
        return "Resources (" + resources$1.size() + ") ======";
    }

    private static Object doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$8(List resources$2) {
        return "Page Resources Resource (" + resources$2.size() + ") ======";
    }

    private static String $anonfun$1() {
        return "";
    }

    private static Object doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$10$$anonfun$1(List items$1) {
        return "Writing (" + items$1.size() + ") items to zip ======";
    }

    private static Object doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$10$$anonfun$3(byte[] bytes$1, String filename$1) {
        return bytes$1.length + " bytes written to " + filename$1;
    }

    private static Object doExport$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$10$$anonfun$4() {
        return "Export Complete";
    }

    private static Object getPageResources$$anonfun$1(String msg$1) {
        return msg$1;
    }
}

