/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management;

import ambience.api.BinaryStore;
import ambience.cms.management.ZipHelper$;
import ambience.cms.management.ZipItem;
import ambience.cms.management.import.ImportRunner;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import java.io.Serializable;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface ImportRoute
extends LoggingHelper2,
ImportRunner {
    public static Function1 importRoute$(ImportRoute $this, UserDB.User user) {
        return $this.importRoute(user);
    }

    default public Function1<GravityRequest, Task<GravityResponse>> importRoute(UserDB.User user) {
        return (Function1 & Serializable)request -> {
            Gravity.FormItem formItem;
            Option option = request.formItems().get("file");
            if (option instanceof Some && (formItem = (Gravity.FormItem)((Some)option).value()) instanceof Gravity.FileUploadItem) {
                String string;
                Gravity.FormItem formItem2;
                Gravity.FileUploadItem fui = (Gravity.FileUploadItem)formItem;
                Option option2 = request.formItems().get("store");
                if (option2 instanceof Some && (formItem2 = (Gravity.FormItem)((Some)option2).value()) instanceof Gravity.AttributeItem) {
                    Gravity.AttributeItem it = (Gravity.AttributeItem)formItem2;
                    string = it.value();
                } else {
                    string = "";
                }
                String store = string;
                return this.doImport(user, BinaryStore.LocationId$.MODULE$.apply(store), fui);
            }
            return Gravity$.MODULE$.BadRequestResponseT("Missing file parameter");
        };
    }

    public static Task doImport$(ImportRoute $this, UserDB.User user, String store, Gravity.FileUploadItem fui) {
        return $this.doImport(user, store, fui);
    }

    default public Task<GravityResponse> doImport(UserDB.User user, String store, Gravity.FileUploadItem fui) {
        this.log().info(() -> ImportRoute.doImport$$anonfun$1(store, fui), Line$.MODULE$.apply(28), FullName$.MODULE$.apply("ambience.cms.management.ImportRoute.doImport"));
        this.log().info(() -> ImportRoute.doImport$$anonfun$2(fui), Line$.MODULE$.apply(29), FullName$.MODULE$.apply("ambience.cms.management.ImportRoute.doImport"));
        Either<String, List<ZipItem>> either = ZipHelper$.MODULE$.zipToResources(fui.data().bytes());
        if (either instanceof Left) {
            String msg = (String)((Left)either).value();
            this.log().error(() -> ImportRoute.doImport$$anonfun$3(msg), Line$.MODULE$.apply(32), FullName$.MODULE$.apply("ambience.cms.management.ImportRoute.doImport"));
            return Gravity$.MODULE$.BadRequestResponseT("Import failed " + msg);
        }
        if (either instanceof Right) {
            List items = (List)((Right)either).value();
            return this.runImport(user, store, items).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Object object;
                    LogMessage err = (LogMessage)((Left)either).value();
                    LogMessage logMessage = err;
                    if (logMessage instanceof LogMessage.Error) {
                        String string;
                        LogMessage.Error error = LogMessage.Error$.MODULE$.unapply((LogMessage.Error)logMessage);
                        String msg = string = error._1();
                        this.log().error(() -> ImportRoute.$anonfun$1(msg), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("ambience.cms.management.ImportRoute.msg"));
                        object = "Import Failed Invalid Zip File";
                    } else if (logMessage instanceof LogMessage.LogMessageList) {
                        List list;
                        LogMessage.LogMessageList logMessageList = (LogMessage.LogMessageList)logMessage;
                        LogMessage.LogMessageList logMessageList2 = LogMessage.LogMessageList$.MODULE$.unapply(logMessageList);
                        List logs = list = logMessageList2._1();
                        LogMessage.LogMessageList m2 = logMessageList;
                        this.log().error(ImportRoute::$anonfun$2, Line$.MODULE$.apply(42), FullName$.MODULE$.apply("ambience.cms.management.ImportRoute.msg"));
                        logs.map((Function1 & Serializable)_$1 -> _$1.msg()).foreach((Function1)(JProcedure1 & Serializable)m -> this.log().error(() -> ImportRoute.$anonfun$4$$anonfun$1(m), Line$.MODULE$.apply(43), FullName$.MODULE$.apply("ambience.cms.management.ImportRoute.msg")));
                        object = "Import Failed Invalid Zip File";
                    } else {
                        LogMessage l = logMessage;
                        object = "Unknown Import Error " + l.msg();
                    }
                    String msg = object;
                    return Gravity$.MODULE$.BadRequestResponse(msg);
                }
                if (either instanceof Right) {
                    return Gravity$.MODULE$.OkResponse();
                }
                throw new MatchError((Object)either);
            });
        }
        throw new MatchError(either);
    }

    private static Object doImport$$anonfun$1(String store$1, Gravity.FileUploadItem fui$1) {
        return "Import received store=" + store$1 + ",file=" + fui$1.filename();
    }

    private static Object doImport$$anonfun$2(Gravity.FileUploadItem fui$2) {
        return "Bytes read=" + fui$2.length();
    }

    private static Object doImport$$anonfun$3(String msg$1) {
        return "Import failed " + msg$1;
    }

    private static Object $anonfun$1(String msg$2) {
        return "Import Error Found: " + msg$2;
    }

    private static Object $anonfun$2() {
        return "Import Errors Found:";
    }

    private static Object $anonfun$4$$anonfun$1(String m$1) {
        return m$1;
    }
}

