/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management;

import ambience.cms.Id;
import ambience.cms.Id$;
import ambience.cms.Name;
import ambience.cms.Name$;
import ambience.codex.BulkRoute;
import ambience.framework.UUIDDocumentManager2;
import ambience.framework.UUIDDocumentRoute2;
import ambience.gravity.GravityHelper$;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SyncDataBytes;
import com.elixirtech.coredata.JsonProcessor;
import com.elixirtech.coredata.JsonProcessor$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.mongodb.UploadHelper2;
import com.elixirtech.mongodb.UploadHelper2$;
import com.elixirtech.webserver.I18N$;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.Json$;
import io.circe.ParsingFailure;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class RouteBuilder
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RouteBuilder.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final UUIDDocumentManager2 docManager;
    private final UUIDDocumentRoute2 docRoute;
    private final BulkRoute bulkRoute;
    private final Function2 blankJsonFn;
    private final Function1 decodeFn;

    public RouteBuilder(UUIDDocumentManager2 docManager, UUIDDocumentRoute2 docRoute, BulkRoute bulkRoute, Function2<UserDB.User, Name, Json> blankJsonFn, Function1<Json, Either<DecodingFailure, BoxedUnit>> decodeFn) {
        this.docManager = docManager;
        this.docRoute = docRoute;
        this.bulkRoute = bulkRoute;
        this.blankJsonFn = blankJsonFn;
        this.decodeFn = decodeFn;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public UUIDDocumentManager2 docManager() {
        return this.docManager;
    }

    public UUIDDocumentRoute2 docRoute() {
        return this.docRoute;
    }

    public BulkRoute bulkRoute() {
        return this.bulkRoute;
    }

    public Function2<UserDB.User, Name, Json> blankJsonFn() {
        return this.blankJsonFn;
    }

    public Function1<Json, Either<DecodingFailure, BoxedUnit>> decodeFn() {
        return this.decodeFn;
    }

    public List<GravityRoute> gravityRoutes(UserDB.User user) {
        return (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathPrefix("bulk", this.bulkRoute().handler()), (List)new .colon.colon((Object)GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data/*", this.getDataSeg(user)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "add", this.postAdd(user)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "upload", this.uploadRoute(user, this.docManager())), (List)new .colon.colon((Object)this.docRoute().route(user), (List)Nil$.MODULE$)))));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getDataSeg(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)uuid -> (Function1 & Serializable)_$1 -> this.docManager().get(user, uuid.value()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                return GravityResponse$.MODULE$.json(json);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponse();
            }
            throw new MatchError((Object)option);
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> postAdd(UserDB.User user) {
        return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)json -> (Function1 & Serializable)request -> this.handleAdd(user, (Json)json, I18N$.MODULE$.getAcceptLanguage(request)));
    }

    public Task<Json> prepareNewContent(UserDB.User user, String name, String copyFrom) {
        if (copyFrom.isEmpty()) {
            return Task$.MODULE$.now(this.blankJsonFn().apply((Object)user, (Object)new Name(name)));
        }
        return this.docManager().get(user, copyFrom).map((Function1 & Serializable)reply -> (Json)reply.map(this.copy(user, name)).getOrElse(() -> this.prepareNewContent$$anonfun$1$$anonfun$1(copyFrom, user, name)));
    }

    public Task<GravityResponse> handleAdd(UserDB.User user, Json json, String language) {
        Tuple2 tuple2;
        Option params = json.hcursor().downField("name").as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)value -> new Name(Name$.MODULE$.apply(value))).flatMap((Function1 & Serializable)name -> RouteBuilder.$anonfun$2(json, name == null ? null : ((Name)name).value()));
        Option option = params;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            String name2 = tuple2._1() == null ? null : ((Name)tuple2._1()).value();
            String copyFrom = tuple2._2() == null ? null : ((Id)tuple2._2()).value();
            return this.prepareNewContent(user, name2, copyFrom).flatMap((Function1 & Serializable)cmsJson -> this.docRoute().save(user, cmsJson));
        }
        if (None$.MODULE$.equals(option)) {
            this.log().warn(() -> RouteBuilder.handleAdd$$anonfun$2(json), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("ambience.cms.management.RouteBuilder.handleAdd"));
            return Gravity$.MODULE$.BadRequestResponseT("Bad json");
        }
        throw new MatchError((Object)option);
    }

    public Function1<Json, Json> copy(UserDB.User user, String name) {
        List actions = (List)new .colon.colon((Object)JsonProcessor.Remove$.MODULE$.apply(JsonProcessor.JsonPath$.MODULE$.apply("_id")), (List)new .colon.colon((Object)JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "name", Json$.MODULE$.fromString(name)), (List)new .colon.colon((Object)JsonProcessor.Add$.MODULE$.apply((Option)None$.MODULE$, "owner", Json$.MODULE$.fromString(user.id())), (List)Nil$.MODULE$)));
        return (Function1 & Serializable)json -> JsonProcessor$.MODULE$.run((Seq)actions, json);
    }

    public Task<GravityResponse> handleUpload(UserDB.User user, UUIDDocumentManager2 docManager, SyncDataBytes data, String name, boolean overwrite) {
        Either either = io.circe.parser.package$.MODULE$.parse(new String(data.bytes(), Gravity$.MODULE$.UTF_8()));
        if (either instanceof Right) {
            Json cmsJson = (Json)((Right)either).value();
            Either either2 = (Either)this.decodeFn().apply((Object)cmsJson);
            if (either2 instanceof Right) {
                return this.doUpload(user, docManager, name, cmsJson, overwrite);
            }
            if (either2 instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either2).value();
                this.log().error(() -> RouteBuilder.handleUpload$$anonfun$1(err), Line$.MODULE$.apply(95), FullName$.MODULE$.apply("ambience.cms.management.RouteBuilder.handleUpload"));
                return Gravity$.MODULE$.BadRequestResponseT("Decode Content failed");
            }
            throw new MatchError((Object)either2);
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            this.log().error(() -> RouteBuilder.handleUpload$$anonfun$2(err), Line$.MODULE$.apply(99), FullName$.MODULE$.apply("ambience.cms.management.RouteBuilder.handleUpload"));
            return Gravity$.MODULE$.BadRequestResponseT("Decode json failed");
        }
        throw new MatchError((Object)either);
    }

    public Task<GravityResponse> doUpload(UserDB.User user, UUIDDocumentManager2 docManager, String name, Json cmsJson, boolean overwrite) {
        Task tPreparation = overwrite ? this.handleDeleteBeforeUpload(docManager, user, name) : Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
        return tPreparation.flatMap((Function1 & Serializable)x$12 -> {
            Either either = x$12;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().apply(msg, Line$.MODULE$.apply(117), FullName$.MODULE$.apply("ambience.cms.management.RouteBuilder.doUpload"));
                return Gravity$.MODULE$.BadRequestResponseT("Add failed");
            }
            if (either instanceof Right) {
                Document newDoc = Document$.MODULE$.apply(this.prepareUpload(name, cmsJson, overwrite).noSpaces());
                return docManager.add(user, (BsonValue)BsonString$.MODULE$.apply(name), newDoc).map((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Right) {
                        return Gravity$.MODULE$.OkResponse();
                    }
                    if (either instanceof Left) {
                        LogMessage msg = (LogMessage)((Left)either).value();
                        this.log().apply(msg, Line$.MODULE$.apply(124), FullName$.MODULE$.apply("ambience.cms.management.RouteBuilder.doUpload"));
                        return Gravity$.MODULE$.BadRequestResponse("Add failed");
                    }
                    throw new MatchError((Object)either);
                });
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, Option<UploadHelper2.KeyData>>> handleDeleteBeforeUpload(UUIDDocumentManager2 docManager, UserDB.User user, String name) {
        return UploadHelper2$.MODULE$.findDocument(docManager, name).flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                UploadHelper2.KeyData keyData = (UploadHelper2.KeyData)((Some)option).value();
                String string = keyData.owner();
                String string2 = user.id();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return docManager.delete(user, keyData._id()).map((Function1 & Serializable)x$1 -> {
                        LogMessage logMessage = x$1;
                        if (LogMessage.None$.MODULE$.equals(logMessage)) {
                            return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)keyData));
                        }
                        LogMessage msg = logMessage;
                        return package$.MODULE$.Left().apply((Object)msg);
                    });
                }
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't overwrite - not the Owner")));
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
            }
            throw new MatchError((Object)option);
        });
    }

    public Json prepareUpload(String name, Json json, boolean isOverwrite) {
        return json.mapObject((Function1 & Serializable)obj -> obj.add("name", Json$.MODULE$.fromString(name)));
    }

    public Function1<GravityRequest, Task<GravityResponse>> uploadRoute(UserDB.User user, UUIDDocumentManager2 docManager) {
        return (Function1 & Serializable)request -> (Task)request.formParameter("name").map((Function1 & Serializable)name -> {
            Gravity.FormItem formItem;
            Object object = request.formParameter("overwrite").getOrElse(RouteBuilder::$anonfun$3);
            String string = "true";
            boolean overwrite = !(object != null ? !object.equals(string) : string != null);
            this.log().info(() -> RouteBuilder.uploadRoute$$anonfun$1$$anonfun$1$$anonfun$1(user, name, overwrite), Line$.MODULE$.apply(157), FullName$.MODULE$.apply("ambience.cms.management.RouteBuilder.uploadRoute"));
            Option option = request.formItems().get("file");
            if (option instanceof Some && (formItem = (Gravity.FormItem)((Some)option).value()) instanceof Gravity.FileUploadItem) {
                Gravity.FileUploadItem file = (Gravity.FileUploadItem)formItem;
                return this.handleUpload(user, docManager, file.data(), (String)name, overwrite);
            }
            return Gravity$.MODULE$.BadRequestResponseT("Can't read file");
        }).getOrElse(RouteBuilder::uploadRoute$$anonfun$1$$anonfun$2);
    }

    private static final Object prepareNewContent$$anonfun$1$$anonfun$1$$anonfun$1(String copyFrom$3) {
        return "Can't locate Content " + new Id(copyFrom$3) + ", using blank";
    }

    private final Json prepareNewContent$$anonfun$1$$anonfun$1(String copyFrom$2, UserDB.User user$6, String name$2) {
        this.log().warn(() -> RouteBuilder.prepareNewContent$$anonfun$1$$anonfun$1$$anonfun$1(copyFrom$2), Line$.MODULE$.apply(53), FullName$.MODULE$.apply("ambience.cms.management.RouteBuilder.prepareNewContent"));
        return (Json)this.blankJsonFn().apply((Object)user$6, (Object)new Name(name$2));
    }

    private static final /* synthetic */ Option $anonfun$2(Json json$2, String name) {
        return json$2.hcursor().downField("copyFrom").as(Decoder$.MODULE$.decodeString()).toOption().map((Function1 & Serializable)value -> new Id(Id$.MODULE$.apply(value))).map((Function1 & Serializable)copyFrom -> Tuple2$.MODULE$.apply((Object)new Name(name), (Object)new Id(copyFrom == null ? null : ((Id)copyFrom).value())));
    }

    private static final Object handleAdd$$anonfun$2(Json json$3) {
        return "Unable to add - bad json: " + json$3.noSpaces();
    }

    private static final Object handleUpload$$anonfun$1(DecodingFailure err$1) {
        return "Cannot decode uploaded file as Content: " + err$1;
    }

    private static final Object handleUpload$$anonfun$2(ParsingFailure err$2) {
        return "Cannot decode uploaded file as json: " + err$2;
    }

    private static final String $anonfun$3() {
        return "false";
    }

    private static final Object uploadRoute$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$12, String name$6, boolean overwrite$2) {
        return "upload by " + user$12.name() + " parameters: name=" + name$6 + ", overwrite=" + overwrite$2;
    }

    private static final Task uploadRoute$$anonfun$1$$anonfun$2() {
        return Gravity$.MODULE$.BadRequestResponseT("Missing form item 'name'");
    }
}

