/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management;

import ambience.cms.management.ZipItem;
import ambience.cms.management.ZipItem$;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.param.DynamicTemplate$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ZipHelper$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ZipHelper$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final ZipHelper$ MODULE$ = new ZipHelper$();

    private ZipHelper$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ZipHelper$.class);
    }

    public boolean isZipByteArray(byte[] bytes) {
        Option option = Try$.MODULE$.apply(() -> ZipHelper$.isZipByteArray$$anonfun$1(bytes)).toOption();
        if (option instanceof Some) {
            boolean v = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            return v;
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    public Either<String, BoxedUnit> unzip(Path zipPath, Path outputPath, boolean deleteZip) {
        this.log().info(() -> ZipHelper$.unzip$$anonfun$1(zipPath, outputPath), Line$.MODULE$.apply(28), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.unzip"));
        if (!Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath, new FileAttribute[0]);
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                ZipHelper$.unzip$$anonfun$2(zipPath, outputPath, deleteZip);
                return BoxedUnit.UNIT;
            }).toEither().left().map((Function1 & Serializable)ex -> {
                MODULE$.log().error(() -> ZipHelper$.unzip$$anonfun$3$$anonfun$1(ex), Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.unzip"));
                MODULE$.log().info(() -> ZipHelper$.unzip$$anonfun$3$$anonfun$2(ex), Line$.MODULE$.apply(55), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.unzip"));
                return ex.getMessage();
            });
        }
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ZipHelper$.unzip$$anonfun$4(zipPath);
            return BoxedUnit.UNIT;
        });
        this.log().warn(ZipHelper$::unzip$$anonfun$5, Line$.MODULE$.apply(61), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.unzip"));
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public Either<String, byte[]> resourcesToZippedByteArray(List<ZipItem> resources) {
        return Try$.MODULE$.apply(() -> ZipHelper$.resourcesToZippedByteArray$$anonfun$1(resources)).toEither().left().map((Function1 & Serializable)ex -> {
            MODULE$.log().error(() -> ZipHelper$.resourcesToZippedByteArray$$anonfun$2$$anonfun$1(ex), Line$.MODULE$.apply(79), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.resourcesToZippedByteArray"));
            return ex.getMessage();
        });
    }

    public Either<String, Object> writeBytesToZip(Path zipPath, byte[] bytes) {
        return Try$.MODULE$.apply(() -> ZipHelper$.writeBytesToZip$$anonfun$1(zipPath, bytes)).toEither().left().map((Function1 & Serializable)ex -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                ZipHelper$.writeBytesToZip$$anonfun$2$$anonfun$1(zipPath);
                return BoxedUnit.UNIT;
            }).failed();
            if (try_ instanceof Failure) {
                Throwable ex2 = ((Failure)try_).exception();
                MODULE$.log().error(() -> ZipHelper$.writeBytesToZip$$anonfun$2$$anonfun$2(ex2), Line$.MODULE$.apply(97), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.writeBytesToZip"));
            } else if (!(try_ instanceof Success)) {
                throw new MatchError((Object)try_);
            }
            MODULE$.log().error(() -> ZipHelper$.writeBytesToZip$$anonfun$2$$anonfun$3(ex), Line$.MODULE$.apply(100), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.writeBytesToZip"));
            MODULE$.log().info(() -> ZipHelper$.writeBytesToZip$$anonfun$2$$anonfun$4(ex), Line$.MODULE$.apply(101), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.writeBytesToZip"));
            return ex.getMessage();
        });
    }

    public Either<String, List<ZipItem>> zipToResources(byte[] bytes) {
        return Try$.MODULE$.apply(() -> ZipHelper$.zipToResources$$anonfun$1(bytes)).toEither().left().map((Function1 & Serializable)ex -> {
            MODULE$.log().error(() -> ZipHelper$.zipToResources$$anonfun$2$$anonfun$1(ex), Line$.MODULE$.apply(120), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.zipToResources"));
            return ex.getMessage();
        });
    }

    public List<ZipItem> substituteResources(List<ZipItem> resources, Map<String, String> map) {
        this.log().info(ZipHelper$::substituteResources$$anonfun$1, Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.substituteResources"));
        return resources.map((Function1 & Serializable)res -> {
            if (res.name().endsWith(".html")) {
                String text = new String(res.bytes(), StandardCharsets.UTF_8);
                byte[] bytes = MODULE$.substitute(text, map).getBytes(StandardCharsets.UTF_8);
                return ZipItem$.MODULE$.apply(res.name(), bytes);
            }
            return res;
        });
    }

    public String substitute(String text, Map<String, String> map) {
        return DynamicTemplate$.MODULE$.apply(text).substitute(CollectionConverters$.MODULE$.MapHasAsJava(map).asJava());
    }

    private static final boolean isZipByteArray$$anonfun$1(byte[] bytes$1) {
        return BoxesRunTime.unboxToBoolean((Object)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            DataInputStream in = (DataInputStream)arm.manage((Object)new DataInputStream(new ByteArrayInputStream(bytes$1)));
            return in.readInt() == 1347093252;
        }));
    }

    private static final Object unzip$$anonfun$1(Path zipPath$1, Path outputPath$1) {
        return "unzipping zipPath=" + zipPath$1 + " outputPath=" + outputPath$1;
    }

    private static final Object unzip$$anonfun$2$$anonfun$2() {
        return "deleting zip";
    }

    private static final void unzip$$anonfun$2(Path zipPath$2, Path outputPath$2, boolean deleteZip$1) {
        ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
            ZipFile zipFile = (ZipFile)arm.manage((Object)new ZipFile(zipPath$2.toFile()));
            CollectionConverters$.MODULE$.EnumerationHasAsScala(zipFile.entries()).asScala().foreach((Function1 & Serializable)entry -> {
                if (entry.isDirectory()) {
                    Path path = outputPath$2.resolve(entry.getName());
                    return Files.createDirectories(path, new FileAttribute[0]);
                }
                String name = entry.getName().startsWith("/") ? StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(entry.getName()), 1) : entry.getName();
                Path path = outputPath$2.resolve(name);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                return BoxesRunTime.boxToLong((long)Files.copy(zipFile.getInputStream((ZipEntry)entry), path, new CopyOption[0]));
            });
        });
        if (deleteZip$1) {
            MODULE$.log().info(ZipHelper$::unzip$$anonfun$2$$anonfun$2, Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.unzip"));
            Files.delete(zipPath$2);
            return;
        }
    }

    private static final Object unzip$$anonfun$3$$anonfun$1(Throwable ex$1) {
        return ex$1;
    }

    private static final Object unzip$$anonfun$3$$anonfun$2(Throwable ex$2) {
        return "error =" + ex$2.getMessage();
    }

    private static final void unzip$$anonfun$4(Path zipPath$4) {
        Files.delete(zipPath$4);
    }

    private static final Object unzip$$anonfun$5() {
        return "Unzip path exists unzip aborted";
    }

    private static final byte[] resourcesToZippedByteArray$$anonfun$1(List resources$1) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        ((List)resources$1.distinctBy((Function1 & Serializable)_$1 -> _$1.name())).foreach((Function1)(JProcedure1 & Serializable)resource -> {
            ZipEntry ze = new ZipEntry(resource.name());
            zos.putNextEntry(ze);
            zos.write(resource.bytes());
            zos.closeEntry();
        });
        zos.close();
        return bos.toByteArray();
    }

    private static final Object resourcesToZippedByteArray$$anonfun$2$$anonfun$1(Throwable ex$3) {
        return ex$3;
    }

    private static final Object writeBytesToZip$$anonfun$1$$anonfun$1(byte[] bytes$4, Path zipPath$6) {
        return "writing " + bytes$4.length + " to zipPath=" + zipPath$6;
    }

    private static final Object writeBytesToZip$$anonfun$1$$anonfun$2(Path zipPath$7) {
        return "File not exist " + zipPath$7;
    }

    private static final boolean writeBytesToZip$$anonfun$1(Path zipPath$5, byte[] bytes$3) {
        if (!Files.exists(zipPath$5, new LinkOption[0])) {
            MODULE$.log().info(() -> ZipHelper$.writeBytesToZip$$anonfun$1$$anonfun$1(bytes$3, zipPath$5), Line$.MODULE$.apply(87), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.writeBytesToZip"));
            Files.write(zipPath$5, bytes$3, new OpenOption[0]);
            return true;
        }
        MODULE$.log().error(() -> ZipHelper$.writeBytesToZip$$anonfun$1$$anonfun$2(zipPath$5), Line$.MODULE$.apply(92), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.writeBytesToZip"));
        return false;
    }

    private static final void writeBytesToZip$$anonfun$2$$anonfun$1(Path zipPath$9) {
        Files.delete(zipPath$9);
    }

    private static final Object writeBytesToZip$$anonfun$2$$anonfun$2(Throwable ex$4) {
        return ex$4;
    }

    private static final Object writeBytesToZip$$anonfun$2$$anonfun$3(Throwable ex$5) {
        return ex$5;
    }

    private static final Object writeBytesToZip$$anonfun$2$$anonfun$4(Throwable ex$6) {
        return "error2 =" + ex$6.getMessage();
    }

    private static final Object zipToResources$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "building zip items";
    }

    private static final ZipEntry zipToResources$$anonfun$1$$anonfun$1$$anonfun$2(ZipInputStream zis$1) {
        return zis$1.getNextEntry();
    }

    private static final List zipToResources$$anonfun$1(byte[] bytes$5) {
        return (List)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            MODULE$.log().info(ZipHelper$::zipToResources$$anonfun$1$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(109), FullName$.MODULE$.apply("ambience.cms.management.ZipHelper.zipToResources"));
            ZipInputStream zis = (ZipInputStream)arm.manage((Object)new ZipInputStream(new ByteArrayInputStream(bytes$5)));
            return package$.MODULE$.LazyList().continually(() -> ZipHelper$.zipToResources$$anonfun$1$$anonfun$1$$anonfun$2(zis)).takeWhile((Function1 & Serializable)_$2 -> _$2 != null).map((Function1 & Serializable)file -> ZipItem$.MODULE$.apply(file.getName(), zis.readAllBytes())).toList();
        });
    }

    private static final Object zipToResources$$anonfun$2$$anonfun$1(Throwable ex$7) {
        return ex$7;
    }

    private static final Object substituteResources$$anonfun$1() {
        return "substitute params in zip item contents";
    }
}

