/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management.import;

import ambience.cms.Lenses$;
import ambience.cms.management.CMSManagementModule;
import ambience.cms.management.ZipItem;
import ambience.cms.management.import.ImportStructure;
import ambience.cms.management.import.ImportStructure$;
import ambience.cms.management.import.NameManager;
import ambience.cms.management.import.NameManager$;
import ambience.cms.management.import.NewIdManager;
import ambience.cms.management.import.NewIdManager$;
import ambience.cms.management.import.ResourceInfo;
import ambience.cms.management.import.ResourceInfo$;
import ambience.cms.management.import.ResourceSaver;
import ambience.cms.management.import.StructureSaver;
import ambience.cms.management.import.StructureUpdater;
import ambience.cms.management.import.Util$;
import ambience.cms.management.resources.ResourcesManager;
import ambience.cms.management.resources.ResourcesManager$StoreCategoryName$;
import ambience.cms.management.snapshots.resources.ResourceType$;
import ambience.module.UserDB;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import com.elixirtech.arch.LogMessage;
import io.circe.Json;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface ImportRunner
extends ResourceSaver,
StructureUpdater,
StructureSaver {
    public static Task runImport$(ImportRunner $this, UserDB.User user, String store, List items) {
        return $this.runImport(user, store, (List<ZipItem>)items);
    }

    default public Task<Either<LogMessage, BoxedUnit>> runImport(UserDB.User user, String store, List<ZipItem> items) {
        ((CMSManagementModule)this).log().info(() -> ImportRunner.runImport$$anonfun$1(items), Line$.MODULE$.apply(22), FullName$.MODULE$.apply("ambience.cms.management.import.ImportRunner.runImport"));
        items.foreach((Function1)(JProcedure1 & Serializable)i -> ((CMSManagementModule)this).log().info(() -> ImportRunner.runImport$$anonfun$2$$anonfun$1(i), Line$.MODULE$.apply(23), FullName$.MODULE$.apply("ambience.cms.management.import.ImportRunner.runImport")));
        return ((Task)EitherT$.MODULE$.apply(this.runInfo("Building import structure")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(this.buildStructure((Option<ZipItem>)items.find((Function1 & Serializable)_$1 -> {
                String string = _$1.name();
                String string2 = "metadata.json";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }))).flatMap((Function1 & Serializable)structure -> EitherT$.MODULE$.apply(this.runInfo("Fetching current group names")).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                boolean bl = EitherT$.MODULE$.right();
                return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, ((CMSManagementModule)this).groupsManager().getGroupNames(user), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)gnames -> EitherT$.MODULE$.apply(this.runInfo("Fetching current page names")).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    boolean bl = EitherT$.MODULE$.right();
                    return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, ((CMSManagementModule)this).pagesManager().getPageNames(user), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)pnames -> EitherT$.MODULE$.apply(this.runInfo("Fetching current template names")).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        boolean bl = EitherT$.MODULE$.right();
                        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, ((CMSManagementModule)this).templatesManager().getTemplateNames(user), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)tnames -> EitherT$.MODULE$.apply(this.runInfo("Fetching current StoreCategoryNames")).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            boolean bl = EitherT$.MODULE$.right();
                            return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, ((CMSManagementModule)this).resourcesManager().getResourceStoreCategoryNames(user), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)scns -> EitherT$.MODULE$.apply(this.runInfo("Building resource info list")).flatMap((Function1 & Serializable)x$1 -> {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return EitherT$.MODULE$.apply((Object)Task$.MODULE$.now(this.buildResourceInfoList(store, items, (List<ResourcesManager.StoreCategoryName>)scns, (List<Json>)structure.resources().toList()))).flatMap((Function1 & Serializable)infoList -> EitherT$.MODULE$.apply(this.runInfo("Building NewIdManager")).flatMap((Function1 & Serializable)x$1 -> {
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    boolean bl = EitherT$.MODULE$.right();
                                    return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.now((Object)NewIdManager$.MODULE$.apply((ImportStructure)structure)), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)idManager -> EitherT$.MODULE$.apply(this.runInfo("Building NameManager")).flatMap((Function1 & Serializable)x$1 -> {
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        boolean bl = EitherT$.MODULE$.right();
                                        return EitherT.RightPartiallyApplied$.MODULE$.apply$extension(bl, (Object)Task$.MODULE$.now((Object)NameManager$.MODULE$.apply((ImportStructure)structure, (List<String>)gnames, (List<String>)pnames, (List<String>)tnames)), (Functor)Task$.MODULE$.catsAsync()).flatMap((Function1 & Serializable)nameManager -> EitherT$.MODULE$.apply(this.runInfo("Saving " + infoList.size() + " items to Binary Stores")).flatMap((Function1 & Serializable)x$1 -> {
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            return EitherT$.MODULE$.apply(this.saveResources((List<ResourceInfo>)infoList)).flatMap((Function1 & Serializable)updatedInfoList -> EitherT$.MODULE$.apply(this.doImport(user, this.revertTask(user, (NewIdManager)idManager, (List<ResourceInfo>)updatedInfoList), store, (ImportStructure)structure, (NewIdManager)idManager, (NameManager)nameManager, (List<ResourceInfo>)updatedInfoList)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            }, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                                        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                                    }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                                }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                        }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                    }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value()).map((Function1 & Serializable)_$2 -> _$2.left().map((Function1 & Serializable)res -> {
            ((CMSManagementModule)this).log().warn(ImportRunner::runImport$$anonfun$4$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(48), FullName$.MODULE$.apply("ambience.cms.management.import.ImportRunner.runImport"));
            return res;
        }));
    }

    public static Task doImport$(ImportRunner $this, UserDB.User user, Task revert, String store, ImportStructure structure, NewIdManager idManager, NameManager nameManager, List infoList) {
        return $this.doImport(user, (Task<Either<LogMessage, BoxedUnit>>)revert, store, structure, idManager, nameManager, (List<ResourceInfo>)infoList);
    }

    default public Task<Either<LogMessage, BoxedUnit>> doImport(UserDB.User user, Task<Either<LogMessage, BoxedUnit>> revert, String store, ImportStructure structure, NewIdManager idManager, NameManager nameManager, List<ResourceInfo> infoList) {
        return ((Task)EitherT$.MODULE$.apply(this.runInfo("Updating import structure")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(this.update(store, structure, idManager, nameManager, infoList)).flatMap((Function1 & Serializable)updatedStructure -> EitherT$.MODULE$.apply(this.runInfo("Saving updated import structure to collections")).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherT$.MODULE$.apply(this.save(user, (ImportStructure)updatedStructure)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }, (Functor)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value()).flatMap((Function1 & Serializable)x$12 -> {
            Either either = x$12;
            if (either instanceof Left) {
                LogMessage res = (LogMessage)((Left)either).value();
                ((CMSManagementModule)this).log().warn(ImportRunner::doImport$$anonfun$2$$anonfun$1, Line$.MODULE$.apply(70), FullName$.MODULE$.apply("ambience.cms.management.import.ImportRunner.doImport"));
                return revert.map((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        LogMessage err = (LogMessage)((Left)either).value();
                        LogMessage logMessage = err;
                        if (logMessage instanceof LogMessage.LogMessageList) {
                            List list;
                            LogMessage.LogMessageList logMessageList = LogMessage.LogMessageList$.MODULE$.unapply((LogMessage.LogMessageList)logMessage);
                            List logs = list = logMessageList._1();
                            ((CMSManagementModule)this).log().error(ImportRunner::doImport$$anonfun$2$$anonfun$2$$anonfun$1, Line$.MODULE$.apply(75), FullName$.MODULE$.apply("ambience.cms.management.import.ImportRunner.doImport"));
                            logs.map((Function1 & Serializable)_$3 -> _$3.msg()).foreach((Function1)(JProcedure1 & Serializable)m -> ((CMSManagementModule)this).log().error(() -> ImportRunner.doImport$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$1(m), Line$.MODULE$.apply(76), FullName$.MODULE$.apply("ambience.cms.management.import.ImportRunner.doImport")));
                        } else {
                            LogMessage m2 = logMessage;
                            ((CMSManagementModule)this).log().error(() -> ImportRunner.doImport$$anonfun$2$$anonfun$2$$anonfun$4(m2), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("ambience.cms.management.import.ImportRunner.doImport"));
                        }
                        return package$.MODULE$.Left().apply((Object)res);
                    }
                    if (either instanceof Right) {
                        BoxedUnit v = (BoxedUnit)((Right)either).value();
                        return package$.MODULE$.Left().apply((Object)res);
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (either instanceof Right) {
                BoxedUnit v = (BoxedUnit)((Right)either).value();
                return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)v));
            }
            throw new MatchError((Object)either);
        });
    }

    public static Task revertTask$(ImportRunner $this, UserDB.User user, NewIdManager idManager, List infoList) {
        return $this.revertTask(user, idManager, (List<ResourceInfo>)infoList);
    }

    default public Task<Either<LogMessage, BoxedUnit>> revertTask(UserDB.User user, NewIdManager idManager, List<ResourceInfo> infoList) {
        return (Task)EitherT$.MODULE$.apply(this.runInfo("Reverting Collections")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply(this.revertImport(user, idManager)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return EitherT$.MODULE$.apply(this.runInfo("Reverting Binary Store Resources")).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherT$.MODULE$.apply(this.revertResources(infoList)).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }, (Functor)Task$.MODULE$.catsAsync());
                }, (Monad)Task$.MODULE$.catsAsync());
            }, (Monad)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public static Task runInfo$(ImportRunner $this, String msg) {
        return $this.runInfo(msg);
    }

    default public Task<Either<LogMessage, BoxedUnit>> runInfo(String msg) {
        return Task$.MODULE$.apply(() -> this.runInfo$$anonfun$1(msg));
    }

    public static Task buildStructure$(ImportRunner $this, Option itemOpt) {
        return $this.buildStructure((Option<ZipItem>)itemOpt);
    }

    default public Task<Either<LogMessage, ImportStructure>> buildStructure(Option<ZipItem> itemOpt) {
        Option<ZipItem> option = itemOpt;
        if (option instanceof Some) {
            ZipItem item = (ZipItem)((Some)option).value();
            return (Task)EitherT$.MODULE$.apply(this.getMetadataJson(item)).flatMap((Function1 & Serializable)json -> EitherT$.MODULE$.apply(this.getMetadataStructure((Json)json)).map((Function1 & Serializable)structure -> structure, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("metadata.json")));
        }
        throw new MatchError(option);
    }

    public static Either buildResourceInfoList$(ImportRunner $this, String store, List items, List currentList, List resources) {
        return $this.buildResourceInfoList(store, (List<ZipItem>)items, (List<ResourcesManager.StoreCategoryName>)currentList, (List<Json>)resources);
    }

    default public Either<LogMessage, List<ResourceInfo>> buildResourceInfoList(String store, List<ZipItem> items, List<ResourcesManager.StoreCategoryName> currentList, List<Json> resources) {
        Function1 & Serializable fn = (Function1 & Serializable)item -> Util$.MODULE$.ensureUnique(currentList, (Function2 & Serializable)(scn, n) -> ImportRunner.$anonfun$1$$anonfun$1((ResourcesManager.StoreCategoryName)scn, BoxesRunTime.unboxToInt((Object)n)), item);
        List res = items.filterNot((Function1 & Serializable)_$4 -> {
            String string = _$4.name();
            String string2 = "metadata.json";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).flatMap((Function1 & Serializable)item -> this.itemToStoreCategoryName((ZipItem)item).map((Function1 & Serializable)scn -> ((Option)fn.apply((Object)scn.copy(store, scn.copy$default$2(), scn.copy$default$3()))).toRight(() -> ImportRunner.$anonfun$3$$anonfun$1$$anonfun$1(scn)).flatMap((Function1 & Serializable)newScn -> this.findResourceIdByStoreCategoryName((ResourcesManager.StoreCategoryName)scn, resources).map((Function1 & Serializable)resourceId -> ResourceInfo$.MODULE$.apply((ZipItem)item, (String)resourceId, (ResourcesManager.StoreCategoryName)scn, (ResourcesManager.StoreCategoryName)newScn, ResourceInfo$.MODULE$.$lessinit$greater$default$5())))));
        Tuple2 tuple2 = res.partition((Function1 & Serializable)_$5 -> _$5.isLeft());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List l = (List)tuple2._1();
        List r = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)l, (Object)r);
        List l2 = (List)tuple22._1();
        List r2 = (List)tuple22._2();
        if (store.isEmpty()) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Resources found but no store specified"));
        }
        if (l2.isEmpty()) {
            return package$.MODULE$.Right().apply((Object)r2.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Either x) {
                    Either either = x;
                    if (either instanceof Right) {
                        ResourceInfo v = (ResourceInfo)((Right)either).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Either x, Function1 function1) {
                    Either either = x;
                    if (either instanceof Right) {
                        ResourceInfo v = (ResourceInfo)((Right)either).value();
                        return v;
                    }
                    return function1.apply((Object)x);
                }
            }));
        }
        return package$.MODULE$.Left().apply((Object)LogMessage.LogMessageList$.MODULE$.apply(l2.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Either x) {
                Either either = x;
                if (either instanceof Left) {
                    LogMessage m = (LogMessage)((Left)either).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Either x, Function1 function1) {
                Either either = x;
                if (either instanceof Left) {
                    LogMessage m = (LogMessage)((Left)either).value();
                    return m;
                }
                return function1.apply((Object)x);
            }
        })));
    }

    public static Either findResourceIdByStoreCategoryName$(ImportRunner $this, ResourcesManager.StoreCategoryName scn, List resources) {
        return $this.findResourceIdByStoreCategoryName(scn, (List<Json>)resources);
    }

    default public Either<LogMessage, String> findResourceIdByStoreCategoryName(ResourcesManager.StoreCategoryName scn, List<Json> resources) {
        return resources.find((Function1 & Serializable)r -> ImportRunner.test$1(scn, r)).flatMap((Function1 & Serializable)s -> Lenses$.MODULE$._Id().getOption(s)).toRight(() -> ImportRunner.findResourceIdByStoreCategoryName$$anonfun$3(scn));
    }

    public static Option itemToStoreCategoryName$(ImportRunner $this, ZipItem item) {
        return $this.itemToStoreCategoryName(item);
    }

    default public Option<ResourcesManager.StoreCategoryName> itemToStoreCategoryName(ZipItem item) {
        List list = (List)Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(item.name()), "/").split("/")).toList().dropWhile((Function1 & Serializable)_$6 -> ResourceType$.MODULE$.resourceTypeList().contains(_$6));
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String string = (String)colon2.head();
            List list2 = colon2.next$access$1();
            String store = string;
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                String string2 = (String)colon3.head();
                List list3 = colon3.next$access$1();
                String name = string2;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list3;
                if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                    return Some$.MODULE$.apply((Object)ResourcesManager$StoreCategoryName$.MODULE$.apply(store, "", name));
                }
                String store2 = string;
                String category = string2;
                if (list3 instanceof .colon.colon) {
                    .colon.colon colon4 = (.colon.colon)list3;
                    List list5 = colon4.next$access$1();
                    String name2 = (String)colon4.head();
                    Nil$ nil$2 = package$.MODULE$.Nil();
                    List list6 = list5;
                    if (!(nil$2 != null ? !nil$2.equals(list6) : list6 != null)) {
                        return Some$.MODULE$.apply((Object)ResourcesManager$StoreCategoryName$.MODULE$.apply(store2, category, name2));
                    }
                }
            }
        }
        return None$.MODULE$;
    }

    public static Task getMetadataJson$(ImportRunner $this, ZipItem item) {
        return $this.getMetadataJson(item);
    }

    default public Task<Either<LogMessage, Json>> getMetadataJson(ZipItem item) {
        Right right;
        String s = new String(item.bytes(), StandardCharsets.UTF_8);
        Option option = io.circe.parser.package$.MODULE$.parse(s).toOption();
        if (option instanceof Some) {
            Json json = (Json)((Some)option).value();
            right = package$.MODULE$.Right().apply((Object)json);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("metadata.json not valid json"));
        } else {
            throw new MatchError((Object)option);
        }
        return Task$.MODULE$.now((Object)right);
    }

    public static Task getMetadataStructure$(ImportRunner $this, Json json) {
        return $this.getMetadataStructure(json);
    }

    default public Task<Either<LogMessage, ImportStructure>> getMetadataStructure(Json json) {
        return Task$.MODULE$.now((Object)Lenses$.MODULE$.GroupJson().getOption((Object)json).flatMap((Function1 & Serializable)group -> Lenses$.MODULE$.Pages().getOption((Object)json).flatMap((Function1 & Serializable)pages -> Lenses$.MODULE$.Templates().getOption((Object)json).flatMap((Function1 & Serializable)templates -> Lenses$.MODULE$.Resources().getOption((Object)json).map((Function1 & Serializable)resources -> ImportStructure$.MODULE$.apply((Json)group, (Vector<Json>)pages, (Vector<Json>)templates, (Vector<Json>)resources))))).toRight(ImportRunner::getMetadataStructure$$anonfun$2));
    }

    private static Object runImport$$anonfun$1(List items$1) {
        return "Running import item count=" + items$1.size();
    }

    private static Object runImport$$anonfun$2$$anonfun$1(ZipItem i$1) {
        return i$1.name() + ", bytes=" + i$1.bytes().length;
    }

    private static Object runImport$$anonfun$4$$anonfun$1$$anonfun$1() {
        return "Import Failed Reverting Import";
    }

    private static Object doImport$$anonfun$2$$anonfun$1() {
        return "Import Failed Reverting Import";
    }

    private static Object doImport$$anonfun$2$$anonfun$2$$anonfun$1() {
        return "Revert Failed";
    }

    private static Object doImport$$anonfun$2$$anonfun$2$$anonfun$3$$anonfun$1(String m$1) {
        return m$1;
    }

    private static Object doImport$$anonfun$2$$anonfun$2$$anonfun$4(LogMessage m$2) {
        return "Revert Failed " + m$2;
    }

    private static Object runInfo$$anonfun$1$$anonfun$1(String msg$2) {
        return msg$2;
    }

    private Right runInfo$$anonfun$1(String msg$1) {
        Right$ right$ = package$.MODULE$.Right();
        ((CMSManagementModule)this).log().info(() -> ImportRunner.runInfo$$anonfun$1$$anonfun$1(msg$1), Line$.MODULE$.apply(96), FullName$.MODULE$.apply("ambience.cms.management.import.ImportRunner.runInfo"));
        return right$.apply((Object)BoxedUnit.UNIT);
    }

    private static String updateName$1(String name, int n) {
        Tuple2 tuple2 = StringOps$.MODULE$.splitAt$extension(Predef$.MODULE$.augmentString(name), name.lastIndexOf("."));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String prefix = (String)tuple2._1();
        String ext = (String)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)prefix, (Object)ext);
        String prefix2 = (String)tuple22._1();
        String ext2 = (String)tuple22._2();
        return prefix2 + " (" + n + ")" + ext2;
    }

    private static /* synthetic */ ResourcesManager.StoreCategoryName $anonfun$1$$anonfun$1(ResourcesManager.StoreCategoryName scn, int n) {
        String string = ImportRunner.updateName$1(scn.name(), n);
        String string2 = scn.copy$default$1();
        String string3 = scn.copy$default$2();
        return scn.copy(string2, string3, string);
    }

    private static LogMessage.Error $anonfun$3$$anonfun$1$$anonfun$1(ResourcesManager.StoreCategoryName scn$1) {
        return LogMessage.Error$.MODULE$.apply("Failed to find new unique StoreCategoryName for " + scn$1);
    }

    private static boolean test$1$$anonfun$2() {
        return false;
    }

    private static boolean test$1(ResourcesManager.StoreCategoryName scn$7, Json r) {
        return BoxesRunTime.unboxToBoolean((Object)Lenses$.MODULE$.Store().getOption((Object)r).flatMap((Function1 & Serializable)s -> Lenses$.MODULE$.Category().getOption((Object)r).flatMap((Function1 & Serializable)c -> Lenses$.MODULE$.Name().getOption((Object)r).map((Function1 & Serializable)n -> {
            ResourcesManager.StoreCategoryName storeCategoryName = ResourcesManager$StoreCategoryName$.MODULE$.apply((String)s, (String)c, (String)n);
            ResourcesManager.StoreCategoryName storeCategoryName2 = scn$7;
            return !(storeCategoryName != null ? !((Object)storeCategoryName).equals(storeCategoryName2) : storeCategoryName2 != null);
        }))).getOrElse(ImportRunner::test$1$$anonfun$2));
    }

    private static LogMessage.Error findResourceIdByStoreCategoryName$$anonfun$3(ResourcesManager.StoreCategoryName scn$8) {
        return LogMessage.Error$.MODULE$.apply("No Resource found for " + scn$8);
    }

    private static LogMessage.Error getMetadataStructure$$anonfun$2() {
        return LogMessage.Error$.MODULE$.apply("metadata.json has invalid json structure");
    }
}

