/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management.pages;

import ambience.cms.Collections$;
import ambience.cms.Lenses$;
import ambience.cms.management.CMSUploadHandler;
import ambience.cms.management.ZipHelper$;
import ambience.cms.management.pages.PageUploadHandler$PageStructure$;
import ambience.cms.management.pages.PageUploadHandler$PageStructure2$;
import ambience.cms.management.pages.PagesManager;
import ambience.framework.SafeUploadHandler;
import ambience.framework.SafeUploadHandler$;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.codex.CodexCollection;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable$;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple4$;
import scala.Tuple8$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class PageUploadHandler
extends CMSUploadHandler {
    private final PagesManager manager;
    private final String groupId;
    private final Task cltnT;

    public PageUploadHandler(PagesManager manager, String groupId) {
        this.manager = manager;
        this.groupId = groupId;
        super("pages");
        this.cltnT = Collections$.MODULE$.templatesT();
    }

    public Task<CodexCollection> cltnT() {
        return this.cltnT;
    }

    public Task<List<SafeUploadHandler.Result>> handleUploadZip(UserDB.User user, byte[] bytes2, boolean overwrite) {
        return Observable$.MODULE$.fromIterable((Iterable)SafeUploadHandler$.MODULE$.unzip(bytes2).flatMap((Function1 & Serializable)bytes -> {
            if (ZipHelper$.MODULE$.isZipByteArray((byte[])bytes)) {
                return SafeUploadHandler$.MODULE$.unzip(bytes);
            }
            return (IterableOnce)new .colon.colon(bytes, (List)Nil$.MODULE$);
        })).flatMap((Function1 & Serializable)bytes -> Observable$.MODULE$.fromTask(this.handleUpload(user, (byte[])bytes, (Option)None$.MODULE$, overwrite))).toListL();
    }

    public Either<Task<SafeUploadHandler.Result>, SafeUploadHandler.ExtractedInfo> isValidContent(Json json) {
        String string = "_id";
        String string2 = "uniqueKey";
        String string3 = "name";
        String string4 = "version";
        String string5 = "urlPageName";
        String string6 = "template";
        String string7 = "group";
        String string8 = "owner";
        int size = 8;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("PageStructure", PageUploadHandler::isValidContent$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), PageUploadHandler::isValidContent$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(PageUploadHandler::isValidContent$$anonfun$3)))));
        if (either instanceof Left) {
            String string9 = "_id";
            String string10 = "name";
            String string11 = "group";
            String string12 = "pageVersions";
            int size2 = 4;
            return json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("PageStructure2", PageUploadHandler::isValidContent$$anonfun$4, package$.MODULE$.Nil().$colon$colon((Object)string12).$colon$colon((Object)string11).$colon$colon((Object)string10).$colon$colon((Object)string9), PageUploadHandler::isValidContent$$anonfun$5, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(PageUploadHandler::isValidContent$$anonfun$6))))).left().map((Function1 & Serializable)err -> this.decodingFailed("pages", (DecodingFailure)err)).map((Function1 & Serializable)dus -> SafeUploadHandler.ExtractedInfo$.MODULE$.apply((BsonValue)BsonString$.MODULE$.apply(dus._id()), dus.name()));
        }
        if (either instanceof Right) {
            PageStructure dus2 = (PageStructure)((Right)either).value();
            return package$.MODULE$.Right().apply((Object)SafeUploadHandler.ExtractedInfo$.MODULE$.apply((BsonValue)BsonString$.MODULE$.apply(dus2._id()), dus2.name()));
        }
        throw new MatchError((Object)either);
    }

    public Task<SafeUploadHandler.Result> handleRequest(SafeUploadHandler.Request request) {
        SafeUploadHandler.Request req2 = this.updateGroup(this.updateName(request));
        return this.manager.getPageGroup(req2.user(), req2.name()).flatMap((Function1 & Serializable)grpIdOpt -> {
            if (grpIdOpt.isEmpty() || grpIdOpt.contains((Object)this.groupId)) {
                return this.manager.saveNewVersion(req2.user(), req2.incomingJson()).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        LogMessage lm = (LogMessage)((Left)either).value();
                        return Task$.MODULE$.apply(() -> PageUploadHandler.handleRequest$$anonfun$1$$anonfun$1$$anonfun$1(req2, lm));
                    }
                    if (either instanceof Right) {
                        Json json = (Json)((Right)either).value();
                        int version = BoxesRunTime.unboxToInt((Object)Lenses$.MODULE$.ContentVersion().getOption((Object)json).getOrElse(PageUploadHandler::$anonfun$4));
                        SafeUploadHandler.Result res = SafeUploadHandler.Result$.MODULE$.apply(req2.name(), (LogMessage)LogMessage.Info$.MODULE$.apply("Upload " + req2.name() + " v" + version + " added successfully"), SafeUploadHandler.Result$.MODULE$.$lessinit$greater$default$3());
                        return this.audit(request, res).as((Object)res);
                    }
                    throw new MatchError((Object)either);
                });
            }
            int version = BoxesRunTime.unboxToInt((Object)Lenses$.MODULE$.ContentVersion().getOption((Object)req2.incomingJson()).getOrElse(PageUploadHandler::$anonfun$5));
            SafeUploadHandler.Result res = SafeUploadHandler.Result$.MODULE$.apply(req2.name(), (LogMessage)LogMessage.Error$.MODULE$.apply("Upload Failed. Page " + req2.name() + " v" + version + " already exists in another group"), SafeUploadHandler.Result$.MODULE$.$lessinit$greater$default$3());
            return this.audit(request, res).as((Object)res);
        });
    }

    @Override
    public List<Json> getVersions(Json json) {
        return ((IterableOnceOps)Lenses$.MODULE$.PageVersions().getOption((Object)json).getOrElse(PageUploadHandler::getVersions$$anonfun$1)).toList();
    }

    public SafeUploadHandler.Request updateGroup(SafeUploadHandler.Request request) {
        Json json = (Json)Lenses$.MODULE$.Group().modify((Function1 & Serializable)_$1 -> this.groupId).apply((Object)request.incomingJson());
        UserDB.User user = request.copy$default$1();
        BsonValue bsonValue = request.copy$default$3();
        String string = request.copy$default$4();
        boolean bl = request.copy$default$5();
        return request.copy(user, json, bsonValue, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final List isValidContent$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        Decoder decodeA6;
        void var3_2;
        void var1;
        Decoder decodeA7 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA8 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA6 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA5 = Decoder$.MODULE$.decodeInt();
        Decoder decoder3 = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder5 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder6 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder6).$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 isValidContent$$anonfun$2() {
        PageUploadHandler$PageStructure$ pageUploadHandler$PageStructure$ = PageUploadHandler$PageStructure$.MODULE$;
        return (Function1 & Serializable)p -> (PageStructure)pageUploadHandler$PageStructure$.fromProduct((Product)p);
    }

    private static final Product isValidContent$$anonfun$3() {
        return Tuple8$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        Decoder decodeA6;
        void var3_2;
        void var1;
        Decoder decodeA7 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA8 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA6 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA5 = Decoder$.MODULE$.decodeInt();
        Decoder decoder3 = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder5 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder6 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder6).$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        PageUploadHandler$PageStructure$ pageUploadHandler$PageStructure$ = PageUploadHandler$PageStructure$.MODULE$;
        return (Function1 & Serializable)p -> (PageStructure)pageUploadHandler$PageStructure$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple8$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List isValidContent$$anonfun$4() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        String string = "_id";
        String string2 = "uniqueKey";
        String string3 = "name";
        String string4 = "version";
        String string5 = "urlPageName";
        String string6 = "template";
        String string7 = "group";
        String string8 = "owner";
        int size = 8;
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeVector(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("PageStructure", PageUploadHandler::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string8).$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), PageUploadHandler::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(PageUploadHandler::$anonfun$3)))));
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 isValidContent$$anonfun$5() {
        PageUploadHandler$PageStructure2$ pageUploadHandler$PageStructure2$ = PageUploadHandler$PageStructure2$.MODULE$;
        return (Function1 & Serializable)p -> (PageStructure2)pageUploadHandler$PageStructure2$.fromProduct((Product)p);
    }

    private static final Product isValidContent$$anonfun$6() {
        return Tuple4$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final SafeUploadHandler.Result handleRequest$$anonfun$1$$anonfun$1$$anonfun$1(SafeUploadHandler.Request req2$3, LogMessage lm$1) {
        return SafeUploadHandler.Result$.MODULE$.apply(req2$3.name(), lm$1, SafeUploadHandler.Result$.MODULE$.$lessinit$greater$default$3());
    }

    private static final int $anonfun$4() {
        return 0;
    }

    private static final int $anonfun$5() {
        return 0;
    }

    private static final Vector getVersions$$anonfun$1() {
        return package$.MODULE$.Vector().empty();
    }

    public static final class PageStructure
    implements Product,
    Serializable {
        private final String _id;
        private final String uniqueKey;
        private final String name;
        private final int version;
        private final String urlPageName;
        private final String template;
        private final String group;
        private final String owner;

        public static PageStructure apply(String string, String string2, String string3, int n, String string4, String string5, String string6, String string7) {
            return PageUploadHandler$PageStructure$.MODULE$.apply(string, string2, string3, n, string4, string5, string6, string7);
        }

        public static PageStructure fromProduct(Product product) {
            return PageUploadHandler$PageStructure$.MODULE$.fromProduct(product);
        }

        public static PageStructure unapply(PageStructure pageStructure) {
            return PageUploadHandler$PageStructure$.MODULE$.unapply(pageStructure);
        }

        public PageStructure(String _id, String uniqueKey, String name, int version, String urlPageName, String template, String group, String owner) {
            this._id = _id;
            this.uniqueKey = uniqueKey;
            this.name = name;
            this.version = version;
            this.urlPageName = urlPageName;
            this.template = template;
            this.group = group;
            this.owner = owner;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this._id()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.uniqueKey()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.version());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.urlPageName()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.template()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.group()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.owner()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PageStructure)) return false;
            PageStructure pageStructure = (PageStructure)object;
            if (this.version() != pageStructure.version()) return false;
            String string = this._id();
            String string2 = pageStructure._id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.uniqueKey();
            String string4 = pageStructure.uniqueKey();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.name();
            String string6 = pageStructure.name();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.urlPageName();
            String string8 = pageStructure.urlPageName();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.template();
            String string10 = pageStructure.template();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.group();
            String string12 = pageStructure.group();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            String string13 = this.owner();
            String string14 = pageStructure.owner();
            if (string13 == null) {
                if (string14 == null) return true;
                return false;
            } else {
                if (!string13.equals(string14)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PageStructure;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "PageStructure";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "_id";
                }
                case 1: {
                    return "uniqueKey";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "version";
                }
                case 4: {
                    return "urlPageName";
                }
                case 5: {
                    return "template";
                }
                case 6: {
                    return "group";
                }
                case 7: {
                    return "owner";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String _id() {
            return this._id;
        }

        public String uniqueKey() {
            return this.uniqueKey;
        }

        public String name() {
            return this.name;
        }

        public int version() {
            return this.version;
        }

        public String urlPageName() {
            return this.urlPageName;
        }

        public String template() {
            return this.template;
        }

        public String group() {
            return this.group;
        }

        public String owner() {
            return this.owner;
        }

        public PageStructure copy(String _id, String uniqueKey, String name, int version, String urlPageName, String template, String group, String owner) {
            return new PageStructure(_id, uniqueKey, name, version, urlPageName, template, group, owner);
        }

        public String copy$default$1() {
            return this._id();
        }

        public String copy$default$2() {
            return this.uniqueKey();
        }

        public String copy$default$3() {
            return this.name();
        }

        public int copy$default$4() {
            return this.version();
        }

        public String copy$default$5() {
            return this.urlPageName();
        }

        public String copy$default$6() {
            return this.template();
        }

        public String copy$default$7() {
            return this.group();
        }

        public String copy$default$8() {
            return this.owner();
        }

        public String _1() {
            return this._id();
        }

        public String _2() {
            return this.uniqueKey();
        }

        public String _3() {
            return this.name();
        }

        public int _4() {
            return this.version();
        }

        public String _5() {
            return this.urlPageName();
        }

        public String _6() {
            return this.template();
        }

        public String _7() {
            return this.group();
        }

        public String _8() {
            return this.owner();
        }
    }

    public static final class PageStructure2
    implements Product,
    Serializable {
        private final String _id;
        private final String name;
        private final String group;
        private final Vector pageVersions;

        public static PageStructure2 apply(String string, String string2, String string3, Vector<PageStructure> vector) {
            return PageUploadHandler$PageStructure2$.MODULE$.apply(string, string2, string3, vector);
        }

        public static PageStructure2 fromProduct(Product product) {
            return PageUploadHandler$PageStructure2$.MODULE$.fromProduct(product);
        }

        public static PageStructure2 unapply(PageStructure2 pageStructure2) {
            return PageUploadHandler$PageStructure2$.MODULE$.unapply(pageStructure2);
        }

        public PageStructure2(String _id, String name, String group, Vector<PageStructure> pageVersions) {
            this._id = _id;
            this.name = name;
            this.group = group;
            this.pageVersions = pageVersions;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PageStructure2)) return false;
            PageStructure2 pageStructure2 = (PageStructure2)object;
            String string = this._id();
            String string2 = pageStructure2._id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = pageStructure2.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.group();
            String string6 = pageStructure2.group();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            Vector<PageStructure> vector = this.pageVersions();
            Vector<PageStructure> vector2 = pageStructure2.pageVersions();
            if (vector == null) {
                if (vector2 == null) return true;
                return false;
            } else {
                if (!vector.equals(vector2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PageStructure2;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PageStructure2";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "_id";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "group";
                }
                case 3: {
                    return "pageVersions";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String _id() {
            return this._id;
        }

        public String name() {
            return this.name;
        }

        public String group() {
            return this.group;
        }

        public Vector<PageStructure> pageVersions() {
            return this.pageVersions;
        }

        public PageStructure2 copy(String _id, String name, String group, Vector<PageStructure> pageVersions) {
            return new PageStructure2(_id, name, group, pageVersions);
        }

        public String copy$default$1() {
            return this._id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String copy$default$3() {
            return this.group();
        }

        public Vector<PageStructure> copy$default$4() {
            return this.pageVersions();
        }

        public String _1() {
            return this._id();
        }

        public String _2() {
            return this.name();
        }

        public String _3() {
            return this.group();
        }

        public Vector<PageStructure> _4() {
            return this.pageVersions();
        }
    }
}

