/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management.resources;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$;
import ambience.arch.EitherTELM;
import ambience.arch.EitherTELM$;
import ambience.cms.management.resources.BinaryStoreHelper;
import ambience.cms.management.resources.BinaryStoreHelper$FileInfo$;
import ambience.cms.management.resources.ResourceUtil$;
import ambience.cms.management.resources.ResourcesManager;
import ambience.cms.management.resources.ResourcesRouteBuilder;
import ambience.cms.management.resources.ResourcesRouteBuilder$FileUpload$;
import ambience.format.HumanReadableBytes$;
import ambience.module.UserDB;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ResourceBinaryStore$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ResourceBinaryStore$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final ResourceBinaryStore$ MODULE$ = new ResourceBinaryStore$();

    private ResourceBinaryStore$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ResourceBinaryStore$.class);
    }

    public Task<Either<LogMessage, Json>> write(UserDB.User user, ResourcesManager manager, ResourcesRouteBuilder.UploadInfo info) {
        if (info.length() == 0L) {
            this.log().warn(() -> ResourceBinaryStore$.write$$anonfun$1(info), Line$.MODULE$.apply(20), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourceBinaryStore.write"));
        }
        String locationId = BinaryStore.LocationId$.MODULE$.apply(info.store());
        Json metadata = this.toMetadata(info);
        EitherTELM task = EitherTELM$.MODULE$.apply(this.logInfo((Function0<String>)((Function0 & Serializable)() -> ResourceBinaryStore$.$anonfun$1(user, locationId, metadata)))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherTELM$.MODULE$.apply(((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(locationId).map((Function1 & Serializable)_$1 -> _$1.toRight(() -> ResourceBinaryStore$.$anonfun$2$$anonfun$1$$anonfun$1(locationId)))).flatMap((Function1 & Serializable)location -> EitherTELM$.MODULE$.apply(MODULE$.doWrite((BinaryStore.Location)location, metadata, (DataBytes)info.bytes())).flatMap((Function1 & Serializable)uuid -> EitherTELM$.MODULE$.apply(MODULE$.logInfo((Function0<String>)((Function0 & Serializable)() -> ResourceBinaryStore$.$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(location, uuid)))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return uuid;
            })));
        });
        return task.value().flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                String uuid = (String)((Right)either).value();
                ResourcesRouteBuilder.FileUpload fileUpload = (ResourcesRouteBuilder.FileUpload)io.circe.syntax.package$.MODULE$.EncoderOps((Object)MODULE$.toFileUpload(info, locationId, uuid));
                String string = "name";
                String string2 = "description";
                String string3 = "category";
                String string4 = "store";
                String string5 = "contentType";
                String string6 = "fileSize";
                String string7 = "contentId";
                return manager.save(user, package.EncoderOps$.MODULE$.asJson$extension((Object)fileUpload, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ResourceBinaryStore$::write$$anonfun$2$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string7).$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))));
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return Task$.MODULE$.apply(() -> ResourceBinaryStore$.write$$anonfun$2$$anonfun$2(msg));
            }
            throw new MatchError((Object)either);
        }).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof BinaryStore.MaxSizeException) {
                    BinaryStore.MaxSizeException ex = (BinaryStore.MaxSizeException)throwable;
                    return true;
                }
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof BinaryStore.MaxSizeException) {
                    BinaryStore.MaxSizeException ex = (BinaryStore.MaxSizeException)throwable;
                    return package$.MODULE$.Left().apply((Object)ResourceBinaryStore$.MODULE$.buildMaxsizeError(ex));
                }
                if (throwable != null) {
                    Throwable ex = throwable;
                    return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Binary Store upload " + ex.getMessage(), ex));
                }
                return function1.apply((Object)x);
            }
        });
    }

    public Task<Either<LogMessage, BoxedUnit>> delete(UserDB.User user, ResourcesManager manager, boolean overwrite, String store, String category, String name) {
        return this.getBinaryStoreId(manager, store, category, name).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                if (overwrite) {
                    return ambience.arch.package$.MODULE$.TRUnit();
                }
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)lm));
            }
            if (either instanceof Right) {
                BinaryStore.Id bId = (BinaryStore.Id)((Right)either).value();
                EitherTELM task = EitherTELM$.MODULE$.apply(((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(bId.locationId()).map((Function1 & Serializable)_$2 -> _$2.toRight(() -> ResourceBinaryStore$.$anonfun$3$$anonfun$1(bId)))).flatMap((Function1 & Serializable)location -> EitherTELM$.MODULE$.apply(manager.permanentDelete(user, store, category, name)).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherTELM$.MODULE$.apply(MODULE$.logInfo((Function0<String>)((Function0 & Serializable)() -> ResourceBinaryStore$.$anonfun$4$$anonfun$1$$anonfun$1(user, bId)))).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return EitherTELM$.MODULE$.apply(MODULE$.doDelete((BinaryStore.Location)location, bId.contentId()).map((Function1 & Serializable)x$1 -> {
                            Either either = x$1;
                            if (either instanceof Left) {
                                LogMessage lm = (LogMessage)((Left)either).value();
                                if (overwrite) {
                                    return ambience.arch.package$.MODULE$.RUnit();
                                }
                                return package$.MODULE$.Left().apply((Object)lm);
                            }
                            if (either instanceof Right) {
                                return ambience.arch.package$.MODULE$.RUnit();
                            }
                            throw new MatchError((Object)either);
                        })).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                }));
                return task.value();
            }
            throw new MatchError((Object)either);
        }).onErrorRecover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                ResourceBinaryStore$.MODULE$.log().error(() -> ResourceBinaryStore$.ambience$cms$management$resources$ResourceBinaryStore$$anon$2$$_$applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourceBinaryStore.delete"));
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("BinStore  deleting from store " + ex.getMessage(), ex));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$cms$management$resources$ResourceBinaryStore$$anon$2$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public Task<Either<LogMessage, BinaryStore.Id>> getBinaryStoreId(ResourcesManager manager, String store, String category, String name) {
        return manager.getByStoreCategoryName(store, category, name).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Upload not found with store category name " + store + "_" + category + "_" + name));
            }
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                Option option2 = doc.get("contentId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)cid -> doc.get("store", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)store -> BinaryStore.Id$.MODULE$.apply(BinaryStore.LocationId$.MODULE$.apply(store.getValue()), BinaryStore.ContentId$.MODULE$.apply(cid.getValue()))));
                if (option2 instanceof Some) {
                    BinaryStore.Id bId = (BinaryStore.Id)((Some)option2).value();
                    return package$.MODULE$.Right().apply((Object)bId);
                }
                if (None$.MODULE$.equals(option2)) {
                    return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Problem getting BinaryStoreId " + doc));
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)option);
        });
    }

    public LogMessage buildMaxsizeError(BinaryStore.MaxSizeException ex) {
        Object[] split = ex.getMessage().split(" ");
        Object object = Predef$.MODULE$.refArrayOps(split);
        String maxSize = this.toReadable$1(ArrayOps$.MODULE$.lastOption$extension(object));
        Object object2 = Predef$.MODULE$.refArrayOps(split);
        String actual = this.toReadable$1(ArrayOps$.MODULE$.headOption$extension(object2));
        return LogMessage.Error$.MODULE$.apply("<p>Binary Store upload limit " + maxSize + " exceeded. Actual (" + actual + ")</p>");
    }

    private Task<Either<LogMessage, String>> doWrite(BinaryStore.Location location, Json metadata, DataBytes dataBytes) {
        return location.add(BinaryStore.Content$.MODULE$.apply(dataBytes, metadata)).map((Function1 & Serializable)cid -> ResourceBinaryStore$.doWrite$$anonfun$1(cid == null ? null : ((BinaryStore.ContentId)cid).value())).onErrorRecover((PartialFunction)new Serializable(location){
            private final BinaryStore.Location location$5;
            {
                this.location$5 = location$7;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                ResourceBinaryStore$.MODULE$.log().error(() -> this.applyOrElse$$anonfun$2(ex), Line$.MODULE$.apply(99), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourceBinaryStore.doWrite"));
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Error writing to store " + ex.getMessage(), ex));
            }

            private final Object applyOrElse$$anonfun$2(Throwable ex$2) {
                return "Save bytes failed " + this.location$5.id() + ": " + ex$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$2(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    private Task<Either<LogMessage, BoxedUnit>> doDelete(BinaryStore.Location location, String contentId) {
        return location.remove(contentId).map((Function1 & Serializable)_$4 -> ambience.arch.package$.MODULE$.RUnit()).onErrorRecover((PartialFunction)new Serializable(location){
            private final BinaryStore.Location location$6;
            {
                this.location$6 = location$8;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                ResourceBinaryStore$.MODULE$.log().error(() -> this.applyOrElse$$anonfun$3(ex), Line$.MODULE$.apply(106), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourceBinaryStore.doDelete"));
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Error deleting from store " + ex.getMessage(), ex));
            }

            private final Object applyOrElse$$anonfun$3(Throwable ex$3) {
                return "Delete failed " + this.location$6.id() + ": " + ex$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    private Json toMetadata(ResourcesRouteBuilder.UploadInfo info) {
        Object[] objectArray = new Tuple2[6];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(info.name()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"description");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(info.description()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"category");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(info.category()));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"filename");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString(info.filename()));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.fromLong(info.length()));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentType");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Json$.MODULE$.fromString(info.contentType()));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Task<DataBytes> read(UserDB.User user, Json json) {
        Option<BinaryStore.Id> option = this.getBinaryStoreId(json);
        if (option instanceof Some) {
            BinaryStore.Id bId = (BinaryStore.Id)((Some)option).value();
            return BinaryStore$.MODULE$.get(bId).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                    return content.bytes();
                }
                if (None$.MODULE$.equals(option)) {
                    MODULE$.log().warn(() -> ResourceBinaryStore$.read$$anonfun$1$$anonfun$1(bId), Line$.MODULE$.apply(128), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourceBinaryStore.read"));
                    return DataBytes$.MODULE$.empty();
                }
                throw new MatchError((Object)option);
            });
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(ResourceBinaryStore$::read$$anonfun$2, Line$.MODULE$.apply(132), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourceBinaryStore.read"));
            return Task$.MODULE$.now((Object)DataBytes$.MODULE$.empty());
        }
        throw new MatchError(option);
    }

    public Option<BinaryStoreHelper.FileInfo> getFileInfo(Json json) {
        Option<BinaryStore.Id> option = this.getBinaryStoreId(json);
        if (option instanceof Some) {
            BinaryStore.Id bId = (BinaryStore.Id)((Some)option).value();
            return ResourceUtil$.MODULE$.getFileName(json).flatMap((Function1 & Serializable)name -> ResourceUtil$.MODULE$.getContentType(json).map((Function1 & Serializable)contentType -> BinaryStoreHelper$FileInfo$.MODULE$.apply((String)name, (String)contentType, ResourceUtil$.MODULE$.getDigest(bId.locationId() + "|" + bId.contentId()))));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<BinaryStore.Id> getBinaryStoreId(Json json) {
        return this.getStore(json).flatMap((Function1 & Serializable)store -> MODULE$.getContentId(json).map((Function1 & Serializable)contentId -> BinaryStore.Id$.MODULE$.apply(BinaryStore.LocationId$.MODULE$.apply(store), BinaryStore.ContentId$.MODULE$.apply(contentId))));
    }

    private ResourcesRouteBuilder.FileUpload toFileUpload(ResourcesRouteBuilder.UploadInfo info, String locationId, String contentId) {
        return ResourcesRouteBuilder$FileUpload$.MODULE$.apply(info.name(), info.description(), info.category(), info.store(), info.contentType(), (int)info.length(), contentId);
    }

    private Option<String> getStore(Json json) {
        return json.hcursor().downField("store").as(Decoder$.MODULE$.decodeString()).toOption();
    }

    private Option<String> getContentId(Json json) {
        return json.hcursor().downField("contentId").as(Decoder$.MODULE$.decodeString()).toOption();
    }

    public String humanReadableBytesSpan(long bytes) {
        String tip = HumanReadableBytes$.MODULE$.tip(bytes);
        return "<span class=\"hr-bytes\" title=\"" + tip + "\">" + HumanReadableBytes$.MODULE$.apply(bytes) + "</span>";
    }

    public Task<Either<LogMessage, BoxedUnit>> logInfo(Function0<String> msg) {
        return Task$.MODULE$.apply(() -> ResourceBinaryStore$.logInfo$$anonfun$1(msg));
    }

    private static final Object write$$anonfun$1(ResourcesRouteBuilder.UploadInfo info$1) {
        return info$1.store() + "-" + info$1.category() + "-" + info$1.name() + " bytes zero length";
    }

    private static final String $anonfun$1(UserDB.User user$1, String locationId$1, Json metadata$1) {
        return "Storing Upload user=" + user$1.name() + " store=" + locationId$1 + " metadata=" + metadata$1;
    }

    private static final LogMessage.Error $anonfun$2$$anonfun$1$$anonfun$1(String locationId$4) {
        return LogMessage.Error$.MODULE$.apply("Can't load location " + new BinaryStore.LocationId(locationId$4));
    }

    private static final String $anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(BinaryStore.Location location$2, String uuid$1) {
        return "New Upload Added store=" + location$2.id() + " uuid=" + uuid$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final List write$$anonfun$2$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        Encoder encodeA5;
        void var3_2;
        void var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA7 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA5 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeInt();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Left write$$anonfun$2$$anonfun$2(LogMessage msg$1) {
        return package$.MODULE$.Left().apply((Object)msg$1);
    }

    private static final LogMessage.Error $anonfun$3$$anonfun$1(BinaryStore.Id bId$2) {
        return LogMessage.Error$.MODULE$.apply("Can't load location " + new BinaryStore.LocationId(bId$2.locationId()));
    }

    private static final String $anonfun$4$$anonfun$1$$anonfun$1(UserDB.User user$6, BinaryStore.Id bId$5) {
        return "Deleting Upload user=" + user$6.name() + " " + bId$5;
    }

    public static final Object ambience$cms$management$resources$ResourceBinaryStore$$anon$2$$_$applyOrElse$$anonfun$1(Throwable ex$1) {
        return "DBinStore elete failed  " + ex$1;
    }

    private static final String toReadable$1$$anonfun$2() {
        return "";
    }

    private static final long toReadable$1$$anonfun$3() {
        return 0L;
    }

    private final String toReadable$1(Option strOpt) {
        return this.humanReadableBytesSpan(BoxesRunTime.unboxToLong((Object)StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString((String)strOpt.map((Function1 & Serializable)_$3 -> _$3.trim()).getOrElse(ResourceBinaryStore$::toReadable$1$$anonfun$2))).getOrElse(ResourceBinaryStore$::toReadable$1$$anonfun$3)));
    }

    private static final /* synthetic */ Right doWrite$$anonfun$1(String cid) {
        return package$.MODULE$.Right().apply((Object)cid);
    }

    private static final Object read$$anonfun$1$$anonfun$1(BinaryStore.Id bId$8) {
        return "No content found in binary store=" + bId$8.locationId() + " for contentId " + bId$8.contentId();
    }

    private static final Object read$$anonfun$2() {
        return "BinaryStoreId not found";
    }

    private static final Right logInfo$$anonfun$1(Function0 msg$2) {
        Right$ right$ = package$.MODULE$.Right();
        MODULE$.log().info(msg$2, Line$.MODULE$.apply(180), FullName$.MODULE$.apply("ambience.cms.management.resources.ResourceBinaryStore.logInfo"));
        return right$.apply((Object)BoxedUnit.UNIT);
    }
}

